/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.specter.impl.common.entity;

import com.cursee.specter.Constants;
import com.cursee.specter.platform.Services;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSpecter
extends Mob
implements TraceableEntity {
    public static final String SPECTER_OWNER_TAG = "specter_owner";
    public static final String SPECTER_COLOR_TAG = "specter_color";
    public static final EntityDataAccessor<Optional<UUID>> OPTIONAL_OWNER_UUID = SynchedEntityData.m_135353_(AbstractSpecter.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static final EntityDataAccessor<Integer> DYE_COLOR_ID = SynchedEntityData.m_135353_(AbstractSpecter.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private LivingEntity owner;
    private DyeColor dyeColor = DyeColor.WHITE;

    public AbstractSpecter(EntityType<? extends AbstractSpecter> entityType, Level level) {
        super(entityType, level);
        this.m_20242_(true);
    }

    public boolean m_6052_() {
        return this.m_8077_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(OPTIONAL_OWNER_UUID, Optional.empty());
        this.m_20088_().m_135372_(DYE_COLOR_ID, (Object)DyeColor.WHITE.m_41060_());
    }

    @NotNull
    public Optional<UUID> getOwnerId() {
        return (Optional)this.m_20088_().m_135370_(OPTIONAL_OWNER_UUID);
    }

    public void setOwnerId(@NotNull UUID uuid) {
        this.f_19804_.m_135381_(OPTIONAL_OWNER_UUID, Optional.of(uuid));
    }

    public DyeColor getDyeColor() {
        return DyeColor.m_41053_((int)((Integer)this.m_20088_().m_135370_(DYE_COLOR_ID)));
    }

    public void setDyeColor(DyeColor dyeColor) {
        this.f_19804_.m_135381_(DYE_COLOR_ID, (Object)dyeColor.m_41060_());
    }

    public void m_7378_(@NotNull CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128425_(SPECTER_OWNER_TAG, 11) && compoundTag.m_128465_(SPECTER_OWNER_TAG).length == 4) {
            this.setOwnerId(compoundTag.m_128342_(SPECTER_OWNER_TAG));
        }
        if (compoundTag.m_128425_(SPECTER_COLOR_TAG, 3)) {
            this.setDyeColor(DyeColor.m_41053_((int)(compoundTag.m_128451_(SPECTER_COLOR_TAG) % 16)));
        }
    }

    public void m_7380_(@NotNull CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        this.getOwnerId().ifPresent(uuid -> compoundTag.m_128362_(SPECTER_OWNER_TAG, uuid));
        compoundTag.m_128405_(SPECTER_COLOR_TAG, this.getDyeColor().m_41060_());
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_7337_(Entity entity) {
        return entity instanceof AbstractSpecter;
    }

    @Nullable
    public LivingEntity getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable LivingEntity newOwner) {
        if (newOwner != null && !newOwner.m_21224_()) {
            this.owner = newOwner;
            this.setOwnerId(newOwner.m_20148_());
        }
    }

    public void scanForEntities() {
        Level level;
        if (this.owner != null && this.getOwnerId().isPresent() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            UUID ownerId = this.getOwnerId().get();
            for (Entity entity : serverLevel.m_8583_()) {
                ServerPlayer serverPlayer;
                if (!(entity instanceof ServerPlayer) || !ownerId.equals((serverPlayer = (ServerPlayer)entity).m_20148_())) continue;
                this.setOwner((LivingEntity)serverPlayer);
            }
        }
        if (this.owner == null) {
            if (Services.PLATFORM.isDevelopmentEnvironment() && this.m_9236_().m_5776_()) {
                Constants.LOG.info("Missing owner on client, searching...");
            }
            this.getOwnerId().ifPresent(uuid -> {
                if (Services.PLATFORM.isDevelopmentEnvironment() && this.m_9236_().m_5776_()) {
                    Constants.LOG.info("Owner UUID {} present on client, still searching...", (Object)uuid.toString());
                }
                this.m_9236_().m_6907_().forEach(player -> {
                    UUID playerId = player.m_20148_();
                    if (uuid.equals(playerId) && !player.m_5833_() && !player.m_21224_()) {
                        if (Services.PLATFORM.isDevelopmentEnvironment() && this.m_9236_().m_5776_()) {
                            Constants.LOG.info("Found player with UUID matching synced owner's UUID, {}", uuid);
                            Constants.LOG.info("Setting owner on client.");
                        }
                        this.setOwner((LivingEntity)player);
                    }
                });
            });
        }
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    protected int m_5639_(float fallDistance, float damageMultiplier) {
        return 0;
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    private void handleLookingAtPlayer() {
        float maxRotDegrees = 8.0f;
        if (this.getOwner() != null) {
            Vec3 targetPositionDelta = new Vec3(this.getOwner().m_20185_() - this.m_20185_(), this.getOwner().m_20186_() + (double)this.getOwner().m_20192_() + 0.25 - this.m_20186_(), this.getOwner().m_20189_() - this.m_20189_());
            double targetPosDeltaSquared = targetPositionDelta.m_82556_();
            if (targetPosDeltaSquared > 16.0) {
                maxRotDegrees = 16.0f;
            }
            this.m_21391_((Entity)this.getOwner(), maxRotDegrees, maxRotDegrees);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        this.handleLookingAtPlayer();
        if (this.m_9236_().m_6425_(this.m_20183_()).m_205070_(FluidTags.f_13132_)) {
            this.m_20334_((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f, 0.2f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        }
        if (!this.m_9236_().m_45772_(this.m_20191_())) {
            this.m_20314_(this.m_20185_(), (this.m_20191_().f_82289_ + this.m_20191_().f_82292_) / 2.0, this.m_20189_());
        }
        if (this.f_19797_ % 20 == 1) {
            this.scanForEntities();
        }
        if (this.getOwner() != null && (this.getOwner().m_5833_() || this.getOwner().m_21224_())) {
            this.setOwner(null);
        }
        if (this.getOwner() != null) {
            Vec3 targetPositionDelta = new Vec3(this.getOwner().m_20185_() - this.m_20185_(), this.getOwner().m_20186_() + (double)this.getOwner().m_20192_() + 0.25 - this.m_20186_(), this.getOwner().m_20189_() - this.m_20189_());
            double targetPosDeltaSquared = targetPositionDelta.m_82556_();
            double movementDampening = 1.0;
            if (targetPosDeltaSquared < 8.0) {
                movementDampening = 0.5;
            }
            if (this.m_9236_().m_46472_().equals((Object)this.getOwner().m_9236_().m_46472_()) && targetPosDeltaSquared > 4.0) {
                this.m_20256_(this.m_20184_().m_82549_(targetPositionDelta.m_82541_().m_82490_(movementDampening * movementDampening * 0.1)));
            }
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        float friction = 0.49f;
        if (this.m_20096_()) {
            friction = this.m_9236_().m_8055_(this.m_20099_()).m_60734_().m_49958_() * 0.98f;
        }
        this.m_20256_(this.m_20184_().m_82542_((double)friction, 0.98, (double)friction));
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, -0.9, 1.0));
        }
    }
}

