/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.specter.impl.common.entity;

import com.cursee.specter.impl.common.entity.AbstractSpecter;
import com.cursee.specter.impl.common.registry.ModEntities;
import com.cursee.specter.impl.common.registry.ModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Specter
extends AbstractSpecter {
    public Specter(EntityType<? extends AbstractSpecter> entityType, Level level) {
        super(entityType, level);
    }

    public Specter(Level level, @Nullable LivingEntity owner) {
        this(ModEntities.SPECTER, level);
        this.setOwner(owner);
    }

    public Specter(Level level, @Nullable LivingEntity owner, DyeColor dyeColor) {
        this(level, owner);
        this.setDyeColor(dyeColor);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22266_(Attributes.f_22281_);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && player.m_21120_(hand).m_41619_() && player.m_6144_()) {
            Item item = this.getSpecterSummonerItem();
            ItemStack stack = new ItemStack((ItemLike)item);
            if (this.m_8077_()) {
                stack.m_41714_(this.m_7770_());
            }
            player.m_21008_(hand, stack);
            this.m_146870_();
        }
        return super.m_6071_(player, hand);
    }

    private Item getSpecterSummonerItem() {
        return switch (this.getDyeColor()) {
            case DyeColor.WHITE -> ModItems.SPECTER_SUMMONER_WHITE;
            case DyeColor.ORANGE -> ModItems.SPECTER_SUMMONER_ORANGE;
            case DyeColor.MAGENTA -> ModItems.SPECTER_SUMMONER_MAGENTA;
            case DyeColor.LIGHT_BLUE -> ModItems.SPECTER_SUMMONER_LIGHT_BLUE;
            case DyeColor.YELLOW -> ModItems.SPECTER_SUMMONER_YELLOW;
            case DyeColor.LIME -> ModItems.SPECTER_SUMMONER_LIME;
            case DyeColor.PINK -> ModItems.SPECTER_SUMMONER_PINK;
            case DyeColor.GRAY -> ModItems.SPECTER_SUMMONER_GRAY;
            case DyeColor.LIGHT_GRAY -> ModItems.SPECTER_SUMMONER_LIGHT_GRAY;
            case DyeColor.CYAN -> ModItems.SPECTER_SUMMONER_CYAN;
            case DyeColor.PURPLE -> ModItems.SPECTER_SUMMONER_PURPLE;
            case DyeColor.BLUE -> ModItems.SPECTER_SUMMONER_BLUE;
            case DyeColor.BROWN -> ModItems.SPECTER_SUMMONER_BROWN;
            case DyeColor.GREEN -> ModItems.SPECTER_SUMMONER_GREEN;
            case DyeColor.RED -> ModItems.SPECTER_SUMMONER_RED;
            case DyeColor.BLACK -> ModItems.SPECTER_SUMMONER_BLACK;
            default -> ModItems.SPECTER_CORE;
        };
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        LivingEntity owner = this.getOwner();
        if (owner instanceof Player) {
            Player player = (Player)owner;
            if (this.f_19797_ % 20 == 0 && this.m_20270_((Entity)player) < 4.0f) {
                this.healOwner(player);
            }
        }
    }

    private void healOwner(Player player) {
        if (player.m_21223_() < player.m_21233_() * 0.95f) {
            player.m_5634_(2.0f);
            if (!player.m_21023_(MobEffects.f_19606_)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 40, 0, true, true));
            }
            player.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_215678_, SoundSource.AMBIENT, 0.8f, 0.8f);
            Vec3 pos = this.m_20182_();
            for (int i = 0; i < 4; ++i) {
                float random = player.m_217043_().m_188501_();
                float offset = random * 2.0f - 1.0f;
                player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, pos.f_82479_ + (double)(offset / 2.0f), pos.f_82480_ + (double)(offset / 2.0f), pos.f_82481_ + (double)(offset / 2.0f), (double)offset, (double)offset, (double)offset);
            }
        }
    }
}

