/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.specter.impl.common.entity;

import com.cursee.specter.Constants;
import com.cursee.specter.platform.Services;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3486;
import net.minecraft.class_8046;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSpecter
extends class_1308
implements class_8046 {
    public static final String SPECTER_OWNER_TAG = "specter_owner";
    public static final String SPECTER_COLOR_TAG = "specter_color";
    public static final class_2940<Optional<UUID>> OPTIONAL_OWNER_UUID = class_2945.method_12791(AbstractSpecter.class, (class_2941)class_2943.field_13313);
    public static final class_2940<Integer> DYE_COLOR_ID = class_2945.method_12791(AbstractSpecter.class, (class_2941)class_2943.field_13327);
    @Nullable
    private class_1309 owner;
    private class_1767 dyeColor = class_1767.field_7952;

    public AbstractSpecter(class_1299<? extends AbstractSpecter> entityType, class_1937 level) {
        super(entityType, level);
        this.method_5875(true);
    }

    public boolean method_5733() {
        return this.method_16914();
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(OPTIONAL_OWNER_UUID, Optional.empty());
        this.method_5841().method_12784(DYE_COLOR_ID, (Object)class_1767.field_7952.method_7789());
    }

    @NotNull
    public Optional<UUID> getOwnerId() {
        return (Optional)this.method_5841().method_12789(OPTIONAL_OWNER_UUID);
    }

    public void setOwnerId(@NotNull UUID uuid) {
        this.field_6011.method_12778(OPTIONAL_OWNER_UUID, Optional.of(uuid));
    }

    public class_1767 getDyeColor() {
        return class_1767.method_7791((int)((Integer)this.method_5841().method_12789(DYE_COLOR_ID)));
    }

    public void setDyeColor(class_1767 dyeColor) {
        this.field_6011.method_12778(DYE_COLOR_ID, (Object)dyeColor.method_7789());
    }

    public void method_5749(@NotNull class_2487 compoundTag) {
        super.method_5749(compoundTag);
        if (compoundTag.method_10573(SPECTER_OWNER_TAG, 11) && compoundTag.method_10561(SPECTER_OWNER_TAG).length == 4) {
            this.setOwnerId(compoundTag.method_25926(SPECTER_OWNER_TAG));
        }
        if (compoundTag.method_10573(SPECTER_COLOR_TAG, 3)) {
            this.setDyeColor(class_1767.method_7791((int)(compoundTag.method_10550(SPECTER_COLOR_TAG) % 16)));
        }
    }

    public void method_5652(@NotNull class_2487 compoundTag) {
        super.method_5652(compoundTag);
        this.getOwnerId().ifPresent(uuid -> compoundTag.method_25927(SPECTER_OWNER_TAG, uuid));
        compoundTag.method_10569(SPECTER_COLOR_TAG, this.getDyeColor().method_7789());
    }

    public boolean method_5863() {
        return true;
    }

    public boolean method_30948() {
        return false;
    }

    public boolean method_30949(class_1297 entity) {
        return entity instanceof AbstractSpecter;
    }

    @Nullable
    public class_1309 getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable class_1309 newOwner) {
        if (newOwner != null && !newOwner.method_29504()) {
            this.owner = newOwner;
            this.setOwnerId(newOwner.method_5667());
        }
    }

    public void scanForEntities() {
        class_1937 class_19372;
        if (this.owner != null && this.getOwnerId().isPresent() && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            UUID ownerId = this.getOwnerId().get();
            for (class_1297 entity : serverLevel.method_27909()) {
                class_3222 serverPlayer;
                if (!(entity instanceof class_3222) || !ownerId.equals((serverPlayer = (class_3222)entity).method_5667())) continue;
                this.setOwner((class_1309)serverPlayer);
            }
        }
        if (this.owner == null) {
            if (Services.PLATFORM.isDevelopmentEnvironment() && this.method_37908().method_8608()) {
                Constants.LOG.info("Missing owner on client, searching...");
            }
            this.getOwnerId().ifPresent(uuid -> {
                if (Services.PLATFORM.isDevelopmentEnvironment() && this.method_37908().method_8608()) {
                    Constants.LOG.info("Owner UUID {} present on client, still searching...", (Object)uuid.toString());
                }
                this.method_37908().method_18456().forEach(player -> {
                    UUID playerId = player.method_5667();
                    if (uuid.equals(playerId) && !player.method_7325() && !player.method_29504()) {
                        if (Services.PLATFORM.isDevelopmentEnvironment() && this.method_37908().method_8608()) {
                            Constants.LOG.info("Found player with UUID matching synced owner's UUID, {}", uuid);
                            Constants.LOG.info("Setting owner on client.");
                        }
                        this.setOwner((class_1309)player);
                    }
                });
            });
        }
    }

    public boolean method_5727(double x, double y, double z) {
        return true;
    }

    public boolean method_5640(double distance) {
        return true;
    }

    public boolean method_5747(float fallDistance, float multiplier, class_1282 source) {
        return false;
    }

    protected int method_23329(float fallDistance, float damageMultiplier) {
        return 0;
    }

    protected void method_5623(double y, boolean onGround, class_2680 state, class_2338 pos) {
    }

    private void handleLookingAtPlayer() {
        float maxRotDegrees = 8.0f;
        if (this.getOwner() != null) {
            class_243 targetPositionDelta = new class_243(this.getOwner().method_23317() - this.method_23317(), this.getOwner().method_23318() + (double)this.getOwner().method_5751() + 0.25 - this.method_23318(), this.getOwner().method_23321() - this.method_23321());
            double targetPosDeltaSquared = targetPositionDelta.method_1027();
            if (targetPosDeltaSquared > 16.0) {
                maxRotDegrees = 16.0f;
            }
            this.method_5951((class_1297)this.getOwner(), maxRotDegrees, maxRotDegrees);
        }
    }

    public void method_5773() {
        super.method_5773();
        this.field_6014 = this.method_23317();
        this.field_6036 = this.method_23318();
        this.field_5969 = this.method_23321();
        this.handleLookingAtPlayer();
        if (this.method_37908().method_8316(this.method_24515()).method_15767(class_3486.field_15518)) {
            this.method_18800((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f, 0.2f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f);
        }
        if (!this.method_37908().method_18026(this.method_5829())) {
            this.method_5632(this.method_23317(), (this.method_5829().field_1322 + this.method_5829().field_1325) / 2.0, this.method_23321());
        }
        if (this.field_6012 % 20 == 1) {
            this.scanForEntities();
        }
        if (this.getOwner() != null && (this.getOwner().method_7325() || this.getOwner().method_29504())) {
            this.setOwner(null);
        }
        if (this.getOwner() != null) {
            class_243 targetPositionDelta = new class_243(this.getOwner().method_23317() - this.method_23317(), this.getOwner().method_23318() + (double)this.getOwner().method_5751() + 0.25 - this.method_23318(), this.getOwner().method_23321() - this.method_23321());
            double targetPosDeltaSquared = targetPositionDelta.method_1027();
            double movementDampening = 1.0;
            if (targetPosDeltaSquared < 8.0) {
                movementDampening = 0.5;
            }
            if (this.method_37908().method_27983().equals(this.getOwner().method_37908().method_27983()) && targetPosDeltaSquared > 4.0) {
                this.method_18799(this.method_18798().method_1019(targetPositionDelta.method_1029().method_1021(movementDampening * movementDampening * 0.1)));
            }
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
        float friction = 0.49f;
        if (this.method_24828()) {
            friction = this.method_37908().method_8320(this.method_23314()).method_26204().method_9499() * 0.98f;
        }
        this.method_18799(this.method_18798().method_18805((double)friction, 0.98, (double)friction));
        if (this.method_24828()) {
            this.method_18799(this.method_18798().method_18805(1.0, -0.9, 1.0));
        }
    }
}

