/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.modlistmemory;

import dev.terminalmc.modlistmemory.config.Config;
import dev.terminalmc.modlistmemory.util.ModLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public class ModListMemory {
    public static final String MOD_ID = "modlistmemory";
    public static final String MOD_NAME = "ModListMemory";
    public static final ModLogger LOG = new ModLogger("ModListMemory");
    public static final int BADGE_TEXT = 0xCACACA;
    public static final int PINNED_BADGE_OUTLINE = -5018855;
    public static final int PINNED_BADGE_FILL = -11719157;
    public static final int RECENT_BADGE_OUTLINE = -14835789;
    public static final int RECENT_BADGE_FILL = -15973299;
    public static FormattedCharSequence pinnedBadgeText = Component.m_237113_((String)"I").m_7532_();
    public static FormattedCharSequence recentBadgeText = Component.m_237113_((String)"R").m_7532_();

    public static void init() {
        Config.getAndSave();
        if (!Config.options().persistOnRestart) {
            Config.options().recentMods.clear();
            Config.options().scrollAmount = Double.MIN_VALUE;
        }
    }

    public static void onClientShutdown(Minecraft mc) {
        if (Config.options().persistOnRestart) {
            Config.save();
        }
    }

    public static void onConfigSaved(Config config) {
        pinnedBadgeText = Component.m_237113_((String)config.options.pinnedText).m_7532_();
        recentBadgeText = Component.m_237113_((String)config.options.recentText).m_7532_();
    }

    public static void onModOpened(String modId) {
        if (Config.options().pinnedMods.contains(modId)) {
            return;
        }
        Config.options().recentMods.remove(modId);
        Config.options().recentMods.add(Config.options().recentMods.size(), modId);
        while (Config.options().recentMods.size() > Config.options().recentModsSize && !Config.options().recentMods.isEmpty()) {
            Config.options().recentMods.remove(0);
        }
        if (Config.options().persistOnRestart && Config.options().saveOnUpdate) {
            Config.save();
        }
    }

    public static boolean onModClicked(String modId) {
        if (ModListMemory.hasKeyDown(Config.options().pinKey)) {
            Config.options().recentMods.remove(modId);
            Config.options().pinnedMods.remove(modId);
            Config.options().pinnedMods.add(Config.options().pinnedMods.size(), modId);
            while (Config.options().pinnedMods.size() > Config.options().pinnedModsSize && !Config.options().pinnedMods.isEmpty()) {
                Config.options().pinnedMods.remove(0);
            }
            if (Config.options().persistOnRestart && Config.options().saveOnUpdate) {
                Config.save();
            }
            return true;
        }
        if (ModListMemory.hasKeyDown(Config.options().unpinKey) && Config.options().pinnedMods.contains(modId)) {
            Config.options().pinnedMods.remove(modId);
            if (Config.options().persistOnRestart && Config.options().saveOnUpdate) {
                Config.save();
            }
            return true;
        }
        return false;
    }

    public static boolean hasKeyDown(Config.Key key) {
        return switch (key) {
            default -> throw new IncompatibleClassChangeError();
            case Config.Key.CONTROL -> Screen.m_96637_();
            case Config.Key.ALT -> Screen.m_96639_();
            case Config.Key.SHIFT -> Screen.m_96638_();
            case Config.Key.NONE -> false;
        };
    }
}

