/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.modlistmemory;

import dev.terminalmc.modlistmemory.config.Config;
import dev.terminalmc.modlistmemory.util.ModLogger;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5481;

public class ModListMemory {
    public static final String MOD_ID = "modlistmemory";
    public static final String MOD_NAME = "ModListMemory";
    public static final ModLogger LOG = new ModLogger("ModListMemory");
    public static final int BADGE_TEXT = -3487030;
    public static final int PINNED_BADGE_OUTLINE = -5018855;
    public static final int PINNED_BADGE_FILL = -11719157;
    public static final int RECENT_BADGE_OUTLINE = -14835789;
    public static final int RECENT_BADGE_FILL = -15973299;
    public static class_5481 pinnedBadgeText = class_2561.method_43470((String)"I").method_30937();
    public static class_5481 recentBadgeText = class_2561.method_43470((String)"R").method_30937();

    public static void init() {
        Config.getAndSave();
        if (!Config.options().persistOnRestart) {
            Config.options().recentMods.clear();
            Config.options().scrollAmount = Double.MIN_VALUE;
        }
    }

    public static void onClientShutdown(class_310 mc) {
        if (Config.options().persistOnRestart) {
            Config.save();
        }
    }

    public static void onConfigSaved(Config config) {
        pinnedBadgeText = class_2561.method_43470((String)config.options.pinnedText).method_30937();
        recentBadgeText = class_2561.method_43470((String)config.options.recentText).method_30937();
    }

    public static void onModOpened(String modId) {
        if (Config.options().pinnedMods.contains(modId)) {
            return;
        }
        Config.options().recentMods.remove(modId);
        Config.options().recentMods.addLast(modId);
        while (Config.options().recentMods.size() > Config.options().recentModsSize) {
            Config.options().recentMods.removeFirst();
        }
        if (Config.options().persistOnRestart && Config.options().saveOnUpdate) {
            Config.save();
        }
    }

    public static boolean onModClicked(class_11909 click, String modId) {
        if (ModListMemory.hasKeyDown(click, Config.options().pinKey)) {
            Config.options().recentMods.remove(modId);
            Config.options().pinnedMods.remove(modId);
            Config.options().pinnedMods.addLast(modId);
            while (Config.options().pinnedMods.size() > Config.options().pinnedModsSize) {
                Config.options().pinnedMods.removeFirst();
            }
            if (Config.options().persistOnRestart && Config.options().saveOnUpdate) {
                Config.save();
            }
            return true;
        }
        if (ModListMemory.hasKeyDown(click, Config.options().unpinKey) && Config.options().pinnedMods.contains(modId)) {
            Config.options().pinnedMods.remove(modId);
            if (Config.options().persistOnRestart && Config.options().saveOnUpdate) {
                Config.save();
            }
            return true;
        }
        return false;
    }

    public static boolean hasKeyDown(class_11909 click, Config.Key key) {
        return switch (key) {
            default -> throw new MatchException(null, null);
            case Config.Key.CONTROL -> click.method_74240();
            case Config.Key.ALT -> click.method_74238();
            case Config.Key.SHIFT -> click.method_74239();
            case Config.Key.NONE -> false;
        };
    }
}

