/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.modlistmemory.gui.screen;

import dev.terminalmc.modlistmemory.gui.screen.ClothScreenProvider;
import dev.terminalmc.modlistmemory.util.Localization;
import net.minecraft.Util;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class ConfigScreenProvider {
    public static Screen getConfigScreen(Screen parent) {
        try {
            return ClothScreenProvider.getConfigScreen(parent);
        }
        catch (NoClassDefFoundError ignored) {
            return new BackupScreen(parent, "installCloth", "https://modrinth.com/mod/9s6osm5g");
        }
    }

    static class BackupScreen
    extends Screen {
        private final Screen parent;
        private final String modKey;
        private final String modUrl;

        public BackupScreen(Screen parent, String modKey, String modUrl) {
            super((Component)Localization.localized("name", new Object[0]));
            this.parent = parent;
            this.modKey = modKey;
            this.modUrl = modUrl;
        }

        public void init() {
            MultiLineTextWidget messageWidget = new MultiLineTextWidget(this.width / 2 - 120, this.height / 2 - 40, (Component)Localization.localized("message", this.modKey, new Object[0]), this.minecraft.font);
            messageWidget.setMaxWidth(240);
            messageWidget.setCentered(true);
            this.addRenderableWidget((GuiEventListener)messageWidget);
            Button openLinkButton = Button.builder((Component)Localization.localized("message", "viewModrinth", new Object[0]), button -> this.minecraft.setScreen((Screen)new ConfirmLinkScreen(open -> {
                if (open) {
                    Util.getPlatform().openUri(this.modUrl);
                }
                this.minecraft.setScreen(this.parent);
            }, this.modUrl, true))).pos(this.width / 2 - 120, this.height / 2).size(115, 20).build();
            this.addRenderableWidget((GuiEventListener)openLinkButton);
            Button exitButton = Button.builder((Component)CommonComponents.GUI_OK, button -> this.onClose()).pos(this.width / 2 + 5, this.height / 2).size(115, 20).build();
            this.addRenderableWidget((GuiEventListener)exitButton);
        }
    }
}

