/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot;

import com.google.gson.JsonElement;
import fzzyhmstrs.emi_loot.EMILootAgnos;
import fzzyhmstrs.emi_loot.client.ClientLootTables;
import fzzyhmstrs.emi_loot.client.ClientLootTablesReceiver;
import fzzyhmstrs.emi_loot.networking.ArchaeologyLootPayload;
import fzzyhmstrs.emi_loot.networking.BlockLootPayload;
import fzzyhmstrs.emi_loot.networking.ChestLootPayload;
import fzzyhmstrs.emi_loot.networking.ClearPayload;
import fzzyhmstrs.emi_loot.networking.GameplayLootPayload;
import fzzyhmstrs.emi_loot.networking.MobLootPayload;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.server.ServerResourceData;
import fzzyhmstrs.emi_loot.util.TextKey;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.annotations.Action;
import me.fzzyhmstrs.fzzy_config.annotations.ConvertFrom;
import me.fzzyhmstrs.fzzy_config.annotations.IgnoreVisibility;
import me.fzzyhmstrs.fzzy_config.annotations.NonSync;
import me.fzzyhmstrs.fzzy_config.annotations.RequiresAction;
import me.fzzyhmstrs.fzzy_config.annotations.Version;
import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import me.fzzyhmstrs.fzzy_config.api.RegisterType;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.entry.Entry;
import me.fzzyhmstrs.fzzy_config.entry.EntryHandler;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedList;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedSet;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedAny;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedChoice;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedEnum;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedString;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedNumber;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMILoot {
    public static final String MOD_ID = "emi_loot";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"emi_loot");
    public static RandomSource emiLootRandom = new SingleThreadedRandomSource(System.currentTimeMillis());
    public static LootTableParser parser = new LootTableParser();
    public static EmiLootConfig config = (EmiLootConfig)ConfigApiJava.registerAndLoadConfig(EmiLootConfig::new, (RegisterType)RegisterType.BOTH);
    public static boolean DEBUG = EMILoot.config.debugMode;
    public static Supplier<LootItemConditionType> WITHER_KILL;
    public static Supplier<LootItemConditionType> SPAWNS_WITH;
    public static Supplier<LootItemConditionType> CREEPER;
    public static Supplier<LootItemFunctionType<?>> SET_ANY_DAMAGE;
    public static Supplier<LootItemFunctionType<?>> OMINOUS_BANNER;
    public static Supplier<Enchantment> RANDOM;

    public static ResourceLocation identity(String path) {
        return ResourceLocation.tryBuild((String)MOD_ID, (String)path);
    }

    public static void onInitialize() {
        ConfigApi.INSTANCE.network().registerS2C(ClearPayload.TYPE, ClearPayload.CODEC, (payload, ctx) -> ClientLootTables.INSTANCE.clearLoots());
        ConfigApi.INSTANCE.network().registerS2C(ChestLootPayload.TYPE, ChestLootPayload.CODEC, ClientLootTablesReceiver::receiveChestSender);
        ConfigApi.INSTANCE.network().registerS2C(BlockLootPayload.TYPE, BlockLootPayload.CODEC, ClientLootTablesReceiver::receiveBlockSender);
        ConfigApi.INSTANCE.network().registerS2C(MobLootPayload.TYPE, MobLootPayload.CODEC, ClientLootTablesReceiver::receiveMobSender);
        ConfigApi.INSTANCE.network().registerS2C(GameplayLootPayload.TYPE, GameplayLootPayload.CODEC, ClientLootTablesReceiver::receiveGameplaySender);
        ConfigApi.INSTANCE.network().registerS2C(ArchaeologyLootPayload.TYPE, ArchaeologyLootPayload.CODEC, ClientLootTablesReceiver::receiveArchaeologySender);
    }

    public static void parseTables(ResourceManager resourceManager, Registry<LootTable> lootManager, RegistryOps<JsonElement> ops) {
        LootTableParser.registryOps = ops;
        ServerResourceData.loadDirectTables(resourceManager, ops);
        LootTableParser.parseLootTables(lootManager);
    }

    @Version(version=1)
    @IgnoreVisibility
    @ConvertFrom(fileName="EmiLootConfig_v1.json")
    public static class EmiLootConfig
    extends Config {
        @RequiresAction(action=Action.RELOAD_DATA)
        public boolean debugMode = false;
        @RequiresAction(action=Action.RELOAD_DATA)
        private ValidatedAny<DebugMode> debugModes = new ValidatedAny((Object)new DebugMode());
        @RequiresAction(action=Action.RELOAD_DATA)
        public boolean parseChestLoot = true;
        @RequiresAction(action=Action.RELOAD_DATA)
        public boolean parseBlockLoot = true;
        @RequiresAction(action=Action.RELOAD_DATA)
        public boolean parseMobLoot = true;
        @RequiresAction(action=Action.RELOAD_DATA)
        public boolean parseGameplayLoot = true;
        @RequiresAction(action=Action.RELOAD_DATA)
        public boolean parseArchaeologyLoot = true;
        @RequiresAction(action=Action.RELOAD_DATA)
        public Set<String> skippedKeys = new ValidatedSet(TextKey.defaultSkips, (Entry)ValidatedString.fromList(TextKey.keys().stream().toList()));
        @NonSync
        private ValidatedAny<CompactLoot> compactLoot = new ValidatedAny((Object)new CompactLoot());
        @NonSync
        private ValidatedAny<LogUntranslatedTables> logUnstranslatedTables = new ValidatedAny((Object)new LogUntranslatedTables());
        @NonSync
        public boolean chestLootAlwaysStackSame = false;
        @NonSync
        public boolean mobLootIncludeDirectDrops = true;
        @NonSync
        public ValidatedInt chanceDecimalPlaces = new ValidatedInt(1, 10, 0, ValidatedNumber.WidgetType.SLIDER);
        @NonSync
        private ValidatedChoice<String> conditionStyle = EMILootAgnos.isModLoaded("symbols_n_stuff") ? new ValidatedChoice(List.of("tooltip", "plain", "default"), (EntryHandler)new ValidatedString(), (t, u) -> FcText.INSTANCE.translate(u + "." + t, new Object[0]), (t, u) -> FcText.INSTANCE.translate(u + "." + t, new Object[0]), ValidatedChoice.WidgetType.CYCLING) : new ValidatedChoice(List.of("default", "tooltip", "plain"), (EntryHandler)new ValidatedString(), (t, u) -> FcText.INSTANCE.translate(u + "." + t + ".sns", new Object[0]), (t, u) -> FcText.INSTANCE.translate(u + "." + t + ".sns", new Object[0]), ValidatedChoice.WidgetType.CYCLING);
        @NonSync
        private ValidatedList<ChatFormatting> linkFormatting = new ValidatedEnum((Enum)ChatFormatting.UNDERLINE).toList((Object[])new ChatFormatting[]{ChatFormatting.UNDERLINE});

        EmiLootConfig() {
            super(new ResourceLocation(EMILoot.MOD_ID, "emi_loot_config"), "", "");
        }

        public boolean isTooltipStyle() {
            return Objects.equals(this.conditionStyle.get(), "tooltip") || Objects.equals(this.conditionStyle.get(), "plain");
        }

        public boolean isNotPlain() {
            return (!Objects.equals(this.conditionStyle.get(), "tooltip") || EMILootAgnos.isModLoaded("symbols_n_stuff")) && !Objects.equals(this.conditionStyle.get(), "plain");
        }

        public boolean isCompact(Type type) {
            return type.compactLootSupplier.getAsBoolean();
        }

        public boolean isDebug(Type type) {
            return type.debugModeSupplier.getAsBoolean();
        }

        public boolean isLogI18n(Type type) {
            return type.logUntranslatedTablesSupplier.getAsBoolean();
        }

        public ChatFormatting[] getLinkFormatting() {
            return (ChatFormatting[])this.linkFormatting.toArray((Object[])new ChatFormatting[this.linkFormatting.getSize()]);
        }
    }

    public static enum Type {
        BLOCK(() -> ((CompactLoot)EMILoot.config.compactLoot.get()).block, () -> ((DebugMode)EMILoot.config.debugModes.get()).block, () -> false),
        CHEST(() -> ((CompactLoot)EMILoot.config.compactLoot.get()).chest, () -> ((DebugMode)EMILoot.config.debugModes.get()).chest, () -> ((LogUntranslatedTables)EMILoot.config.logUnstranslatedTables.get()).chest),
        MOB(() -> ((CompactLoot)EMILoot.config.compactLoot.get()).mob, () -> ((DebugMode)EMILoot.config.debugModes.get()).mob, () -> false),
        GAMEPLAY(() -> ((CompactLoot)EMILoot.config.compactLoot.get()).gameplay, () -> ((DebugMode)EMILoot.config.debugModes.get()).gameplay, () -> ((LogUntranslatedTables)EMILoot.config.logUnstranslatedTables.get()).gameplay),
        ARCHAEOLOGY(() -> ((CompactLoot)EMILoot.config.compactLoot.get()).archaeology, () -> ((DebugMode)EMILoot.config.debugModes.get()).archaeology, () -> ((LogUntranslatedTables)EMILoot.config.logUnstranslatedTables.get()).archaeology);

        final BooleanSupplier compactLootSupplier;
        final BooleanSupplier debugModeSupplier;
        final BooleanSupplier logUntranslatedTablesSupplier;

        private Type(BooleanSupplier compactLootSupplier, BooleanSupplier debugModeSupplier, BooleanSupplier logUntranslatedTablesSupplier) {
            this.compactLootSupplier = compactLootSupplier;
            this.debugModeSupplier = debugModeSupplier;
            this.logUntranslatedTablesSupplier = logUntranslatedTablesSupplier;
        }
    }

    @IgnoreVisibility
    private static class LogUntranslatedTables {
        public boolean chest = EMILootAgnos.isDevelopmentEnvironment();
        public boolean gameplay = EMILootAgnos.isDevelopmentEnvironment();
        public boolean archaeology = EMILootAgnos.isDevelopmentEnvironment();

        private LogUntranslatedTables() {
        }
    }

    @IgnoreVisibility
    private static class DebugMode {
        public boolean block = false;
        public boolean chest = false;
        public boolean mob = false;
        public boolean gameplay = false;
        public boolean archaeology = false;

        private DebugMode() {
        }
    }

    @IgnoreVisibility
    private static class CompactLoot {
        public boolean block = true;
        public boolean chest = true;
        public boolean mob = true;
        public boolean gameplay = true;
        public boolean archaeology = true;

        private CompactLoot() {
        }
    }
}

