/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser.function;

import fzzyhmstrs.emi_loot.mixins.SetEnchantmentsLootFunctionAccessor;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.function.FunctionParser;
import fzzyhmstrs.emi_loot.parser.processor.NumberProcessors;
import fzzyhmstrs.emi_loot.util.TextKey;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class SetEnchantmentsFunctionParser
implements FunctionParser {
    @Override
    public LootTableParser.LootFunctionResult parseFunction(LootItemFunction function, ItemStack stack, boolean parentIsAlternative, List<TextKey> conditionTexts) {
        Map<Enchantment, NumberProvider> enchantments = ((SetEnchantmentsLootFunctionAccessor)function).getEnchantments();
        boolean add = ((SetEnchantmentsLootFunctionAccessor)function).getAdd();
        if (stack.is(Items.BOOK)) {
            stack = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            AtomicReference<ItemStack> finalStack = new AtomicReference<ItemStack>(stack);
            enchantments.forEach((enchantment, provider) -> {
                float rollAvg = NumberProcessors.getRollAvg(provider);
                finalStack.set(EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(enchantment, (int)rollAvg)));
            });
            return new LootTableParser.LootFunctionResult(TextKey.of("emi_loot.function.set_enchant_book"), finalStack.get(), conditionTexts);
        }
        if (!stack.isEmpty()) {
            ItemEnchantments.Mutable finalStackMap = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
            if (add) {
                ItemEnchantments stackMap = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
                enchantments.forEach((enchantment, provider) -> {
                    float rollAvg = NumberProcessors.getRollAvg(provider);
                    finalStackMap.set(enchantment, Math.max((int)rollAvg + stackMap.getLevel(enchantment), 0));
                });
            } else {
                enchantments.forEach((enchantment, provider) -> {
                    float rollAvg = NumberProcessors.getRollAvg(provider);
                    finalStackMap.set(enchantment, Math.max((int)rollAvg, 1));
                });
            }
            stack.set(DataComponents.ENCHANTMENTS, (Object)finalStackMap.toImmutable());
            return new LootTableParser.LootFunctionResult(TextKey.of("emi_loot.function.set_enchant_item"), stack, conditionTexts);
        }
        return new LootTableParser.LootFunctionResult(TextKey.of("emi_loot.function.set_enchant_item"), ItemStack.EMPTY, conditionTexts);
    }
}

