/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.mixins.CombinedEntryAccessor;
import fzzyhmstrs.emi_loot.mixins.ConditionalLootFunctionAccessor;
import fzzyhmstrs.emi_loot.mixins.ItemEntryAccessor;
import fzzyhmstrs.emi_loot.mixins.LeafEntryAccessor;
import fzzyhmstrs.emi_loot.mixins.LootPoolAccessor;
import fzzyhmstrs.emi_loot.mixins.LootPoolEntryAccessor;
import fzzyhmstrs.emi_loot.mixins.LootTableAccessor;
import fzzyhmstrs.emi_loot.mixins.LootTableEntryAccessor;
import fzzyhmstrs.emi_loot.mixins.TagEntryAccessor;
import fzzyhmstrs.emi_loot.networking.ClearPayload;
import fzzyhmstrs.emi_loot.parser.processor.NumberProcessors;
import fzzyhmstrs.emi_loot.parser.registry.LootParserRegistry;
import fzzyhmstrs.emi_loot.server.ArchaeologyLootTableSender;
import fzzyhmstrs.emi_loot.server.BlockLootTableSender;
import fzzyhmstrs.emi_loot.server.ChestLootTableSender;
import fzzyhmstrs.emi_loot.server.ComplexLootPoolBuilder;
import fzzyhmstrs.emi_loot.server.GameplayLootTableSender;
import fzzyhmstrs.emi_loot.server.LootBuilder;
import fzzyhmstrs.emi_loot.server.LootSender;
import fzzyhmstrs.emi_loot.server.MobLootTableSender;
import fzzyhmstrs.emi_loot.server.NestedLootTableResults;
import fzzyhmstrs.emi_loot.server.ServerResourceData;
import fzzyhmstrs.emi_loot.server.SimpleLootPoolBuilder;
import fzzyhmstrs.emi_loot.util.LText;
import fzzyhmstrs.emi_loot.util.TextKey;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_176;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_219;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5342;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_65;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_72;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_83;
import net.minecraft.class_8710;
import net.minecraft.class_91;
import net.minecraft.class_93;
import org.jetbrains.annotations.Nullable;

public class LootTableParser {
    private static final Map<class_2960, ChestLootTableSender> chestSenders = new HashMap<class_2960, ChestLootTableSender>();
    private static final Map<class_2960, BlockLootTableSender> blockSenders = new HashMap<class_2960, BlockLootTableSender>();
    private static final Map<class_2960, MobLootTableSender> mobSenders = new HashMap<class_2960, MobLootTableSender>();
    private static final Map<class_2960, GameplayLootTableSender> gameplaySenders = new HashMap<class_2960, GameplayLootTableSender>();
    private static final Map<class_2960, ArchaeologyLootTableSender> archaeologySenders = new HashMap<class_2960, ArchaeologyLootTableSender>();
    public static final Object2BooleanMap<PostProcessor> postProcessors;
    public static String currentTable;
    public static List<class_2960> parsedDirectDrops;
    public static boolean hasParsedLootTables;
    public static class_2378<class_52> lootManager;
    public static class_6903<JsonElement> registryOps;

    private static boolean hasPostProcessed() {
        BooleanIterator booleanIterator = postProcessors.values().iterator();
        while (booleanIterator.hasNext()) {
            boolean bl = (Boolean)booleanIterator.next();
            if (bl) continue;
            return false;
        }
        return true;
    }

    public void registerServer(class_3222 player) {
        if (!LootTableParser.hasPostProcessed()) {
            EMILoot.LOGGER.warn("Post-processing not completed for some reason, completing now...");
            for (PostProcessor process : PostProcessor.values()) {
                LootTableParser.postProcess(process);
            }
            EMILoot.LOGGER.warn("Post-processing complete!");
        }
        if (ConfigApi.INSTANCE.network().canSend(ClearPayload.TYPE.comp_2242(), (class_1657)player)) {
            ConfigApi.INSTANCE.network().send((class_8710)ClearPayload.INSTANCE, (class_1657)player);
        }
        if (EMILoot.config.parseChestLoot) {
            chestSenders.forEach((id, chestSender) -> chestSender.send(player));
        }
        if (EMILoot.config.parseBlockLoot) {
            blockSenders.forEach((id, blockSender) -> blockSender.send(player));
        }
        if (EMILoot.config.parseMobLoot) {
            mobSenders.forEach((id, mobSender) -> mobSender.send(player));
        }
        if (EMILoot.config.parseGameplayLoot) {
            gameplaySenders.forEach((id, gameplaySender) -> gameplaySender.send(player));
        }
        if (EMILoot.config.parseArchaeologyLoot) {
            archaeologySenders.forEach((id, archaeologySender) -> archaeologySender.send(player));
        }
    }

    public static void parseLootTables(class_2378<class_52> manager) {
        lootManager = manager;
        parsedDirectDrops = new LinkedList<class_2960>();
        chestSenders.clear();
        blockSenders.clear();
        mobSenders.clear();
        gameplaySenders.clear();
        archaeologySenders.clear();
        try {
            EMILoot.LOGGER.info("parsing loot tables");
            manager.method_29722().forEach(entry -> {
                class_52 table = (class_52)entry.getValue();
                if (!((LootTableAccessor)table).getPools().isEmpty()) {
                    LootTableParser.parseLootTable(((class_5321)entry.getKey()).method_29177(), table);
                }
            });
            if (EMILoot.config.parseMobLoot) {
                class_2960 chk = new class_2960("pig");
                class_7923.field_41177.method_10220().toList().forEach(type -> {
                    if (type == class_1299.field_6115) {
                        for (class_2960 sheepId : ServerResourceData.SHEEP_TABLES) {
                            LootTableParser.parseEntityType(manager, type, sheepId, chk);
                        }
                    }
                    LootTableParser.parseEntityType(manager, type, type.method_16351().method_29177(), chk);
                });
            }
            Multimap<class_2960, class_52> missedDrops = ServerResourceData.getMissedDirectDrops(parsedDirectDrops);
            for (Map.Entry entry2 : missedDrops.entries()) {
                if (EMILoot.DEBUG) {
                    EMILoot.LOGGER.info("parsing missed direct drop table: {}", entry2.getKey());
                }
                LootTableParser.parseLootTable((class_2960)entry2.getKey(), (class_52)entry2.getValue());
            }
            EMILoot.LOGGER.info("finished parsing loot tables");
            hasParsedLootTables = true;
        }
        catch (Throwable e) {
            EMILoot.LOGGER.error("Critical unhandled error encountered while parsing loot tables. Results may be incomplete.");
            EMILoot.LOGGER.error("Thrown Error: ", e);
        }
    }

    private static void parseLootTable(class_2960 id, class_52 lootTable) {
        if (ServerResourceData.skipTable(id)) {
            return;
        }
        currentTable = id.toString();
        try {
            class_176 type = lootTable.method_322();
            if (type == class_173.field_1179 && EMILoot.config.parseChestLoot) {
                chestSenders.put(id, LootTableParser.parseChestLootTable(lootTable, id));
            } else if (type == class_173.field_1172 && EMILoot.config.parseBlockLoot) {
                blockSenders.put(id, LootTableParser.parseBlockLootTable(lootTable, id));
            } else if ((type == class_173.field_1176 || type == class_173.field_16235 || type == class_173.field_22403) && EMILoot.config.parseGameplayLoot) {
                gameplaySenders.put(id, LootTableParser.parseGameplayLootTable(lootTable, id));
            } else if (type == class_173.field_42858 && EMILoot.config.parseArchaeologyLoot) {
                archaeologySenders.put(id, LootTableParser.parseArchaeologyTable(lootTable, id));
            }
        }
        catch (Throwable e) {
            EMILoot.LOGGER.error("Critical error encountered while parsing Loot Table {}", (Object)id);
            EMILoot.LOGGER.error("Thrown Error: ", e);
        }
    }

    public static void postProcess(PostProcessor process) {
        if (!hasParsedLootTables) {
            return;
        }
        try {
            for (LootSender lootSender : chestSenders.values()) {
                for (LootBuilder lootBuilder : lootSender.getBuilders()) {
                    for (class_79 entry : lootBuilder.getEntriesToPostProcess(process)) {
                        if (EMILoot.DEBUG) {
                            EMILoot.LOGGER.info("Post-processing builder in chest sender: {}", (Object)lootSender.getId());
                        }
                        LootTableParser.parseLootPoolEntry(lootBuilder, entry, process);
                    }
                }
                lootSender.build();
            }
            for (LootSender<SimpleLootPoolBuilder> lootSender : blockSenders.values()) {
                for (LootBuilder lootBuilder : lootSender.getBuilders()) {
                    for (class_79 entry : lootBuilder.getEntriesToPostProcess(process)) {
                        if (EMILoot.DEBUG) {
                            EMILoot.LOGGER.info("Post-processing builder in block sender: {}", (Object)lootSender.getId());
                        }
                        LootTableParser.parseLootPoolEntry(lootBuilder, entry, process);
                    }
                }
                lootSender.build();
            }
            for (LootSender<SimpleLootPoolBuilder> lootSender : mobSenders.values()) {
                for (LootBuilder lootBuilder : lootSender.getBuilders()) {
                    for (class_79 entry : lootBuilder.getEntriesToPostProcess(process)) {
                        if (EMILoot.DEBUG) {
                            EMILoot.LOGGER.info("Post-processing builder in mob sender: {}", (Object)lootSender.getId());
                        }
                        LootTableParser.parseLootPoolEntry(lootBuilder, entry, process);
                    }
                }
                lootSender.build();
            }
            for (LootSender<SimpleLootPoolBuilder> lootSender : gameplaySenders.values()) {
                for (LootBuilder lootBuilder : lootSender.getBuilders()) {
                    for (class_79 entry : lootBuilder.getEntriesToPostProcess(process)) {
                        if (EMILoot.DEBUG) {
                            EMILoot.LOGGER.info("Post-processing builder in gameplay sender: {}", (Object)lootSender.getId());
                        }
                        LootTableParser.parseLootPoolEntry(lootBuilder, entry, process);
                    }
                }
                lootSender.build();
            }
            for (LootSender<SimpleLootPoolBuilder> lootSender : archaeologySenders.values()) {
                for (LootBuilder lootBuilder : lootSender.getBuilders()) {
                    for (class_79 entry : lootBuilder.getEntriesToPostProcess(process)) {
                        if (EMILoot.DEBUG) {
                            EMILoot.LOGGER.info("Post-processing builder in archaeology sender: {}", (Object)lootSender.getId());
                        }
                        LootTableParser.parseLootPoolEntry(lootBuilder, entry, process);
                    }
                }
                lootSender.build();
            }
            postProcessors.put((Object)process, true);
        }
        catch (Throwable e) {
            EMILoot.LOGGER.error("Critical error encountered while post-processing for {}", (Object)process);
            EMILoot.LOGGER.error("Thrown Error: ", e);
        }
    }

    private static void parseEntityType(class_2378<class_52> manager, class_1299<?> type, class_2960 mobTableId, class_2960 fallback) {
        try {
            class_2960 mobId = class_7923.field_41177.method_10221(type);
            class_52 mobTable = (class_52)manager.method_10223(mobTableId);
            if ((type == class_1299.field_6093 && mobId.equals((Object)fallback) || mobTable != class_52.field_948) && mobTable != null) {
                currentTable = mobTableId.toString();
                mobSenders.put(mobTableId, LootTableParser.parseMobLootTable(mobTable, mobTableId, mobId));
            } else if (EMILoot.DEBUG) {
                EMILoot.LOGGER.warn("Found empty mob table at id: " + String.valueOf(mobTableId));
            }
        }
        catch (Throwable e) {
            EMILoot.LOGGER.error("Critical error encountered while parsing Mob Loot Table {}", (Object)mobTableId.toString());
            EMILoot.LOGGER.error("Thrown Error: ", e);
        }
    }

    private static ChestLootTableSender parseChestLootTable(class_52 lootTable, class_2960 id) {
        ChestLootTableSender sender = new ChestLootTableSender(id);
        for (class_55 pool : ((LootTableAccessor)lootTable).getPools()) {
            class_5658 rollProvider = ((LootPoolAccessor)pool).getRolls();
            float conditionalMultiplier = 1.0f;
            for (class_5341 condition : ((LootPoolAccessor)pool).getConditions()) {
                if (!(condition instanceof class_219)) continue;
                class_219 randomChanceLootCondition = (class_219)condition;
                conditionalMultiplier *= randomChanceLootCondition.comp_1881();
            }
            float rollAvg = NumberProcessors.getRollAvg(rollProvider) * conditionalMultiplier;
            SimpleLootPoolBuilder builder = new SimpleLootPoolBuilder(rollAvg);
            List<class_79> entries = ((LootPoolAccessor)pool).getEntries();
            for (class_79 entry : entries) {
                LootTableParser.parseLootPoolEntry(builder, entry);
            }
            sender.addBuilder(builder);
        }
        return sender;
    }

    private static BlockLootTableSender parseBlockLootTable(class_52 lootTable, class_2960 id) {
        BlockLootTableSender sender = new BlockLootTableSender(id);
        LootTableParser.parseBlockLootTableInternal(lootTable, sender, false);
        if (ServerResourceData.DIRECT_DROPS.containsKey((Object)id) && EMILoot.config.mobLootIncludeDirectDrops) {
            parsedDirectDrops.add(id);
            Collection directTables = ServerResourceData.DIRECT_DROPS.get((Object)id);
            LootTableParser.parseBlockDirectLootTable(directTables, sender);
        }
        return sender;
    }

    private static void parseBlockDirectLootTable(Collection<class_52> tables, BlockLootTableSender sender) {
        for (class_52 directTable : tables) {
            if (directTable == null) continue;
            LootTableParser.parseBlockLootTableInternal(directTable, sender, true);
        }
    }

    private static void parseBlockLootTableInternal(class_52 lootTable, BlockLootTableSender sender, boolean isDirect) {
        for (class_55 pool : ((LootTableAccessor)lootTable).getPools()) {
            List<class_5341> conditions = ((LootPoolAccessor)pool).getConditions();
            List<LootConditionResult> parsedConditions = LootTableParser.parseLootConditions(conditions, class_1799.field_8037, false);
            if (isDirect) {
                if (EMILoot.DEBUG) {
                    EMILoot.LOGGER.info("Adding direct drop block condition to {}", (Object)currentTable);
                }
                parsedConditions.add(new LootConditionResult(TextKey.of("emi_loot.condition.direct_drop")));
            }
            List<class_117> functions = ((LootPoolAccessor)pool).getFunctions();
            LinkedList<LootFunctionResult> parsedFunctions = new LinkedList<LootFunctionResult>();
            for (class_117 function : functions) {
                LootFunctionResult r = LootTableParser.parseLootFunction(function);
                if (r.skip()) continue;
                parsedFunctions.add(r);
            }
            class_5658 rollProvider = ((LootPoolAccessor)pool).getRolls();
            float rollAvg = NumberProcessors.getRollAvg(rollProvider);
            ComplexLootPoolBuilder builder = new ComplexLootPoolBuilder(rollAvg, parsedConditions, parsedFunctions);
            List<class_79> entries = ((LootPoolAccessor)pool).getEntries();
            for (class_79 entry : entries) {
                LootTableParser.parseLootPoolEntry(builder, entry);
            }
            sender.addBuilder(builder);
        }
    }

    private static MobLootTableSender parseMobLootTable(class_52 lootTable, class_2960 id, class_2960 mobId) {
        MobLootTableSender sender = new MobLootTableSender(id, mobId);
        LootTableParser.parseMobLootTableInternal(lootTable, sender, false);
        if (ServerResourceData.DIRECT_DROPS.containsKey((Object)id) && EMILoot.config.mobLootIncludeDirectDrops) {
            parsedDirectDrops.add(id);
            Collection directTables = ServerResourceData.DIRECT_DROPS.get((Object)id);
            LootTableParser.parseMobDirectLootTable(directTables, sender);
        }
        return sender;
    }

    private static void parseMobDirectLootTable(Collection<class_52> tables, MobLootTableSender sender) {
        for (class_52 directTable : tables) {
            if (directTable == null) continue;
            LootTableParser.parseMobLootTableInternal(directTable, sender, true);
        }
    }

    private static void parseMobLootTableInternal(class_52 lootTable, MobLootTableSender sender, boolean isDirect) {
        for (class_55 pool : ((LootTableAccessor)lootTable).getPools()) {
            List<class_5341> conditions = ((LootPoolAccessor)pool).getConditions();
            List<LootConditionResult> parsedConditions = LootTableParser.parseLootConditions(conditions, class_1799.field_8037, false);
            if (isDirect) {
                if (EMILoot.DEBUG) {
                    EMILoot.LOGGER.info("Adding direct drop mob condition to {}", (Object)currentTable);
                }
                parsedConditions.add(new LootConditionResult(TextKey.of("emi_loot.condition.direct_drop")));
            }
            List<class_117> functions = ((LootPoolAccessor)pool).getFunctions();
            LinkedList<LootFunctionResult> parsedFunctions = new LinkedList<LootFunctionResult>();
            for (class_117 function : functions) {
                LootFunctionResult r = LootTableParser.parseLootFunction(function);
                if (r.skip()) continue;
                parsedFunctions.add(r);
            }
            class_5658 rollProvider = ((LootPoolAccessor)pool).getRolls();
            float rollAvg = NumberProcessors.getRollAvg(rollProvider);
            ComplexLootPoolBuilder builder = new ComplexLootPoolBuilder(rollAvg, parsedConditions, parsedFunctions);
            List<class_79> entries = ((LootPoolAccessor)pool).getEntries();
            for (class_79 entry : entries) {
                LootTableParser.parseLootPoolEntry(builder, entry);
            }
            sender.addBuilder(builder);
        }
    }

    private static GameplayLootTableSender parseGameplayLootTable(class_52 lootTable, class_2960 id) {
        GameplayLootTableSender sender = new GameplayLootTableSender(id);
        for (class_55 pool : ((LootTableAccessor)lootTable).getPools()) {
            List<class_5341> conditions = ((LootPoolAccessor)pool).getConditions();
            List<LootConditionResult> parsedConditions = LootTableParser.parseLootConditions(conditions, class_1799.field_8037, false);
            List<class_117> functions = ((LootPoolAccessor)pool).getFunctions();
            LinkedList<LootFunctionResult> parsedFunctions = new LinkedList<LootFunctionResult>();
            for (class_117 function : functions) {
                LootFunctionResult r = LootTableParser.parseLootFunction(function);
                if (r.skip()) continue;
                parsedFunctions.add(r);
            }
            class_5658 rollProvider = ((LootPoolAccessor)pool).getRolls();
            float rollAvg = NumberProcessors.getRollAvg(rollProvider);
            ComplexLootPoolBuilder builder = new ComplexLootPoolBuilder(rollAvg, parsedConditions, parsedFunctions);
            List<class_79> entries = ((LootPoolAccessor)pool).getEntries();
            for (class_79 entry : entries) {
                LootTableParser.parseLootPoolEntry(builder, entry);
            }
            sender.addBuilder(builder);
        }
        return sender;
    }

    private static ArchaeologyLootTableSender parseArchaeologyTable(class_52 lootTable, class_2960 id) {
        ArchaeologyLootTableSender sender = new ArchaeologyLootTableSender(id);
        for (class_55 pool : ((LootTableAccessor)lootTable).getPools()) {
            class_5658 rollProvider = ((LootPoolAccessor)pool).getRolls();
            float rollAvg = NumberProcessors.getRollAvg(rollProvider);
            SimpleLootPoolBuilder builder = new SimpleLootPoolBuilder(rollAvg);
            List<class_79> entries = ((LootPoolAccessor)pool).getEntries();
            for (class_79 entry : entries) {
                LootTableParser.parseLootPoolEntry(builder, entry);
            }
            sender.addBuilder(builder);
        }
        return sender;
    }

    private static void parseGenericComplexLootTableInternal(class_52 lootTable, LootSender<ComplexLootPoolBuilder> sender) {
        for (class_55 pool : ((LootTableAccessor)lootTable).getPools()) {
            List<class_5341> conditions = ((LootPoolAccessor)pool).getConditions();
            List<LootConditionResult> parsedConditions = LootTableParser.parseLootConditions(conditions, class_1799.field_8037, false);
            List<class_117> functions = ((LootPoolAccessor)pool).getFunctions();
            LinkedList<LootFunctionResult> parsedFunctions = new LinkedList<LootFunctionResult>();
            for (class_117 function : functions) {
                LootFunctionResult r = LootTableParser.parseLootFunction(function);
                if (r.skip()) continue;
                parsedFunctions.add(r);
            }
            class_5658 rollProvider = ((LootPoolAccessor)pool).getRolls();
            float rollAvg = NumberProcessors.getRollAvg(rollProvider);
            ComplexLootPoolBuilder builder = new ComplexLootPoolBuilder(rollAvg, parsedConditions, parsedFunctions);
            List<class_79> entries = ((LootPoolAccessor)pool).getEntries();
            for (class_79 entry : entries) {
                LootTableParser.parseLootPoolEntry(builder, entry);
            }
            sender.addBuilder(builder);
        }
    }

    static void parseLootPoolEntry(LootBuilder builder, class_79 entry) {
        LootTableParser.parseLootPoolEntry(builder, entry, null);
    }

    static void parseLootPoolEntry(LootBuilder builder, class_79 entry, @Nullable PostProcessor process) {
        if (entry instanceof class_91) {
            class_91 tagEntry = (class_91)entry;
            if (process == PostProcessor.TAG) {
                List<ItemEntryResult> result = LootTableParser.parseTagEntry(tagEntry, false);
                result.forEach(builder::addItem);
            } else {
                builder.addEntryForPostProcessing(PostProcessor.TAG, (class_79)tagEntry);
            }
        } else {
            List<ItemEntryResult> result = LootTableParser.parseLootPoolEntry(entry, false);
            result.forEach(builder::addItem);
        }
    }

    static List<ItemEntryResult> parseLootPoolEntry(class_79 entry, boolean parentIsAlternative) {
        if (entry instanceof class_77) {
            class_77 itemEntry = (class_77)entry;
            return LootTableParser.parseItemEntry(itemEntry, parentIsAlternative);
        }
        if (entry instanceof class_65) {
            class_65 alternativeEntry = (class_65)entry;
            return LootTableParser.parseAlternativeEntry(alternativeEntry);
        }
        if (entry instanceof class_93) {
            class_93 groupEntry = (class_93)entry;
            return LootTableParser.parseGroupEntry(groupEntry, parentIsAlternative);
        }
        if (entry instanceof class_72) {
            class_72 sequenceEntry = (class_72)entry;
            return LootTableParser.parseSequenceEntry(sequenceEntry, parentIsAlternative);
        }
        if (entry instanceof class_91) {
            class_91 tagEntry = (class_91)entry;
            return LootTableParser.parseTagEntry(tagEntry, parentIsAlternative);
        }
        if (entry instanceof class_83) {
            class_83 lootTableEntry = (class_83)entry;
            return LootTableParser.parseLootTableEntry(lootTableEntry, parentIsAlternative);
        }
        return List.of();
    }

    static List<ItemEntryResult> parseItemEntry(class_77 entry, boolean parentIsAlternative) {
        int weight = ((LeafEntryAccessor)entry).getWeight();
        class_1799 item = new class_1799(((ItemEntryAccessor)entry).getItem());
        List<class_117> functions = ((LeafEntryAccessor)entry).getFunctions();
        List<class_5341> conditions = ((LootPoolEntryAccessor)entry).getConditions();
        return LootTableParser.parseItemEntry(weight, item, functions, conditions, parentIsAlternative);
    }

    static List<ItemEntryResult> parseItemEntry(int weight, class_1799 item, List<class_117> functions, List<class_5341> conditions, boolean parentIsAlternative) {
        FunctionApplierResult functionApplierResult = LootTableParser.applyLootFunctionToItem(functions, item, weight, parentIsAlternative);
        List<ItemEntryResult> conditionalEntryResults = functionApplierResult.conditionalResults;
        List<TextKey> functionTexts = functionApplierResult.functionTexts;
        item = functionApplierResult.stack;
        List<TextKey> conditionsTexts = LootTableParser.parseLootConditionTexts(conditions, item, parentIsAlternative);
        LinkedList<ItemEntryResult> returnList = new LinkedList<ItemEntryResult>();
        returnList.add(new ItemEntryResult(item, weight, conditionsTexts, functionTexts));
        conditionalEntryResults.forEach(conditionalEntry -> {
            conditionalEntry.conditions.addAll(conditionsTexts);
            conditionalEntry.functions.addAll(functionTexts);
            returnList.add((ItemEntryResult)conditionalEntry);
        });
        return returnList;
    }

    static List<ItemEntryResult> parseTagEntry(class_91 entry, boolean parentIsAlternative) {
        class_6862<class_1792> items = ((TagEntryAccessor)entry).getName();
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.info(">>> Parsing tag entry {}", (Object)items.comp_327());
        }
        Iterable itemsItr = class_7923.field_41178.method_40286(items);
        LinkedList<ItemEntryResult> returnList = new LinkedList<ItemEntryResult>();
        int weight = ((LeafEntryAccessor)entry).getWeight();
        List<class_117> functions = ((LeafEntryAccessor)entry).getFunctions();
        List<class_5341> conditions = ((LootPoolEntryAccessor)entry).getConditions();
        for (class_6880 item : itemsItr) {
            class_1799 stack = new class_1799((class_1935)item.comp_349());
            returnList.addAll(LootTableParser.parseItemEntry(weight, stack, functions, conditions, parentIsAlternative));
        }
        return returnList;
    }

    static List<ItemEntryResult> parseAlternativeEntry(class_65 entry) {
        List<class_79> children = ((CombinedEntryAccessor)entry).getChildren();
        List<class_5341> conditions = ((LootPoolEntryAccessor)entry).getConditions();
        List<TextKey> conditionsTexts = LootTableParser.parseLootConditionTexts(conditions, class_1799.field_8037, true);
        LinkedList<ItemEntryResult> results = new LinkedList<ItemEntryResult>();
        children.forEach(lootEntry -> {
            List<ItemEntryResult> result = LootTableParser.parseLootPoolEntry(lootEntry, true);
            result.forEach(resultEntry -> {
                resultEntry.conditions.addAll(conditionsTexts);
                results.add((ItemEntryResult)resultEntry);
            });
        });
        return results;
    }

    static List<ItemEntryResult> parseGroupEntry(class_93 entry, boolean parentIsAlternative) {
        List<class_79> children = ((CombinedEntryAccessor)entry).getChildren();
        List<class_5341> conditions = ((LootPoolEntryAccessor)entry).getConditions();
        List<TextKey> conditionsTexts = LootTableParser.parseLootConditionTexts(conditions, class_1799.field_8037, parentIsAlternative);
        LinkedList<ItemEntryResult> results = new LinkedList<ItemEntryResult>();
        children.forEach(lootEntry -> {
            List<ItemEntryResult> result = LootTableParser.parseLootPoolEntry(lootEntry, parentIsAlternative);
            result.forEach(resultEntry -> {
                resultEntry.conditions.addAll(conditionsTexts);
                results.add((ItemEntryResult)resultEntry);
            });
        });
        return results;
    }

    static List<ItemEntryResult> parseSequenceEntry(class_72 entry, boolean parentIsAlternative) {
        List<class_79> children = ((CombinedEntryAccessor)entry).getChildren();
        List<class_5341> conditions = ((LootPoolEntryAccessor)entry).getConditions();
        List<TextKey> conditionsTexts = LootTableParser.parseLootConditionTexts(conditions, class_1799.field_8037, parentIsAlternative);
        LinkedList<ItemEntryResult> results = new LinkedList<ItemEntryResult>();
        TextKey sequenceCondition = TextKey.of("emi_loot.condition.sequence");
        children.forEach(lootEntry -> {
            List<ItemEntryResult> result = LootTableParser.parseLootPoolEntry(lootEntry, parentIsAlternative);
            result.forEach(resultEntry -> {
                resultEntry.conditions.addAll(conditionsTexts);
                resultEntry.conditions.add(sequenceCondition);
                results.add((ItemEntryResult)resultEntry);
            });
        });
        return results;
    }

    static List<ItemEntryResult> parseLootTableEntry(class_83 entry, boolean parentIsAlternative) {
        Either<class_5321<class_52>, class_52> value = ((LootTableEntryAccessor)entry).getValue();
        class_52 table = (class_52)value.map(arg_0 -> lootManager.method_29107(arg_0), Function.identity());
        if (table == null) {
            return List.of();
        }
        class_2960 id = lootManager.method_10221((Object)table);
        if (id == null) {
            return List.of();
        }
        List<class_5341> conditions = ((LootPoolEntryAccessor)entry).getConditions();
        List<TextKey> conditionsTexts = LootTableParser.parseLootConditionTexts(conditions, class_1799.field_8037, parentIsAlternative);
        NestedLootTableResults results = new NestedLootTableResults();
        LootTableParser.parseGenericComplexLootTableInternal(table, results);
        ArrayList<ItemEntryResult> parsedList = new ArrayList<ItemEntryResult>();
        results.getBuilders().forEach(parsedBuilder -> parsedList.addAll(parsedBuilder.revert()));
        parsedList.forEach(result -> result.conditions.addAll(conditionsTexts));
        List<class_117> functions = ((LeafEntryAccessor)entry).getFunctions();
        return LootTableParser.applyLootFunctionsToTableResults(functions, parsedList, parentIsAlternative);
    }

    static LootFunctionResult parseLootFunction(class_117 function) {
        return LootTableParser.parseLootFunction(function, class_1799.field_8037, false);
    }

    static LootFunctionResult parseLootFunction(class_117 function, class_1799 stack, boolean parentIsAlternative) {
        LinkedList<TextKey> conditionsTexts;
        class_5339 type;
        try {
            type = function.method_29321();
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Failed to determine a function type for stack {} in table {}", (Object)stack.method_7964(), (Object)currentTable);
            EMILoot.LOGGER.error("Thrown Error:", (Throwable)e);
            return LootFunctionResult.EMPTY;
        }
        if (function instanceof class_120) {
            List<class_5341> conditions = ((ConditionalLootFunctionAccessor)function).getConditions();
            conditionsTexts = LootTableParser.parseLootConditionTexts(conditions, stack, parentIsAlternative);
        } else {
            conditionsTexts = new LinkedList();
        }
        try {
            return LootParserRegistry.parseFunction(function, stack, type, parentIsAlternative, conditionsTexts);
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Failed to parse LootFunction of type {} for stack {} in table {}", new Object[]{type, stack.method_7964(), currentTable});
            EMILoot.LOGGER.error("Thrown Error:", (Throwable)e);
            return LootFunctionResult.EMPTY;
        }
    }

    private static List<ItemEntryResult> applyLootFunctionsToTableResults(List<class_117> functions, List<ItemEntryResult> parsedList, boolean parentIsAlternative) {
        LinkedList conditionalEntryResults = new LinkedList();
        LinkedList<ItemEntryResult> processedEntryResults = new LinkedList<ItemEntryResult>();
        parsedList.forEach(itemEntry -> {
            FunctionApplierResult result = LootTableParser.applyLootFunctionToItem(functions, itemEntry.item, itemEntry.weight, parentIsAlternative);
            List<TextKey> conditionTexts = itemEntry.conditions;
            List<TextKey> functionTexts = itemEntry.functions;
            functionTexts.addAll(result.functionTexts);
            processedEntryResults.add(new ItemEntryResult(result.stack, itemEntry.weight, conditionTexts, functionTexts));
            conditionalEntryResults.addAll(result.conditionalResults);
        });
        processedEntryResults.addAll(conditionalEntryResults);
        return processedEntryResults;
    }

    private static FunctionApplierResult applyLootFunctionToItem(List<class_117> functions, class_1799 item, int weight, boolean parentIsAlternative) {
        LinkedList<TextKey> functionTexts = new LinkedList<TextKey>();
        LinkedList<ItemEntryResult> conditionalEntryResults = new LinkedList<ItemEntryResult>();
        for (class_117 lootFunction : functions) {
            LootFunctionResult result = LootTableParser.parseLootFunction(lootFunction, item, parentIsAlternative);
            TextKey lootText = result.text;
            class_1799 newStack = result.stack;
            List<TextKey> resultConditions = result.conditions;
            if (!resultConditions.isEmpty()) {
                class_1799 conditionalItem = newStack != class_1799.field_8037 ? newStack : item;
                ArrayList<TextKey> conditionalFunctionTexts = new ArrayList<TextKey>();
                conditionalFunctionTexts.add(lootText);
                conditionalEntryResults.add(new ItemEntryResult(conditionalItem, weight, resultConditions, conditionalFunctionTexts));
                continue;
            }
            if (lootText.isNotEmpty() && !lootText.skip()) {
                functionTexts.add(lootText);
            }
            if (newStack == class_1799.field_8037) continue;
            item = newStack;
        }
        return new FunctionApplierResult(conditionalEntryResults, functionTexts, item);
    }

    public static List<TextKey> parseLootConditionTexts(List<class_5341> conditions, class_1799 item, boolean parentIsAlternative) {
        LinkedList<TextKey> conditionsTexts = new LinkedList<TextKey>();
        List<LootConditionResult> parsedConditions = LootTableParser.parseLootConditions(conditions, item, parentIsAlternative);
        for (LootConditionResult result : parsedConditions) {
            conditionsTexts.add(result.text);
        }
        return conditionsTexts;
    }

    public static List<LootConditionResult> parseLootConditions(List<class_5341> conditions, class_1799 item, boolean parentIsAlternative) {
        LinkedList<LootConditionResult> parsedConditions = new LinkedList<LootConditionResult>();
        for (class_5341 condition : conditions) {
            List<LootConditionResult> results = LootTableParser.parseLootCondition(condition, item, parentIsAlternative);
            for (LootConditionResult result : results) {
                if (!result.text.isNotEmpty()) continue;
                parsedConditions.add(result);
            }
        }
        return parsedConditions;
    }

    public static List<LootConditionResult> parseLootCondition(class_5341 condition, class_1799 stack) {
        return LootTableParser.parseLootCondition(condition, stack, false);
    }

    public static List<LootConditionResult> parseLootCondition(class_5341 condition, class_1799 stack, boolean parentIsAlternative) {
        class_5342 type;
        try {
            type = condition.method_29325();
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("failed to determine a condition type for stack {} in table {}", (Object)stack.method_7964(), (Object)currentTable);
            return Collections.singletonList(LootConditionResult.EMPTY);
        }
        try {
            return LootParserRegistry.parseCondition(condition, type, stack, parentIsAlternative);
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Failed to parse LootCondition of type {} for stack {} in table {}", new Object[]{condition.method_29325(), stack.method_7964(), currentTable});
            EMILoot.LOGGER.error("Thrown Error:", (Throwable)e);
            return Collections.singletonList(LootConditionResult.EMPTY);
        }
    }

    public static class_2561 compileConditionTexts(class_1799 stack, List<LootConditionResult> results) {
        class_5250 finalText = LText.empty();
        int size = results.size();
        for (int i = 0; i < size; ++i) {
            LootConditionResult result = results.get(i);
            class_2561 resultText = result.text.process(stack, null).text();
            if (i == 0) {
                finalText = resultText.method_27661();
            } else {
                finalText.method_10852(resultText);
            }
            if (i >= size - 1) continue;
            finalText.method_10852((class_2561)LText.translatable("emi_loot.and"));
        }
        return finalText;
    }

    static {
        currentTable = "none";
        parsedDirectDrops = new LinkedList<class_2960>();
        hasParsedLootTables = false;
        lootManager = null;
        registryOps = null;
        Object2BooleanOpenHashMap map = new Object2BooleanOpenHashMap();
        for (PostProcessor value : PostProcessor.values()) {
            map.put((Object)value, false);
        }
        postProcessors = map;
    }

    public static enum PostProcessor {
        TAG;

    }

    public record LootConditionResult(TextKey text) {
        public static LootConditionResult EMPTY = new LootConditionResult(TextKey.empty());

        public TextKey getText() {
            return this.text;
        }
    }

    public record LootFunctionResult(TextKey text, class_1799 stack, List<TextKey> conditions) {
        public static LootFunctionResult EMPTY = new LootFunctionResult(TextKey.empty(), class_1799.field_8037, new LinkedList<TextKey>());

        public boolean skip() {
            return this.conditions.isEmpty() && this.text.skip();
        }
    }

    public record FunctionApplierResult(List<ItemEntryResult> conditionalResults, List<TextKey> functionTexts, class_1799 stack) {
    }

    public record ItemEntryResult(class_1799 item, int weight, List<TextKey> conditions, List<TextKey> functions) {
    }
}

