/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.server;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.networking.BlockLootPayload;
import fzzyhmstrs.emi_loot.server.ComplexLootPoolBuilder;
import fzzyhmstrs.emi_loot.server.LootSender;
import fzzyhmstrs.emi_loot.server.SimpleLootPoolBuilder;
import fzzyhmstrs.emi_loot.util.TextKey;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class BlockLootTableSender
implements LootSender<ComplexLootPoolBuilder> {
    private final String idToSend;
    final List<ComplexLootPoolBuilder> builderList = new LinkedList<ComplexLootPoolBuilder>();
    boolean isEmpty = true;

    public BlockLootTableSender(class_2960 id) {
        this.idToSend = LootSender.getIdToSend(id);
    }

    @Override
    public void build() {
        this.builderList.forEach(builder -> {
            builder.build();
            if (!builder.isEmpty) {
                this.isEmpty = false;
            }
        });
    }

    @Override
    public String getId() {
        return this.idToSend;
    }

    @Override
    public void send(class_3222 player) {
        if (!ConfigApi.INSTANCE.network().canSend(BlockLootPayload.TYPE.comp_2242(), (class_1657)player)) {
            return;
        }
        if (this.isEmpty) {
            if (EMILoot.config.isDebug(EMILoot.Type.BLOCK)) {
                EMILoot.LOGGER.info("avoiding empty block: {}", (Object)this.idToSend);
            }
            return;
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10814(this.idToSend);
        if (this.builderList.size() == 1 && this.builderList.get((int)0).isSimple) {
            if (EMILoot.config.isDebug(EMILoot.Type.BLOCK)) {
                EMILoot.LOGGER.info("sending simple block: {}", (Object)this.idToSend);
            }
            buf.method_52998(-1);
            buf.method_44116(this.builderList.get((int)0).simpleStack.method_7909().method_40131().method_40237());
            ConfigApi.INSTANCE.network().send((class_8710)new BlockLootPayload(buf), (class_1657)player);
            return;
        }
        if (this.builderList.isEmpty()) {
            return;
        }
        buf.method_52998(this.builderList.size());
        this.builderList.forEach(builder -> {
            ArrayList totalConditions = new ArrayList();
            builder.conditions.forEach(lootConditionResult -> totalConditions.add(lootConditionResult.text()));
            builder.functions.forEach(lootFunctionResult -> totalConditions.addAll(lootFunctionResult.conditions()));
            buf.method_52998(totalConditions.size());
            totalConditions.forEach(textKey -> textKey.toBuf(buf));
            buf.method_52998(builder.functions.size());
            builder.functions.forEach(lootFunctionResult -> lootFunctionResult.text().toBuf(buf));
            HashMap<List<TextKey>, SimpleLootPoolBuilder> lootPoolBuilderMap = builder.builtMap;
            buf.method_52998(lootPoolBuilderMap.size());
            lootPoolBuilderMap.forEach((key, chestBuilder) -> {
                buf.method_52998(key.size());
                key.forEach(textKey -> textKey.toBuf(buf));
                Object2FloatMap<class_1799> keyPoolMap = lootPoolBuilderMap.getOrDefault((Object)key, new SimpleLootPoolBuilder((float)1.0f)).builtMap;
                buf.method_52998(keyPoolMap.size());
                keyPoolMap.forEach((stack, weight) -> {
                    this.writeItemStack(buf, (class_1799)stack, (class_1937)player.method_51469());
                    buf.method_52941(weight.floatValue());
                });
            });
        });
        ConfigApi.INSTANCE.network().send((class_8710)new BlockLootPayload(buf), (class_1657)player);
    }

    @Override
    public void addBuilder(ComplexLootPoolBuilder builder) {
        this.builderList.add(builder);
    }

    @Override
    public List<ComplexLootPoolBuilder> getBuilders() {
        return this.builderList;
    }
}

