/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiInitRegistry;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiStack;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.client.ClientArchaeologyLootTable;
import fzzyhmstrs.emi_loot.client.ClientBlockLootTable;
import fzzyhmstrs.emi_loot.client.ClientChestLootTable;
import fzzyhmstrs.emi_loot.client.ClientGameplayLootTable;
import fzzyhmstrs.emi_loot.client.ClientLootTables;
import fzzyhmstrs.emi_loot.client.ClientMobLootTable;
import fzzyhmstrs.emi_loot.emi.ArchaeologyLootRecipe;
import fzzyhmstrs.emi_loot.emi.BlockLootRecipe;
import fzzyhmstrs.emi_loot.emi.ChestLootRecipe;
import fzzyhmstrs.emi_loot.emi.GameplayLootRecipe;
import fzzyhmstrs.emi_loot.emi.LootSimplifiedRenderer;
import fzzyhmstrs.emi_loot.emi.MobLootRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import net.minecraft.class_156;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2960;

@EmiEntrypoint
public class EmiClientPlugin
implements EmiPlugin {
    private static final class_2960 LOOT_ID = new class_2960("emi_loot", "chest_loot");
    private static final class_2960 BLOCK_ID = new class_2960("emi_loot", "block_drops");
    private static final class_2960 MOB_ID = new class_2960("emi_loot", "mob_drops");
    private static final class_2960 GAMEPLAY_ID = new class_2960("emi_loot", "gameplay_drops");
    private static final class_2960 ARCHAEOLOGY_ID = new class_2960("emi_loot", "archaeology_drops");
    public static final EmiRecipeCategory CHEST_CATEGORY = new EmiRecipeCategory(LOOT_ID, (EmiRenderable)EmiStack.of((class_1935)class_2246.field_10034.method_8389()), (EmiRenderable)new LootSimplifiedRenderer(0, 0));
    public static final EmiRecipeCategory BLOCK_CATEGORY = new EmiRecipeCategory(BLOCK_ID, (EmiRenderable)EmiStack.of((class_1935)class_2246.field_10442.method_8389()), (EmiRenderable)new LootSimplifiedRenderer(16, 0));
    public static final EmiRecipeCategory MOB_CATEGORY = new EmiRecipeCategory(MOB_ID, (EmiRenderable)EmiStack.of((class_1935)class_2246.field_10241.method_8389()), (EmiRenderable)new LootSimplifiedRenderer(0, 16));
    public static final EmiRecipeCategory GAMEPLAY_CATEGORY = new EmiRecipeCategory(GAMEPLAY_ID, (EmiRenderable)EmiStack.of((class_1935)class_1802.field_8378), (EmiRenderable)new LootSimplifiedRenderer(16, 16));
    public static final EmiRecipeCategory ARCHAEOLOGY_CATEGORY = new EmiRecipeCategory(ARCHAEOLOGY_ID, (EmiRenderable)EmiStack.of((class_1935)class_1802.field_42716));
    private static CompletableFuture<List<ChestLootRecipe.ChestLootRecipeData>> chestFuture;
    private static CompletableFuture<List<BlockLootRecipe>> blockFuture;
    private static CompletableFuture<List<MobLootRecipe.MobLootRecipeData>> mobFuture;
    private static CompletableFuture<List<GameplayLootRecipe.GameplayLootRecipeData>> gameplayFuture;
    private static CompletableFuture<List<ArchaeologyLootRecipe.ArchaeologyLootRecipeData>> archaeologyFuture;

    public void initialize(EmiInitRegistry registry) {
        chestFuture = CompletableFuture.supplyAsync(() -> {
            try {
                return ClientLootTables.INSTANCE.chestLoots.stream().flatMap(lr -> {
                    try {
                        return Stream.of(ChestLootRecipe.ChestLootRecipeData.of((ClientChestLootTable)lr));
                    }
                    catch (Throwable e) {
                        EMILoot.LOGGER.error("Critical error encountered while creating a Chest loot recipe; recipe skipped: {}", (Object)lr.getId().toString());
                        EMILoot.LOGGER.error("Thrown Error: ", e);
                        return Stream.of(new ChestLootRecipe.ChestLootRecipeData[0]);
                    }
                }).toList();
            }
            catch (Throwable e) {
                EMILoot.LOGGER.error("Critical error encountered while creating all Chest loot recipes. Recipes completely skipped!");
                EMILoot.LOGGER.error("Thrown Error: ", e);
                return new ArrayList();
            }
        });
        blockFuture = CompletableFuture.supplyAsync(() -> {
            try {
                return ClientLootTables.INSTANCE.blockLoots.stream().flatMap(lr -> {
                    try {
                        return Stream.of(new BlockLootRecipe(BlockLootRecipe.BlockLootRecipeData.of((ClientBlockLootTable)lr)));
                    }
                    catch (Throwable e) {
                        EMILoot.LOGGER.error("Critical error encountered while creating a Block loot recipe; recipe skipped: {}", (Object)lr.getId().toString());
                        EMILoot.LOGGER.error("Thrown Error: ", e);
                        return Stream.of(new BlockLootRecipe[0]);
                    }
                }).toList();
            }
            catch (Throwable e) {
                EMILoot.LOGGER.error("Critical error encountered while creating all Block Recipes. Recipes completely skipped!");
                EMILoot.LOGGER.error("Thrown Error: ", e);
                return new ArrayList();
            }
        });
        mobFuture = CompletableFuture.supplyAsync(() -> {
            try {
                return ClientLootTables.INSTANCE.mobLoots.stream().flatMap(lr -> {
                    try {
                        return Stream.of(MobLootRecipe.MobLootRecipeData.of((ClientMobLootTable)lr));
                    }
                    catch (Throwable e) {
                        EMILoot.LOGGER.error("Critical error encountered while creating a Mob loot recipe; recipe skipped: {}", (Object)lr.getId().toString());
                        EMILoot.LOGGER.error("Thrown Error: ", e);
                        return Stream.of(new MobLootRecipe.MobLootRecipeData[0]);
                    }
                }).toList();
            }
            catch (Throwable e) {
                EMILoot.LOGGER.error("Critical error encountered while creating all Mob Recipes. Recipes completely skipped!");
                EMILoot.LOGGER.error("Thrown Error: ", e);
                return new ArrayList();
            }
        });
        gameplayFuture = CompletableFuture.supplyAsync(() -> {
            try {
                return ClientLootTables.INSTANCE.gameplayLoots.stream().flatMap(lr -> {
                    try {
                        return Stream.of(GameplayLootRecipe.GameplayLootRecipeData.of((ClientGameplayLootTable)lr));
                    }
                    catch (Throwable e) {
                        EMILoot.LOGGER.error("Critical error encountered while creating a Gameplay loot recipe; recipe skipped: {}", (Object)lr.getId().toString());
                        EMILoot.LOGGER.error("Thrown Error: ", e);
                        return Stream.of(new GameplayLootRecipe.GameplayLootRecipeData[0]);
                    }
                }).toList();
            }
            catch (Throwable e) {
                EMILoot.LOGGER.error("Critical error encountered while creating all Gameplay Recipes. Recipes completely skipped!");
                EMILoot.LOGGER.error("Thrown Error: ", e);
                return new ArrayList();
            }
        });
        archaeologyFuture = CompletableFuture.supplyAsync(() -> {
            try {
                return ClientLootTables.INSTANCE.archaeologyLoots.stream().flatMap(lr -> {
                    try {
                        return Stream.of(ArchaeologyLootRecipe.ArchaeologyLootRecipeData.of((ClientArchaeologyLootTable)lr));
                    }
                    catch (Throwable e) {
                        EMILoot.LOGGER.error("Critical error encountered while creating an Archaeology loot recipe; recipe skipped: {}", (Object)lr.getId().toString());
                        EMILoot.LOGGER.error("Thrown Error: ", e);
                        return Stream.of(new ArchaeologyLootRecipe.ArchaeologyLootRecipeData[0]);
                    }
                }).toList();
            }
            catch (Throwable e) {
                EMILoot.LOGGER.error("Critical error encountered while creating all Archaeology Recipes. Recipes completely skipped!");
                EMILoot.LOGGER.error("Thrown Error: ", e);
                return new ArrayList();
            }
        });
    }

    public void register(EmiRegistry registry) {
        registry.addCategory(CHEST_CATEGORY);
        registry.addCategory(BLOCK_CATEGORY);
        registry.addCategory(MOB_CATEGORY);
        registry.addCategory(GAMEPLAY_CATEGORY);
        registry.addCategory(ARCHAEOLOGY_CATEGORY);
        CompletionStage chestRecipeFuture = chestFuture == null ? null : ((CompletableFuture)((CompletableFuture)chestFuture.thenApplyAsync(l -> {
            long t = class_156.method_648();
            List<ChestLootRecipe> l2 = l.stream().map(ChestLootRecipe::new).toList();
            EMILoot.LOGGER.info("Built {} chest loot recipes in {}ms", (Object)l2.size(), (Object)((class_156.method_648() - t) / 1000000L));
            return l2;
        })).exceptionally(e -> {
            EMILoot.LOGGER.error("Critical error encountered while registering all Chest Recipes. Recipes completely skipped!");
            EMILoot.LOGGER.error("Thrown Error: ", e);
            return null;
        })).thenAcceptAsync(l -> l.forEach(r -> this.registerRecipe(registry, (EmiRecipe)r)));
        CompletionStage blockRecipeFuture = blockFuture == null ? null : ((CompletableFuture)blockFuture.thenAcceptAsync(l -> {
            long t = class_156.method_648();
            l.forEach(r -> {
                r.init();
                this.registerRecipe(registry, (EmiRecipe)r);
            });
            EMILoot.LOGGER.info("Built {} block loot recipes in {}ms", (Object)l.size(), (Object)((class_156.method_648() - t) / 1000000L));
        })).exceptionally(e -> {
            EMILoot.LOGGER.error("Critical error encountered while registering all Block Recipes. Recipes completely skipped!");
            EMILoot.LOGGER.error("Thrown Error: ", e);
            return null;
        });
        CompletionStage mobRecipeFuture = mobFuture == null ? null : ((CompletableFuture)((CompletableFuture)mobFuture.thenApplyAsync(l -> {
            long t = class_156.method_648();
            List<MobLootRecipe> l2 = l.stream().map(MobLootRecipe::new).toList();
            EMILoot.LOGGER.info("Built {} mob loot recipes in {}ms", (Object)l2.size(), (Object)((class_156.method_648() - t) / 1000000L));
            return l2;
        })).exceptionally(e -> {
            EMILoot.LOGGER.error("Critical error encountered while registering all Mob Recipes. Recipes completely skipped!");
            EMILoot.LOGGER.error("Thrown Error: ", e);
            return null;
        })).thenAcceptAsync(l -> l.forEach(r -> this.registerRecipe(registry, (EmiRecipe)r)));
        CompletionStage gameplayRecipeFuture = gameplayFuture == null ? null : ((CompletableFuture)((CompletableFuture)gameplayFuture.thenApplyAsync(l -> {
            long t = class_156.method_648();
            List<GameplayLootRecipe> l2 = l.stream().map(GameplayLootRecipe::new).toList();
            EMILoot.LOGGER.info("Built {} gameplay loot recipes in {}ms", (Object)l2.size(), (Object)((class_156.method_648() - t) / 1000000L));
            return l2;
        })).exceptionally(e -> {
            EMILoot.LOGGER.error("Critical error encountered while registering all Gameplay Recipes. Recipes completely skipped!");
            EMILoot.LOGGER.error("Thrown Error: ", e);
            return null;
        })).thenAcceptAsync(l -> l.forEach(r -> this.registerRecipe(registry, (EmiRecipe)r)));
        CompletionStage archaeologyRecipeFuture = archaeologyFuture == null ? null : ((CompletableFuture)((CompletableFuture)archaeologyFuture.thenApplyAsync(l -> {
            long t = class_156.method_648();
            List<ArchaeologyLootRecipe> l2 = l.stream().map(ArchaeologyLootRecipe::new).toList();
            EMILoot.LOGGER.info("Built {} archaeology loot recipes in {}ms", (Object)l2.size(), (Object)((class_156.method_648() - t) / 1000000L));
            return l2;
        })).exceptionally(e -> {
            EMILoot.LOGGER.error("Critical error encountered while registering all Archaeology Recipes. Recipes completely skipped!");
            EMILoot.LOGGER.error("Thrown Error: ", e);
            return null;
        })).thenAcceptAsync(l -> l.forEach(r -> this.registerRecipe(registry, (EmiRecipe)r)));
        long t = class_156.method_648();
        if (gameplayRecipeFuture != null) {
            ((CompletableFuture)gameplayRecipeFuture).join();
        } else {
            EMILoot.LOGGER.error("Gameplay loot recipe future null for an unknown reason; there may have been a problem during EMI initialization");
            EMILoot.LOGGER.error("Gameplay recipes skipped!");
        }
        EMILoot.LOGGER.info("Registered gameplay loot recipes after {}ms", (Object)((class_156.method_648() - t) / 1000000L));
        if (archaeologyRecipeFuture != null) {
            ((CompletableFuture)archaeologyRecipeFuture).join();
        } else {
            EMILoot.LOGGER.error("Archaeology loot recipe future null for an unknown reason; there may have been a problem during EMI initialization");
            EMILoot.LOGGER.error("Archaeology recipes skipped!");
        }
        EMILoot.LOGGER.info("Registered archaeology loot recipes after {}ms", (Object)((class_156.method_648() - t) / 1000000L));
        if (mobRecipeFuture != null) {
            ((CompletableFuture)mobRecipeFuture).join();
        } else {
            EMILoot.LOGGER.error("Mob loot recipe future null for an unknown reason; there may have been a problem during EMI initialization");
            EMILoot.LOGGER.error("Mob recipes skipped!");
        }
        EMILoot.LOGGER.info("Registered mob loot recipes after {}ms", (Object)((class_156.method_648() - t) / 1000000L));
        if (chestRecipeFuture != null) {
            ((CompletableFuture)chestRecipeFuture).join();
        } else {
            EMILoot.LOGGER.error("Chest loot recipe future null for an unknown reason; there may have been a problem during EMI initialization");
            EMILoot.LOGGER.error("Chest recipes skipped!");
        }
        EMILoot.LOGGER.info("Registered chest loot recipes after {}ms", (Object)((class_156.method_648() - t) / 1000000L));
        if (blockRecipeFuture != null) {
            ((CompletableFuture)blockRecipeFuture).join();
        } else {
            EMILoot.LOGGER.error("Block loot recipe future null for an unknown reason; there may have been a problem during EMI initialization");
            EMILoot.LOGGER.error("Block recipes skipped!");
        }
        EMILoot.LOGGER.info("Registered all loot recipes after {}ms", (Object)((class_156.method_648() - t) / 1000000L));
    }

    private synchronized void registerRecipe(EmiRegistry registry, EmiRecipe recipe) {
        registry.addRecipe(recipe);
    }
}

