/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import com.google.gson.JsonObject;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.mixins.FishingHookPredicateAccessor;
import fzzyhmstrs.emi_loot.mixins.LightningBoltPredicateAccessor;
import fzzyhmstrs.emi_loot.mixins.PlayerPredicateAccessor;
import fzzyhmstrs.emi_loot.mixins.SlimePredicateAccessor;
import fzzyhmstrs.emi_loot.parser.EntityPredicateParser;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.processor.ListProcessors;
import fzzyhmstrs.emi_loot.parser.processor.NumberProcessors;
import fzzyhmstrs.emi_loot.util.LText;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.class_1934;
import net.minecraft.class_2048;
import net.minecraft.class_2096;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3445;
import net.minecraft.class_3518;
import net.minecraft.class_4553;
import net.minecraft.class_4965;
import net.minecraft.class_5250;
import net.minecraft.class_6404;
import net.minecraft.class_7376;
import net.minecraft.class_7383;
import net.minecraft.class_7923;

public class TypeSpecificPredicateParser {
    public static class_2561 parseTypeSpecificPredicate(class_7376 predicate) {
        String variant;
        class_2960 id;
        if (predicate instanceof class_6404) {
            return TypeSpecificPredicateParser.parseLightningBoltPredicate((class_6404)predicate);
        }
        if (predicate instanceof class_4965) {
            return TypeSpecificPredicateParser.parseFishingHookPredicate((class_4965)predicate);
        }
        if (predicate instanceof class_4553) {
            return TypeSpecificPredicateParser.parsePlayerPredicate((class_4553)predicate);
        }
        if (predicate instanceof class_7383) {
            return TypeSpecificPredicateParser.parseSlimePredicate((class_7383)predicate);
        }
        JsonObject jsonObject = predicate.method_22494();
        if (jsonObject.has("variant") && (id = class_2960.method_12829((String)(variant = class_3518.method_15265((JsonObject)jsonObject, (String)"variant")))) != null) {
            if (class_7923.field_41163.method_10250(id)) {
                class_5250 catVar = LText.translatable("emi_loot.entity_predicate.type_specific.cat." + String.valueOf(id));
                return LText.translatable("emi_loot.entity_predicate.type_specific.cat", catVar);
            }
            if (class_7923.field_41164.method_10250(id)) {
                class_5250 frogVar = LText.translatable("emi_loot.entity_predicate.type_specific.frog." + String.valueOf(id));
                return LText.translatable("emi_loot.entity_predicate.type_specific.frog", frogVar);
            }
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Type specific predicate undefined or unparsable. Affects table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }

    public static class_2561 parseLightningBoltPredicate(class_6404 predicate) {
        class_2096.class_2100 blocksSetOnFire = ((LightningBoltPredicateAccessor)predicate).getBlocksSetOnFire();
        if (!blocksSetOnFire.equals(class_2096.class_2100.field_9708)) {
            return LText.translatable("emi_loot.entity_predicate.type_specific.lightning", NumberProcessors.processNumberRange(blocksSetOnFire, "emi_loot.entity_predicate.type_specific.lightning.blocks", "emi_loot.entity_predicate.type_specific.lightning.blocks_2", "emi_loot.entity_predicate.type_specific.lightning.blocks_3", "emi_loot.entity_predicate.type_specific.lightning.blocks_4", "", new Object[0]));
        }
        class_2048 entityStruck = ((LightningBoltPredicateAccessor)predicate).getEntityStruck();
        if (!entityStruck.equals(class_2048.field_9599)) {
            return LText.translatable("emi_loot.entity_predicate.type_specific.lightning", LText.translatable("emi_loot.entity_predicate.type_specific.lightning.struck", EntityPredicateParser.parseEntityPredicate(entityStruck)));
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Lightning bolt predicate empty or unparsable. Affects table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }

    public static class_2561 parseFishingHookPredicate(class_4965 predicate) {
        boolean inOpenWater = ((FishingHookPredicateAccessor)predicate).getInOpenWater();
        return inOpenWater ? LText.translatable("emi_loot.entity_predicate.type_specific.fishing_hook_true") : LText.translatable("emi_loot.entity_predicate.type_specific.fishing_hook_false");
    }

    public static class_2561 parsePlayerPredicate(class_4553 predicate) {
        Map<class_2960, class_4553.class_4556> advancements;
        Object2BooleanMap<class_2960> recipes;
        class_2096.class_2100 experienceLevel = ((PlayerPredicateAccessor)predicate).getExperienceLevel();
        if (!experienceLevel.equals(class_2096.class_2100.field_9708)) {
            return LText.translatable("emi_loot.entity_predicate.type_specific.player", NumberProcessors.processNumberRange(experienceLevel, "emi_loot.entity_predicate.type_specific.player.level", "emi_loot.entity_predicate.type_specific.player.level_2", "emi_loot.entity_predicate.type_specific.player.level_3", "emi_loot.entity_predicate.type_specific.player.level_4", "", new Object[0]));
        }
        class_1934 gameMode = ((PlayerPredicateAccessor)predicate).getGameMode();
        if (gameMode != null) {
            return LText.translatable("emi_loot.entity_predicate.type_specific.player", LText.translatable("emi_loot.entity_predicate.type_specific.player.gamemode", gameMode.method_8381()));
        }
        Map<class_3445<?>, class_2096.class_2100> stats = ((PlayerPredicateAccessor)predicate).getStats();
        if (!stats.isEmpty()) {
            LinkedList<class_5250> list = new LinkedList<class_5250>();
            for (Map.Entry<class_3445<?>, class_2096.class_2100> entry : stats.entrySet()) {
                String name = entry.getKey().method_1225();
                String[] namePieces = name.split(":");
                if (namePieces.length != 2) continue;
                String typeId = namePieces[0].replace('.', ':');
                String valueId = namePieces[1].replace('.', ':');
                class_5250 num = NumberProcessors.processNumberRange((class_2096)entry.getValue(), "emi_loot.entity_predicate.type_specific.player.stats.exact", "emi_loot.entity_predicate.type_specific.player.stats.between", "emi_loot.entity_predicate.type_specific.player.stats.at_least", "emi_loot.entity_predicate.type_specific.player.stats.at_most", "emi_loot.entity_predicate.type_specific.player.stats.fallback", new Object[0]);
                list.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.stats.type." + typeId, valueId, num));
            }
            if (!list.isEmpty()) {
                return LText.translatable("emi_loot.entity_predicate.type_specific.player", ListProcessors.buildAndList(list));
            }
        }
        if (!(recipes = ((PlayerPredicateAccessor)predicate).getRecipes()).isEmpty()) {
            LinkedList<class_5250> list = new LinkedList<class_5250>();
            for (Object2BooleanMap.Entry entry : recipes.object2BooleanEntrySet()) {
                list.add(entry.getBooleanValue() ? LText.translatable("emi_loot.entity_predicate.type_specific.player.recipe_true", entry.getKey()) : LText.translatable("emi_loot.entity_predicate.type_specific.player.recipe_false", entry.getKey()));
            }
            if (!list.isEmpty()) {
                return LText.translatable("emi_loot.entity_predicate.type_specific.player", ListProcessors.buildAndList(list));
            }
        }
        if (!(advancements = ((PlayerPredicateAccessor)predicate).getAdvancements()).isEmpty()) {
            LinkedList<class_5250> linkedList = new LinkedList<class_5250>();
            for (Map.Entry<class_2960, class_4553.class_4556> entry : advancements.entrySet()) {
                Object2BooleanMap criteria;
                String idString = entry.getKey().toString();
                class_4553.class_4556 advancementPredicate = entry.getValue();
                if (advancementPredicate instanceof class_4553.class_4555) {
                    boolean done = ((class_4553.class_4555)advancementPredicate).field_20729;
                    if (done) {
                        linkedList.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.adv.id_true", idString));
                        continue;
                    }
                    linkedList.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.adv.id_false", idString));
                    continue;
                }
                if (!(advancementPredicate instanceof class_4553.class_4554) || (criteria = ((class_4553.class_4554)advancementPredicate).field_20728).isEmpty()) continue;
                LinkedList<class_5250> list2 = new LinkedList<class_5250>();
                for (Object2BooleanMap.Entry criteriaEntry : criteria.object2BooleanEntrySet()) {
                    if (criteriaEntry.getBooleanValue()) {
                        list2.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.adv.crit_true", criteriaEntry.getKey()));
                        continue;
                    }
                    list2.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.adv.crit_false", criteriaEntry.getKey()));
                }
                linkedList.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.adv.crit_base", idString, ListProcessors.buildAndList(list2)));
            }
            return LText.translatable("emi_loot.entity_predicate.type_specific.player", ListProcessors.buildAndList(linkedList));
        }
        class_2048 class_20482 = ((PlayerPredicateAccessor)predicate).getLookingAt();
        if (!class_20482.equals(class_2048.field_9599)) {
            return LText.translatable("emi_loot.entity_predicate.type_specific.player", LText.translatable("emi_loot.entity_predicate.type_specific.player.looking", EntityPredicateParser.parseEntityPredicate(class_20482)));
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Lightning bolt predicate empty or unparsable. Affects table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }

    public static class_2561 parseSlimePredicate(class_7383 predicate) {
        class_2096.class_2100 size = ((SlimePredicateAccessor)predicate).getSize();
        if (size.equals(class_2096.class_2100.field_9708)) {
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.warn("Undefined slime size predicate in table: " + LootTableParser.currentTable);
            }
            return LText.translatable("emi_loot.predicate.invalid");
        }
        return NumberProcessors.processNumberRange(size, "emi_loot.entity_predicate.type_specific.slime", "emi_loot.entity_predicate.type_specific.slime_2", "emi_loot.entity_predicate.type_specific.slime_3", "emi_loot.entity_predicate.type_specific.slime_4", "", new Object[0]);
    }
}

