/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fzzyhmstrs.emi_loot.EMILoot;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.EntityType;
import org.joml.Vector3f;

public class ClientResourceData {
    public static final Object2IntMap<EntityType<?>> MOB_OFFSETS = new Object2IntOpenHashMap();
    public static final Object2FloatMap<EntityType<?>> MOB_SCALES = new Object2FloatOpenHashMap();
    public static final Map<EntityType<?>, Vector3f> MOB_ROTATIONS = new HashMap();

    public static class EntityOffsetsReloadListener
    implements ResourceManagerReloadListener {
        public void onResourceManagerReload(ResourceManager manager) {
            MOB_OFFSETS.clear();
            MOB_SCALES.clear();
            MOB_ROTATIONS.clear();
            manager.listResources("entity_fixers", path -> path.getPath().endsWith(".json")).forEach(this::load);
            if (EMILoot.config.isDebug(EMILoot.Type.MOB)) {
                EMILoot.LOGGER.info(MOB_OFFSETS.toString());
            }
            if (EMILoot.config.isDebug(EMILoot.Type.MOB)) {
                EMILoot.LOGGER.info(MOB_ROTATIONS.toString());
            }
            if (EMILoot.config.isDebug(EMILoot.Type.MOB)) {
                EMILoot.LOGGER.info(MOB_SCALES.toString());
            }
        }

        private void load(ResourceLocation fileId, Resource resource) {
            if (EMILoot.config.isDebug(EMILoot.Type.MOB)) {
                EMILoot.LOGGER.info("Reading entity fixers from file: " + fileId.toString());
            }
            try {
                BufferedReader reader = resource.openAsReader();
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                json.entrySet().forEach(entry -> {
                    JsonElement element = (JsonElement)entry.getValue();
                    ResourceLocation mobId = new ResourceLocation((String)entry.getKey());
                    if (BuiltInRegistries.ENTITY_TYPE.containsKey(mobId)) {
                        if (element.isJsonObject()) {
                            JsonElement zEl;
                            JsonElement yEl;
                            JsonElement scaling;
                            JsonObject object = element.getAsJsonObject();
                            JsonElement offset = object.get("offset");
                            if (offset != null && offset.isJsonPrimitive()) {
                                MOB_OFFSETS.put((Object)((EntityType)BuiltInRegistries.ENTITY_TYPE.get(mobId)), offset.getAsInt());
                            }
                            if ((scaling = object.get("scale")) != null && scaling.isJsonPrimitive()) {
                                MOB_SCALES.put((Object)((EntityType)BuiltInRegistries.ENTITY_TYPE.get(mobId)), scaling.getAsFloat());
                            }
                            float x = 0.0f;
                            float y = 0.0f;
                            float z = 0.0f;
                            JsonElement xEl = object.get("x");
                            if (xEl != null && xEl.isJsonPrimitive()) {
                                x = xEl.getAsFloat();
                            }
                            if ((yEl = object.get("y")) != null && yEl.isJsonPrimitive()) {
                                y = yEl.getAsFloat();
                            }
                            if ((zEl = object.get("z")) != null && zEl.isJsonPrimitive()) {
                                z = zEl.getAsFloat();
                            }
                            if (x != 0.0f || y != 0.0f || z != 0.0f) {
                                MOB_ROTATIONS.put((EntityType)BuiltInRegistries.ENTITY_TYPE.get(mobId), new Vector3f(x, y, z));
                            }
                        } else {
                            throw new IllegalArgumentException("Element in mobfixer " + String.valueOf(fileId) + "not properly formatted");
                        }
                    }
                });
            }
            catch (Exception e) {
                EMILoot.LOGGER.error("Failed to open or read Entity Offsets file: " + String.valueOf(fileId));
            }
        }
    }
}

