/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.client;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public interface LootReceiver {
    public boolean isEmpty();

    public ResourceLocation getId();

    public LootReceiver fromBuf(FriendlyByteBuf var1);

    default public ItemStack readItemStack(FriendlyByteBuf buf) {
        Item byId = (Item)BuiltInRegistries.ITEM.byId(buf.readVarInt());
        int count = buf.readVarInt();
        if (buf.readBoolean()) {
            CompoundTag nbt = buf.readNbt();
            ItemStack stack = new ItemStack((ItemLike)byId, count);
            if (nbt instanceof CompoundTag) {
                CompoundTag compound = nbt;
                stack.setTag(compound);
            }
            return stack;
        }
        return new ItemStack((ItemLike)byId, count);
    }
}

