/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.StatePredicateParser;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.Optional;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;

public class FluidPredicateParser {
    public static Component parseFluidPredicate(FluidPredicate predicate) {
        return LText.translatable("emi_loot.fluid_predicate.base", FluidPredicateParser.parseFluidPredicateInternal(predicate));
    }

    private static Component parseFluidPredicateInternal(FluidPredicate predicate) {
        Optional tag = predicate.tag();
        if (tag.isPresent()) {
            return LText.translatable("emi_loot.fluid_predicate.tag", ((TagKey)tag.get()).location().toString());
        }
        Optional fluid = predicate.fluid();
        if (fluid.isPresent()) {
            return LText.translatable("emi_loot.fluid_predicate.fluid", BuiltInRegistries.FLUID.getKey((Object)((Fluid)((Holder)fluid.get()).value())).toString());
        }
        Optional statePredicate = predicate.properties();
        if (statePredicate.isPresent()) {
            return StatePredicateParser.parseStatePredicate((StatePropertiesPredicate)statePredicate.get());
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Empty or unparsable fluid predicate in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }
}

