/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.parser.EnchantmentPredicateParser;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.processor.ListProcessors;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderSet;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public class ItemPredicateParser {
    public static Component parseItemPredicate(ItemPredicate predicate) {
        Optional tag = predicate.tag();
        if (tag.isPresent()) {
            return LText.translatable("emi_loot.item_predicate.tag", ((TagKey)tag.get()).location().toString());
        }
        Optional items = predicate.items();
        if (items.isPresent() && ((HolderSet)items.get()).size() > 0) {
            List<MutableComponent> list = ((HolderSet)items.get()).stream().map(item -> (MutableComponent)((Item)item.value()).getDescription()).toList();
            return LText.translatable("emi_loot.item_predicate.items", ListProcessors.buildOrList(list));
        }
        MinMaxBounds.Ints count = predicate.count();
        if (count != MinMaxBounds.Ints.ANY) {
            int finalMax = count.max().orElse(0);
            int finalMin = count.min().orElse(0);
            return LText.translatable("emi_loot.item_predicate.count", Integer.toString(finalMin), Integer.toString(finalMax));
        }
        MinMaxBounds.Ints durability = predicate.durability();
        if (durability != MinMaxBounds.Ints.ANY) {
            int finalMax = durability.max().orElse(0);
            int finalMin = durability.min().orElse(0);
            return LText.translatable("emi_loot.item_predicate.durability", Integer.toString(finalMin), Integer.toString(finalMax));
        }
        List enchants = predicate.enchantments();
        List storedEnchants = predicate.storedEnchantments();
        if (enchants.size() + storedEnchants.size() > 0) {
            ArrayList<EnchantmentPredicate> list = new ArrayList<EnchantmentPredicate>();
            list.addAll(enchants);
            list.addAll(storedEnchants);
            return EnchantmentPredicateParser.parseEnchantmentPredicates(list);
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Empty item predicate in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }
}

