/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.parser.BlockPredicateParser;
import fzzyhmstrs.emi_loot.parser.FluidPredicateParser;
import fzzyhmstrs.emi_loot.parser.LightPredicateParser;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.processor.NumberProcessors;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.Optional;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;

public class LocationPredicateParser {
    public static Component parseLocationPredicate(LocationPredicate predicate) {
        Optional dim;
        Optional position = predicate.position();
        if (position.isPresent()) {
            MinMaxBounds.Doubles x = ((LocationPredicate.PositionPredicate)position.get()).x();
            if (!x.equals((Object)MinMaxBounds.Doubles.ANY)) {
                return NumberProcessors.processNumberRange(x, "emi_loot.location_predicate.x.exact", "emi_loot.location_predicate.x", "emi_loot.location_predicate.x.at_least", "emi_loot.location_predicate.x.at_most", "Unknown X coordinate", new Object[0]);
            }
            MinMaxBounds.Doubles y = ((LocationPredicate.PositionPredicate)position.get()).y();
            if (!y.equals((Object)MinMaxBounds.Doubles.ANY)) {
                return NumberProcessors.processNumberRange(y, "emi_loot.location_predicate.y.exact", "emi_loot.location_predicate.y", "emi_loot.location_predicate.y.at_least", "emi_loot.location_predicate.y.at_most", "Unknown Y coordinate", new Object[0]);
            }
            MinMaxBounds.Doubles z = ((LocationPredicate.PositionPredicate)position.get()).z();
            if (!z.equals((Object)MinMaxBounds.Doubles.ANY)) {
                return NumberProcessors.processNumberRange(z, "emi_loot.location_predicate.z.exact", "emi_loot.location_predicate.z", "emi_loot.location_predicate.z.at_least", "emi_loot.location_predicate.z.at_most", "Unknown Z coordinate", new Object[0]);
            }
        }
        if ((dim = predicate.dimension()).isPresent()) {
            return LText.translatable("emi_loot.location_predicate.dim", ((ResourceKey)dim.get()).location().toString());
        }
        Optional biome = predicate.biome();
        if (biome.isPresent()) {
            return LText.translatable("emi_loot.location_predicate.biome", ((ResourceKey)biome.get()).location().toString());
        }
        Optional structure = predicate.structure();
        if (structure.isPresent()) {
            return LText.translatable("emi_loot.location_predicate.structure", ((ResourceKey)structure.get()).location().toString());
        }
        Optional smokey = predicate.smokey();
        if (smokey.isPresent()) {
            if (((Boolean)smokey.get()).booleanValue()) {
                return LText.translatable("emi_loot.location_predicate.smoke_true");
            }
            return LText.translatable("emi_loot.location_predicate.smoke_false");
        }
        Optional light = predicate.light();
        if (light.isPresent()) {
            return LightPredicateParser.parseLightPredicate((LightPredicate)light.get());
        }
        Optional block = predicate.block();
        if (block.isPresent()) {
            return BlockPredicateParser.parseBlockPredicate((BlockPredicate)block.get());
        }
        Optional fluid = predicate.fluid();
        if (fluid.isPresent()) {
            return FluidPredicateParser.parseFluidPredicate((FluidPredicate)fluid.get());
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Empty or unparsable location predicate in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }
}

