/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.parser.EntityPredicateParser;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.processor.ListProcessors;
import fzzyhmstrs.emi_loot.parser.processor.NumberProcessors;
import fzzyhmstrs.emi_loot.util.LText;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntityVariantPredicate;
import net.minecraft.advancements.critereon.FishingHookPredicate;
import net.minecraft.advancements.critereon.LightningBoltPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.SlimePredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.level.GameType;

public class TypeSpecificPredicateParser {
    public static Component parseTypeSpecificPredicate(EntitySubPredicate predicate) {
        if (predicate instanceof LightningBoltPredicate) {
            return TypeSpecificPredicateParser.parseLightningBoltPredicate((LightningBoltPredicate)predicate);
        }
        if (predicate instanceof FishingHookPredicate) {
            return TypeSpecificPredicateParser.parseFishingHookPredicate((FishingHookPredicate)predicate);
        }
        if (predicate instanceof PlayerPredicate) {
            return TypeSpecificPredicateParser.parsePlayerPredicate((PlayerPredicate)predicate);
        }
        if (predicate instanceof SlimePredicate) {
            return TypeSpecificPredicateParser.parseSlimePredicate((SlimePredicate)predicate);
        }
        if (predicate instanceof EntityVariantPredicate.SubPredicate) {
            EntityVariantPredicate.SubPredicate variantPredicate = (EntityVariantPredicate.SubPredicate)predicate;
            Object object = variantPredicate.variant();
            if (object instanceof CatVariant) {
                CatVariant cat = (CatVariant)object;
                id = BuiltInRegistries.CAT_VARIANT.getKey((Object)cat);
                if (id != null) {
                    MutableComponent catVar = LText.translatable("emi_loot.entity_predicate.type_specific.cat." + String.valueOf(id));
                    return LText.translatable("emi_loot.entity_predicate.type_specific.cat", catVar);
                }
            } else {
                FrogVariant frog;
                id = variantPredicate.variant();
                if (id instanceof FrogVariant && (id = BuiltInRegistries.FROG_VARIANT.getKey((Object)(frog = (FrogVariant)id))) != null) {
                    MutableComponent frogVar = LText.translatable("emi_loot.entity_predicate.type_specific.frog." + String.valueOf(id));
                    return LText.translatable("emi_loot.entity_predicate.type_specific.frog", frogVar);
                }
            }
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Type specific predicate undefined or unparsable. Affects table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }

    public static Component parseLightningBoltPredicate(LightningBoltPredicate predicate) {
        MinMaxBounds.Ints blocksSetOnFire = predicate.blocksSetOnFire();
        if (!blocksSetOnFire.equals((Object)MinMaxBounds.Ints.ANY)) {
            return LText.translatable("emi_loot.entity_predicate.type_specific.lightning", NumberProcessors.processNumberRange(blocksSetOnFire, "emi_loot.entity_predicate.type_specific.lightning.blocks", "emi_loot.entity_predicate.type_specific.lightning.blocks_2", "emi_loot.entity_predicate.type_specific.lightning.blocks_3", "emi_loot.entity_predicate.type_specific.lightning.blocks_4", "", new Object[0]));
        }
        Optional entityStruck = predicate.entityStruck();
        if (entityStruck.isPresent()) {
            return LText.translatable("emi_loot.entity_predicate.type_specific.lightning", LText.translatable("emi_loot.entity_predicate.type_specific.lightning.struck", EntityPredicateParser.parseEntityPredicate((EntityPredicate)entityStruck.get())));
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Lightning bolt predicate empty or unparsable. Affects table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }

    public static Component parseFishingHookPredicate(FishingHookPredicate predicate) {
        Optional inOpenWater = predicate.inOpenWater();
        return inOpenWater.isPresent() && (Boolean)inOpenWater.get() != false ? LText.translatable("emi_loot.entity_predicate.type_specific.fishing_hook_true") : LText.translatable("emi_loot.entity_predicate.type_specific.fishing_hook_false");
    }

    public static Component parsePlayerPredicate(PlayerPredicate predicate) {
        Map advancements;
        Object2BooleanMap recipes;
        MinMaxBounds.Ints experienceLevel = predicate.level();
        if (!experienceLevel.equals((Object)MinMaxBounds.Ints.ANY)) {
            return LText.translatable("emi_loot.entity_predicate.type_specific.player", NumberProcessors.processNumberRange(experienceLevel, "emi_loot.entity_predicate.type_specific.player.level", "emi_loot.entity_predicate.type_specific.player.level_2", "emi_loot.entity_predicate.type_specific.player.level_3", "emi_loot.entity_predicate.type_specific.player.level_4", "", new Object[0]));
        }
        Optional gameMode = predicate.gameType();
        if (gameMode.isPresent()) {
            return LText.translatable("emi_loot.entity_predicate.type_specific.player", LText.translatable("emi_loot.entity_predicate.type_specific.player.gamemode", ((GameType)gameMode.get()).getName()));
        }
        List stats = predicate.stats();
        if (!stats.isEmpty()) {
            LinkedList<MutableComponent> list = new LinkedList<MutableComponent>();
            for (PlayerPredicate.StatMatcher stat : stats) {
                String name = ((Stat)stat.stat().get()).getName();
                String[] namePieces = name.split(":");
                if (namePieces.length != 2) continue;
                String typeId = namePieces[0].replace('.', ':');
                String valueId = namePieces[1].replace('.', ':');
                MutableComponent num = NumberProcessors.processNumberRange(stat.range(), "emi_loot.entity_predicate.type_specific.player.stats.exact", "emi_loot.entity_predicate.type_specific.player.stats.between", "emi_loot.entity_predicate.type_specific.player.stats.at_least", "emi_loot.entity_predicate.type_specific.player.stats.at_most", "emi_loot.entity_predicate.type_specific.player.stats.fallback", new Object[0]);
                list.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.stats.type." + typeId, valueId, num));
            }
            if (!list.isEmpty()) {
                return LText.translatable("emi_loot.entity_predicate.type_specific.player", ListProcessors.buildAndList(list));
            }
        }
        if (!(recipes = predicate.recipes()).isEmpty()) {
            LinkedList<MutableComponent> list = new LinkedList<MutableComponent>();
            for (Object2BooleanMap.Entry entry : recipes.object2BooleanEntrySet()) {
                list.add(entry.getBooleanValue() ? LText.translatable("emi_loot.entity_predicate.type_specific.player.recipe_true", ((ResourceLocation)entry.getKey()).toString()) : LText.translatable("emi_loot.entity_predicate.type_specific.player.recipe_false", ((ResourceLocation)entry.getKey()).toString()));
            }
            if (!list.isEmpty()) {
                return LText.translatable("emi_loot.entity_predicate.type_specific.player", ListProcessors.buildAndList(list));
            }
        }
        if (!(advancements = predicate.advancements()).isEmpty()) {
            LinkedList<MutableComponent> list = new LinkedList<MutableComponent>();
            for (Map.Entry entry : advancements.entrySet()) {
                Object2BooleanMap criteria;
                String idString = ((ResourceLocation)entry.getKey()).toString();
                PlayerPredicate.AdvancementPredicate advancementPredicate = (PlayerPredicate.AdvancementPredicate)entry.getValue();
                if (advancementPredicate instanceof PlayerPredicate.AdvancementDonePredicate) {
                    boolean done = ((PlayerPredicate.AdvancementDonePredicate)advancementPredicate).state();
                    if (done) {
                        list.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.adv.id_true", idString));
                        continue;
                    }
                    list.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.adv.id_false", idString));
                    continue;
                }
                if (!(advancementPredicate instanceof PlayerPredicate.AdvancementCriterionsPredicate) || (criteria = ((PlayerPredicate.AdvancementCriterionsPredicate)advancementPredicate).criterions()).isEmpty()) continue;
                LinkedList<MutableComponent> list2 = new LinkedList<MutableComponent>();
                for (Object2BooleanMap.Entry criteriaEntry : criteria.object2BooleanEntrySet()) {
                    if (criteriaEntry.getBooleanValue()) {
                        list2.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.adv.crit_true", criteriaEntry.getKey()));
                        continue;
                    }
                    list2.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.adv.crit_false", criteriaEntry.getKey()));
                }
                list.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.adv.crit_base", idString, ListProcessors.buildAndList(list2)));
            }
            return LText.translatable("emi_loot.entity_predicate.type_specific.player", ListProcessors.buildAndList(list));
        }
        Optional entityPredicate = predicate.lookingAt();
        if (entityPredicate.isPresent()) {
            return LText.translatable("emi_loot.entity_predicate.type_specific.player", LText.translatable("emi_loot.entity_predicate.type_specific.player.looking", EntityPredicateParser.parseEntityPredicate((EntityPredicate)entityPredicate.get())));
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Lightning bolt predicate empty or unparsable. Affects table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }

    public static Component parseSlimePredicate(SlimePredicate predicate) {
        MinMaxBounds.Ints size = predicate.size();
        if (size.equals((Object)MinMaxBounds.Ints.ANY)) {
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.warn("Undefined slime size predicate in table: " + LootTableParser.currentTable);
            }
            return LText.translatable("emi_loot.predicate.invalid");
        }
        return NumberProcessors.processNumberRange(size, "emi_loot.entity_predicate.type_specific.slime", "emi_loot.entity_predicate.type_specific.slime_2", "emi_loot.entity_predicate.type_specific.slime_3", "emi_loot.entity_predicate.type_specific.slime_4", "", new Object[0]);
    }
}

