/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser.function;

import fzzyhmstrs.emi_loot.mixins.SetAttributesLootFunctionAccessor;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.function.FunctionParser;
import fzzyhmstrs.emi_loot.parser.processor.ListProcessors;
import fzzyhmstrs.emi_loot.parser.processor.NumberProcessors;
import fzzyhmstrs.emi_loot.util.LText;
import fzzyhmstrs.emi_loot.util.TextKey;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetAttributesFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class SetAttributesFunctionParser
implements FunctionParser {
    @Override
    public LootTableParser.LootFunctionResult parseFunction(LootItemFunction function, ItemStack stack, boolean parentIsAlternative, List<TextKey> conditionTexts) {
        List<SetAttributesFunction.Modifier> attributes = ((SetAttributesLootFunctionAccessor)function).getModifiers();
        LinkedList<MutableComponent> list = new LinkedList<MutableComponent>();
        for (SetAttributesFunction.Modifier attribute : attributes) {
            String name = attribute.name;
            NumberProvider amount = attribute.amount;
            AttributeModifier.Operation operation = attribute.operation;
            if (operation == AttributeModifier.Operation.ADDITION) {
                list.add(LText.translatable("emi_loot.function.set_attributes.add", Float.valueOf(NumberProcessors.getRollAvg(amount)), name));
                continue;
            }
            if (operation == AttributeModifier.Operation.MULTIPLY_BASE) {
                list.add(LText.translatable("emi_loot.function.set_attributes.multiply_base", Float.valueOf(NumberProcessors.getRollAvg(amount) + 1.0f), name));
                continue;
            }
            list.add(LText.translatable("emi_loot.function.set_attributes.multiply", Float.valueOf(NumberProcessors.getRollAvg(amount) + 1.0f), name));
        }
        return new LootTableParser.LootFunctionResult(TextKey.of("emi_loot.function.set_attributes", (Component)ListProcessors.buildAndList(list)), ItemStack.EMPTY, conditionTexts);
    }
}

