/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser.processor;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.mixins.BoundedIntUnaryOperatorAccessor;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraft.world.level.storage.loot.providers.number.ScoreboardValue;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class NumberProcessors {
    public static MutableComponent processBoolean(Boolean input, String keyTrue, String keyFalse, Object ... args) {
        if (input != null) {
            if (input.booleanValue()) {
                return LText.translatable(keyTrue, args);
            }
            return LText.translatable(keyFalse, args);
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Boolean null for keys: " + keyTrue + " / " + keyFalse + " in table: " + LootTableParser.currentTable);
        }
        return LText.empty();
    }

    public static MutableComponent processNumberRange(MinMaxBounds<?> range, String exact, String between, String atLeast, String atMost, String fallback, Object ... args) {
        if (!range.equals((Object)MinMaxBounds.Ints.ANY) && !range.equals((Object)MinMaxBounds.Doubles.ANY)) {
            Optional max;
            Optional min = range.min();
            if (Objects.equals(min, max = range.max()) && min.isPresent()) {
                ArrayList<Object> realArgs = args.length > 0 ? new ArrayList<Object>(Arrays.stream(args).toList()) : new ArrayList();
                realArgs.add(0, min.get());
                return LText.translatable(exact, realArgs.toArray());
            }
            if (min.isPresent() && max.isPresent()) {
                ArrayList<Object> realArgs = args.length > 0 ? new ArrayList<Object>(Arrays.stream(args).toList()) : new ArrayList();
                realArgs.add(0, max.get());
                realArgs.add(0, min.get());
                return LText.translatable(between, realArgs.toArray());
            }
            if (min.isPresent()) {
                ArrayList<Object> realArgs = args.length > 0 ? new ArrayList<Object>(Arrays.stream(args).toList()) : new ArrayList();
                realArgs.add(0, min.get());
                return LText.translatable(atLeast, realArgs.toArray());
            }
            if (max.isPresent()) {
                ArrayList<Object> realArgs = args.length > 0 ? new ArrayList<Object>(Arrays.stream(args).toList()) : new ArrayList();
                realArgs.add(0, max.get());
                return LText.translatable(atMost, realArgs.toArray());
            }
            if (fallback.isEmpty()) {
                return LText.empty();
            }
            return LText.translatable(fallback);
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Non-specific number range for keys: " + exact + " / " + between + " in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }

    public static MutableComponent processBoundedIntUnaryOperator(IntRange operator) {
        NumberProvider min = ((BoundedIntUnaryOperatorAccessor)operator).getMin();
        NumberProvider max = ((BoundedIntUnaryOperatorAccessor)operator).getMax();
        if (min != null && max != null) {
            float maxVal;
            float minVal;
            if (min.getType() == NumberProviders.CONSTANT && max.getType() == NumberProviders.CONSTANT && (minVal = ((ConstantValue)min).value()) == (maxVal = ((ConstantValue)max).value())) {
                return NumberProcessors.processLootNumberProvider(min);
            }
            return LText.translatable("emi_loot.operator.between", NumberProcessors.processLootNumberProvider(min), NumberProcessors.processLootNumberProvider(max));
        }
        if (min != null) {
            return LText.translatable("emi_loot.operator.min", NumberProcessors.processLootNumberProvider(min));
        }
        if (max != null) {
            return LText.translatable("emi_loot.operator.max", NumberProcessors.processLootNumberProvider(max));
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Null or undefined bounded int unary operator in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.operator.unknown");
    }

    public static MutableComponent processLootNumberProvider(NumberProvider provider) {
        LootNumberProviderType type = provider.getType();
        if (type == NumberProviders.CONSTANT) {
            return LText.translatable("emi_loot.number_provider.constant", Float.valueOf(((ConstantValue)provider).value()));
        }
        if (type == NumberProviders.BINOMIAL) {
            NumberProvider n = ((BinomialDistributionGenerator)provider).n();
            NumberProvider p = ((BinomialDistributionGenerator)provider).p();
            float nVal = NumberProcessors.getRollAvg(n);
            float pVal = NumberProcessors.getRollAvg(p);
            MutableComponent nValText = NumberProcessors.processLootNumberProvider(n);
            MutableComponent pValText = NumberProcessors.processLootNumberProvider(p);
            float avg = nVal * pVal;
            return LText.translatable("emi_loot.number_provider.binomial", nValText, pValText, Float.valueOf(avg));
        }
        if (type == NumberProviders.UNIFORM) {
            NumberProvider min = ((UniformGenerator)provider).min();
            NumberProvider max = ((UniformGenerator)provider).max();
            float minVal = NumberProcessors.getRollAvg(min);
            float maxVal = NumberProcessors.getRollAvg(max);
            MutableComponent minValText = NumberProcessors.processLootNumberProvider(min);
            MutableComponent maxValText = NumberProcessors.processLootNumberProvider(max);
            float avg = (minVal + maxVal) / 2.0f;
            return LText.translatable("emi_loot.number_provider.uniform", minValText, maxValText, Float.valueOf(avg));
        }
        if (type == NumberProviders.SCORE) {
            String lootScore = ((ScoreboardValue)provider).score();
            float lootScale = ((ScoreboardValue)provider).scale();
            return LText.translatable("emi_loot.number_provider.score", lootScore, Float.valueOf(lootScale));
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Non-specific or undefined number provider in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.number_provider.unknown");
    }

    public static float getRollAvg(NumberProvider provider) {
        LootNumberProviderType type = provider.getType();
        if (type == NumberProviders.CONSTANT) {
            return ((ConstantValue)provider).value();
        }
        if (type == NumberProviders.BINOMIAL) {
            NumberProvider n = ((BinomialDistributionGenerator)provider).n();
            NumberProvider p = ((BinomialDistributionGenerator)provider).p();
            float nVal = NumberProcessors.getRollAvg(n);
            float pVal = NumberProcessors.getRollAvg(p);
            return nVal * pVal;
        }
        if (type == NumberProviders.UNIFORM) {
            NumberProvider min = ((UniformGenerator)provider).min();
            NumberProvider max = ((UniformGenerator)provider).max();
            float minVal = NumberProcessors.getRollAvg(min);
            float maxVal = NumberProcessors.getRollAvg(max);
            return (minVal + maxVal) / 2.0f;
        }
        if (type == NumberProviders.SCORE) {
            return 0.0f;
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Loot number provider with unknown type: " + provider.getType().toString());
        }
        return 0.0f;
    }
}

