/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.server;

import fzzyhmstrs.emi_loot.server.LootBuilder;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public interface LootSender<T extends LootBuilder> {
    public String getId();

    public void send(ServerPlayer var1);

    public void addBuilder(T var1);

    public List<T> getBuilders();

    public void build();

    public static String getIdToSend(ResourceLocation id) {
        if (id.getNamespace().equals("minecraft")) {
            String path = id.getPath();
            if (path.contains("blocks/")) {
                return "b/" + path.substring(7);
            }
            if (path.contains("entities/")) {
                return "e/" + path.substring(9);
            }
            if (path.contains("chests/")) {
                return "c/" + path.substring(7);
            }
            if (path.contains("gameplay/")) {
                return "g/" + path.substring(9);
            }
            if (path.contains("archaeology/")) {
                return "a/" + path.substring(12);
            }
            return path;
        }
        return id.toString();
    }

    default public void writeItemStack(FriendlyByteBuf buf, ItemStack stack, Level world) {
        buf.writeVarInt(BuiltInRegistries.ITEM.getId((Object)stack.getItem()));
        buf.writeVarInt(stack.getCount());
        CompoundTag nbt = stack.getTag();
        if (nbt == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeNbt((Tag)nbt);
        }
    }
}

