/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.server;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.server.ComplexLootPoolBuilder;
import fzzyhmstrs.emi_loot.server.LootSender;
import fzzyhmstrs.emi_loot.server.SimpleLootPoolBuilder;
import fzzyhmstrs.emi_loot.util.SimpleCustomPayload;
import fzzyhmstrs.emi_loot.util.TextKey;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2359;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.class_8710;

public class GameplayLootTableSender
implements LootSender<ComplexLootPoolBuilder> {
    private final String idToSend;
    final List<ComplexLootPoolBuilder> builderList = new LinkedList<ComplexLootPoolBuilder>();
    public static class_2960 GAMEPLAY_SENDER = new class_2960("e_l", "g_s");
    boolean isEmpty = true;

    public GameplayLootTableSender(class_2960 id) {
        this.idToSend = LootSender.getIdToSend(id);
    }

    @Override
    public String getId() {
        return this.idToSend;
    }

    @Override
    public void build() {
        this.builderList.forEach(builder -> {
            builder.build();
            if (!builder.isEmpty) {
                this.isEmpty = false;
            }
        });
    }

    @Override
    public void send(class_3222 player) {
        if (!ConfigApi.INSTANCE.network().canSend(GAMEPLAY_SENDER, (class_1657)player)) {
            return;
        }
        if (this.isEmpty) {
            if (EMILoot.config.isDebug(EMILoot.Type.GAMEPLAY)) {
                EMILoot.LOGGER.info("avoiding empty gameplay table: " + this.idToSend);
            }
            return;
        }
        class_2540 buf = ConfigApi.INSTANCE.network().buf();
        buf.method_10814(this.idToSend);
        if (this.builderList.size() == 1 && this.builderList.get((int)0).isSimple) {
            if (EMILoot.config.isDebug(EMILoot.Type.GAMEPLAY)) {
                EMILoot.LOGGER.info("sending simple gameplay table: " + this.idToSend);
            }
            buf.method_52998(-1);
            buf.method_42065((class_2359)class_7923.field_41178, (Object)this.builderList.get((int)0).simpleStack.method_7909());
            ConfigApi.INSTANCE.network().send((class_8710)new SimpleCustomPayload(buf, GAMEPLAY_SENDER), (class_1657)player);
            return;
        }
        if (this.builderList.isEmpty()) {
            return;
        }
        buf.method_52998(this.builderList.size());
        this.builderList.forEach(builder -> {
            ArrayList totalConditions = new ArrayList();
            builder.conditions.forEach(lootConditionResult -> totalConditions.add(lootConditionResult.text()));
            builder.functions.forEach(lootFunctionResult -> totalConditions.addAll(lootFunctionResult.conditions()));
            buf.method_52998(totalConditions.size());
            totalConditions.forEach(lootConditionResult -> lootConditionResult.toBuf(buf));
            buf.method_52998(builder.functions.size());
            builder.functions.forEach(lootFunctionResult -> lootFunctionResult.text().toBuf(buf));
            HashMap<List<TextKey>, SimpleLootPoolBuilder> lootPoolBuilderMap = builder.builtMap;
            buf.method_52998(lootPoolBuilderMap.size());
            lootPoolBuilderMap.forEach((key, chestBuilder) -> {
                buf.method_52998(key.size());
                key.forEach(textKey -> textKey.toBuf(buf));
                Object2FloatMap<class_1799> keyPoolMap = lootPoolBuilderMap.getOrDefault((Object)key, new SimpleLootPoolBuilder((float)1.0f)).builtMap;
                buf.method_52998(keyPoolMap.size());
                keyPoolMap.forEach((stack, weight) -> {
                    this.writeItemStack(buf, (class_1799)stack, player.method_37908());
                    buf.method_52941(weight.floatValue());
                });
            });
        });
        ConfigApi.INSTANCE.network().send((class_8710)new SimpleCustomPayload(buf, GAMEPLAY_SENDER), (class_1657)player);
    }

    @Override
    public void addBuilder(ComplexLootPoolBuilder builder) {
        this.builderList.add(builder);
    }

    @Override
    public List<ComplexLootPoolBuilder> getBuilders() {
        return this.builderList;
    }
}

