/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.neoforge;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.neoforge.util.BlockRendererImpl;
import fzzyhmstrs.emi_loot.server.condition.BlownUpByCreeperLootCondition;
import fzzyhmstrs.emi_loot.server.condition.KilledByWitherLootCondition;
import fzzyhmstrs.emi_loot.server.condition.MobSpawnedWithLootCondition;
import fzzyhmstrs.emi_loot.server.function.OminousBannerLootFunction;
import fzzyhmstrs.emi_loot.server.function.SetAnyDamageLootFunction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="emi_loot")
public class EMILootNeoForge {
    public static final DeferredRegister<LootItemConditionType> LOOT_CONDITION_TYPES = DeferredRegister.create((ResourceKey)Registries.LOOT_CONDITION_TYPE, (String)"lootify");
    public static final DeferredRegister<LootItemFunctionType<?>> LOOT_FUNCTION_TYPES = DeferredRegister.create((ResourceKey)Registries.LOOT_FUNCTION_TYPE, (String)"lootify");
    public static final DeferredRegister<Enchantment> ENCHANTMENTS = DeferredRegister.create((ResourceKey)Registries.ENCHANTMENT, (String)"emi_loot");

    public EMILootNeoForge(IEventBus modBus) {
        LOOT_CONDITION_TYPES.register(modBus);
        LOOT_FUNCTION_TYPES.register(modBus);
        ENCHANTMENTS.register(modBus);
        if (FMLLoader.getDist().isClient()) {
            NeoForge.EVENT_BUS.addListener(BlockRendererImpl::onClientTick);
        }
        EMILoot.onInitialize();
    }

    static {
        EMILoot.WITHER_KILL = LOOT_CONDITION_TYPES.register("wither_kill", () -> new LootItemConditionType(KilledByWitherLootCondition.CODEC));
        EMILoot.SPAWNS_WITH = LOOT_CONDITION_TYPES.register("spawns_with", () -> new LootItemConditionType(MobSpawnedWithLootCondition.CODEC));
        EMILoot.CREEPER = LOOT_CONDITION_TYPES.register("creeper", () -> new LootItemConditionType(BlownUpByCreeperLootCondition.CODEC));
        EMILoot.SET_ANY_DAMAGE = LOOT_FUNCTION_TYPES.register("set_any_damage", () -> new LootItemFunctionType(SetAnyDamageLootFunction.CODEC));
        EMILoot.OMINOUS_BANNER = LOOT_FUNCTION_TYPES.register("ominous_banner", () -> new LootItemFunctionType(OminousBannerLootFunction.CODEC));
        EMILoot.RANDOM = ENCHANTMENTS.register("random", () -> new Enchantment(Enchantment.definition((TagKey)ItemTags.ANVIL, (TagKey)ItemTags.ANVIL, (int)1, (int)1, (Enchantment.Cost)new Enchantment.Cost(10, 0), (Enchantment.Cost)new Enchantment.Cost(30, 0), (int)30, (EquipmentSlot[])new EquipmentSlot[]{EquipmentSlot.MAINHAND})){

            public boolean isTradeable() {
                return false;
            }

            public boolean isDiscoverable() {
                return false;
            }
        });
    }
}

