/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.parser.DistancePredicateParser;
import fzzyhmstrs.emi_loot.parser.EntityEffectPredicateParser;
import fzzyhmstrs.emi_loot.parser.EntityEquipmentPredicateParser;
import fzzyhmstrs.emi_loot.parser.EntityFlagsPredicateParser;
import fzzyhmstrs.emi_loot.parser.EntityTypePredicateParser;
import fzzyhmstrs.emi_loot.parser.LocationPredicateParser;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.NbtPredicateParser;
import fzzyhmstrs.emi_loot.parser.TypeSpecificPredicateParser;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.Optional;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.network.chat.Component;

public class EntityPredicateParser {
    public static Component parseEntityPredicate(EntityPredicate predicate) {
        return LText.translatable("emi_loot.entity_predicate.base", EntityPredicateParser.parseEntityPredicateInternal(predicate));
    }

    private static Component parseEntityPredicateInternal(EntityPredicate predicate) {
        Optional typePredicate = predicate.entityType();
        if (typePredicate.isPresent()) {
            return EntityTypePredicateParser.parseEntityTypePredicate((EntityTypePredicate)typePredicate.get());
        }
        Optional distancePredicate = predicate.distanceToPlayer();
        if (distancePredicate.isPresent()) {
            return DistancePredicateParser.parseDistancePredicate((DistancePredicate)distancePredicate.get());
        }
        Optional locationPredicate = predicate.location();
        if (locationPredicate.isPresent()) {
            return LocationPredicateParser.parseLocationPredicate((LocationPredicate)locationPredicate.get());
        }
        Optional steppingOnPredicate = predicate.steppingOnLocation();
        if (steppingOnPredicate.isPresent()) {
            return LocationPredicateParser.parseLocationPredicate((LocationPredicate)locationPredicate.get());
        }
        Optional entityEffectPredicate = predicate.effects();
        if (entityEffectPredicate.isPresent()) {
            return EntityEffectPredicateParser.parseEntityEffectPredicate((MobEffectsPredicate)entityEffectPredicate.get());
        }
        Optional nbt = predicate.nbt();
        if (nbt.isPresent()) {
            return NbtPredicateParser.parseNbtPredicate((NbtPredicate)nbt.get());
        }
        Optional entityFlagsPredicate = predicate.flags();
        if (entityFlagsPredicate.isPresent()) {
            return EntityFlagsPredicateParser.parseEntityFlagsPredicate((EntityFlagsPredicate)entityFlagsPredicate.get());
        }
        Optional entityEquipmentPredicate = predicate.equipment();
        if (entityEquipmentPredicate.isPresent()) {
            return EntityEquipmentPredicateParser.parseEntityEquipmentPredicate((EntityEquipmentPredicate)entityEquipmentPredicate.get());
        }
        Optional typeSpecificPredicate = predicate.subPredicate();
        if (typeSpecificPredicate.isPresent()) {
            return TypeSpecificPredicateParser.parseTypeSpecificPredicate((EntitySubPredicate)typeSpecificPredicate.get());
        }
        Optional vehicle = predicate.vehicle();
        if (vehicle.isPresent()) {
            return EntityPredicateParser.parseEntityPredicate((EntityPredicate)vehicle.get());
        }
        Optional passenger = predicate.passenger();
        if (passenger.isPresent()) {
            return EntityPredicateParser.parseEntityPredicate((EntityPredicate)passenger.get());
        }
        Optional targetedEntity = predicate.targetedEntity();
        if (targetedEntity.isPresent()) {
            return EntityPredicateParser.parseEntityPredicate((EntityPredicate)targetedEntity.get());
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Entity predicate undefined in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }
}

