/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.mixins.EnchantmentsPredicateAccessor;
import fzzyhmstrs.emi_loot.parser.EnchantmentPredicateParser;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.NbtPredicateParser;
import fzzyhmstrs.emi_loot.parser.processor.ListProcessors;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.ItemAttributeModifiersPredicate;
import net.minecraft.advancements.critereon.ItemBundlePredicate;
import net.minecraft.advancements.critereon.ItemContainerPredicate;
import net.minecraft.advancements.critereon.ItemCustomDataPredicate;
import net.minecraft.advancements.critereon.ItemDamagePredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemFireworkExplosionPredicate;
import net.minecraft.advancements.critereon.ItemFireworksPredicate;
import net.minecraft.advancements.critereon.ItemPotionsPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemTrimPredicate;
import net.minecraft.advancements.critereon.ItemWritableBookPredicate;
import net.minecraft.advancements.critereon.ItemWrittenBookPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderSet;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.component.FireworkExplosion;

public class ItemSubPredicateParser {
    public static Component parseItemSubPredicate(ItemSubPredicate.Type<? extends ItemSubPredicate> type, ItemSubPredicate predicate) {
        if (predicate instanceof ItemDamagePredicate) {
            ItemDamagePredicate damagePredicate = (ItemDamagePredicate)predicate;
            MinMaxBounds.Ints durability = damagePredicate.durability();
            if (durability != MinMaxBounds.Ints.ANY) {
                int finalMax = durability.max().orElse(0);
                int finalMin = durability.min().orElse(0);
                return LText.translatable("emi_loot.item_predicate.durability", Integer.toString(finalMin), Integer.toString(finalMax));
            }
            MinMaxBounds.Ints damage = damagePredicate.damage();
            if (damage != MinMaxBounds.Ints.ANY) {
                int finalMax = durability.max().orElse(0);
                int finalMin = durability.min().orElse(0);
                return LText.translatable("emi_loot.item_predicate.damage", Integer.toString(finalMin), Integer.toString(finalMax));
            }
        } else {
            if (predicate instanceof ItemEnchantmentsPredicate.Enchantments) {
                ItemEnchantmentsPredicate.Enchantments enchantmentPredicate = (ItemEnchantmentsPredicate.Enchantments)predicate;
                return EnchantmentPredicateParser.parseEnchantmentPredicates(((EnchantmentsPredicateAccessor)enchantmentPredicate).getEnchantments());
            }
            if (predicate instanceof ItemEnchantmentsPredicate.StoredEnchantments) {
                ItemEnchantmentsPredicate.StoredEnchantments enchantmentPredicate = (ItemEnchantmentsPredicate.StoredEnchantments)predicate;
                return EnchantmentPredicateParser.parseEnchantmentPredicates(((EnchantmentsPredicateAccessor)enchantmentPredicate).getEnchantments());
            }
            if (predicate instanceof ItemPotionsPredicate) {
                ItemPotionsPredicate potionContentsPredicate = (ItemPotionsPredicate)predicate;
                HolderSet potions = potionContentsPredicate.potions();
                if (potions.unwrapKey().isPresent()) {
                    return LText.translatable("emi_loot.predicate.potion.tag", ((TagKey)potions.unwrapKey().get()).location().toString());
                }
                if (potions.size() > 0) {
                    List<MutableComponent> list = potions.stream().map(p -> LText.translatable(Potion.getName(Optional.of(p), (String)(Items.POTION.getDescriptionId() + ".effect.")))).toList();
                    return LText.translatable("emi_loot.predicate.potion.list", ListProcessors.buildOrList(list));
                }
            } else {
                if (predicate instanceof ItemCustomDataPredicate) {
                    ItemCustomDataPredicate customDataPredicate = (ItemCustomDataPredicate)predicate;
                    return NbtPredicateParser.parseNbtPredicate(customDataPredicate.value());
                }
                if (predicate instanceof ItemContainerPredicate) {
                    return LText.translatable("emi_loot.predicate.container");
                }
                if (predicate instanceof ItemBundlePredicate) {
                    return LText.translatable("emi_loot.predicate.container");
                }
                if (predicate instanceof ItemFireworkExplosionPredicate) {
                    ItemFireworkExplosionPredicate fireworkExplosionPredicate = (ItemFireworkExplosionPredicate)predicate;
                    ItemFireworkExplosionPredicate.FireworkPredicate fireworkExplosionPredicatePredicate = fireworkExplosionPredicate.predicate();
                    if (fireworkExplosionPredicatePredicate.shape().isPresent()) {
                        MutableComponent v = ((FireworkExplosion.Shape)fireworkExplosionPredicatePredicate.shape().get()).getName();
                        return LText.translatable("emi_loot.predicate.firework.shape", v);
                    }
                    if (fireworkExplosionPredicatePredicate.twinkle().isPresent()) {
                        return (Boolean)fireworkExplosionPredicatePredicate.twinkle().get() != false ? LText.translatable("emi_loot.predicate.firework.twinkle") : LText.translatable("emi_loot.predicate.firework.no_twinkle");
                    }
                    if (fireworkExplosionPredicatePredicate.trail().isPresent()) {
                        return (Boolean)fireworkExplosionPredicatePredicate.trail().get() != false ? LText.translatable("emi_loot.predicate.firework.trail") : LText.translatable("emi_loot.predicate.firework.no_trail");
                    }
                    return LText.translatable("emi_loot.predicate.container");
                }
                if (predicate instanceof ItemFireworksPredicate) {
                    return LText.translatable("emi_loot.predicate.fireworks");
                }
                if (predicate instanceof ItemWritableBookPredicate) {
                    return LText.translatable("emi_loot.predicate.writable_book");
                }
                if (predicate instanceof ItemWrittenBookPredicate) {
                    return LText.translatable("emi_loot.predicate.writable_book");
                }
                if (predicate instanceof ItemAttributeModifiersPredicate) {
                    return LText.translatable("emi_loot.predicate.attribute");
                }
                if (predicate instanceof ItemTrimPredicate) {
                    return LText.translatable("emi_loot.predicate.trim");
                }
            }
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Empty item predicate in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }
}

