/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.mixins.VariantPredicateAccessor;
import fzzyhmstrs.emi_loot.parser.EntityPredicateParser;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.processor.ListProcessors;
import fzzyhmstrs.emi_loot.parser.processor.NumberProcessors;
import fzzyhmstrs.emi_loot.util.LText;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicates;
import net.minecraft.advancements.critereon.FishingHookPredicate;
import net.minecraft.advancements.critereon.LightningBoltPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.SlimePredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.GameType;

public class TypeSpecificPredicateParser {
    public static Component parseTypeSpecificPredicate(EntitySubPredicate predicate) {
        if (predicate instanceof LightningBoltPredicate) {
            return TypeSpecificPredicateParser.parseLightningBoltPredicate((LightningBoltPredicate)predicate);
        }
        if (predicate instanceof FishingHookPredicate) {
            return TypeSpecificPredicateParser.parseFishingHookPredicate((FishingHookPredicate)predicate);
        }
        if (predicate instanceof PlayerPredicate) {
            return TypeSpecificPredicateParser.parsePlayerPredicate((PlayerPredicate)predicate);
        }
        if (predicate instanceof SlimePredicate) {
            return TypeSpecificPredicateParser.parseSlimePredicate((SlimePredicate)predicate);
        }
        if (predicate instanceof EntitySubPredicates.EntityVariantPredicateType.Instance) {
            EntitySubPredicates.EntityVariantPredicateType.Instance variantPredicate = (EntitySubPredicates.EntityVariantPredicateType.Instance)predicate;
            Object v = ((VariantPredicateAccessor)variantPredicate).getVariant();
            if (v instanceof CatVariant) {
                CatVariant cat = (CatVariant)v;
                id = BuiltInRegistries.CAT_VARIANT.getKey((Object)cat);
                if (id != null) {
                    MutableComponent v2 = LText.translatable("emi_loot.entity_predicate.type_specific.cat." + String.valueOf(id));
                    return LText.translatable("emi_loot.entity_predicate.type_specific.cat", v2);
                }
            } else {
                id = ((VariantPredicateAccessor)variantPredicate).getVariant();
                if (id instanceof FrogVariant) {
                    FrogVariant frog = (FrogVariant)id;
                    if ((id = BuiltInRegistries.FROG_VARIANT.getKey((Object)frog)) != null) {
                        MutableComponent v3 = LText.translatable("emi_loot.entity_predicate.type_specific.frog." + String.valueOf(id));
                        return LText.translatable("emi_loot.entity_predicate.type_specific.frog", v3);
                    }
                } else {
                    id = ((VariantPredicateAccessor)variantPredicate).getVariant();
                    if (id instanceof Axolotl.Variant) {
                        Axolotl.Variant axolotl = (Axolotl.Variant)id;
                        name = axolotl.getName();
                        if (name != null) {
                            MutableComponent v4 = LText.translatable("emi_loot.entity_predicate.type_specific.axolotl." + name);
                            return LText.translatable("emi_loot.entity_predicate.type_specific.axolotl", v4);
                        }
                    } else {
                        name = ((VariantPredicateAccessor)variantPredicate).getVariant();
                        if (name instanceof Boat.Type) {
                            Boat.Type boat = (Boat.Type)name;
                            if ((name = boat.getName()) != null) {
                                MutableComponent v5 = LText.translatable("emi_loot.entity_predicate.type_specific.boat." + name);
                                return LText.translatable("emi_loot.entity_predicate.type_specific.boat", v5);
                            }
                        } else {
                            name = ((VariantPredicateAccessor)variantPredicate).getVariant();
                            if (name instanceof Fox.Type) {
                                Fox.Type fox = (Fox.Type)name;
                                if ((name = fox.getSerializedName()) != null) {
                                    MutableComponent v6 = LText.translatable("emi_loot.entity_predicate.type_specific.fox." + name);
                                    return LText.translatable("emi_loot.entity_predicate.type_specific.fox", v6);
                                }
                            } else {
                                name = ((VariantPredicateAccessor)variantPredicate).getVariant();
                                if (name instanceof MushroomCow.MushroomType) {
                                    MushroomCow.MushroomType moo = (MushroomCow.MushroomType)name;
                                    if ((name = moo.getSerializedName()) != null) {
                                        MutableComponent v7 = LText.translatable("emi_loot.entity_predicate.type_specific.mooshroom." + name);
                                        return LText.translatable("emi_loot.entity_predicate.type_specific.mooshroom", v7);
                                    }
                                } else {
                                    name = ((VariantPredicateAccessor)variantPredicate).getVariant();
                                    if (name instanceof Rabbit.Variant) {
                                        Rabbit.Variant rabbit = (Rabbit.Variant)name;
                                        if ((name = rabbit.getSerializedName()) != null) {
                                            MutableComponent v8 = LText.translatable("emi_loot.entity_predicate.type_specific.rabbit." + name);
                                            return LText.translatable("emi_loot.entity_predicate.type_specific.rabbit", v8);
                                        }
                                    } else {
                                        name = ((VariantPredicateAccessor)variantPredicate).getVariant();
                                        if (name instanceof Variant) {
                                            Variant horse = (Variant)name;
                                            if ((name = horse.getSerializedName()) != null) {
                                                MutableComponent v9 = LText.translatable("emi_loot.entity_predicate.type_specific.horse." + name);
                                                return LText.translatable("emi_loot.entity_predicate.type_specific.horse", v9);
                                            }
                                        } else {
                                            name = ((VariantPredicateAccessor)variantPredicate).getVariant();
                                            if (name instanceof Llama.Variant) {
                                                Llama.Variant llama = (Llama.Variant)name;
                                                if ((name = llama.getSerializedName()) != null) {
                                                    MutableComponent v10 = LText.translatable("emi_loot.entity_predicate.type_specific.llama." + name);
                                                    return LText.translatable("emi_loot.entity_predicate.type_specific.llama", v10);
                                                }
                                            } else {
                                                name = ((VariantPredicateAccessor)variantPredicate).getVariant();
                                                if (name instanceof VillagerType) {
                                                    VillagerType villager = (VillagerType)name;
                                                    if ((name = villager.toString()) != null) {
                                                        MutableComponent v11 = LText.translatable("emi_loot.entity_predicate.type_specific.villager." + name);
                                                        return LText.translatable("emi_loot.entity_predicate.type_specific.villager", v11);
                                                    }
                                                } else {
                                                    name = ((VariantPredicateAccessor)variantPredicate).getVariant();
                                                    if (name instanceof Parrot.Variant) {
                                                        Parrot.Variant parrot = (Parrot.Variant)name;
                                                        if ((name = parrot.getSerializedName()) != null) {
                                                            MutableComponent v12 = LText.translatable("emi_loot.entity_predicate.type_specific.parrot." + name);
                                                            return LText.translatable("emi_loot.entity_predicate.type_specific.parrot", v12);
                                                        }
                                                    } else {
                                                        name = ((VariantPredicateAccessor)variantPredicate).getVariant();
                                                        if (name instanceof TropicalFish.Pattern) {
                                                            TropicalFish.Pattern tropical_fish = (TropicalFish.Pattern)name;
                                                            if ((name = tropical_fish.displayName()) != null) {
                                                                return LText.translatable("emi_loot.entity_predicate.type_specific.tropical_fish", name);
                                                            }
                                                        } else {
                                                            if (((VariantPredicateAccessor)variantPredicate).getVariant() instanceof PaintingVariant) {
                                                                return LText.translatable("emi_loot.entity_predicate.type_specific.painting");
                                                            }
                                                            if (((VariantPredicateAccessor)variantPredicate).getVariant() instanceof WolfVariant) {
                                                                return LText.translatable("emi_loot.entity_predicate.type_specific.wolf");
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Type specific predicate undefined or unparsable. Affects table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }

    public static Component parseLightningBoltPredicate(LightningBoltPredicate predicate) {
        MinMaxBounds.Ints blocksSetOnFire = predicate.blocksSetOnFire();
        if (!blocksSetOnFire.equals((Object)MinMaxBounds.Ints.ANY)) {
            return LText.translatable("emi_loot.entity_predicate.type_specific.lightning", NumberProcessors.processNumberRange(blocksSetOnFire, "emi_loot.entity_predicate.type_specific.lightning.blocks", "emi_loot.entity_predicate.type_specific.lightning.blocks_2", "emi_loot.entity_predicate.type_specific.lightning.blocks_3", "emi_loot.entity_predicate.type_specific.lightning.blocks_4", "", new Object[0]));
        }
        Optional entityStruck = predicate.entityStruck();
        if (entityStruck.isPresent()) {
            return LText.translatable("emi_loot.entity_predicate.type_specific.lightning", LText.translatable("emi_loot.entity_predicate.type_specific.lightning.struck", EntityPredicateParser.parseEntityPredicate((EntityPredicate)entityStruck.get())));
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Lightning bolt predicate empty or unparsable. Affects table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }

    public static Component parseFishingHookPredicate(FishingHookPredicate predicate) {
        Optional inOpenWater = predicate.inOpenWater();
        return inOpenWater.isPresent() && (Boolean)inOpenWater.get() != false ? LText.translatable("emi_loot.entity_predicate.type_specific.fishing_hook_true") : LText.translatable("emi_loot.entity_predicate.type_specific.fishing_hook_false");
    }

    public static Component parsePlayerPredicate(PlayerPredicate predicate) {
        Map advancements;
        Object2BooleanMap recipes;
        MinMaxBounds.Ints experienceLevel = predicate.level();
        if (!experienceLevel.equals((Object)MinMaxBounds.Ints.ANY)) {
            return LText.translatable("emi_loot.entity_predicate.type_specific.player", NumberProcessors.processNumberRange(experienceLevel, "emi_loot.entity_predicate.type_specific.player.level", "emi_loot.entity_predicate.type_specific.player.level_2", "emi_loot.entity_predicate.type_specific.player.level_3", "emi_loot.entity_predicate.type_specific.player.level_4", "", new Object[0]));
        }
        Optional gameMode = predicate.gameType();
        if (gameMode.isPresent()) {
            return LText.translatable("emi_loot.entity_predicate.type_specific.player", LText.translatable("emi_loot.entity_predicate.type_specific.player.gamemode", ((GameType)gameMode.get()).getName()));
        }
        List stats = predicate.stats();
        if (!stats.isEmpty()) {
            LinkedList<MutableComponent> list = new LinkedList<MutableComponent>();
            for (PlayerPredicate.StatMatcher stat : stats) {
                String name = ((Stat)stat.stat().get()).getName();
                String[] namePieces = name.split(":");
                if (namePieces.length != 2) continue;
                String typeId = namePieces[0].replace('.', ':');
                String valueId = namePieces[1].replace('.', ':');
                MutableComponent num = NumberProcessors.processNumberRange(stat.range(), "emi_loot.entity_predicate.type_specific.player.stats.exact", "emi_loot.entity_predicate.type_specific.player.stats.between", "emi_loot.entity_predicate.type_specific.player.stats.at_least", "emi_loot.entity_predicate.type_specific.player.stats.at_most", "emi_loot.entity_predicate.type_specific.player.stats.fallback", new Object[0]);
                list.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.stats.type." + typeId, valueId, num));
            }
            if (!list.isEmpty()) {
                return LText.translatable("emi_loot.entity_predicate.type_specific.player", ListProcessors.buildAndList(list));
            }
        }
        if (!(recipes = predicate.recipes()).isEmpty()) {
            LinkedList<MutableComponent> list = new LinkedList<MutableComponent>();
            for (Object2BooleanMap.Entry entry : recipes.object2BooleanEntrySet()) {
                list.add(entry.getBooleanValue() ? LText.translatable("emi_loot.entity_predicate.type_specific.player.recipe_true", ((ResourceLocation)entry.getKey()).toString()) : LText.translatable("emi_loot.entity_predicate.type_specific.player.recipe_false", ((ResourceLocation)entry.getKey()).toString()));
            }
            if (!list.isEmpty()) {
                return LText.translatable("emi_loot.entity_predicate.type_specific.player", ListProcessors.buildAndList(list));
            }
        }
        if (!(advancements = predicate.advancements()).isEmpty()) {
            LinkedList<MutableComponent> list = new LinkedList<MutableComponent>();
            for (Map.Entry entry : advancements.entrySet()) {
                Object2BooleanMap criteria;
                String idString = ((ResourceLocation)entry.getKey()).toString();
                PlayerPredicate.AdvancementPredicate advancementPredicate = (PlayerPredicate.AdvancementPredicate)entry.getValue();
                if (advancementPredicate instanceof PlayerPredicate.AdvancementDonePredicate) {
                    boolean done = ((PlayerPredicate.AdvancementDonePredicate)advancementPredicate).state();
                    if (done) {
                        list.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.adv.id_true", idString));
                        continue;
                    }
                    list.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.adv.id_false", idString));
                    continue;
                }
                if (!(advancementPredicate instanceof PlayerPredicate.AdvancementCriterionsPredicate) || (criteria = ((PlayerPredicate.AdvancementCriterionsPredicate)advancementPredicate).criterions()).isEmpty()) continue;
                LinkedList<MutableComponent> list2 = new LinkedList<MutableComponent>();
                for (Object2BooleanMap.Entry criteriaEntry : criteria.object2BooleanEntrySet()) {
                    if (criteriaEntry.getBooleanValue()) {
                        list2.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.adv.crit_true", criteriaEntry.getKey()));
                        continue;
                    }
                    list2.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.adv.crit_false", criteriaEntry.getKey()));
                }
                list.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.adv.crit_base", idString, ListProcessors.buildAndList(list2)));
            }
            return LText.translatable("emi_loot.entity_predicate.type_specific.player", ListProcessors.buildAndList(list));
        }
        Optional entityPredicate = predicate.lookingAt();
        if (entityPredicate.isPresent()) {
            return LText.translatable("emi_loot.entity_predicate.type_specific.player", LText.translatable("emi_loot.entity_predicate.type_specific.player.looking", EntityPredicateParser.parseEntityPredicate((EntityPredicate)entityPredicate.get())));
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Lightning bolt predicate empty or unparsable. Affects table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }

    public static Component parseSlimePredicate(SlimePredicate predicate) {
        MinMaxBounds.Ints size = predicate.size();
        if (size.equals((Object)MinMaxBounds.Ints.ANY)) {
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.warn("Undefined slime size predicate in table: " + LootTableParser.currentTable);
            }
            return LText.translatable("emi_loot.predicate.invalid");
        }
        return NumberProcessors.processNumberRange(size, "emi_loot.entity_predicate.type_specific.slime", "emi_loot.entity_predicate.type_specific.slime_2", "emi_loot.entity_predicate.type_specific.slime_3", "emi_loot.entity_predicate.type_specific.slime_4", "", new Object[0]);
    }
}

