/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.server;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.EMILootAgnos;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;

public class ServerResourceData {
    public static final Multimap<ResourceLocation, LootTable> DIRECT_DROPS = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), ArrayList::new);
    public static final List<ResourceLocation> SHEEP_TABLES;
    public static final List<ResourceLocation> TABLE_EXCLUSIONS;
    private static final int DIRECT_DROPS_PATH_LENGTH;
    private static final int FILE_SUFFIX_LENGTH;

    public static void loadDirectTables(ResourceManager resourceManager, RegistryOps<JsonElement> ops) {
        DIRECT_DROPS.clear();
        resourceManager.listResources("direct_drops", path -> path.getPath().endsWith(".json")).forEach((id, resource) -> ServerResourceData.loadDirectTable(id, resource, ops));
        resourceManager.listResources("emi_loot_data", path -> path.getPath().endsWith(".json")).forEach(ServerResourceData::loadTableExclusion);
    }

    private static void loadDirectTable(ResourceLocation id, Resource resource, RegistryOps<JsonElement> ops) {
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.info("Reading direct drop table from file: {}", (Object)id.toString());
        }
        String path = id.getPath();
        ResourceLocation id2 = ResourceLocation.tryBuild((String)id.getNamespace(), (String)path.substring(DIRECT_DROPS_PATH_LENGTH, path.length() - FILE_SUFFIX_LENGTH));
        String path2 = id2.getPath();
        if (!path2.startsWith("blocks/") && !path2.startsWith("entities/")) {
            EMILoot.LOGGER.error("File path for [{}] not correct; needs a 'blocks' or 'entities' subfolder. Skipping.", (Object)id);
            EMILoot.LOGGER.error("Example: [./data/mod_id/direct_drops/blocks/cobblestone.json] is a valid block direct drop table path for a block added by [mod_id].");
            return;
        }
        try {
            BufferedReader reader = resource.openAsReader();
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            LootTable lootTable = EMILootAgnos.loadLootTable(id, (LootTable)LootTable.DIRECT_CODEC.parse(ops, (Object)json).getOrThrow());
            if (lootTable != null) {
                DIRECT_DROPS.put((Object)id2, (Object)lootTable);
            } else {
                EMILoot.LOGGER.error("Loot table in file [{}] is empty!", (Object)id);
            }
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Failed to open or read direct drops loot table file: {}", (Object)id);
        }
    }

    private static void loadTableExclusion(ResourceLocation id, Resource resource) {
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.info("Reading exclusion table from file: {}", (Object)id.toString());
        }
        try {
            BufferedReader reader = resource.openAsReader();
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            JsonElement list = json.get("exclusions");
            if (list != null && list.isJsonArray()) {
                list.getAsJsonArray().forEach(element -> {
                    if (element.isJsonPrimitive()) {
                        ResourceLocation identifier = new ResourceLocation(element.getAsString());
                        if (EMILoot.DEBUG) {
                            EMILoot.LOGGER.info("Adding exclusion: {}", (Object)identifier);
                        }
                        TABLE_EXCLUSIONS.add(identifier);
                    } else {
                        EMILoot.LOGGER.error("Exclusion element not properly formatted: {}", element);
                    }
                });
            } else {
                EMILoot.LOGGER.error("Exclusions in file: {} not readable.", (Object)id);
            }
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Failed to open or read table exclusions file: {}", (Object)id);
        }
    }

    public static boolean skipTable(ResourceLocation id) {
        return TABLE_EXCLUSIONS.contains(id);
    }

    public static Multimap<ResourceLocation, LootTable> getMissedDirectDrops(List<ResourceLocation> parsedList) {
        Multimap missedDrops = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), ArrayList::new);
        for (Map.Entry entry : DIRECT_DROPS.entries()) {
            if (parsedList.contains(entry.getKey())) continue;
            missedDrops.put((Object)((ResourceLocation)entry.getKey()), (Object)((LootTable)entry.getValue()));
        }
        return missedDrops;
    }

    static {
        TABLE_EXCLUSIONS = new LinkedList<ResourceLocation>();
        DIRECT_DROPS_PATH_LENGTH = "direct_drops/".length();
        FILE_SUFFIX_LENGTH = ".json".length();
        ResourceLocation[] ids = new ResourceLocation[]{BuiltInLootTables.SHEEP_WHITE.location(), BuiltInLootTables.SHEEP_ORANGE.location(), BuiltInLootTables.SHEEP_MAGENTA.location(), BuiltInLootTables.SHEEP_LIGHT_BLUE.location(), BuiltInLootTables.SHEEP_YELLOW.location(), BuiltInLootTables.SHEEP_LIME.location(), BuiltInLootTables.SHEEP_PINK.location(), BuiltInLootTables.SHEEP_GRAY.location(), BuiltInLootTables.SHEEP_LIGHT_GRAY.location(), BuiltInLootTables.SHEEP_CYAN.location(), BuiltInLootTables.SHEEP_PURPLE.location(), BuiltInLootTables.SHEEP_BLUE.location(), BuiltInLootTables.SHEEP_BROWN.location(), BuiltInLootTables.SHEEP_GREEN.location(), BuiltInLootTables.SHEEP_RED.location(), BuiltInLootTables.SHEEP_BLACK.location()};
        SHEEP_TABLES = Arrays.stream(ids).toList();
    }
}

