/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.util.stack;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.client.ClientResourceData;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class EntityEmiStack
extends EmiStack {
    @Nullable
    private final Entity entity;
    private final EntityRenderContext ctx;

    protected EntityEmiStack(@Nullable Entity entity) {
        this(entity, 8.0);
    }

    protected EntityEmiStack(@Nullable Entity entity, double scale) {
        this.entity = entity;
        if (entity != null) {
            boolean hasTransform = ClientResourceData.MOB_ROTATIONS.containsKey(entity.getType());
            Vector3f transform = ClientResourceData.MOB_ROTATIONS.getOrDefault(entity.getType(), new Vector3f(0.0f, 0.0f, 0.0f)).mul((float)Math.PI / 180);
            this.ctx = new EntityRenderContext(scale, hasTransform, transform);
        } else {
            this.ctx = new EntityRenderContext(scale, false, new Vector3f(0.0f, 0.0f, 0.0f));
        }
    }

    public static EntityEmiStack of(@Nullable Entity entity) {
        return new EntityEmiStack(entity);
    }

    public static EntityEmiStack ofScaled(@Nullable Entity entity, double scale) {
        return new EntityEmiStack(entity, scale);
    }

    public EmiStack copy() {
        EntityEmiStack stack = new EntityEmiStack(this.entity);
        stack.setRemainder(this.getRemainder().copy());
        stack.comparison = this.comparison;
        return stack;
    }

    public boolean isEmpty() {
        return this.entity == null;
    }

    public void render(GuiGraphics matrices, int x, int y, float delta, int flags) {
        block5: {
            try {
                if (this.entity != null) {
                    Entity entity = this.entity;
                    if (entity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)entity;
                        EntityEmiStack.renderEntity(matrices.pose(), x + 8, (int)((double)(y + 8) + this.ctx.size), this.ctx, living);
                    } else {
                        EntityEmiStack.renderEntity(matrices.pose(), (int)((double)x + 2.0 * this.ctx.size / 2.0), (int)((double)y + 2.0 * this.ctx.size), this.ctx, this.entity);
                    }
                }
            }
            catch (Throwable e) {
                if (!EMILoot.DEBUG || Util.getMillis() % 1000L != 0L) break block5;
                EMILoot.LOGGER.error("Rendering error for entity stack" + this.toString());
            }
        }
    }

    public DataComponentPatch getComponentChanges() {
        throw new UnsupportedOperationException("EntityEmiStack is not intended for NBT handling");
    }

    public Object getKey() {
        return this.entity;
    }

    public ResourceLocation getId() {
        if (this.entity == null) {
            throw new RuntimeException("Entity is null");
        }
        return BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.entity.getType());
    }

    public List<Component> getTooltipText() {
        return List.of(this.getName());
    }

    public List<ClientTooltipComponent> getTooltip() {
        ArrayList<ClientTooltipComponent> list = new ArrayList<ClientTooltipComponent>();
        if (this.entity != null) {
            list.addAll(this.getTooltipText().stream().map(Component::getVisualOrderText).map(ClientTooltipComponent::create).toList());
            EmiTooltipComponents.appendModName(list, (String)BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.entity.getType()).getNamespace());
            if (!this.getRemainder().isEmpty()) {
                list.add(EmiTooltipComponents.getRemainderTooltipComponent((EmiIngredient)this));
            }
        }
        return list;
    }

    public Component getName() {
        return this.entity != null ? this.entity.getName() : LText.literal("yet another missingno");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void renderEntity(PoseStack matrices, int x, int y, EntityRenderContext ctx, LivingEntity entity) {
        Minecraft client = Minecraft.getInstance();
        double width = client.getWindow().getGuiScaledWidth();
        double height = client.getWindow().getGuiScaledHeight();
        float mouseX = (float)(client.mouseHandler.xpos() * width / (double)client.getWindow().getScreenWidth());
        float mouseY = (float)(client.mouseHandler.ypos() * height / (double)client.getWindow().getScreenHeight());
        double posX = (double)mouseX - width / 2.0 + 63.0;
        if (Double.isNaN(posX)) {
            return;
        }
        double posY = (double)mouseY - height / 2.0;
        if (Double.isNaN(posY)) {
            return;
        }
        float f = (float)Math.atan(-posX / 40.0);
        float g = (float)Math.atan(-posY / 40.0);
        Matrix4fStack matrixStack = RenderSystem.getModelViewStack();
        matrixStack.pushMatrix();
        matrixStack.mul((Matrix4fc)matrices.last().pose());
        matrixStack.translate((float)x, (float)y, 1050.0f);
        matrixStack.scale(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack matrixStack2 = new PoseStack();
        matrixStack2.translate(0.0, 0.0, 1000.0);
        matrixStack2.scale((float)ctx.size, (float)ctx.size, (float)ctx.size);
        Quaternionf quaternion = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternion2 = new Quaternionf().rotateX(g * 20.0f * ((float)Math.PI / 180) * Mth.cos((float)ctx.transform.z) - f * 20.0f * ((float)Math.PI / 180) * Mth.sin((float)ctx.transform.z));
        if (ctx.hasTransform) {
            Quaternionf quaternion3 = new Quaternionf().rotateXYZ(ctx.transform.x, ctx.transform.y, ctx.transform.z);
            quaternion.mul((Quaternionfc)quaternion3);
        }
        quaternion.mul((Quaternionfc)quaternion2);
        matrixStack2.mulPose(quaternion);
        float h = entity.yBodyRot;
        float i = entity.getYRot();
        float j = entity.getXRot();
        float k = entity.yHeadRotO;
        float l = entity.yHeadRot;
        entity.yBodyRot = 180.0f + (f * 20.0f * Mth.cos((float)ctx.transform.z) + g * 20.0f * Mth.sin((float)ctx.transform.z));
        float yaw = 180.0f + (f * 40.0f * Mth.cos((float)ctx.transform.z) + g * 40.0f * Mth.sin((float)ctx.transform.z));
        entity.setYRot(yaw);
        float pitch = -g * 20.0f * Mth.cos((float)ctx.transform.z) + -f * 20.0f * Mth.sin((float)ctx.transform.z);
        entity.setXRot(pitch);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        entityRenderDispatcher.setRenderShadow(false);
        MultiBufferSource.BufferSource immediate = Minecraft.getInstance().renderBuffers().bufferSource();
        try {
            RenderSystem.runAsFancy(() -> entityRenderDispatcher.render((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack2, (MultiBufferSource)immediate, 0xF000F0));
        }
        finally {
            immediate.endBatch();
        }
        entityRenderDispatcher.setRenderShadow(true);
        entity.yBodyRot = h;
        entity.setYRot(i);
        entity.setXRot(j);
        entity.yHeadRotO = k;
        entity.yHeadRot = l;
        matrixStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        Lighting.setupFor3DItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void renderEntity(PoseStack matrices, int x, int y, EntityRenderContext ctx, Entity entity) {
        Minecraft client = Minecraft.getInstance();
        MouseHandler mouse = client.mouseHandler;
        float w = 1920.0f;
        float h = 1080.0f;
        Screen screen = client.screen;
        if (screen != null) {
            w = screen.width;
            h = screen.height;
        }
        float mouseX = (float)((double)(w + 51.0f) - mouse.xpos());
        float mouseY = (float)((double)(h + 75.0f - 50.0f) - mouse.ypos());
        float f = (float)Math.atan(mouseX / 40.0f);
        float g = (float)Math.atan(mouseY / 40.0f);
        Matrix4fStack matrixStack = RenderSystem.getModelViewStack();
        matrixStack.pushMatrix();
        matrixStack.mul((Matrix4fc)matrices.last().pose());
        matrixStack.translate((float)x, (float)y, 1050.0f);
        matrixStack.scale(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack matrixStack2 = new PoseStack();
        matrixStack2.translate(0.0, 0.0, 1000.0);
        matrixStack2.scale((float)ctx.size, (float)ctx.size, (float)ctx.size);
        Quaternionf quaternion = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternion2 = new Quaternionf().rotateX(g * 20.0f * ((float)Math.PI / 180) * Mth.cos((float)ctx.transform.z) - f * 20.0f * ((float)Math.PI / 180) * Mth.sin((float)ctx.transform.z));
        if (ctx.hasTransform) {
            Quaternionf quaternion3 = new Quaternionf().rotateXYZ(ctx.transform.x, ctx.transform.y, ctx.transform.z);
            quaternion.mul((Quaternionfc)quaternion3);
        }
        quaternion.mul((Quaternionfc)quaternion2);
        matrixStack2.mulPose(quaternion);
        float i = entity.getYRot();
        float j = entity.getXRot();
        entity.setYRot(180.0f + (f * 40.0f * Mth.cos((float)ctx.transform.z) + g * 40.0f * Mth.sin((float)ctx.transform.z)));
        entity.setXRot(-g * 20.0f * Mth.cos((float)ctx.transform.z) + -f * 20.0f * Mth.sin((float)ctx.transform.z));
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        entityRenderDispatcher.setRenderShadow(false);
        MultiBufferSource.BufferSource immediate = Minecraft.getInstance().renderBuffers().bufferSource();
        try {
            RenderSystem.runAsFancy(() -> entityRenderDispatcher.render(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack2, (MultiBufferSource)immediate, 0xF000F0));
        }
        finally {
            immediate.endBatch();
        }
        entityRenderDispatcher.setRenderShadow(true);
        entity.setYRot(i);
        entity.setXRot(j);
        matrixStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        Lighting.setupFor3DItems();
    }

    private record EntityRenderContext(double size, boolean hasTransform, Vector3f transform) {
        static EntityRenderContext EMPTY = new EntityRenderContext(8.0, false, new Vector3f(0.0f, 0.0f, 0.0f));
    }
}

