/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bagofholding.client.gui.screens.inventory;

import fuzs.bagofholding.BagOfHolding;
import fuzs.bagofholding.config.ClientConfig;
import fuzs.bagofholding.world.inventory.BagItemMenu;
import fuzs.bagofholding.world.inventory.LockableInventorySlot;
import fuzs.iteminteractions.api.v1.DyeBackedColor;
import fuzs.iteminteractions.api.v1.client.tooltip.AbstractClientItemContentsTooltip;
import fuzs.puzzleslib.api.client.key.v1.KeyMappingHelper;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class BagItemScreen
extends AbstractContainerScreen<BagItemMenu> {
    private static final ResourceLocation CONTAINER_BACKGROUND = ResourceLocationHelper.withDefaultNamespace((String)"textures/gui/container/generic_54.png");

    public BagItemScreen(BagItemMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.imageHeight = 114 + menu.getInventoryHeight() * 18;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderSlotHighlightBack(GuiGraphics guiGraphics) {
        super.renderSlotHighlightBack(guiGraphics);
        this.renderLockableSlotHighlight(guiGraphics, SLOT_HIGHLIGHT_BACK_SPRITE);
    }

    protected void renderSlotHighlightFront(GuiGraphics guiGraphics) {
        super.renderSlotHighlightFront(guiGraphics);
        this.renderLockableSlotHighlight(guiGraphics, SLOT_HIGHLIGHT_FRONT_SPRITE);
    }

    private void renderLockableSlotHighlight(GuiGraphics guiGraphics, ResourceLocation resourceLocation) {
        for (Slot slot : ((BagItemMenu)this.menu).slots) {
            LockableInventorySlot lockableSlot;
            if (slot == this.hoveredSlot || !slot.isHighlightable() || !(slot instanceof LockableInventorySlot) || !(lockableSlot = (LockableInventorySlot)slot).locked()) continue;
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, resourceLocation, slot.x - 4, slot.y - 4, 24, 24);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int backgroundColor = this.getBackgroundColor();
        int leftPos = (this.width - this.imageWidth) / 2;
        int topPos = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, CONTAINER_BACKGROUND, leftPos, topPos, 0.0f, 0.0f, this.imageWidth, 17, 256, 256, backgroundColor);
        int inventoryHeight = ((BagItemMenu)this.menu).getInventoryHeight();
        for (int k = 0; k < (int)Math.ceil((double)inventoryHeight / 6.0); ++k) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, CONTAINER_BACKGROUND, leftPos, topPos + 17 + 108 * k, 0.0f, 17.0f, this.imageWidth, Math.min(inventoryHeight - 6 * k, 6) * 18, 256, 256, backgroundColor);
        }
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, CONTAINER_BACKGROUND, leftPos, topPos + inventoryHeight * 18 + 17, 0.0f, 126.0f, this.imageWidth, 96, 256, 256, backgroundColor);
    }

    private int getBackgroundColor() {
        if (((ClientConfig)BagOfHolding.CONFIG.get(ClientConfig.class)).colorfulMenuBackgrounds) {
            return AbstractClientItemContentsTooltip.getBackgroundColor((DyeBackedColor)((BagItemMenu)this.menu).getBackgroundColor());
        }
        return -1;
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, -1, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, -1, false);
    }

    protected boolean checkHotbarKeyPressed(KeyEvent keyEvent) {
        if (((BagItemMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null) {
            for (int i = 0; i < 9; ++i) {
                LockableInventorySlot slot;
                Slot slot2;
                if (!KeyMappingHelper.isKeyActiveAndMatches((KeyMapping)this.minecraft.options.keyHotbarSlots[i], (KeyEvent)keyEvent) || !((slot2 = ((BagItemMenu)this.menu).getSlot(((BagItemMenu)this.menu).getHotbarStartIndex() + i)) instanceof LockableInventorySlot) || !(slot = (LockableInventorySlot)slot2).locked()) continue;
                return true;
            }
        }
        return super.checkHotbarKeyPressed(keyEvent);
    }

    public boolean isHoveredSlot(Slot slot) {
        return this.hoveredSlot == slot;
    }
}

