/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bagofholding.world.item;

import fuzs.bagofholding.BagOfHolding;
import fuzs.bagofholding.config.ServerConfig;
import fuzs.bagofholding.network.ClientboundLockSlotMessage;
import fuzs.bagofholding.world.inventory.BagItemMenu;
import fuzs.bagofholding.world.inventory.LockableInventorySlot;
import fuzs.iteminteractions.api.v1.ItemContentsHelper;
import fuzs.iteminteractions.api.v1.provider.ItemContentsBehavior;
import fuzs.puzzleslib.api.container.v1.ContainerMenuHelper;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.PlayerSet;
import fuzs.puzzleslib.api.network.v4.message.Message;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;

public class BagOfHoldingItem
extends Item {
    public BagOfHoldingItem(Item.Properties properties) {
        super(properties);
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public InteractionResult use(Level level, Player player, InteractionHand interactionHand) {
        if (player.isSecondaryUseActive() || !((ServerConfig)BagOfHolding.CONFIG.get(ServerConfig.class)).sneakToOpenBag) {
            ItemStack itemInHand = player.getItemInHand(interactionHand);
            if (level instanceof ServerLevel) {
                ContainerMenuHelper.openMenu((Player)player, (MenuProvider)this.getMenuProvider(itemInHand), (Object)itemInHand.getItemHolder());
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                this.lockMySlot((ServerPlayer)player, itemInHand);
            }
            player.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + level.getRandom().nextFloat() * 0.4f);
            return InteractionResultHelper.sidedSuccess((ItemStack)itemInHand, (boolean)level.isClientSide());
        }
        return super.use(level, player, interactionHand);
    }

    private MenuProvider getMenuProvider(ItemStack itemStack) {
        return new SimpleMenuProvider((containerId, inventory, player) -> {
            ItemContentsBehavior behavior = ItemContentsHelper.getItemContentsBehavior((ItemStack)itemStack);
            SimpleContainer itemContainer = behavior.getItemContainer(itemStack, player);
            return new BagItemMenu(containerId, inventory, (Container)itemContainer, behavior);
        }, itemStack.getHoverName());
    }

    private void lockMySlot(ServerPlayer serverPlayer, ItemStack itemStack) {
        AbstractContainerMenu abstractContainerMenu = serverPlayer.containerMenu;
        if (abstractContainerMenu instanceof BagItemMenu) {
            BagItemMenu menu = (BagItemMenu)abstractContainerMenu;
            NonNullList items = menu.getItems();
            for (int i = 0; i < items.size(); ++i) {
                if (items.get(i) != itemStack) continue;
                Slot slot = menu.getSlot(i);
                if (slot instanceof LockableInventorySlot) {
                    LockableInventorySlot slot2 = (LockableInventorySlot)slot;
                    slot2.lock();
                    MessageSender.broadcast((PlayerSet)PlayerSet.ofPlayer((ServerPlayer)serverPlayer), (Message)new ClientboundLockSlotMessage(menu.containerId, i));
                    break;
                }
                BagOfHolding.LOGGER.warn("Unable to lock bag slot at {} in container {} containing {}", new Object[]{i, menu, itemStack});
                break;
            }
        }
    }

    public void onDestroyed(ItemEntity itemEntity) {
        SimpleContainer container = ItemContentsHelper.getItemContentsBehavior((ItemStack)itemEntity.getItem()).getItemContainer(itemEntity.getItem(), null);
        Stream<ItemStack> stream = container.getItems().stream().filter(Predicate.not(ItemStack::isEmpty));
        ItemUtils.onContainerDestroyed((ItemEntity)itemEntity, stream.toList());
    }
}

