/*
 * Decompiled with CFR 0.152.
 */
package animalhunger.animalhunger;

import animalhunger.animalhunger.AnimalData;
import animalhunger.animalhunger.AnimalHunger;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Animals;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ColorSelectionGUI
implements Listener {
    private static final Logger LOGGER = Logger.getLogger("AnimalHunger");
    private final AnimalHunger plugin;
    private final boolean enableParticles;
    private final boolean guiOpenSound;
    private static final Map<String, Map<String, String>> DEFAULT_MESSAGES = new HashMap<String, Map<String, String>>();

    public ColorSelectionGUI(AnimalHunger plugin) {
        this.plugin = plugin;
        this.enableParticles = plugin.getConfig().getBoolean("enable-particles", true);
        this.guiOpenSound = plugin.getConfig().getBoolean("gui.animations.gui_open_sound", true);
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.logDebug("ColorSelectionGUI initialized and registered as listener");
    }

    public void openColorSelectionGUI(Player player, Animals animal) {
        if (!animal.isValid()) {
            player.sendMessage(this.getMessage(player, "color_animal_no_longer_exists"));
            this.logDebug("Failed to open color selection GUI: Invalid animal UUID " + animal.getUniqueId());
            return;
        }
        int size = this.plugin.getConfig().getInt("color_selection_gui.size", 27);
        String guiTitle = this.getMessage(player, "color_gui_title");
        Inventory colorGUI = Bukkit.createInventory(null, (int)size, (String)guiTitle);
        List colors = this.plugin.getConfig().getList("color_selection_gui.colors");
        if (colors == null || colors.isEmpty()) {
            player.sendMessage(this.getMessage(player, "color_config_error"));
            this.logDebug("No colors defined in color_selection_gui.colors");
            return;
        }
        int itemsAdded = 0;
        for (Object obj : colors) {
            int slot;
            String displayName;
            String colorName;
            String materialName;
            block17: {
                if (!(obj instanceof Map)) {
                    this.logDebug("Invalid color configuration entry: " + obj);
                    continue;
                }
                Map colorData = (Map)obj;
                materialName = (String)colorData.get("material");
                colorName = (String)colorData.get("color");
                Object slotObj = colorData.get("slot");
                displayName = (String)colorData.get("display_name");
                if (materialName == null || colorName == null || slotObj == null || displayName == null) {
                    this.logDebug("Invalid color configuration: " + colorData);
                    continue;
                }
                if (slotObj instanceof Integer) {
                    slot = (Integer)slotObj;
                } else {
                    if (slotObj instanceof String) {
                        try {
                            slot = Integer.parseInt((String)slotObj);
                            break block17;
                        }
                        catch (NumberFormatException e) {
                            this.logDebug("Invalid slot format: " + slotObj);
                            continue;
                        }
                    }
                    this.logDebug("Invalid slot type: " + slotObj.getClass().getSimpleName());
                    continue;
                }
            }
            Material material = Material.getMaterial((String)materialName.toUpperCase());
            if (material == null) {
                this.logDebug("Invalid material: " + materialName);
                continue;
            }
            try {
                ChatColor testColor = ChatColor.valueOf((String)colorName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.logDebug("Invalid ChatColor: " + colorName);
                continue;
            }
            ItemStack item = new ItemStack(material);
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)displayName));
                meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "color"), PersistentDataType.STRING, (Object)colorName.toUpperCase());
                meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "non_pickup"), PersistentDataType.BYTE, (Object)1);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                item.setItemMeta(meta);
            }
            if (slot >= 0 && slot < size) {
                colorGUI.setItem(slot, item);
                ++itemsAdded;
                this.logDebug("Added color item " + colorName + " at slot " + slot);
                continue;
            }
            this.logDebug("Invalid slot for color " + colorName + ": " + slot + " (GUI size: " + size + ")");
        }
        if (itemsAdded == 0) {
            player.sendMessage(this.getMessage(player, "color_config_error"));
            this.logDebug("No valid color items were added to the GUI");
            return;
        }
        player.setMetadata("colorSelectionAnimal", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)animal));
        player.openInventory(colorGUI);
        this.logDebug("Opened color selection GUI for player " + player.getName() + " and animal " + animal.getUniqueId() + " with " + itemsAdded + " color options");
        if (this.guiOpenSound) {
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_HARP, 1.0f, 1.0f);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Animals animal;
        ChatColor selectedColor;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String expectedTitle = this.getMessage(player, "color_gui_title");
        if (!event.getView().getTitle().equals(expectedTitle)) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            this.logDebug("Clicked empty slot or null item in color selection GUI: slot=" + event.getRawSlot());
            return;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        if (meta == null || !meta.getPersistentDataContainer().has(new NamespacedKey((Plugin)this.plugin, "color"), PersistentDataType.STRING)) {
            this.logDebug("Clicked item lacks color data: slot=" + event.getRawSlot());
            return;
        }
        String colorName = (String)meta.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "color"), PersistentDataType.STRING);
        if (colorName == null) {
            this.logDebug("Color name is null in item NBT");
            return;
        }
        try {
            selectedColor = ChatColor.valueOf((String)colorName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            player.sendMessage(this.getMessage(player, "color_invalid_error"));
            this.logDebug("Invalid ChatColor value: " + colorName);
            return;
        }
        if (!player.hasMetadata("colorSelectionAnimal")) {
            player.sendMessage(this.getMessage(player, "color_animal_not_found"));
            player.closeInventory();
            this.logDebug("No colorSelectionAnimal metadata for player " + player.getName());
            return;
        }
        Object metaValue = ((MetadataValue)player.getMetadata("colorSelectionAnimal").get(0)).value();
        if (!(metaValue instanceof Animals) || !(animal = (Animals)metaValue).isValid()) {
            player.sendMessage(this.getMessage(player, "color_animal_no_longer_exists"));
            player.removeMetadata("colorSelectionAnimal", (Plugin)this.plugin);
            player.closeInventory();
            this.logDebug("Invalid or non-existent animal in colorSelectionAnimal metadata for player " + player.getName());
            return;
        }
        AnimalData data = this.plugin.getAnimalData(animal.getUniqueId());
        if (data == null) {
            player.sendMessage(this.getMessage(player, "color_data_not_found"));
            player.closeInventory();
            this.logDebug("No AnimalData found for animal UUID " + animal.getUniqueId());
            return;
        }
        String currentName = data.getCustomName() != null ? data.getCustomName() : this.plugin.getConfig().getString("animals." + animal.getType().name().toLowerCase() + ".display_name", animal.getType().name());
        String cleanName = ChatColor.stripColor((String)currentName);
        data.setCustomName(cleanName);
        data.setNameColor(selectedColor);
        this.plugin.saveAnimalData(animal.getUniqueId());
        this.plugin.updateHungerDisplay(animal, data);
        String successMessage = this.getMessage(player, "color_changed_success").replace("{color}", selectedColor.toString()).replace("{name}", cleanName);
        player.sendMessage(successMessage);
        if (this.guiOpenSound) {
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.2f);
        }
        if (this.enableParticles) {
            animal.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, animal.getLocation().add(0.0, 1.0, 0.0), 10, 0.3, 0.3, 0.3, 0.0);
        }
        player.removeMetadata("colorSelectionAnimal", (Plugin)this.plugin);
        player.closeInventory();
        this.logDebug("Color changed to " + colorName + " for animal " + animal.getUniqueId() + " by player " + player.getName());
    }

    private String getMessage(Player player, String key) {
        String language = this.plugin.getConfig().getString("language", "en");
        String locale = player != null && !language.equals("default") ? language : (player != null ? player.getLocale().replace("_", "") : "en");
        FileConfiguration messages = null;
        String message = null;
        try {
            Field messagesField = ((Object)((Object)this.plugin)).getClass().getDeclaredField("messages");
            messagesField.setAccessible(true);
            messages = (FileConfiguration)messagesField.get((Object)this.plugin);
            if (messages != null) {
                message = messages.getString(locale + "." + key, messages.getString("en." + key, messages.getString("ru." + key, null)));
            }
        }
        catch (Exception e) {
            this.logDebug("Failed to access messages config via reflection: " + e.getMessage());
        }
        if (message == null) {
            message = this.getDefaultMessage(key, locale);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', message);
    }

    private String getDefaultMessage(String key, String locale) {
        Map<String, String> localeMessages = DEFAULT_MESSAGES.get(locale);
        if (localeMessages == null) {
            localeMessages = DEFAULT_MESSAGES.get("en");
        }
        if (localeMessages != null && localeMessages.containsKey(key)) {
            return localeMessages.get(key);
        }
        this.logDebug("No message found for key: " + key + " in locale: " + locale);
        return "Message not found: " + key;
    }

    public void handleColorSelection(InventoryClickEvent event) {
        this.onInventoryClick(event);
    }

    public boolean isColorSelectionGUI(String title, Player player) {
        String expectedTitle = this.getMessage(player, "color_gui_title");
        return title.equals(expectedTitle);
    }

    public void cleanupPlayerMetadata(Player player) {
        if (player.hasMetadata("colorSelectionAnimal")) {
            player.removeMetadata("colorSelectionAnimal", (Plugin)this.plugin);
            this.logDebug("Cleaned up colorSelectionAnimal metadata for player " + player.getName());
        }
    }

    public List<?> getAvailableColors() {
        return this.plugin.getConfig().getList("color_selection_gui.colors");
    }

    public boolean validateColorConfiguration() {
        List<?> colors = this.getAvailableColors();
        if (colors == null || colors.isEmpty()) {
            this.logDebug("No colors defined in configuration");
            return false;
        }
        int validColors = 0;
        for (Object obj : colors) {
            if (!(obj instanceof Map)) continue;
            Map colorData = (Map)obj;
            String materialName = (String)colorData.get("material");
            String colorName = (String)colorData.get("color");
            Object slotObj = colorData.get("slot");
            String displayName = (String)colorData.get("display_name");
            if (materialName == null || colorName == null || slotObj == null || displayName == null) continue;
            try {
                Material.getMaterial((String)materialName.toUpperCase());
                ChatColor.valueOf((String)colorName.toUpperCase());
                ++validColors;
            }
            catch (Exception e) {
                this.logDebug("Invalid color configuration entry: " + colorData);
            }
        }
        this.logDebug("Validated " + validColors + " color configurations");
        return validColors > 0;
    }

    private void logDebug(String message) {
        if (this.plugin.getConfig().getBoolean("debug", false)) {
            LOGGER.info("[DEBUG] [ColorSelectionGUI] " + message);
        }
    }

    static {
        HashMap<String, String> englishMessages = new HashMap<String, String>();
        englishMessages.put("color_gui_title", "&d\u2190\ud83c\udfa8\u2192 Name Color Selection");
        englishMessages.put("color_config_error", "&c\u2718 Color selection menu configuration error!");
        englishMessages.put("color_invalid_error", "&c\u2718 Error: invalid color!");
        englishMessages.put("color_animal_not_found", "&c\u2718 Error: animal not found!");
        englishMessages.put("color_animal_no_longer_exists", "&c\u2718 Animal no longer exists!");
        englishMessages.put("color_data_not_found", "&c\u2718 Animal data not found!");
        englishMessages.put("color_changed_success", "&a\u2714 Name color changed to {color}{name}");
        DEFAULT_MESSAGES.put("en", englishMessages);
        HashMap<String, String> russianMessages = new HashMap<String, String>();
        russianMessages.put("color_gui_title", "&d\u2190\ud83c\udfa8\u2192 \u0412\u044b\u0431\u043e\u0440 \u0446\u0432\u0435\u0442\u0430 \u0438\u043c\u0435\u043d\u0438");
        russianMessages.put("color_config_error", "&c\u2718 \u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043c\u0435\u043d\u044e \u0432\u044b\u0431\u043e\u0440\u0430 \u0446\u0432\u0435\u0442\u0430!");
        russianMessages.put("color_invalid_error", "&c\u2718 \u041e\u0448\u0438\u0431\u043a\u0430: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0446\u0432\u0435\u0442!");
        russianMessages.put("color_animal_not_found", "&c\u2718 \u041e\u0448\u0438\u0431\u043a\u0430: \u0436\u0438\u0432\u043e\u0442\u043d\u043e\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e!");
        russianMessages.put("color_animal_no_longer_exists", "&c\u2718 \u0416\u0438\u0432\u043e\u0442\u043d\u043e\u0435 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
        russianMessages.put("color_data_not_found", "&c\u2718 \u0414\u0430\u043d\u043d\u044b\u0435 \u0436\u0438\u0432\u043e\u0442\u043d\u043e\u0433\u043e \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b!");
        russianMessages.put("color_changed_success", "&a\u2714 \u0426\u0432\u0435\u0442 \u0438\u043c\u0435\u043d\u0438 \u0438\u0437\u043c\u0435\u043d\u0451\u043d \u043d\u0430 {color}{name}");
        DEFAULT_MESSAGES.put("ru", russianMessages);
        HashMap<String, String> portugueseMessages = new HashMap<String, String>();
        portugueseMessages.put("color_gui_title", "&d\u2190\ud83c\udfa8\u2192 Sele\u00e7\u00e3o de Cor do Nome");
        portugueseMessages.put("color_config_error", "&c\u2718 Erro na configura\u00e7\u00e3o do menu de sele\u00e7\u00e3o de cor!");
        portugueseMessages.put("color_invalid_error", "&c\u2718 Erro: cor inv\u00e1lida!");
        portugueseMessages.put("color_animal_not_found", "&c\u2718 Erro: animal n\u00e3o encontrado!");
        portugueseMessages.put("color_animal_no_longer_exists", "&c\u2718 Animal n\u00e3o existe mais!");
        portugueseMessages.put("color_data_not_found", "&c\u2718 Dados do animal n\u00e3o encontrados!");
        portugueseMessages.put("color_changed_success", "&a\u2714 Cor do nome alterada para {color}{name}");
        DEFAULT_MESSAGES.put("pt", portugueseMessages);
        DEFAULT_MESSAGES.put("pt_BR", portugueseMessages);
    }
}

