/*
 * Decompiled with CFR 0.152.
 */
package animalhunger.animalhunger;

import animalhunger.animalhunger.AnimalData;
import animalhunger.animalhunger.AnimalHunger;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AnimalHungerCrutch {
    private static final Logger LOGGER = Logger.getLogger(AnimalHungerCrutch.class.getName());
    private static final String FALLBACK_FILE_NAME = "fallback_base.yml";
    private static final String ANIMALS_PATH = "animals";
    private static final long MAINTENANCE_DELAY = 12000L;
    private static final long MAINTENANCE_PERIOD = 12000L;
    private final AnimalHunger plugin;
    private final FileConfiguration fallbackDataBase;
    private final File fallbackDataBaseFile;
    private volatile boolean isSaving = false;

    public AnimalHungerCrutch(AnimalHunger plugin) {
        this.plugin = plugin;
        this.fallbackDataBaseFile = new File(plugin.getDataFolder(), FALLBACK_FILE_NAME);
        this.fallbackDataBase = this.setupFallbackDataBase();
        this.startMaintenanceTasks();
    }

    private FileConfiguration setupFallbackDataBase() {
        if (!this.fallbackDataBaseFile.exists()) {
            this.createFallbackFile();
        }
        return YamlConfiguration.loadConfiguration((File)this.fallbackDataBaseFile);
    }

    private void createFallbackFile() {
        try {
            File dataFolder = this.plugin.getDataFolder();
            if (!dataFolder.exists() && !dataFolder.mkdirs()) {
                LOGGER.warning("Failed to create plugin data folder");
            }
            if (this.fallbackDataBaseFile.createNewFile()) {
                LOGGER.info("Created new fallback database file: fallback_base.yml");
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to create fallback database file", e);
        }
    }

    public void saveToFallback(UUID id, AnimalData data) {
        if (id == null) {
            LOGGER.warning("Attempted to save data with null UUID");
            return;
        }
        String basePath = "animals." + id.toString();
        if (data == null) {
            this.fallbackDataBase.set(basePath, null);
        } else {
            this.saveAnimalData(basePath, data);
        }
        this.saveFallbackDataBaseAsync();
    }

    private void saveAnimalData(String basePath, AnimalData data) {
        this.fallbackDataBase.set(basePath + ".hunger", (Object)data.getHunger());
        this.fallbackDataBase.set(basePath + ".maxHunger", (Object)data.getMaxHunger());
        this.fallbackDataBase.set(basePath + ".level", (Object)data.getLevel());
        this.fallbackDataBase.set(basePath + ".feedCount", (Object)data.getFeedCount());
        this.fallbackDataBase.set(basePath + ".bondLevel", (Object)data.getBondLevel());
        this.fallbackDataBase.set(basePath + ".resourceCount", (Object)data.getResourceCount());
        if (data.getCustomName() != null) {
            this.fallbackDataBase.set(basePath + ".customName", (Object)data.getCustomName());
        }
        if (data.getNameColor() != null) {
            this.fallbackDataBase.set(basePath + ".nameColor", (Object)data.getNameColor().name());
        }
    }

    private CompletableFuture<Void> saveFallbackDataBaseAsync() {
        if (this.isSaving) {
            return CompletableFuture.completedFuture(null);
        }
        this.isSaving = true;
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        new BukkitRunnable(){

            public void run() {
                try {
                    AnimalHungerCrutch.this.fallbackDataBase.save(AnimalHungerCrutch.this.fallbackDataBaseFile);
                    LOGGER.fine("Fallback data saved successfully");
                    future.complete(null);
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Failed to save fallback database", e);
                    future.completeExceptionally(e);
                }
                finally {
                    AnimalHungerCrutch.this.isSaving = false;
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
        return future;
    }

    private void startMaintenanceTasks() {
        new BukkitRunnable(){

            public void run() {
                AnimalHungerCrutch.this.performMaintenance();
            }
        }.runTaskTimer((Plugin)this.plugin, 12000L, 12000L);
        LOGGER.info("Maintenance task scheduled: every 600 seconds");
    }

    private void performMaintenance() {
        int removedCount = 0;
        Map<UUID, AnimalData> cache = this.plugin.getAnimalDataCache();
        Iterator<Map.Entry<UUID, AnimalData>> iterator = cache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, AnimalData> entry = iterator.next();
            UUID entityId = entry.getKey();
            if (!this.shouldRemoveEntity(entityId)) continue;
            AnimalData data = this.plugin.getAnimalData(entityId);
            this.saveToFallback(entityId, data);
            this.plugin.removeAnimalData(entityId);
            iterator.remove();
            ++removedCount;
        }
        if (removedCount > 0) {
            LOGGER.info("Maintenance completed: removed " + removedCount + " orphaned entities");
        } else {
            LOGGER.fine("Maintenance completed: no orphaned entities found");
        }
    }

    private boolean shouldRemoveEntity(UUID entityId) {
        Entity entity = Bukkit.getEntity((UUID)entityId);
        return entity == null || !(entity instanceof Animals) || !entity.isValid();
    }

    public Map<UUID, AnimalData> getAnimalDataCache() {
        return this.plugin.getAnimalDataCache();
    }

    public AnimalData loadFromFallback(UUID id) {
        if (id == null) {
            return null;
        }
        String basePath = "animals." + id.toString();
        if (!this.fallbackDataBase.contains(basePath)) {
            return null;
        }
        try {
            int hunger = this.fallbackDataBase.getInt(basePath + ".hunger", 0);
            int maxHunger = this.fallbackDataBase.getInt(basePath + ".maxHunger", 100);
            int level = this.fallbackDataBase.getInt(basePath + ".level", 1);
            int feedCount = this.fallbackDataBase.getInt(basePath + ".feedCount", 0);
            int bondLevel = this.fallbackDataBase.getInt(basePath + ".bondLevel", 0);
            int resourceCount = this.fallbackDataBase.getInt(basePath + ".resourceCount", 0);
            AnimalData data = new AnimalData(hunger, maxHunger, level, feedCount, bondLevel, resourceCount);
            if (this.fallbackDataBase.contains(basePath + ".customName")) {
                data.setCustomName(this.fallbackDataBase.getString(basePath + ".customName"));
            }
            if (this.fallbackDataBase.contains(basePath + ".nameColor")) {
                try {
                    String colorName = this.fallbackDataBase.getString(basePath + ".nameColor");
                    data.setNameColor(ChatColor.valueOf((String)colorName));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warning("Invalid color name for entity " + id + ", using default");
                }
            }
            return data;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to load data for entity " + id, e);
            return null;
        }
    }

    public void removeFromFallback(UUID id) {
        if (id == null) {
            return;
        }
        String basePath = "animals." + id.toString();
        this.fallbackDataBase.set(basePath, null);
        this.saveFallbackDataBaseAsync();
        LOGGER.fine("Removed entity " + id + " from fallback storage");
    }

    public void forceSaveSync() {
        try {
            this.fallbackDataBase.save(this.fallbackDataBaseFile);
            LOGGER.info("Fallback data force-saved on shutdown");
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to force-save fallback database", e);
        }
    }

    public int getFallbackCount() {
        if (!this.fallbackDataBase.contains(ANIMALS_PATH)) {
            return 0;
        }
        return this.fallbackDataBase.getConfigurationSection(ANIMALS_PATH).getKeys(false).size();
    }

    public void clearFallback() {
        this.fallbackDataBase.set(ANIMALS_PATH, null);
        this.saveFallbackDataBaseAsync();
        LOGGER.info("Fallback storage cleared");
    }
}

