/*
 * Decompiled with CFR 0.152.
 */
package animalhunger.animalhunger;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;

public class ColorUtils {
    private static final Pattern HEX_PATTERN = Pattern.compile("&#([A-Fa-f0-9]{6})");

    public static String colorize(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        message = ColorUtils.translateHexColors(message);
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        return message;
    }

    private static String translateHexColors(String message) {
        Matcher matcher = HEX_PATTERN.matcher(message);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hexColor = matcher.group(1);
            ChatColor color = ChatColor.of((String)("#" + hexColor));
            matcher.appendReplacement(buffer, color.toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static String stripColor(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        message = message.replaceAll("&#[A-Fa-f0-9]{6}", "");
        return ChatColor.stripColor((String)message);
    }

    public static String gradient(String text, String startHex, String endHex) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        int startR = Integer.parseInt(startHex.substring(0, 2), 16);
        int startG = Integer.parseInt(startHex.substring(2, 4), 16);
        int startB = Integer.parseInt(startHex.substring(4, 6), 16);
        int endR = Integer.parseInt(endHex.substring(0, 2), 16);
        int endG = Integer.parseInt(endHex.substring(2, 4), 16);
        int endB = Integer.parseInt(endHex.substring(4, 6), 16);
        StringBuilder result = new StringBuilder();
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            float factor = (float)i / (float)(length - 1);
            int r = (int)((float)startR + (float)(endR - startR) * factor);
            int g = (int)((float)startG + (float)(endG - startG) * factor);
            int b = (int)((float)startB + (float)(endB - startB) * factor);
            String hex = String.format("%02X%02X%02X", r, g, b);
            result.append(ChatColor.of((String)("#" + hex))).append(text.charAt(i));
        }
        return result.toString();
    }

    public static class Colors {
        public static final String SANDY_BROWN = "#F4A460";
        public static final String GOLD = "#FFD700";
        public static final String SKY_BLUE = "#87CEEB";
        public static final String PALE_GREEN = "#98FB98";
        public static final String LIGHT_PINK = "#FFB6C1";
        public static final String PLUM = "#DDA0DD";
        public static final String LIGHT_CORAL = "#F08080";
        public static final String LAVENDER = "#E6E6FA";

        public static String accent(String text) {
            return ChatColor.of((String)SANDY_BROWN) + text;
        }

        public static String success(String text) {
            return ChatColor.of((String)PALE_GREEN) + text;
        }

        public static String error(String text) {
            return ChatColor.of((String)LIGHT_CORAL) + text;
        }

        public static String info(String text) {
            return ChatColor.of((String)SKY_BLUE) + text;
        }
    }
}

