/*
 * Decompiled with CFR 0.152.
 */
package animalhunger.animalhunger.storage;

import animalhunger.animalhunger.AnimalData;
import animalhunger.animalhunger.AnimalHunger;
import animalhunger.animalhunger.storage.DatabaseManager;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;

public class DataMigrationTool {
    private final AnimalHunger plugin;
    private final DatabaseManager databaseManager;

    public DataMigrationTool(AnimalHunger plugin, DatabaseManager databaseManager) {
        this.plugin = plugin;
        this.databaseManager = databaseManager;
    }

    public MigrationResult migrateFromYaml() {
        File backupFile;
        MigrationResult result = new MigrationResult();
        File dataFile = new File(this.plugin.getDataFolder(), "data.yml");
        if (!dataFile.exists()) {
            return result;
        }
        YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)dataFile);
        for (String key : yaml.getKeys(false)) {
            if (key.equals("nextAnimalId")) {
                try {
                    int nextId = yaml.getInt(key, 0);
                    this.databaseManager.saveMetaData("nextAnimalId", String.valueOf(nextId));
                }
                catch (Exception nextId) {}
                continue;
            }
            try {
                UUID uuid = UUID.fromString(key);
                int hunger = yaml.getInt(key + ".hunger", 10);
                int maxHunger = yaml.getInt(key + ".maxHunger", 10);
                int level = yaml.getInt(key + ".level", 1);
                int feedCount = yaml.getInt(key + ".feedCount", 0);
                int bondLevel = yaml.getInt(key + ".bondLevel", 0);
                int resourceCount = yaml.getInt(key + ".resourceCount", 0);
                String customName = yaml.getString(key + ".customName", null);
                String colorName = yaml.getString(key + ".nameColor", "YELLOW");
                int animalId = yaml.getInt(key + ".id", -1);
                AnimalData data = new AnimalData(hunger, maxHunger, level, feedCount, bondLevel, resourceCount);
                data.setCustomName(customName);
                try {
                    data.setNameColor(ChatColor.valueOf((String)colorName));
                }
                catch (IllegalArgumentException e) {
                    data.setNameColor(ChatColor.YELLOW);
                }
                this.databaseManager.saveAnimalData(uuid, data, animalId);
                ++result.successCount;
            }
            catch (IllegalArgumentException e) {
                ++result.failedCount;
            }
            catch (Exception e) {
                ++result.failedCount;
            }
        }
        if (result.successCount <= 0 || dataFile.renameTo(backupFile = new File(this.plugin.getDataFolder(), "data.yml.backup"))) {
            // empty if block
        }
        return result;
    }

    public MigrationResult migrateToYaml() {
        MigrationResult result = new MigrationResult();
        File dataFile = new File(this.plugin.getDataFolder(), "data.yml");
        YamlConfiguration yaml = new YamlConfiguration();
        try {
            Map<UUID, AnimalData> dataMap = this.databaseManager.loadAllAnimalData();
            Map<Integer, UUID> idMap = this.databaseManager.loadAnimalIdMap();
            for (Map.Entry<UUID, AnimalData> entry : dataMap.entrySet()) {
                UUID uuid = entry.getKey();
                AnimalData data = entry.getValue();
                String key = uuid.toString();
                yaml.set(key + ".hunger", (Object)data.getHunger());
                yaml.set(key + ".maxHunger", (Object)data.getMaxHunger());
                yaml.set(key + ".level", (Object)data.getLevel());
                yaml.set(key + ".feedCount", (Object)data.getFeedCount());
                yaml.set(key + ".bondLevel", (Object)data.getBondLevel());
                yaml.set(key + ".resourceCount", (Object)data.getResourceCount());
                yaml.set(key + ".customName", (Object)data.getCustomName());
                yaml.set(key + ".nameColor", (Object)data.getNameColor().name());
                int animalId = -1;
                for (Map.Entry<Integer, UUID> idEntry : idMap.entrySet()) {
                    if (!idEntry.getValue().equals(uuid)) continue;
                    animalId = idEntry.getKey();
                    break;
                }
                if (animalId >= 0) {
                    yaml.set(key + ".id", (Object)animalId);
                }
                ++result.successCount;
            }
            String nextIdStr = this.databaseManager.loadMetaData("nextAnimalId");
            if (nextIdStr != null) {
                yaml.set("nextAnimalId", (Object)Integer.parseInt(nextIdStr));
            }
            yaml.save(dataFile);
        }
        catch (Exception e) {
            result.failedCount = result.successCount;
            result.successCount = 0;
        }
        return result;
    }

    public static class MigrationResult {
        public int successCount = 0;
        public int failedCount = 0;

        public boolean isSuccess() {
            return this.failedCount == 0 && this.successCount > 0;
        }
    }
}

