/*
 * Decompiled with CFR 0.152.
 */
package animalhunger.animalhunger;

import animalhunger.animalhunger.AnimalData;
import animalhunger.animalhunger.AnimalDataManager;
import animalhunger.animalhunger.AnimalHomeManager;
import animalhunger.animalhunger.AnimalHungerCrutch;
import animalhunger.animalhunger.AnimalHungerExpansion;
import animalhunger.animalhunger.AnimalRidingSystem;
import animalhunger.animalhunger.ColorSelectionGUI;
import animalhunger.animalhunger.CustomDropManager;
import animalhunger.animalhunger.DropChanceHandler;
import animalhunger.animalhunger.PluginCompatibility;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AnimalHunger
extends JavaPlugin
implements Listener {
    private boolean guiSecondPageEnabled;
    private Map<String, Integer> secondPageSlotsSmall;
    private Map<String, Integer> secondPageSlotsMedium;
    private Map<String, Integer> secondPageSlotsLarge;
    private Map<String, SecondPageItemConfig> secondPageItemConfigs;
    private ColorSelectionGUI colorSelectionGUI;
    private AnimalRidingSystem animalRidingSystem;
    private PluginCompatibility compatibility;
    private AnimalDataManager animalDataManager;
    private CustomDropManager customDropManager;
    private AnimalHungerCrutch crutch;
    private DropChanceHandler dropHandler;
    private AnimalHomeManager animalHomeManager;
    private static final Logger LOGGER = Logger.getLogger("AnimalHunger");
    private static final String LAST_ANIMAL_META_KEY = "lastAnimal";
    private static final String RENAMING_ANIMAL_META_KEY = "renamingAnimal";
    private static final int AUTO_SAVE_INTERVAL = 6000;
    private static final int RENAME_TIMEOUT_TICKS = 600;
    private static final double NEARBY_ENTITY_RADIUS = 20.0;
    private static final double NOTIFICATION_RADIUS = 10.0;
    private static final long BREEDING_COOLDOWN = 300000L;
    private static final int MIN_BREEDING_LEVEL = 6;
    private static final int MAX_NAME_LENGTH = 20;
    private static final int HUNGER_BAR_LENGTH = 10;
    private static final boolean PREMIUM_ANIMAL_HOME_ENABLED = false;
    private final Map<UUID, AnimalData> animalDataCache = new ConcurrentHashMap<UUID, AnimalData>();
    private final Map<Integer, UUID> animalIdMap = new ConcurrentHashMap<Integer, UUID>();
    private final Map<UUID, Long> breedingCooldowns = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, UUID> breedingPairs = new ConcurrentHashMap<UUID, UUID>();
    private final Random random = new Random();
    private FileConfiguration config;
    private FileConfiguration messages;
    private FileConfiguration dataBase;
    private File dataBaseFile;
    private int nextAnimalId;
    private long lastResourceCheck = 0L;
    private int totalTicksProcessed = 0;
    private int totalAnimalsProcessed = 0;
    private int totalDataSaves = 0;
    private int totalGUIOpens = 0;
    private int totalFeedingActions = 0;
    private int totalKillActions = 0;
    private int totalUpgradeActions = 0;
    private int totalCollectActions = 0;
    private int totalBondDecays = 0;
    private int totalAnimalDeaths = 0;
    private int totalAnimalBirths = 0;
    private int totalParticlesSpawned = 0;
    private int totalSoundsPlayed = 0;
    private int hungerDecreaseInterval;
    private int hungerRestoreAmount;
    private int maxHungerCap;
    private int maxLevel;
    private int feedingsPerLevel;
    private int upgradeCost;
    private boolean disableRiding;
    private boolean disableResourceCollection;
    private String language;
    private boolean enableParticles;
    private boolean debug;
    private Material feedItem;
    private Material upgradeItem;
    private boolean bondDecayEnabled;
    private int bondDecayRate;
    private long bondDecayInterval;
    private int bondDecayStarving;
    private int bondUpgradeGain;
    private int bondFeedingGain;
    private int bondThresholdResource;
    private int bondThresholdRareDrops;
    private int bondThresholdBonusResources;
    private int resMinBondToProduce;
    private int resRareItemBond;
    private int resBonusAmountBond;
    private double resChanceLvl1;
    private double resChanceLvl2;
    private double resChanceLvl3;
    private int resBonusMinAmount;
    private int resProductionInterval;
    private int resBonusMaxAmount;
    private boolean disableVanillaMilking;
    private boolean isMilkingEnabled;
    private Set<String> milkableAnimals;
    private Set<String> vanillaMilkableAnimals;
    private String milkingResultItem;
    private double milkingChance;
    private String milkingSuccessMessage;
    private String milkingNotMilkableMessage;
    private double vanillaMilkingChance;
    private String vanillaMilkingFailureMsg;
    private boolean ignoreEntitiesEnabled;
    private Set<String> ignoredEntityTypes;
    private int killRequiredLevel;
    private String killRequiredItem;
    private boolean entityDisplayEnabled;
    private boolean entityDisplayShowLevel;
    private boolean entityDisplayShowBond;
    private boolean entityDisplayBarEnabled;
    private String entityDisplayFormat;
    private int entityDisplayBarLength;
    private String entityDisplayBarHungerColor;
    private String entityDisplayBarFullColor;
    private boolean entityDisplayShowOnlyAfterRename;
    private int entityDisplayMinLevel;
    private boolean guiAnimationsEnabled;
    private boolean guiOpenSoundEnabled;
    private boolean guiLevelUpEffectEnabled;
    private boolean guiBondParticlesEnabled;
    private String guiTitleSmall;
    private String guiTitleMedium;
    private String guiTitleLarge;
    private String animalHomeGUITitle;
    private final Map<String, GUIItemConfig> guiItemConfigCache = new HashMap<String, GUIItemConfig>();
    private List<Integer> guiBorderSmall;
    private List<Integer> guiBorderMedium;
    private List<Integer> guiBorderLarge;
    private int resourceCheckInterval;

    public void onEnable() {
        if (!this.getServer().getPluginManager().isPluginEnabled("ProtocolLib")) {
            LOGGER.severe("ProtocolLib is not installed or enabled! AnimalHunger requires ProtocolLib to function.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (!this.initializePlugin()) {
            LOGGER.severe("Failed to initialize AnimalHunger plugin!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (this.animalRidingSystem == null) {
            this.animalRidingSystem = new AnimalRidingSystem(this, this.animalDataCache);
        }
        if (this.animalDataManager == null) {
            this.animalDataManager = new AnimalDataManager(this);
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.animalRidingSystem, (Plugin)this);
        this.startScheduledTasks();
        this.registerPlaceholderAPI();
        this.sendAdminPatreonMessage();
        LOGGER.info("AnimalHunger plugin enabled successfully.");
    }

    public void onDisable() {
        LOGGER.info("Shutting down AnimalHunger...");
        this.saveAllAnimalData();
        if (this.animalHomeManager != null) {
            this.animalHomeManager.saveAllHomeData();
        }
        LOGGER.info("AnimalHunger disabled.");
    }

    private boolean initializePlugin() {
        try {
            this.saveDefaultConfig();
            this.config = this.getConfig();
            this.loadMessages();
            this.setupDataBase();
            this.loadConfigValues();
            this.animalDataManager = new AnimalDataManager(this);
            this.compatibility = new PluginCompatibility(this);
            this.customDropManager = new CustomDropManager(this, this.compatibility);
            if (this.compatibility == null || this.animalDataManager == null || this.customDropManager == null) {
                LOGGER.severe("Failed to initialize critical components!");
                return false;
            }
            this.loadAllAnimalData();
            this.nextAnimalId = this.dataBase.getInt("nextAnimalId", 0);
            try {
                this.crutch = new AnimalHungerCrutch(this);
                this.dropHandler = new DropChanceHandler(this);
                this.colorSelectionGUI = new ColorSelectionGUI(this);
            }
            catch (Exception e) {
                LOGGER.warning("Some helper components failed to initialize: " + e.getMessage());
            }
            this.initializeExistingAnimals();
            this.logDebug("Plugin initialized successfully");
            return true;
        }
        catch (Exception e) {
            LOGGER.severe("Critical error during plugin initialization: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private void loadConfigValues() {
        String[] secondPageItems;
        String[] itemTypes;
        this.hungerDecreaseInterval = this.config.getInt("hunger-decrease-interval", 6000);
        this.hungerRestoreAmount = this.config.getInt("hunger-restore-amount", 1);
        this.maxHungerCap = this.config.getInt("max-hunger-cap", 15);
        this.maxLevel = this.config.getInt("max-level", 5);
        this.feedingsPerLevel = this.config.getInt("feedings-per-level", 5);
        this.language = this.config.getString("language", "en");
        this.enableParticles = this.config.getBoolean("enable-particles", true);
        this.debug = this.config.getBoolean("debug", true);
        this.feedItem = this.getMaterialSafely(this.config.getString("feed-item", "WHEAT"), Material.WHEAT);
        this.upgradeItem = this.getMaterialSafely(this.config.getString("gui.items.upgrade_action.item", "GOLDEN_CARROT"), Material.GOLDEN_CARROT);
        this.upgradeCost = this.config.getInt("gui.items.upgrade_action.cost", 3);
        this.disableRiding = this.config.getBoolean("disable-riding", false);
        this.disableResourceCollection = this.config.getBoolean("disable-resource-collection", false);
        this.bondDecayEnabled = this.config.getBoolean("bond.enable-decay", false);
        this.bondDecayRate = this.config.getInt("bond.decay-rate", 1);
        this.bondDecayInterval = this.config.getLong("bond.decay-interval", 12000L);
        this.bondDecayStarving = this.config.getInt("bond.starving-bond-loss", 2);
        this.bondUpgradeGain = this.config.getInt("bond.upgrade-bond-gain", 10);
        this.bondFeedingGain = this.config.getInt("bond.feeding-bond-gain", 5);
        this.bondThresholdResource = this.config.getInt("bond.thresholds.resource-production", 50);
        this.bondThresholdRareDrops = this.config.getInt("bond.thresholds.rare-drops", 75);
        this.bondThresholdBonusResources = this.config.getInt("bond.thresholds.bonus-resources", 100);
        this.disableVanillaMilking = this.config.getBoolean("disable-vanilla-milking", false);
        this.isMilkingEnabled = this.config.getBoolean("milking.enabled", false);
        this.milkableAnimals = new HashSet<String>(this.config.getStringList("milking.milkable_animals"));
        this.milkableAnimals = this.milkableAnimals.stream().map(String::toUpperCase).collect(Collectors.toSet());
        this.vanillaMilkableAnimals = new HashSet<String>(this.config.getStringList("vanilla_milking.milkable_animals"));
        this.vanillaMilkableAnimals = this.vanillaMilkableAnimals.stream().map(String::toUpperCase).collect(Collectors.toSet());
        this.milkingResultItem = this.config.getString("milking.result_item", "MILK_BUCKET");
        this.milkingChance = this.config.getDouble("milking.chance", 100.0);
        this.milkingSuccessMessage = this.config.getString("milking.success_message", "&aYou successfully milked the {animal_name}!");
        this.milkingNotMilkableMessage = this.config.getString("milking.not_milkable_message", "&cThis {animal_name} cannot be milked.");
        this.vanillaMilkingChance = this.config.getDouble("vanilla_milking.chance", 100.0);
        this.vanillaMilkingFailureMsg = this.config.getString("vanilla_milking.failure_message", "&cThe {animal_name} didn't give any milk this time.");
        this.ignoreEntitiesEnabled = this.config.getBoolean("ignored-entity-types.enabled", false);
        if (this.ignoreEntitiesEnabled) {
            this.ignoredEntityTypes = new HashSet<String>(this.config.getStringList("ignored-entity-types.types"));
            this.ignoredEntityTypes = this.ignoredEntityTypes.stream().map(String::toUpperCase).collect(Collectors.toSet());
            LOGGER.info("Ignoring the following entity types: " + this.ignoredEntityTypes);
        } else {
            this.ignoredEntityTypes = new HashSet<String>();
            LOGGER.info("Ignoring entities feature is disabled.");
        }
        this.killRequiredLevel = this.config.getInt("kill.required-level", 2);
        this.killRequiredItem = this.config.getString("kill.required-item", "").toUpperCase();
        this.entityDisplayEnabled = this.config.getBoolean("entity_display.enabled", true);
        this.entityDisplayShowLevel = this.config.getBoolean("entity_display.show_level", true);
        this.entityDisplayShowBond = this.config.getBoolean("entity_display.show_bond", false);
        this.entityDisplayBarEnabled = this.config.getBoolean("entity_display.bar.enabled", true);
        this.entityDisplayFormat = this.config.getString("entity_display.format", "{name} {level} {bar}");
        this.entityDisplayBarLength = this.config.getInt("entity_display.bar.length", 10);
        this.entityDisplayBarHungerColor = this.config.getString("entity_display.bar.hunger_color", "&c");
        this.entityDisplayBarFullColor = this.config.getString("entity_display.bar.full_color", "&a");
        this.entityDisplayShowOnlyAfterRename = this.config.getBoolean("entity_display.show_only_after_rename", false);
        this.entityDisplayMinLevel = this.config.getInt("entity_display.min_level_to_show", 2);
        this.guiAnimationsEnabled = this.config.getBoolean("gui.animations.enabled", true);
        this.guiOpenSoundEnabled = this.config.getBoolean("gui.animations.gui_open_sound", true);
        this.guiLevelUpEffectEnabled = this.config.getBoolean("gui.animations.level_up_effect", true);
        this.guiBondParticlesEnabled = this.config.getBoolean("gui.animations.bond_particles", true);
        this.guiTitleSmall = this.config.getString("gui.titles.small", "&6&l{animal_name} Care");
        this.guiTitleMedium = this.config.getString("gui.titles.medium", "&6&l{animal_name} Management");
        this.guiTitleLarge = this.config.getString("gui.titles.large", "&6&l{animal_name} Sanctuary");
        this.guiItemConfigCache.clear();
        for (String itemKey : itemTypes = new String[]{"level_display", "hunger_display", "bond_display", "name_display", "feed_action", "kill_action", "upgrade_action", "collect_action", "info_display", "name_color"}) {
            if (!this.config.contains("gui.items." + itemKey)) continue;
            this.guiItemConfigCache.put(itemKey, new GUIItemConfig(this.config, itemKey));
        }
        this.guiBorderSmall = this.config.getIntegerList("gui.layouts.small.decoration_border");
        this.guiBorderMedium = this.config.getIntegerList("gui.layouts.medium.decoration_border");
        this.guiBorderLarge = this.config.getIntegerList("gui.layouts.large.decoration_border");
        this.resourceCheckInterval = this.config.getInt("performance.resource-check-interval", 6000);
        this.guiSecondPageEnabled = this.config.getBoolean("gui_second_page.enabled", true);
        this.secondPageSlotsSmall = new HashMap<String, Integer>();
        this.secondPageSlotsSmall.put("back_button", this.config.getInt("gui_second_page.layouts.small.back_button", 22));
        this.secondPageSlotsSmall.put("animal_home", this.config.getInt("gui_second_page.layouts.small.animal_home", 13));
        this.secondPageSlotsSmall.put("detailed_info", this.config.getInt("gui_second_page.layouts.small.detailed_info", 11));
        this.secondPageSlotsSmall.put("bond_bonuses", this.config.getInt("gui_second_page.layouts.small.bond_bonuses", 15));
        this.secondPageSlotsMedium = new HashMap<String, Integer>();
        this.secondPageSlotsMedium.put("back_button", this.config.getInt("gui_second_page.layouts.medium.back_button", 40));
        this.secondPageSlotsMedium.put("animal_home", this.config.getInt("gui_second_page.layouts.medium.animal_home", 22));
        this.secondPageSlotsMedium.put("detailed_info", this.config.getInt("gui_second_page.layouts.medium.detailed_info", 20));
        this.secondPageSlotsMedium.put("bond_bonuses", this.config.getInt("gui_second_page.layouts.medium.bond_bonuses", 24));
        this.secondPageSlotsLarge = new HashMap<String, Integer>();
        this.secondPageSlotsLarge.put("back_button", this.config.getInt("gui_second_page.layouts.large.back_button", 49));
        this.secondPageSlotsLarge.put("animal_home", this.config.getInt("gui_second_page.layouts.large.animal_home", 21));
        this.secondPageSlotsLarge.put("detailed_info", this.config.getInt("gui_second_page.layouts.large.detailed_info", 23));
        this.secondPageSlotsLarge.put("bond_bonuses", this.config.getInt("gui_second_page.layouts.large.bond_bonuses", 25));
        this.secondPageItemConfigs = new HashMap<String, SecondPageItemConfig>();
        for (String itemKey : secondPageItems = new String[]{"back_button", "animal_home"}) {
            if (this.config.contains("gui_second_page.items." + itemKey)) {
                this.secondPageItemConfigs.put(itemKey, new SecondPageItemConfig(this.config, itemKey));
                continue;
            }
            this.logDebug("Config for 'gui_second_page.items." + itemKey + "' not found.");
        }
        this.animalHomeGUITitle = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("animal_home_gui.title", "&c&l[!] \u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0414\u043e\u043c\u043e\u043c"));
        this.resMinBondToProduce = this.config.getInt("resource_production.min_bond_to_produce", 50);
        this.resRareItemBond = this.config.getInt("resource_production.rare_resource_bond_threshold", 75);
        this.resBonusAmountBond = this.config.getInt("resource_production.bonus_resource_bond_threshold", 100);
        this.resChanceLvl1 = this.config.getDouble("resource_production.chance_level_1", 0.05);
        this.resChanceLvl2 = this.config.getDouble("resource_production.chance_level_2", 0.1);
        this.resChanceLvl3 = this.config.getDouble("resource_production.chance_level_3", 0.15);
        this.resBonusMinAmount = this.config.getInt("resource_production.bonus_resource_min_amount", 1);
        this.resBonusMaxAmount = this.config.getInt("resource_production.bonus_resource_max_amount", 2);
        this.resProductionInterval = this.config.getInt("resource_production.production_check_interval", 6000);
    }

    private void loadMessages() {
        File messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
        this.language = "en";
    }

    private void setupDataBase() {
        this.dataBaseFile = new File(this.getDataFolder(), "data.yml");
        if (!this.dataBaseFile.exists()) {
            try {
                this.dataBaseFile.createNewFile();
                this.logDebug("Created new data.yml file.");
            }
            catch (IOException e) {
                LOGGER.severe("Could not create data.yml: " + e.getMessage());
            }
        }
        this.dataBase = YamlConfiguration.loadConfiguration((File)this.dataBaseFile);
    }

    private void loadAllAnimalData() {
        this.animalDataCache.clear();
        this.animalIdMap.clear();
        if (this.dataBase == null) {
            LOGGER.warning("Database not initialized, skipping data load.");
            return;
        }
        for (String key : this.dataBase.getKeys(false)) {
            if (key.equals("nextAnimalId")) continue;
            try {
                UUID uuid = UUID.fromString(key);
                this.loadAnimalDataFromConfig(uuid, key);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warning("Invalid UUID in data.yml: " + key);
            }
        }
        LOGGER.info("Loaded data for " + this.animalDataCache.size() + " animals.");
    }

    private void loadAnimalDataFromConfig(UUID uuid, String key) {
        ChatColor nameColor;
        int hunger = this.dataBase.getInt(key + ".hunger", 10);
        int maxHunger = this.dataBase.getInt(key + ".maxHunger", 10);
        int level = this.dataBase.getInt(key + ".level", 1);
        int feedCount = this.dataBase.getInt(key + ".feedCount", 0);
        int bondLevel = this.dataBase.getInt(key + ".bondLevel", 0);
        int resourceCount = this.dataBase.getInt(key + ".resourceCount", 0);
        String customName = this.dataBase.getString(key + ".customName", null);
        int animalId = this.dataBase.getInt(key + ".id", -1);
        String colorName = this.dataBase.getString(key + ".nameColor", "YELLOW");
        try {
            nameColor = ChatColor.valueOf((String)colorName);
        }
        catch (IllegalArgumentException e) {
            nameColor = ChatColor.YELLOW;
        }
        AnimalData data = new AnimalData(hunger, maxHunger, level, feedCount, bondLevel, resourceCount);
        data.setCustomName(customName);
        data.setNameColor(nameColor);
        this.animalDataCache.put(uuid, data);
        if (animalId >= 0) {
            this.animalIdMap.put(animalId, uuid);
        }
    }

    private void initializeExistingAnimals() {
        int initializedCount = 0;
        int defaultHunger = this.config.getInt("default_values.hunger", 10);
        int defaultMaxHunger = this.config.getInt("default_values.max_hunger", 10);
        int defaultLevel = this.config.getInt("default_values.level", 1);
        int defaultBond = this.config.getInt("default_values.bond", 0);
        int defaultResources = this.config.getInt("default_values.resources", 0);
        int defaultFeedCount = this.config.getInt("default_values.feed_count", 0);
        for (World world : Bukkit.getWorlds()) {
            for (Animals animal : world.getEntitiesByClass(Animals.class)) {
                if (this.isEntityTypeIgnored(animal.getType()) || !this.compatibility.isSupportedEntity((Entity)animal)) continue;
                UUID animalId = animal.getUniqueId();
                if (!this.animalDataCache.containsKey(animalId)) {
                    AnimalData data = new AnimalData(defaultHunger, defaultMaxHunger, defaultLevel, defaultBond, defaultResources, defaultFeedCount);
                    this.animalDataCache.put(animalId, data);
                    this.updateHungerDisplay(animal, data);
                    ++initializedCount;
                    continue;
                }
                this.updateHungerDisplay(animal, this.animalDataCache.get(animalId));
            }
        }
        if (initializedCount > 0) {
            LOGGER.info("Initialized " + initializedCount + " existing animals with new data.");
        }
        this.logDebug("Existing animals initialization completed. Total animals in cache: " + this.animalDataCache.size());
    }

    public void saveAnimalData(UUID id) {
        AnimalData data = this.animalDataCache.get(id);
        if (data == null) {
            this.dataBase.set(id.toString(), null);
            this.logDebug("Marked removal for UUID " + id + " in database config.");
        } else {
            this.saveAnimalDataToConfig(id, data);
        }
        ++this.totalDataSaves;
    }

    private void saveAnimalDataToConfig(UUID id, AnimalData data) {
        String path = id.toString();
        this.dataBase.set(path + ".hunger", (Object)data.getHunger());
        this.dataBase.set(path + ".maxHunger", (Object)data.getMaxHunger());
        this.dataBase.set(path + ".level", (Object)data.getLevel());
        this.dataBase.set(path + ".feedCount", (Object)data.getFeedCount());
        this.dataBase.set(path + ".bondLevel", (Object)data.getBondLevel());
        this.dataBase.set(path + ".resourceCount", (Object)data.getResourceCount());
        this.dataBase.set(path + ".customName", (Object)data.getCustomName());
        this.dataBase.set(path + ".nameColor", (Object)data.getNameColor().name());
        int animalId = this.getAnimalId(id);
        if (data.getLevel() >= 2) {
            if (animalId < 0) {
                animalId = this.nextAnimalId++;
                this.animalIdMap.put(animalId, id);
                this.logDebug("Assigned new Id " + animalId + " to UUID " + id);
            }
            this.dataBase.set(path + ".id", (Object)animalId);
        }
    }

    private void saveAllAnimalData() {
        Iterator<Map.Entry<UUID, AnimalData>> iterator = this.animalDataCache.entrySet().iterator();
        int activeCount = 0;
        while (iterator.hasNext()) {
            Map.Entry<UUID, AnimalData> entry = iterator.next();
            UUID id = entry.getKey();
            AnimalData data = entry.getValue();
            Entity entity = Bukkit.getEntity((UUID)id);
            if (entity != null && entity.isValid()) {
                this.saveAnimalDataToConfig(id, data);
                ++activeCount;
                continue;
            }
            this.dataBase.set(id.toString(), null);
            iterator.remove();
            this.logDebug("Evicted non-existent animal from cache: " + id);
        }
        this.dataBase.set("nextAnimalId", (Object)this.nextAnimalId);
        try {
            this.dataBase.save(this.dataBaseFile);
            this.logDebug("Saved all animal data to data.yml (" + activeCount + " active entries).");
        }
        catch (IOException e) {
            LOGGER.severe("Could not save data.yml: " + e.getMessage());
        }
    }

    private void startScheduledTasks() {
        new BukkitRunnable(){

            public void run() {
                AnimalHunger.this.processAnimalTick();
            }
        }.runTaskTimer((Plugin)this, (long)this.hungerDecreaseInterval, (long)this.hungerDecreaseInterval);
        new BukkitRunnable(){

            public void run() {
                AnimalHunger.this.processResourceProduction();
            }
        }.runTaskTimer((Plugin)this, (long)this.resProductionInterval, (long)this.resProductionInterval);
        if (this.bondDecayEnabled) {
            new BukkitRunnable(){

                public void run() {
                    AnimalHunger.this.processBondDecay();
                }
            }.runTaskTimer((Plugin)this, this.bondDecayInterval, this.bondDecayInterval);
        }
        new BukkitRunnable(){

            public void run() {
                AnimalHunger.this.saveAllAnimalData();
            }
        }.runTaskTimer((Plugin)this, 6000L, 6000L);
        this.logDebug("Scheduled tasks started.");
    }

    private void processAnimalTick() {
        ++this.totalTicksProcessed;
        for (World world : Bukkit.getWorlds()) {
            for (Animals animal : world.getEntitiesByClass(Animals.class)) {
                if (this.isEntityTypeIgnored(animal.getType()) || !this.compatibility.isSupportedEntity((Entity)animal)) continue;
                AnimalData data = this.animalDataCache.get(animal.getUniqueId());
                if (data == null) {
                    data = this.getOrCreateAnimalData(animal.getUniqueId());
                    this.logDebug("Created missing data for animal " + animal.getType() + " in tick task.");
                }
                ++this.totalAnimalsProcessed;
                data.setHunger(Math.max(data.getHunger() - 1, 0));
                if (data.getHunger() <= 2) {
                    data.setBondLevel(Math.max(data.getBondLevel() - this.bondDecayStarving, 0));
                }
                this.updateHungerDisplay(animal, data);
                if (data.getHunger() > 0) continue;
                this.handleAnimalDeath(animal, animal.getUniqueId());
                ++this.totalAnimalDeaths;
            }
        }
    }

    private void processResourceProduction() {
        for (World world : Bukkit.getWorlds()) {
            for (Animals animal : world.getEntitiesByClass(Animals.class)) {
                double productionChance;
                AnimalData data;
                if (this.isEntityTypeIgnored(animal.getType()) || !this.compatibility.isSupportedEntity((Entity)animal) || (data = this.animalDataCache.get(animal.getUniqueId())) == null || !((productionChance = this.getProductionChance(data)) > 0.0) || !(this.random.nextDouble() < productionChance)) continue;
                data.incrementResourceCount();
            }
        }
    }

    private void processBondDecay() {
        for (World world : Bukkit.getWorlds()) {
            for (Animals animal : world.getEntitiesByClass(Animals.class)) {
                AnimalData data;
                if (this.isEntityTypeIgnored(animal.getType()) || !this.compatibility.isSupportedEntity((Entity)animal) || (data = this.animalDataCache.get(animal.getUniqueId())) == null) continue;
                data.setBondLevel(Math.max(0, data.getBondLevel() - this.bondDecayRate));
                ++this.totalBondDecays;
            }
        }
    }

    public void saveAnimalHomeData(UUID id) {
        if (this.animalHomeManager != null) {
            // empty if block
        }
    }

    public void saveDataBaseSilently() {
        try {
            this.dataBase.save(this.dataBaseFile);
        }
        catch (IOException e) {
            LOGGER.severe("Error data.yml: " + e.getMessage());
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("animalhunger.admin")) {
            this.sendAdminPatreonMessage(player);
        }
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Animals)) {
            return;
        }
        Animals animal = (Animals)livingEntity;
        if (this.isEntityTypeIgnored(animal.getType())) {
            this.logDebug("Spawn event for " + animal.getType() + " ignored.");
            return;
        }
        if (!this.compatibility.isSupportedEntity((Entity)animal)) {
            return;
        }
        UUID animalId = animal.getUniqueId();
        if (!this.animalDataCache.containsKey(animalId)) {
            int defaultHunger = this.config.getInt("default_values.hunger", 10);
            int defaultMaxHunger = this.config.getInt("default_values.max_hunger", 10);
            int defaultLevel = this.config.getInt("default_values.level", 1);
            int defaultBond = this.config.getInt("default_values.bond", 0);
            int defaultResources = this.config.getInt("default_values.resources", 0);
            int defaultFeedCount = this.config.getInt("default_values.feed_count", 0);
            AnimalData data = new AnimalData(defaultHunger, defaultMaxHunger, defaultLevel, defaultBond, defaultResources, defaultFeedCount);
            this.animalDataCache.put(animalId, data);
            this.updateHungerDisplay(animal, data);
            this.logDebug("Created data for newly spawned animal: " + animal.getType() + " (UUID: " + animalId + ")");
        }
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        boolean hasEmptyHands;
        Entity entity;
        if (event.getHand() != EquipmentSlot.HAND || !((entity = event.getRightClicked()) instanceof Animals)) {
            return;
        }
        Animals animal = (Animals)entity;
        if (this.isEntityTypeIgnored(animal.getType())) {
            this.logDebug("Interact event for " + animal.getType() + " ignored, allowing vanilla behavior.");
            return;
        }
        if (!this.compatibility.isSupportedEntity((Entity)animal) || !animal.isValid()) {
            return;
        }
        Player player = event.getPlayer();
        UUID animalId = animal.getUniqueId();
        AnimalData data = this.getOrCreateAnimalData(animalId);
        this.setLastAnimalMetadata(player, animal);
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        boolean bl = hasEmptyHands = itemInHand == null || itemInHand.getType() == Material.AIR;
        if (this.disableVanillaMilking && itemInHand != null && itemInHand.getType() == Material.BUCKET && (animal.getType() == EntityType.COW || animal.getType() == EntityType.MUSHROOM_COW)) {
            event.setCancelled(true);
            this.logDebug("Cancelled vanilla milking for " + player.getName() + " with " + animal.getType());
            return;
        }
        if (player.isSneaking()) {
            event.setCancelled(true);
            this.openEnhancedAnimalGUI(player, animal);
        } else if (!hasEmptyHands && this.hasValidFeedItemForAnimal(player, animal)) {
            event.setCancelled(true);
            this.startFeedingProcess(player, animal, animalId, data);
        } else {
            boolean canRide;
            event.setCancelled(true);
            boolean bl2 = canRide = !this.disableRiding && data.getLevel() >= 6 && data.getHunger() >= data.getMaxHunger() / 2;
            if (canRide) {
                if (!animal.getPassengers().isEmpty()) {
                    player.sendMessage(this.getMessage((CommandSender)player, "animal_already_ridden"));
                    return;
                }
                this.animalRidingSystem.startRidingCommand(player, animal, data);
            } else {
                String messageKey = "ride_level_too_low";
                if (this.disableRiding) {
                    messageKey = "ride_disabled";
                } else if (data.getLevel() >= 6) {
                    messageKey = "ride_hunger_too_low";
                }
                player.sendMessage(this.getMessage((CommandSender)player, messageKey).replace("{animal}", this.getAnimalDisplayName(animal)).replace("{required_level}", "6").replace("{level}", String.valueOf(data.getLevel())).replace("{hunger}", String.valueOf(data.getHunger())).replace("{max_hunger}", String.valueOf(data.getMaxHunger())));
            }
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Animals animal;
        Entity entity;
        block7: {
            block6: {
                entity = event.getEntity();
                if (!(entity instanceof Animals)) break block6;
                animal = (Animals)entity;
                entity = event.getDamager();
                if (entity instanceof Player) break block7;
            }
            return;
        }
        Player player = (Player)entity;
        if (this.isEntityTypeIgnored(animal.getType())) {
            this.logDebug("Damage event for " + animal.getType() + " ignored, allowing vanilla behavior.");
            return;
        }
        if (!this.isSupportedAnimal((Entity)animal)) {
            return;
        }
        if (event.getFinalDamage() >= animal.getHealth()) {
            event.setCancelled(true);
            this.handleAnimalKill(player, animal, false);
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        final Player player = event.getPlayer();
        if (!player.hasMetadata(RENAMING_ANIMAL_META_KEY)) {
            return;
        }
        event.setCancelled(true);
        final String message = event.getMessage().trim();
        if (message.equalsIgnoreCase("cancel") || message.equalsIgnoreCase("\u043e\u0442\u043c\u0435\u043d\u0430")) {
            player.removeMetadata(RENAMING_ANIMAL_META_KEY, (Plugin)this);
            player.sendMessage(this.getMessage((CommandSender)player, "rename_cancelled"));
            return;
        }
        new BukkitRunnable(){

            public void run() {
                AnimalHunger.this.handleAnimalRename(player, message);
            }
        }.runTask((Plugin)this);
    }

    private ItemStack createSecondPageItem(SecondPageItemConfig itemConfig, Animals animal, AnimalData data, String itemType) {
        Material material = itemConfig.material != null ? itemConfig.material : Material.STONE;
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (itemConfig.customModelData != 0) {
                meta.setCustomModelData(Integer.valueOf(itemConfig.customModelData));
            }
            String display = this.processEnhancedPlaceholders(itemConfig.display, animal, data);
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)display));
            ArrayList<String> lore = new ArrayList<String>();
            for (String line : itemConfig.lore) {
                String processed = this.processEnhancedPlaceholders(line, animal, data);
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)processed));
            }
            meta.setLore(lore);
            if (itemType.equals("back_button")) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createBondBonusesItem(SecondPageItemConfig itemConfig, Animals animal, AnimalData data) {
        Material material = itemConfig.material != null ? itemConfig.material : Material.DIAMOND;
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String line;
            if (itemConfig.customModelData != 0) {
                meta.setCustomModelData(Integer.valueOf(itemConfig.customModelData));
            }
            String display = this.processEnhancedPlaceholders(itemConfig.display, animal, data);
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)display));
            ArrayList<String> lore = new ArrayList<String>();
            for (String line2 : itemConfig.lore) {
                String processed = this.processEnhancedPlaceholders(line2, animal, data);
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)processed));
            }
            if (data.getBondLevel() >= this.bondThresholdResource) {
                line = itemConfig.loreResourceProduction.replace("{threshold}", String.valueOf(this.bondThresholdResource));
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            } else {
                line = itemConfig.loreLocked.replace("{threshold}", String.valueOf(this.bondThresholdResource));
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            }
            if (data.getBondLevel() >= this.bondThresholdRareDrops) {
                line = itemConfig.loreRareDrops.replace("{threshold}", String.valueOf(this.bondThresholdRareDrops));
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            } else {
                line = itemConfig.loreLocked.replace("{threshold}", String.valueOf(this.bondThresholdRareDrops));
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            }
            if (data.getBondLevel() >= this.bondThresholdBonusResources) {
                line = itemConfig.loreBonusResources.replace("{threshold}", String.valueOf(this.bondThresholdBonusResources));
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            } else {
                line = itemConfig.loreLocked.replace("{threshold}", String.valueOf(this.bondThresholdBonusResources));
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private Map<String, Integer> getSecondPageSlots(String layoutType) {
        return switch (layoutType.toLowerCase()) {
            case "small" -> this.secondPageSlotsSmall;
            case "medium" -> this.secondPageSlotsMedium;
            case "large" -> this.secondPageSlotsLarge;
            default -> new HashMap<String, Integer>();
        };
    }

    private void handleSecondPageClick(Player player, Animals animal, int slot, ItemStack clickedItem) {
        int guiSize = this.getGUISize(animal);
        String layoutType = this.getGUILayoutType(guiSize);
        Map<String, Integer> slots = this.getSecondPageSlots(layoutType);
        int backButtonSlot = slots.getOrDefault("back_button", -1);
        if (slot == backButtonSlot) {
            player.playSound(player.getLocation(), Sound.BLOCK_CHEST_CLOSE, 0.3f, 1.2f);
            this.openEnhancedAnimalGUI(player, animal);
            this.logDebug("Player " + player.getName() + " returned to main menu from page 2");
            return;
        }
        int animalHomeSlot = slots.getOrDefault("animal_home", -1);
        if (slot == animalHomeSlot) {
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
            if (this.animalHomeManager != null && this.animalHomeManager.isPremiumEnabled()) {
                this.animalHomeManager.openHomeGUI(player, animal);
                this.logDebug("Opening Animal Home GUI for " + player.getName());
            } else {
                player.sendMessage(ChatColor.RED + "\u2717 This feature requires the Premium version!");
                player.sendMessage(ChatColor.GRAY + "Visit: " + ChatColor.AQUA + "patreon.com/msL244");
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
            }
            return;
        }
        this.logDebug("Second page click on slot " + slot + " (e.g., info panel) - no action defined");
    }

    private ItemStack createAnimalHomeItem(SecondPageItemConfig itemConfig, Animals animal, AnimalData data) {
        Material material = itemConfig.material != null ? itemConfig.material : Material.REDSTONE_BLOCK;
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (itemConfig.customModelData != 0) {
                meta.setCustomModelData(Integer.valueOf(itemConfig.customModelData));
            }
            boolean isPremium = this.animalHomeManager != null && this.animalHomeManager.isPremiumEnabled();
            String display = this.processEnhancedPlaceholders(itemConfig.display, animal, data);
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)display));
            ArrayList<String> lore = new ArrayList<String>();
            for (String line : itemConfig.lore) {
                String processed = this.processEnhancedPlaceholders(line, animal, data);
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)processed));
            }
            List<String> additionalLore = isPremium ? itemConfig.lorePremiumEnabled : itemConfig.lorePremiumLocked;
            for (String line : additionalLore) {
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            }
            meta.setLore(lore);
            if (isPremium && itemConfig.addGlowWhenPremium) {
                meta.addEnchant(Enchantment.DURABILITY, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createDetailedInfoItem(SecondPageItemConfig itemConfig, Animals animal, AnimalData data) {
        Material material = itemConfig.material != null ? itemConfig.material : Material.BOOK;
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (itemConfig.customModelData != 0) {
                meta.setCustomModelData(Integer.valueOf(itemConfig.customModelData));
            }
            String display = this.processEnhancedPlaceholders(itemConfig.display, animal, data);
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)display));
            ArrayList<String> lore = new ArrayList<String>();
            for (String line : itemConfig.lore) {
                String processed = this.processEnhancedPlaceholders(line, animal, data);
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)processed));
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String title = event.getView().getTitle();
        if (this.colorSelectionGUI != null && this.colorSelectionGUI.isColorSelectionGUI(title, player)) {
            this.colorSelectionGUI.handleColorSelection(event);
            return;
        }
        if (this.animalHomeManager != null && title.equals(this.animalHomeGUITitle)) {
            event.setCancelled(true);
            this.animalHomeManager.handleHomeGUIClick(event);
            return;
        }
        if (!this.isAnimalGUIClick(event)) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        Animals animal = this.getAnimalFromMetadata(player);
        if (animal == null || !animal.isValid() || this.isEntityTypeIgnored(animal.getType())) {
            player.closeInventory();
            player.sendMessage(this.getMessage((CommandSender)player, "animal_not_found"));
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
            return;
        }
        boolean isSecondPage = title.contains("\u00a77[Page 2]");
        if (isSecondPage) {
            this.handleSecondPageClick(player, animal, event.getRawSlot(), clickedItem);
            return;
        }
        String layoutType = this.getGUILayoutType(event.getInventory().getSize());
        try {
            GUIAction action = this.getActionForSlot(event.getRawSlot(), layoutType);
            this.logDebug("Slot " + event.getRawSlot() + " clicked, action: " + action);
            if (action != GUIAction.UNKNOWN) {
                this.handleGUIAction(player, animal, action, event.getRawSlot());
            }
        }
        catch (Exception e) {
            player.sendMessage(ChatColor.RED + "\u274c An error occurred while processing the action!");
            this.logDebug("GUI Click Error for player " + player.getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean isAnimalGUIClick(InventoryClickEvent event) {
        String title = event.getView().getTitle();
        String smallTitleMatch = ChatColor.translateAlternateColorCodes((char)'&', (String)this.guiTitleSmall).split(" ")[0];
        String mediumTitleMatch = ChatColor.translateAlternateColorCodes((char)'&', (String)this.guiTitleMedium).split(" ")[0];
        String largeTitleMatch = ChatColor.translateAlternateColorCodes((char)'&', (String)this.guiTitleLarge).split(" ")[0];
        return title.contains(smallTitleMatch) || title.contains(mediumTitleMatch) || title.contains(largeTitleMatch) || title.contains("\u00a77[Page 2]");
    }

    private GUIAction getActionForSlot(int slot, String layoutType) {
        for (Map.Entry<String, GUIItemConfig> entry : this.guiItemConfigCache.entrySet()) {
            int targetSlot;
            GUIItemConfig itemConfig = entry.getValue();
            if ((targetSlot = (switch (layoutType) {
                case "small" -> itemConfig.positionSmall;
                case "medium" -> itemConfig.positionMedium;
                case "large" -> itemConfig.positionLarge;
                default -> -1;
            })) != slot) continue;
            return switch (entry.getKey()) {
                case "feed_action" -> GUIAction.FEED;
                case "kill_action" -> GUIAction.KILL;
                case "upgrade_action" -> GUIAction.UPGRADE;
                case "collect_action" -> GUIAction.COLLECT;
                case "name_display" -> GUIAction.RENAME;
                case "info_display" -> GUIAction.INFO;
                case "name_color" -> GUIAction.NAME_COLOR;
                default -> GUIAction.UNKNOWN;
            };
        }
        int page2SmallPos = this.config.getInt("gui.items.page2_action.positions.small", 40);
        int page2MediumPos = this.config.getInt("gui.items.page2_action.positions.medium", 40);
        int page2LargePos = this.config.getInt("gui.items.page2_action.positions.large", 40);
        if (layoutType.equalsIgnoreCase("small") && slot == page2SmallPos || layoutType.equalsIgnoreCase("medium") && slot == page2MediumPos || layoutType.equalsIgnoreCase("large") && slot == page2LargePos) {
            return GUIAction.PAGE2;
        }
        return GUIAction.UNKNOWN;
    }

    public void openSecondPageGUI(Player player, Animals animal) {
        if (!animal.isValid()) {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_not_found"));
            return;
        }
        UUID animalId = animal.getUniqueId();
        AnimalData data = this.getAnimalData(animalId);
        if (data == null) {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_not_found"));
            this.logDebug("Animal data not found for UUID: " + animalId);
            return;
        }
        int guiSize = this.getGUISize(animal);
        String layoutType = this.getGUILayoutType(guiSize);
        String title = this.getGUITitle(animal, layoutType) + " \u00a77[Page 2]";
        Inventory gui = Bukkit.createInventory(null, (int)guiSize, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)title));
        this.populateSecondPageGUI(gui, animal, data, layoutType);
        this.populateEnhancedGUIDecoration(gui, layoutType, data);
        player.openInventory(gui);
        this.setLastAnimalMetadata(player, animal);
        if (this.enableParticles && this.guiAnimationsEnabled && this.guiOpenSoundEnabled) {
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.2f);
        }
        this.logDebug("Opened Page 2 GUI for player " + player.getName() + ", animal: " + animal.getType());
    }

    private void populateSecondPageGUI(Inventory gui, Animals animal, AnimalData data, String layoutType) {
        SecondPageItemConfig homeConfig;
        Map<String, Integer> slots = this.getSecondPageSlots(layoutType);
        SecondPageItemConfig backConfig = this.secondPageItemConfigs.get("back_button");
        if (backConfig != null) {
            int slot = slots.getOrDefault("back_button", -1);
            ItemStack backButton = this.createSecondPageItem(backConfig, animal, data, "back_button");
            if (slot >= 0 && slot < gui.getSize()) {
                gui.setItem(slot, backButton);
            }
        }
        if ((homeConfig = this.secondPageItemConfigs.get("animal_home")) != null) {
            int slot = slots.getOrDefault("animal_home", -1);
            ItemStack homeItem = this.createAnimalHomeItem(homeConfig, animal, data);
            if (slot >= 0 && slot < gui.getSize()) {
                gui.setItem(slot, homeItem);
            }
        }
    }

    private String getBondThemeKey(int bondLevel) {
        if (bondLevel >= 75) {
            return "bond_75_100";
        }
        if (bondLevel >= 50) {
            return "bond_50_75";
        }
        if (bondLevel >= 25) {
            return "bond_25_50";
        }
        return "bond_0_25";
    }

    private String getDecorationKey(int bondLevel) {
        if (bondLevel >= this.bondThresholdBonusResources) {
            return "decoration_gold";
        }
        if (bondLevel >= this.bondThresholdRareDrops) {
            return "decoration_silver";
        }
        if (bondLevel >= this.bondThresholdResource) {
            return "decoration_bronze";
        }
        return "decoration_base";
    }

    private void addSecondPageCornerDecorations(Inventory gui, String layoutType, AnimalData data) {
        int[] cornerSlots = this.getCornerSlots(layoutType);
        String themeKey = this.getBondThemeKey(data.getBondLevel());
        String primaryMaterialName = this.config.getString("decoration_themes." + themeKey + ".primary", "GRAY_STAINED_GLASS_PANE");
        String secondaryMaterialName = this.config.getString("decoration_themes." + themeKey + ".secondary", "LIGHT_GRAY_STAINED_GLASS_PANE");
        String accentMaterialName = this.config.getString("decoration_themes." + themeKey + ".accent", "WHITE_STAINED_GLASS_PANE");
        Material primaryMaterial = Material.matchMaterial((String)primaryMaterialName);
        Material secondaryMaterial = Material.matchMaterial((String)secondaryMaterialName);
        Material accentMaterial = Material.matchMaterial((String)accentMaterialName);
        if (primaryMaterial == null) {
            primaryMaterial = Material.GRAY_STAINED_GLASS_PANE;
        }
        if (secondaryMaterial == null) {
            secondaryMaterial = Material.LIGHT_GRAY_STAINED_GLASS_PANE;
        }
        if (accentMaterial == null) {
            accentMaterial = Material.WHITE_STAINED_GLASS_PANE;
        }
        String bondStatus = this.getBondStatus(data.getBondLevel());
        String decorKey = this.getDecorationKey(data.getBondLevel());
        Material[] materials = new Material[]{primaryMaterial, secondaryMaterial, accentMaterial, primaryMaterial};
        for (int i = 0; i < cornerSlots.length && i < materials.length; ++i) {
            int slot = cornerSlots[i];
            if (slot < 0 || slot >= gui.getSize()) continue;
            ItemStack decorItem = new ItemStack(materials[i]);
            ItemMeta meta = decorItem.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(this.getMessage(null, decorKey));
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(this.getMessage(null, "decoration_bond_level").replace("{bond}", String.valueOf(data.getBondLevel())));
                lore.add(this.getMessage(null, "decoration_bond_status").replace("{status}", bondStatus));
                meta.setLore(lore);
                if (data.getBondLevel() >= this.bondThresholdRareDrops) {
                    meta.addEnchant(Enchantment.DURABILITY, 1, true);
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                }
                decorItem.setItemMeta(meta);
            }
            gui.setItem(slot, decorItem);
        }
    }

    private void handleGUIAction(Player player, Animals animal, GUIAction action, int slot) {
        if (!animal.isValid()) {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_not_found"));
            player.closeInventory();
            return;
        }
        UUID animalId = animal.getUniqueId();
        AnimalData data = this.getAnimalData(animalId);
        if (data == null) {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_not_found"));
            player.closeInventory();
            this.logDebug("Animal data not found for UUID: " + animalId);
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        this.logDebug("Processing GUI action: " + action + " for player " + player.getName());
        switch (action) {
            case FEED: {
                if (!player.hasPermission("animalhunger.feed")) {
                    player.sendMessage(this.getMessage((CommandSender)player, "no_permission"));
                    return;
                }
                this.feedAnimalInGUI(player, animal, animalId, data);
                this.refreshGUI(player, animal);
                break;
            }
            case NAME_COLOR: {
                if (!player.hasPermission("animalhunger.rename")) {
                    player.sendMessage(this.getMessage((CommandSender)player, "no_permission"));
                    return;
                }
                this.colorSelectionGUI.openColorSelectionGUI(player, animal);
                break;
            }
            case PAGE2: {
                this.openSecondPageGUI(player, animal);
                break;
            }
            case KILL: {
                if (!player.hasPermission("animalhunger.kill")) {
                    player.sendMessage(this.getMessage((CommandSender)player, "no_permission"));
                    return;
                }
                if (data.getLevel() < this.killRequiredLevel) {
                    player.sendMessage(this.getMessage((CommandSender)player, "kill_level_required").replace("{level}", String.valueOf(this.killRequiredLevel)));
                    player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
                    return;
                }
                this.killAnimalDirectly(player, animal, animalId, data);
                break;
            }
            case UPGRADE: {
                if (!player.hasPermission("animalhunger.upgrade")) {
                    player.sendMessage(this.getMessage((CommandSender)player, "no_permission"));
                    return;
                }
                if (data.getLevel() >= this.maxLevel) {
                    player.sendMessage(this.getMessage((CommandSender)player, "animal_already_max_level").replace("{animal}", this.getAnimalDisplayName(animal)));
                    player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
                    return;
                }
                this.upgradeAnimal(player, animal, animalId, data);
                break;
            }
            case COLLECT: {
                if (!player.hasPermission("animalhunger.collect")) {
                    player.sendMessage(this.getMessage((CommandSender)player, "no_permission"));
                    return;
                }
                if (this.disableResourceCollection) {
                    player.sendMessage(ChatColor.RED + "Resource collection is disabled.");
                    player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
                    return;
                }
                if (data.getBondLevel() >= this.bondThresholdResource) {
                    this.collectResources(player, animal, animalId, data);
                    this.refreshGUI(player, animal);
                    break;
                }
                player.sendMessage(this.getMessage((CommandSender)player, "no_resources"));
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
                break;
            }
            case RENAME: {
                if (!player.hasPermission("animalhunger.rename")) {
                    player.sendMessage(this.getMessage((CommandSender)player, "no_permission"));
                    return;
                }
                this.initiateAnimalRename(player, animal);
                break;
            }
            case INFO: {
                if (!player.hasPermission("animalhunger.info")) {
                    player.sendMessage(this.getMessage((CommandSender)player, "no_permission"));
                    return;
                }
                this.sendAnimalInfo(player, animal, data);
                break;
            }
            default: {
                this.logDebug("Unknown or non-action GUI item clicked.");
            }
        }
    }

    public void refreshGUI(final Player player, final Animals animal) {
        new BukkitRunnable(){

            public void run() {
                if (player.isOnline() && animal.isValid() && player.getOpenInventory().getTopInventory().getHolder() == null) {
                    String title = player.getOpenInventory().getTitle();
                    if (title.contains("\u00a77[Page 2]")) {
                        AnimalHunger.this.openSecondPageGUI(player, animal);
                    } else if (title.equals(AnimalHunger.this.animalHomeGUITitle)) {
                        AnimalHunger.this.animalHomeManager.openHomeGUI(player, animal);
                    } else {
                        AnimalHunger.this.openEnhancedAnimalGUI(player, animal);
                    }
                }
            }
        }.runTaskLater((Plugin)this, 1L);
    }

    private void sendAnimalInfo(Player player, Animals animal, AnimalData data) {
        player.sendMessage(this.getMessage((CommandSender)player, "info_header").replace("{animal}", this.getAnimalDisplayName(animal)));
        player.sendMessage(this.getMessage((CommandSender)player, "info_level").replace("{level}", String.valueOf(data.getLevel())).replace("{max_level}", String.valueOf(this.maxLevel)));
        player.sendMessage(this.getMessage((CommandSender)player, "info_hunger").replace("{hunger}", String.valueOf(data.getHunger())).replace("{max_hunger}", String.valueOf(data.getMaxHunger())));
        player.sendMessage(this.getMessage((CommandSender)player, "info_bond").replace("{bond}", String.valueOf(data.getBondLevel())));
        player.sendMessage(this.getMessage((CommandSender)player, "info_resources").replace("{resources}", String.valueOf(data.getResourceCount())));
        player.sendMessage(this.getMessage((CommandSender)player, "info_feedings").replace("{feed_count}", String.valueOf(data.getFeedCount())));
        if (data.getCustomName() != null) {
            player.sendMessage(this.getMessage((CommandSender)player, "info_name").replace("{name}", data.getCustomName()));
        }
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 1.0f);
    }

    public void openEnhancedAnimalGUI(Player player, Animals animal) {
        ++this.totalGUIOpens;
        if (!animal.isValid()) {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_not_found"));
            return;
        }
        try {
            UUID animalId = animal.getUniqueId();
            AnimalData data = this.getOrCreateAnimalData(animalId);
            int guiSize = this.getGUISize(animal);
            String layoutType = this.getGUILayoutType(guiSize);
            String title = this.getGUITitle(animal, layoutType);
            Inventory gui = Bukkit.createInventory(null, (int)guiSize, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)title));
            this.populateEnhancedGUIItems(gui, animal, data, layoutType);
            this.populateEnhancedGUIDecoration(gui, layoutType, data);
            player.openInventory(gui);
            this.setLastAnimalMetadata(player, animal);
            if (this.enableParticles && this.guiAnimationsEnabled) {
                if (this.guiOpenSoundEnabled) {
                    player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.2f);
                }
                if (this.guiLevelUpEffectEnabled) {
                    animal.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, animal.getLocation().add(0.0, 1.0, 0.0), 15, 0.5, 0.5, 0.5, 0.1);
                }
            }
            this.logDebug("Opened GUI for player " + player.getName() + ", animal: " + animal.getType() + ", layout: " + layoutType + ", size: " + guiSize);
        }
        catch (Exception e) {
            player.sendMessage(ChatColor.RED + "\u274c \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u0438 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430: " + e.getMessage());
            this.logDebug("GUI Opening Error for player " + player.getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void populateEnhancedGUIItems(Inventory gui, Animals animal, AnimalData data, String layoutType) {
        for (Map.Entry<String, GUIItemConfig> entry : this.guiItemConfigCache.entrySet()) {
            int position;
            String itemKey = entry.getKey();
            GUIItemConfig itemConfig = entry.getValue();
            if ((position = (switch (layoutType) {
                case "small" -> itemConfig.positionSmall;
                case "medium" -> itemConfig.positionMedium;
                case "large" -> itemConfig.positionLarge;
                default -> -1;
            })) < 0 || position >= gui.getSize()) continue;
            try {
                ItemStack item = this.createEnhancedGUIItem(animal, data, itemKey, itemConfig);
                if (item == null) continue;
                gui.setItem(position, item);
            }
            catch (Exception e) {
                LOGGER.warning("Failed to create GUI item " + itemKey + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
        if (this.config.contains("gui.items.page2_action")) {
            ItemStack page2Item;
            ItemMeta page2Meta;
            String page2MaterialName = this.config.getString("gui.items.page2_action.material", "PAPER");
            int page2CustomModelData = this.config.getInt("gui.items.page2_action.customModelData", 0);
            String page2Display = this.config.getString("gui.items.page2_action.display", "&a\u2192 &lPage 2");
            List page2Lore = this.config.getStringList("gui.items.page2_action.lore");
            int page2SmallPos = this.config.getInt("gui.items.page2_action.positions.small", 40);
            int page2MediumPos = this.config.getInt("gui.items.page2_action.positions.medium", 40);
            int page2LargePos = this.config.getInt("gui.items.page2_action.positions.large", 40);
            int page2Position = switch (layoutType.toLowerCase()) {
                case "small" -> page2SmallPos;
                case "medium" -> page2MediumPos;
                case "large" -> page2LargePos;
                default -> 40;
            };
            Material page2Material = Material.matchMaterial((String)page2MaterialName);
            if (page2Material == null) {
                page2Material = Material.PAPER;
                this.getLogger().warning("Invalid material for page2_action: " + page2MaterialName);
            }
            if ((page2Meta = (page2Item = new ItemStack(page2Material)).getItemMeta()) != null) {
                if (page2CustomModelData != 0) {
                    page2Meta.setCustomModelData(Integer.valueOf(page2CustomModelData));
                }
                page2Meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)page2Display));
                ArrayList<String> lore = new ArrayList<String>();
                for (String line : page2Lore) {
                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                }
                page2Meta.setLore(lore);
                page2Item.setItemMeta(page2Meta);
            }
            if (page2Position >= 0 && page2Position < gui.getSize()) {
                gui.setItem(page2Position, page2Item);
            } else {
                this.getLogger().warning("Invalid slot " + page2Position + " for page2_action in layout " + layoutType);
            }
        } else {
            this.logDebug("gui.items.page2_action not found in config.yml, skipping button.");
        }
    }

    private ItemStack createEnhancedGUIItem(Animals animal, AnimalData data, String itemType, GUIItemConfig itemConfig) {
        ItemStack item = new ItemStack(itemConfig.material != null ? itemConfig.material : Material.STONE);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        String display = this.addAnimatedElements(itemConfig.display, data);
        meta.setDisplayName(this.processEnhancedPlaceholders(display, animal, data));
        if (itemConfig.customModelData != 0) {
            meta.setCustomModelData(Integer.valueOf(itemConfig.customModelData));
        }
        List<String> processedLore = itemConfig.lore.stream().map(line -> this.processEnhancedPlaceholders((String)line, animal, data)).map(line -> this.addProgressBars((String)line, data)).collect(Collectors.toList());
        this.addDynamicLore(processedLore, itemType, data);
        meta.setLore(processedLore);
        if (this.shouldAddGlow(itemType, data)) {
            meta.addEnchant(Enchantment.DURABILITY, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        item.setItemMeta(meta);
        return item;
    }

    private void populateEnhancedGUIDecoration(Inventory gui, String layoutType, AnimalData data) {
        List<Object> borderSlots = switch (layoutType) {
            case "small" -> this.guiBorderSmall;
            case "medium" -> this.guiBorderMedium;
            case "large" -> this.guiBorderLarge;
            default -> Collections.emptyList();
        };
        String themeKey = this.getBondThemeKey(data.getBondLevel());
        String primaryMaterialName = this.config.getString("decoration_themes." + themeKey + ".primary", "GRAY_STAINED_GLASS_PANE");
        Material decorMaterial = this.getMaterialSafely(primaryMaterialName, Material.GRAY_STAINED_GLASS_PANE);
        Iterator<Object> iterator = borderSlots.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (slot < 0 || slot >= gui.getSize()) continue;
            ItemStack decorItem = new ItemStack(decorMaterial);
            ItemMeta meta = decorItem.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(ChatColor.RESET + " ");
                decorItem.setItemMeta(meta);
            }
            gui.setItem(slot, decorItem);
        }
        this.addSpecialDecorations(gui, layoutType, data);
    }

    private void startFeedingProcess(Player player, Animals animal, UUID animalId, AnimalData data) {
        ++this.totalFeedingActions;
        ItemStack item = player.getInventory().getItemInMainHand();
        String animalType = animal.getType().name().toLowerCase();
        if (data.getHunger() >= data.getMaxHunger()) {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_already_full").replace("{animal}", this.getAnimalDisplayName(animal)));
            return;
        }
        int hungerRestore = this.getFoodValue(item.getType(), animalType);
        item.setAmount(item.getAmount() - 1);
        data.setHunger(Math.min(data.getHunger() + hungerRestore, data.getMaxHunger()));
        data.setFeedCount(data.getFeedCount() + 1);
        data.setBondLevel(Math.min(data.getBondLevel() + this.bondFeedingGain, 100));
        this.checkForBreeding(player, animal, animalId, data);
        boolean leveledUp = false;
        if (data.getFeedCount() >= this.feedingsPerLevel * data.getLevel() && data.getLevel() < this.maxLevel) {
            this.levelUpAnimal(player, animal, data, animalId);
            leveledUp = true;
        }
        this.updateHungerDisplay(animal, data);
        this.playFeedingEffects(animal);
        this.saveAnimalData(animalId);
        player.sendMessage(this.getMessage((CommandSender)player, "fed_animal").replace("{animal}", this.getAnimalDisplayName(animal)).replace("{hunger}", String.valueOf(data.getHunger())).replace("{max_hunger}", String.valueOf(data.getMaxHunger())).replace("{bond}", String.valueOf(data.getBondLevel())).replace("{food_value}", String.valueOf(hungerRestore)));
        if (leveledUp) {
            player.sendMessage(this.getMessage((CommandSender)player, "level_up").replace("{level}", String.valueOf(data.getLevel())));
        }
    }

    private void feedAnimalInGUI(Player player, Animals animal, UUID animalId, AnimalData data) {
        ItemStack item = player.getInventory().getItemInMainHand();
        String animalType = animal.getType().name().toLowerCase();
        List feedItems = this.config.getStringList("animals." + animalType + ".feed_items");
        if (item == null || item.getAmount() <= 0 || !feedItems.contains(item.getType().name())) {
            player.sendMessage(this.getMessage((CommandSender)player, "no_gui_feed_item"));
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
            return;
        }
        if (data.getHunger() >= data.getMaxHunger()) {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_already_full").replace("{animal}", this.getAnimalDisplayName(animal)));
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            return;
        }
        int hungerRestore = this.getFoodValue(item.getType(), animalType);
        item.setAmount(item.getAmount() - 1);
        data.setHunger(Math.min(data.getHunger() + hungerRestore, data.getMaxHunger()));
        data.setFeedCount(data.getFeedCount() + 1);
        data.setBondLevel(Math.min(data.getBondLevel() + this.bondFeedingGain, 100));
        this.checkForBreeding(player, animal, animalId, data);
        boolean leveledUp = false;
        if (data.getFeedCount() >= this.feedingsPerLevel * data.getLevel() && data.getLevel() < this.maxLevel) {
            this.levelUpAnimal(player, animal, data, animalId);
            leveledUp = true;
        }
        this.updateHungerDisplay(animal, data);
        this.playFeedingEffects(animal);
        this.saveAnimalData(animalId);
        player.sendMessage(this.getMessage((CommandSender)player, "gui_fed_animal").replace("{animal}", this.getAnimalDisplayName(animal)).replace("{hunger}", String.valueOf(data.getHunger())).replace("{max_hunger}", String.valueOf(data.getMaxHunger())).replace("{bond}", String.valueOf(data.getBondLevel())).replace("{food_value}", String.valueOf(hungerRestore)));
        if (leveledUp) {
            player.sendMessage(this.getMessage((CommandSender)player, "level_up").replace("{level}", String.valueOf(data.getLevel())));
        }
    }

    private void levelUpAnimal(Player player, Animals animal, AnimalData data, UUID animalId) {
        data.setLevel(data.getLevel() + 1);
        data.setMaxHunger(Math.min(data.getMaxHunger() + 2, this.maxHungerCap));
        data.setFeedCount(0);
        if (data.getLevel() >= 2 && !this.animalIdMap.containsValue(animalId)) {
            this.animalIdMap.put(this.nextAnimalId, animalId);
            this.logDebug("Assigned Id " + this.nextAnimalId + " to UUID " + animalId);
            ++this.nextAnimalId;
        }
        if (this.enableParticles && this.guiLevelUpEffectEnabled) {
            animal.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, animal.getLocation().add(0.0, 1.0, 0.0), 20, 0.5, 0.5, 0.5, 0.0);
            animal.getWorld().playSound(animal.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        }
        this.saveAnimalData(animalId);
    }

    private void upgradeAnimal(Player player, Animals animal, UUID animalId, AnimalData data) {
        ItemStack costItem = new ItemStack(this.upgradeItem, this.upgradeCost);
        if (!player.getInventory().containsAtLeast(costItem, this.upgradeCost)) {
            player.sendMessage(this.getMessage((CommandSender)player, "not_enough_resources").replace("{cost}", String.valueOf(this.upgradeCost)).replace("{upgrade_item}", this.upgradeItem.name().toLowerCase().replace("_", " ")));
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
            return;
        }
        int oldLevel = data.getLevel();
        int oldBond = data.getBondLevel();
        int oldMaxHunger = data.getMaxHunger();
        player.getInventory().removeItem(new ItemStack[]{costItem});
        data.setLevel(data.getLevel() + 1);
        data.setMaxHunger(Math.min(data.getMaxHunger() + 2, this.maxHungerCap));
        data.setBondLevel(Math.min(data.getBondLevel() + this.bondUpgradeGain, 100));
        data.setFeedCount(0);
        if (data.getLevel() >= 2 && !this.animalIdMap.containsValue(animalId)) {
            this.animalIdMap.put(this.nextAnimalId, animalId);
            this.logDebug("Assigned Id " + this.nextAnimalId + " to UUID " + animalId + " via upgrade");
            ++this.nextAnimalId;
        }
        this.updateHungerDisplay(animal, data);
        this.saveAnimalData(animalId);
        player.sendMessage(this.getMessage((CommandSender)player, "animal_upgraded").replace("{level}", String.valueOf(data.getLevel())).replace("{animal}", this.getAnimalDisplayName(animal)));
        player.sendMessage(this.getMessage((CommandSender)player, "upgrade_level_change").replace("{old_level}", String.valueOf(oldLevel)).replace("{new_level}", String.valueOf(data.getLevel())));
        player.sendMessage(this.getMessage((CommandSender)player, "upgrade_max_hunger_change").replace("{old_max_hunger}", String.valueOf(oldMaxHunger)).replace("{new_max_hunger}", String.valueOf(data.getMaxHunger())));
        player.sendMessage(this.getMessage((CommandSender)player, "upgrade_bond_change").replace("{old_bond}", String.valueOf(oldBond)).replace("{new_bond}", String.valueOf(data.getBondLevel())));
        player.playSound(animal.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
        if (this.enableParticles && this.guiLevelUpEffectEnabled) {
            animal.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, animal.getLocation().add(0.0, 1.0, 0.0), 20, 0.7, 0.7, 0.7, 0.1);
            animal.getWorld().spawnParticle(Particle.FIREWORKS_SPARK, animal.getLocation().add(0.0, 1.0, 0.0), 15, 0.5, 0.5, 0.5, 0.05);
        }
        this.refreshGUI(player, animal);
    }

    private void handleAnimalDeath(Animals animal, UUID animalId) {
        animal.remove();
        this.notifyNearbyPlayers(animal, "animal_died");
        this.animalDataCache.remove(animalId);
        this.saveAnimalData(animalId);
    }

    private void handleAnimalKill(Player player, Animals animal, boolean fromGUI) {
        KillResult result;
        UUID animalId = animal.getUniqueId();
        AnimalData data = this.getOrCreateAnimalData(animalId);
        ItemStack drop = this.getKillDrop(animal, data, result = this.validateKillAttempt(player, data, fromGUI));
        if (drop != null) {
            animal.getWorld().dropItemNaturally(animal.getLocation(), drop);
        }
        animal.remove();
        this.removeAnimalData(animalId);
        this.saveAnimalData(animalId);
        this.playKillEffects(player, animal);
        this.sendKillMessage(player, result);
        if (fromGUI) {
            player.closeInventory();
        }
    }

    private ItemStack getKillDrop(Animals animal, AnimalData data, KillResult result) {
        if (this.dropHandler == null) {
            LOGGER.warning("DropChanceHandler \u043d\u0435 \u0431\u044b\u043b \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d! \u0414\u0440\u043e\u043f \u043d\u0435 \u0431\u0443\u0434\u0435\u0442 \u0432\u044b\u0434\u0430\u043d.");
            return null;
        }
        return switch (result) {
            default -> throw new IncompatibleClassChangeError();
            case KillResult.SUCCESS -> this.dropHandler.getDrop(animal, data, true);
            case KillResult.WRONG_TOOL, KillResult.LEVEL_TOO_LOW -> this.dropHandler.getDrop(animal, data, false);
        };
    }

    private void killAnimalDirectly(Player player, Animals animal, UUID animalId, AnimalData data) {
        ItemStack drop = this.dropHandler.getDrop(animal, data, true);
        if (drop != null) {
            animal.getWorld().dropItemNaturally(animal.getLocation(), drop);
            player.sendMessage(this.getMessage((CommandSender)player, "animal_killed"));
        } else {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_killed_by_hand"));
        }
        this.removeAnimalData(animalId);
        animal.remove();
        this.saveAnimalData(animalId);
        player.closeInventory();
    }

    private void collectResources(Player player, Animals animal, UUID animalId, AnimalData data) {
        if (data.getResourceCount() == 0 || data.getBondLevel() < this.resMinBondToProduce) {
            player.sendMessage(this.getMessage((CommandSender)player, "no_resources"));
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
            return;
        }
        ItemStack resource = this.getResourceItem(animal, data);
        if (resource != null) {
            HashMap overflow = player.getInventory().addItem(new ItemStack[]{resource});
            for (ItemStack item : overflow.values()) {
                animal.getWorld().dropItemNaturally(animal.getLocation(), item);
            }
            player.sendMessage(this.getMessage((CommandSender)player, "resources_collected").replace("{amount}", String.valueOf(resource.getAmount())).replace("{item}", resource.getType().name().toLowerCase().replace('_', ' ')));
            player.playSound(animal.getLocation(), Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f);
            if (this.enableParticles && this.guiBondParticlesEnabled) {
                animal.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, animal.getLocation().add(0.0, 1.0, 0.0), 10, 0.3, 0.3, 0.3, 0.0);
            }
        }
        data.setResourceCount(0);
        this.saveAnimalData(animalId);
    }

    private void initiateAnimalRename(final Player player, Animals animal) {
        player.closeInventory();
        player.sendMessage(this.getMessage((CommandSender)player, "rename_instruction"));
        player.setMetadata(RENAMING_ANIMAL_META_KEY, (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)animal));
        new BukkitRunnable(){

            public void run() {
                if (player.hasMetadata(AnimalHunger.RENAMING_ANIMAL_META_KEY)) {
                    player.removeMetadata(AnimalHunger.RENAMING_ANIMAL_META_KEY, (Plugin)AnimalHunger.this);
                    player.sendMessage(AnimalHunger.this.getMessage((CommandSender)player, "rename_cancelled"));
                }
            }
        }.runTaskLater((Plugin)this, 600L);
    }

    private void handleAnimalRename(Player player, String newName) {
        Animals animal;
        if (!player.hasMetadata(RENAMING_ANIMAL_META_KEY)) {
            return;
        }
        Object metaValue = ((MetadataValue)player.getMetadata(RENAMING_ANIMAL_META_KEY).get(0)).value();
        player.removeMetadata(RENAMING_ANIMAL_META_KEY, (Plugin)this);
        if (!(metaValue instanceof Animals) || !(animal = (Animals)metaValue).isValid()) {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_not_found"));
            return;
        }
        UUID animalId = animal.getUniqueId();
        AnimalData data = this.getAnimalData(animalId);
        if (data == null) {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_not_found"));
            return;
        }
        if (newName.length() > 20) {
            player.sendMessage(this.getMessage((CommandSender)player, "name_too_long"));
            return;
        }
        if (newName.isEmpty()) {
            player.sendMessage(this.getMessage((CommandSender)player, "name_empty"));
            return;
        }
        if (!this.isValidName(newName)) {
            player.sendMessage(ChatColor.RED + "error_name");
            return;
        }
        data.setCustomName(newName);
        this.updateHungerDisplay(animal, data);
        this.saveAnimalData(animalId);
        player.sendMessage(this.getMessage((CommandSender)player, "animal_renamed").replace("{name}", newName));
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.2f);
        if (this.enableParticles) {
            animal.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, animal.getLocation().add(0.0, 1.0, 0.0), 10, 0.3, 0.3, 0.3, 0.0);
        }
    }

    private void checkForBreeding(Player player, Animals animal, UUID animalId, AnimalData data) {
        UUID partnerId;
        AnimalData partnerData;
        Animals partner;
        if (data.getLevel() < 6) {
            return;
        }
        if (this.breedingCooldowns.containsKey(animalId)) {
            long lastBreeding = this.breedingCooldowns.get(animalId);
            if (System.currentTimeMillis() - lastBreeding < 300000L) {
                return;
            }
        }
        if ((partner = this.findBreedingPartner(animal, animalId)) != null && (partnerData = this.getAnimalData(partnerId = partner.getUniqueId())) != null && this.canBreed(partnerData, partnerId)) {
            this.performBreeding(player, animal, partner, animalId, partnerId, data, partnerData);
        }
    }

    private boolean canBreed(AnimalData data, UUID animalId) {
        if (data.getLevel() < 6) {
            return false;
        }
        if (this.breedingCooldowns.containsKey(animalId)) {
            long lastBreeding = this.breedingCooldowns.get(animalId);
            return System.currentTimeMillis() - lastBreeding >= 300000L;
        }
        return true;
    }

    private Animals findBreedingPartner(Animals animal, UUID animalId) {
        for (Entity nearbyEntity : animal.getNearbyEntities(8.0, 8.0, 8.0)) {
            AnimalData nearbyData;
            Animals nearbyAnimal;
            if (!(nearbyEntity instanceof Animals) || (nearbyAnimal = (Animals)nearbyEntity).getType() != animal.getType() || nearbyAnimal.getUniqueId().equals(animalId) || (nearbyData = this.getAnimalData(nearbyAnimal.getUniqueId())) == null || !this.canBreed(nearbyData, nearbyAnimal.getUniqueId())) continue;
            return nearbyAnimal;
        }
        return null;
    }

    private void performBreeding(Player player, Animals parent1, Animals parent2, UUID parent1Id, UUID parent2Id, AnimalData data1, AnimalData data2) {
        long currentTime = System.currentTimeMillis();
        this.breedingCooldowns.put(parent1Id, currentTime);
        this.breedingCooldowns.put(parent2Id, currentTime);
        Animals baby = (Animals)parent1.getWorld().spawnEntity(parent1.getLocation().add(0.5, 0.0, 0.5), parent1.getType());
        ++this.totalAnimalBirths;
        if (baby instanceof Ageable) {
            baby.setBaby();
        }
        UUID babyId = baby.getUniqueId();
        int inheritedLevel = Math.max(1, (data1.getLevel() + data2.getLevel()) / 3);
        int inheritedMaxHunger = Math.min((data1.getMaxHunger() + data2.getMaxHunger()) / 2, this.maxHungerCap);
        int inheritedBond = (data1.getBondLevel() + data2.getBondLevel()) / 4;
        AnimalData babyData = new AnimalData(inheritedMaxHunger, inheritedMaxHunger, inheritedLevel, inheritedBond, 0, 0);
        this.setAnimalData(babyId, babyData);
        this.saveAnimalData(babyId);
        this.updateHungerDisplay(baby, babyData);
        this.playBreedingEffects(parent1, parent2, baby);
        player.sendMessage(this.getMessage((CommandSender)player, "breeding_success").replace("{animal}", this.getAnimalDisplayName(parent1)).replace("{baby_level}", String.valueOf(inheritedLevel)).replace("{baby_bond}", String.valueOf(inheritedBond)));
        player.giveExp(this.random.nextInt(7) + 1);
        this.logDebug("Breeding successful: " + parent1.getType() + " (levels " + data1.getLevel() + " & " + data2.getLevel() + ") -> baby (level " + inheritedLevel + ")");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String cmdName = command.getName().toLowerCase();
        if (cmdName.equals("animalhunger")) {
            if (args.length == 0) {
                sender.sendMessage(this.getMessage(sender, "plugin_active"));
                return true;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                if (!sender.hasPermission("animalhunger.reload")) {
                    sender.sendMessage(this.getMessage(sender, "no_permission"));
                    return true;
                }
                this.reloadPlugin(sender);
                return true;
            }
            if (args[0].equalsIgnoreCase("debug") && sender instanceof Player) {
                Player player = (Player)sender;
                this.handleDebugCommand(player);
                return true;
            }
            if (args[0].equalsIgnoreCase("resources") && sender.hasPermission("animalhunger.admin")) {
                this.handleResourceCheckCommand(sender);
                return true;
            }
        }
        if (cmdName.equals("animalhome")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("This command is for players only.");
                return true;
            }
            Player player = (Player)sender;
            if (this.animalHomeManager != null) {
                return this.animalHomeManager.handleCommand(player, args);
            }
            player.sendMessage(ChatColor.RED + "Animal home feature is disabled.");
            return true;
        }
        if (cmdName.equals("sp")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(ChatColor.RED + "This command can only be used by players!");
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("animalhunger.ride")) {
                player.sendMessage(this.getMessage((CommandSender)player, "no_permission"));
                return true;
            }
            this.handleSpCommand(player);
            return true;
        }
        return false;
    }

    private void reloadPlugin(CommandSender sender) {
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        this.saveAllAnimalData();
        this.reloadConfig();
        this.config = this.getConfig();
        this.loadMessages();
        this.loadConfigValues();
        this.startScheduledTasks();
        sender.sendMessage(this.getMessage(sender, "config_reloaded"));
    }

    private void handleDebugCommand(Player player) {
        Animals animal = this.getAnimalFromMetadata(player);
        if (animal == null) {
            player.sendMessage(ChatColor.RED + "No valid animal in metadata. Right-click an animal first.");
            return;
        }
        AnimalData data = this.getAnimalData(animal.getUniqueId());
        player.sendMessage(ChatColor.GREEN + "Animal: " + animal.getType() + " (UUID: " + animal.getUniqueId() + ")");
        player.sendMessage(ChatColor.GREEN + "Data: " + (String)(data != null ? "Hunger=" + data.getHunger() + "/" + data.getMaxHunger() + ", Level=" + data.getLevel() + ", Bond=" + data.getBondLevel() + "%, Resources=" + data.getResourceCount() + ", Name=" + (data.getCustomName() != null ? data.getCustomName() : "none") : "null"));
        if (data != null) {
            boolean canBreed = this.canBreed(data, animal.getUniqueId());
            player.sendMessage(ChatColor.GREEN + "Breeding: Level " + data.getLevel() + "/6 (min), " + (data.getLevel() >= 6 ? "\u2713" : "\u2717") + " Level OK, " + (canBreed ? "\u2713 Ready" : "\u2717 On cooldown/LowLvl"));
        }
    }

    private void handleSpCommand(Player player) {
        Animals closestAnimal = null;
        double closestDistance = 5.0;
        for (Entity entity : player.getNearbyEntities(5.0, 5.0, 5.0)) {
            AnimalData data;
            double distance;
            Animals animal;
            if (!(entity instanceof Animals) || !this.isSupportedAnimal((Entity)(animal = (Animals)entity)) || this.isEntityTypeIgnored(animal.getType()) || !((distance = player.getLocation().distance(animal.getLocation())) < closestDistance) || (data = this.getAnimalData(animal.getUniqueId())) == null || data.getLevel() < 6) continue;
            closestAnimal = animal;
            closestDistance = distance;
        }
        if (closestAnimal == null) {
            player.sendMessage(ChatColor.RED + "no_rideable_animal_nearby");
            return;
        }
        if (closestAnimal.getPassengers().size() > 0) {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_already_ridden"));
            return;
        }
        AnimalData data = this.getAnimalData(closestAnimal.getUniqueId());
        if (data.getHunger() < data.getMaxHunger() / 2) {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_too_hungry"));
            return;
        }
        this.animalRidingSystem.startRidingCommand(player, closestAnimal, data);
    }

    public void updateHungerDisplay(Animals animal, AnimalData data) {
        if (animal == null || data == null) {
            return;
        }
        if (this.isEntityTypeIgnored(animal.getType())) {
            animal.setCustomNameVisible(false);
            return;
        }
        boolean shouldShow = false;
        if (data.getCustomName() != null) {
            shouldShow = true;
        } else if (this.entityDisplayMinLevel > 0 && data.getLevel() >= this.entityDisplayMinLevel) {
            shouldShow = true;
        } else if (this.entityDisplayMinLevel == 0) {
            shouldShow = true;
        }
        if (this.entityDisplayShowOnlyAfterRename && data.getCustomName() == null) {
            shouldShow = false;
        }
        if (!shouldShow) {
            animal.setCustomNameVisible(false);
            animal.setCustomName(null);
            return;
        }
        if (!this.entityDisplayEnabled) {
            String customName = data.getColoredName(animal.getType().name());
            if (customName != null && !customName.trim().isEmpty()) {
                animal.setCustomName(customName);
                animal.setCustomNameVisible(true);
            } else {
                animal.setCustomNameVisible(false);
            }
            return;
        }
        String animalTypeKey = this.getAnimalTypeKey(animal);
        String displayName = this.config.getString("animals." + animalTypeKey + ".display_name", animalTypeKey);
        String name = data.getCustomName() != null ? data.getCustomName() : displayName;
        ChatColor nameColor = data.getNameColor();
        String coloredName = nameColor + name;
        Object levelPart = "";
        Object bondPart = "";
        Object barPart = "";
        if (this.entityDisplayShowLevel) {
            levelPart = " \u00a7e[\u00a76Lvl " + data.getLevel() + "\u00a7e]";
        }
        if (this.entityDisplayShowBond) {
            bondPart = " \u00a7d[" + data.getBondLevel() + "%\u00a7d]";
        }
        if (this.entityDisplayBarEnabled) {
            barPart = " " + this.buildHungerBar(data);
        }
        String displayText = this.entityDisplayFormat.replace("{name}", coloredName).replace("{level}", (CharSequence)levelPart).replace("{bond}", (CharSequence)bondPart).replace("{bar}", (CharSequence)barPart).trim();
        animal.setCustomName(ChatColor.translateAlternateColorCodes((char)'&', (String)displayText));
        animal.setCustomNameVisible(true);
    }

    private String buildHungerBar(AnimalData data) {
        double hungerPercent = (double)data.getHunger() / (double)data.getMaxHunger();
        int filledBars = (int)((double)this.entityDisplayBarLength * hungerPercent);
        String barColor = hungerPercent < 0.4 ? this.entityDisplayBarHungerColor : this.entityDisplayBarFullColor;
        StringBuilder bar = new StringBuilder();
        bar.append(barColor);
        for (int i = 0; i < this.entityDisplayBarLength; ++i) {
            bar.append(i < filledBars ? "\u2588" : "\u2592");
        }
        bar.append(ChatColor.RESET);
        return "[" + bar + "]";
    }

    private int getFoodValue(Material foodType, String animalType) {
        String configPath = "animals." + animalType + ".food_values." + foodType.name();
        if (this.config.contains(configPath)) {
            return this.config.getInt(configPath);
        }
        return switch (foodType) {
            case Material.HAY_BLOCK -> this.config.getInt("food-values.hay_block", 5);
            case Material.WHEAT -> this.config.getInt("food-values.wheat", 1);
            case Material.GOLDEN_CARROT -> this.config.getInt("food-values.golden_carrot", 3);
            case Material.CARROT -> this.config.getInt("food-values.carrot", 2);
            case Material.POTATO -> this.config.getInt("food-values.potato", 2);
            case Material.BEETROOT -> this.config.getInt("food-values.beetroot", 1);
            case Material.APPLE -> this.config.getInt("food-values.apple", 2);
            default -> this.hungerRestoreAmount;
        };
    }

    private KillResult validateKillAttempt(Player player, AnimalData data, boolean fromGUI) {
        boolean hasRequiredTool;
        if (fromGUI) {
            return data.getLevel() >= this.killRequiredLevel ? KillResult.SUCCESS : KillResult.LEVEL_TOO_LOW;
        }
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        boolean bl = hasRequiredTool = this.killRequiredItem.isEmpty() || heldItem != null && heldItem.getType().name().equalsIgnoreCase(this.killRequiredItem);
        if (data.getLevel() < this.killRequiredLevel) {
            return KillResult.LEVEL_TOO_LOW;
        }
        return hasRequiredTool ? KillResult.SUCCESS : KillResult.WRONG_TOOL;
    }

    public String processEnhancedPlaceholders(String text, Animals animal, AnimalData data) {
        if (text == null) {
            return "";
        }
        String animalType = animal.getType().name().toLowerCase();
        String displayName = this.config.getString("animals." + animalType + ".display_name", animalType);
        List feedItemsList = this.config.getStringList("animals." + animalType + ".feed_items");
        String feedItemsStr = feedItemsList.isEmpty() ? "none" : feedItemsList.stream().map(item -> item.toLowerCase().replace("_", " ")).collect(Collectors.joining(", "));
        List resourceItemsList = this.config.getStringList("animals." + animalType + ".resource_items");
        String resourceType = "none";
        if (!resourceItemsList.isEmpty()) {
            int index = data.getBondLevel() >= this.bondThresholdRareDrops && resourceItemsList.size() > 1 ? 1 : 0;
            resourceType = ((String)resourceItemsList.get(index)).toLowerCase().replace("_", " ");
        }
        int nextThreshold = this.getNextBondThreshold(data.getBondLevel());
        String bondEffects = this.getBondEffects(data.getBondLevel());
        double hungerPercent = data.getMaxHunger() > 0 ? (double)data.getHunger() / (double)data.getMaxHunger() * 100.0 : 0.0;
        String hungerStatus = this.getHungerStatus(data.getHunger(), data.getMaxHunger());
        String customName = data.getCustomName() != null ? data.getCustomName() : displayName;
        int requiredFeeds = Math.max(1, this.feedingsPerLevel * data.getLevel());
        double bondMultiplier = 1.0 + (double)data.getBondLevel() / 100.0;
        double productionRate = this.getProductionChance(data) * 100.0;
        String dropQuality = this.getDropQuality(data.getLevel());
        String homeStatus = "N/A";
        String homeRadius = "N/A";
        String homeCenter = "N/A";
        String defaultRadius = "N/A";
        if (this.animalHomeManager != null) {
            AnimalHomeManager.HomeData homeData = this.animalHomeManager.getHomeData(animal.getUniqueId());
            if (homeData != null) {
                homeStatus = "&aSet";
                homeRadius = String.valueOf(homeData.getRadius());
                Location center = homeData.getCenter();
                homeCenter = String.format("X: %.0f, Y: %.0f, Z: %.0f", center.getX(), center.getY(), center.getZ());
            } else {
                homeStatus = "&cNot set";
                homeRadius = "0";
                homeCenter = "---";
            }
            defaultRadius = String.valueOf(this.animalHomeManager.getDefaultRadius());
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text.replace("{animal_name}", displayName).replace("{hunger}", String.valueOf(data.getHunger())).replace("{maxhunger}", String.valueOf(data.getMaxHunger())).replace("{hunger_percent}", String.format("%.0f", hungerPercent)).replace("{hunger_status}", hungerStatus).replace("{level}", String.valueOf(data.getLevel())).replace("{max_level}", String.valueOf(this.maxLevel)).replace("{bond}", String.valueOf(data.getBondLevel())).replace("{feed_count}", String.valueOf(data.getFeedCount())).replace("{required_feeds}", String.valueOf(requiredFeeds)).replace("{resources}", String.valueOf(data.getResourceCount())).replace("{resource_type}", resourceType).replace("{feed_items}", feedItemsStr).replace("{hunger_restore}", String.valueOf(this.hungerRestoreAmount)).replace("{bond_gain}", String.valueOf(this.bondFeedingGain)).replace("{bond_multiplier}", String.format("%.2f", bondMultiplier)).replace("{production_rate}", String.format("%.2f%%", productionRate)).replace("{name}", customName).replace("{nextlevel}", String.valueOf(data.getLevel() + 1)).replace("{upgrade_cost}", String.valueOf(this.upgradeCost)).replace("{upgrade_item}", this.upgradeItem.name().toLowerCase().replace("_", " ")).replace("{min_kill_level}", String.valueOf(this.killRequiredLevel)).replace("{drop_quality}", dropQuality).replace("{next_threshold}", String.valueOf(nextThreshold)).replace("{bond_effects}", bondEffects).replace("{upgrade_bond_gain}", String.valueOf(this.bondUpgradeGain)).replace("{resource_threshold}", String.valueOf(this.bondThresholdResource) + "%").replace("{status}", homeStatus).replace("{radius}", homeRadius).replace("{center}", homeCenter).replace("{default_radius}", defaultRadius));
    }

    private void addSpecialDecorations(Inventory gui, String layoutType, AnimalData data) {
        int[] cornerSlots;
        String decorKey;
        Material decorMaterial;
        if (data.getBondLevel() >= this.bondThresholdRareDrops) {
            decorMaterial = Material.GOLD_BLOCK;
            decorKey = "decoration_gold";
        } else if (data.getBondLevel() >= this.bondThresholdResource) {
            decorMaterial = Material.IRON_BLOCK;
            decorKey = "decoration_silver";
        } else if (data.getBondLevel() >= 25) {
            decorMaterial = Material.COPPER_BLOCK;
            decorKey = "decoration_bronze";
        } else {
            decorMaterial = Material.COBBLESTONE;
            decorKey = "decoration_base";
        }
        for (int slot : cornerSlots = this.getCornerSlots(layoutType)) {
            if (slot >= gui.getSize()) continue;
            ItemStack decorItem = new ItemStack(decorMaterial);
            ItemMeta meta = decorItem.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(this.getMessage(null, decorKey));
                meta.setLore(Arrays.asList(this.getMessage(null, "decoration_bond_level").replace("{bond}", String.valueOf(data.getBondLevel())), this.getMessage(null, "decoration_bond_status").replace("{status}", this.getBondStatus(data.getBondLevel()))));
                meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this, "non_pickup"), PersistentDataType.BYTE, (Object)1);
                decorItem.setItemMeta(meta);
            }
            gui.setItem(slot, decorItem);
        }
    }

    private void playFeedingEffects(Animals animal) {
        if (this.enableParticles && this.guiBondParticlesEnabled) {
            animal.getWorld().spawnParticle(Particle.HEART, animal.getLocation().add(0.0, 1.0, 0.0), 5);
            ++this.totalParticlesSpawned;
        }
        animal.getWorld().playSound(animal.getLocation(), Sound.ENTITY_PLAYER_BURP, 1.0f, 1.0f);
        ++this.totalSoundsPlayed;
    }

    private void playBreedingEffects(Animals parent1, Animals parent2, final Animals baby) {
        if (this.enableParticles) {
            parent1.getWorld().spawnParticle(Particle.HEART, parent1.getLocation().add(0.0, 2.0, 0.0), 5, 0.5, 0.5, 0.5, 0.0);
            parent2.getWorld().spawnParticle(Particle.HEART, parent2.getLocation().add(0.0, 2.0, 0.0), 5, 0.5, 0.5, 0.5, 0.0);
            baby.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, baby.getLocation().add(0.0, 1.0, 0.0), 10, 0.3, 0.3, 0.3, 0.0);
            this.totalParticlesSpawned += 3;
        }
        parent1.getWorld().playSound(parent1.getLocation(), Sound.ENTITY_GENERIC_EAT, 1.0f, 1.0f);
        ++this.totalSoundsPlayed;
        new BukkitRunnable(){

            public void run() {
                if (baby.isValid()) {
                    Sound babySound = switch (baby.getType()) {
                        case EntityType.COW -> Sound.ENTITY_COW_AMBIENT;
                        case EntityType.SHEEP -> Sound.ENTITY_SHEEP_AMBIENT;
                        case EntityType.PIG -> Sound.ENTITY_PIG_AMBIENT;
                        case EntityType.CHICKEN -> Sound.ENTITY_CHICKEN_AMBIENT;
                        default -> Sound.ENTITY_GENERIC_EAT;
                    };
                    baby.getWorld().playSound(baby.getLocation(), babySound, 0.8f, 1.5f);
                    ++AnimalHunger.this.totalSoundsPlayed;
                }
            }
        }.runTaskLater((Plugin)this, 20L);
    }

    private void playKillEffects(Player player, Animals animal) {
        player.playSound(animal.getLocation(), Sound.ENTITY_GENERIC_HURT, 1.0f, 1.0f);
        ++this.totalSoundsPlayed;
        if (this.enableParticles) {
            animal.getWorld().spawnParticle(Particle.SMOKE_NORMAL, animal.getLocation().add(0.0, 1.0, 0.0), 10, 0.3, 0.3, 0.3, 0.0);
            ++this.totalParticlesSpawned;
        }
    }

    private void sendAdminPatreonMessage() {
        String messageKey = "&e[AnimalHunger] &7You are using the PAID version of the plugin, thank you for your support!";
        String message = this.messages.getString(this.language + "." + messageKey, "&e[AnimalHunger] &7You are using the PAID version of the plugin, thank you for your support!");
        String coloredMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        TextComponent clickableMessage = new TextComponent(coloredMessage);
        clickableMessage.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://patreon.com/msL244"));
        clickableMessage.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Click to visit Patreon!").create()));
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission("animalhunger.admin")) continue;
            player.spigot().sendMessage((BaseComponent)clickableMessage);
        }
    }

    private void sendAdminPatreonMessage(Player player) {
        String messageKey = "free_version_notice";
        String message = this.messages.getString(this.language + "." + messageKey, "&e[AnimalHunger] &7This is the free version of the plugin! Unlock the full version at &b&npatreon.com/msL244&7!");
        String coloredMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        TextComponent clickableMessage = new TextComponent(coloredMessage);
        clickableMessage.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://patreon.com/msL244"));
        clickableMessage.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Click to visit Patreon!").create()));
        player.spigot().sendMessage((BaseComponent)clickableMessage);
    }

    private boolean isEntityTypeIgnored(EntityType type) {
        if (!this.ignoreEntitiesEnabled || this.ignoredEntityTypes == null) {
            return false;
        }
        return this.ignoredEntityTypes.contains(type.name());
    }

    private void registerPlaceholderAPI() {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new AnimalHungerExpansion(this).register();
            LOGGER.info("PlaceholderAPI support enabled.");
        }
    }

    public AnimalData getOrCreateAnimalData(UUID id) {
        return this.animalDataCache.computeIfAbsent(id, k -> {
            this.logDebug("Creating new default data for " + id);
            int defaultHunger = this.config.getInt("default_values.hunger", 10);
            int defaultMaxHunger = this.config.getInt("default_values.max_hunger", 10);
            int defaultLevel = this.config.getInt("default_values.level", 1);
            int defaultBond = this.config.getInt("default_values.bond", 0);
            int defaultResources = this.config.getInt("default_values.resources", 0);
            int defaultFeedCount = this.config.getInt("default_values.feed_count", 0);
            return new AnimalData(defaultHunger, defaultMaxHunger, defaultLevel, defaultBond, defaultResources, defaultFeedCount);
        });
    }

    private int getGUISize(Animals animal) {
        return 54;
    }

    private String getGUILayoutType(int size) {
        return switch (size) {
            case 27 -> "small";
            case 45 -> "medium";
            default -> "large";
        };
    }

    private String getGUITitle(Animals animal, String layoutType) {
        String animalType = animal.getType().name().toLowerCase();
        AnimalData data = this.getOrCreateAnimalData(animal.getUniqueId());
        String displayName = data.getCustomName() != null ? data.getCustomName() : this.config.getString("animals." + animalType + ".display_name", animal.getType().name());
        String titleTemplate = switch (layoutType) {
            case "small" -> this.guiTitleSmall;
            case "medium" -> this.guiTitleMedium;
            default -> this.guiTitleLarge;
        };
        return ChatColor.translateAlternateColorCodes((char)'&', (String)titleTemplate.replace("{animal_name}", displayName));
    }

    private boolean isSupportedAnimal(Entity entity) {
        if (this.compatibility == null) {
            this.logDebug("PluginCompatibility is null, entity check failed.");
            return false;
        }
        return this.compatibility.isSupportedEntity(entity);
    }

    private boolean hasValidFeedItemForAnimal(Player player, Animals animal) {
        if (this.compatibility == null) {
            this.logDebug("PluginCompatibility is null, feed item check failed.");
            return false;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getAmount() <= 0) {
            return false;
        }
        String animalTypeKey = this.getAnimalTypeKey(animal);
        List feedItems = this.config.getStringList("animals." + animalTypeKey + ".feed_items");
        return this.compatibility.isValidFeedItem(item, feedItems);
    }

    private String getAnimalTypeKey(Animals animal) {
        String mythicType;
        if (this.compatibility.isMythicMobsEnabled() && this.compatibility.isMythicMob((Entity)animal) && (mythicType = this.compatibility.getMythicMobType((Entity)animal)) != null) {
            return mythicType.toLowerCase();
        }
        return animal.getType().name().toLowerCase();
    }

    private int[] getCornerSlots(String layoutType) {
        int[] nArray;
        switch (layoutType.toLowerCase()) {
            case "small": {
                int[] nArray2 = new int[4];
                nArray2[0] = 0;
                nArray2[1] = 8;
                nArray2[2] = 18;
                nArray = nArray2;
                nArray2[3] = 26;
                break;
            }
            case "medium": {
                int[] nArray3 = new int[4];
                nArray3[0] = 0;
                nArray3[1] = 8;
                nArray3[2] = 36;
                nArray = nArray3;
                nArray3[3] = 44;
                break;
            }
            case "large": {
                int[] nArray4 = new int[4];
                nArray4[0] = 0;
                nArray4[1] = 8;
                nArray4[2] = 45;
                nArray = nArray4;
                nArray4[3] = 53;
                break;
            }
            default: {
                int[] nArray5 = new int[4];
                nArray5[0] = 0;
                nArray5[1] = 8;
                nArray5[2] = 45;
                nArray = nArray5;
                nArray5[3] = 53;
            }
        }
        return nArray;
    }

    public String getMessage(CommandSender sender, String key) {
        String locale = sender instanceof Player && !this.language.equals("default") ? this.language : (sender instanceof Player ? ((Player)sender).getLocale().replace("_", "") : "en");
        String message = this.messages.getString(locale + "." + key, this.messages.getString("en." + key, "Message not found: " + key));
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public void logDebug(String message) {
        if (this.debug) {
            LOGGER.info("[DEBUG] " + message);
        }
    }

    private Material getMaterialSafely(String materialName, Material fallback) {
        try {
            Material material = Material.getMaterial((String)materialName.toUpperCase());
            if (material == null) {
                LOGGER.warning("Invalid material: " + materialName + ", using fallback: " + fallback.name());
                return fallback;
            }
            return material;
        }
        catch (Exception e) {
            LOGGER.warning("Error parsing material: " + materialName + ", using fallback: " + fallback.name());
            return fallback;
        }
    }

    private void setLastAnimalMetadata(Player player, Animals animal) {
        player.setMetadata(LAST_ANIMAL_META_KEY, (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)animal));
    }

    public Animals getAnimalFromMetadata(Player player) {
        Animals animal;
        if (!player.hasMetadata(LAST_ANIMAL_META_KEY)) {
            return null;
        }
        Object value = ((MetadataValue)player.getMetadata(LAST_ANIMAL_META_KEY).get(0)).value();
        if (!(value instanceof Animals) || !(animal = (Animals)value).isValid()) {
            player.removeMetadata(LAST_ANIMAL_META_KEY, (Plugin)this);
            return null;
        }
        return animal;
    }

    private int getAnimalId(UUID id) {
        return this.animalIdMap.entrySet().stream().filter(entry -> ((UUID)entry.getValue()).equals(id)).map(Map.Entry::getKey).findFirst().orElse(-1);
    }

    @EventHandler
    public void onPlayerInteractEntityVanillaMilk(PlayerInteractEntityEvent event) {
        Animals animal;
        block12: {
            block11: {
                Entity entity = event.getRightClicked();
                if (!(entity instanceof Animals)) break block11;
                animal = (Animals)entity;
                if (event.getHand() == EquipmentSlot.HAND) break block12;
            }
            return;
        }
        if (this.isEntityTypeIgnored(animal.getType())) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand.getType() != Material.BUCKET) {
            return;
        }
        String animalTypeKey = animal.getType().name().toUpperCase();
        if (!this.vanillaMilkableAnimals.contains(animalTypeKey)) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble(100.0) >= this.vanillaMilkingChance) {
            String failureMsg = this.vanillaMilkingFailureMsg.replace("{animal_name}", this.getAnimalDisplayName(animal));
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)failureMsg));
            return;
        }
        ItemStack milkBucket = new ItemStack(Material.MILK_BUCKET);
        HashMap overflow = player.getInventory().addItem(new ItemStack[]{milkBucket});
        if (!overflow.isEmpty()) {
            for (ItemStack item : overflow.values()) {
                animal.getWorld().dropItemNaturally(animal.getLocation(), item);
            }
        }
        if (itemInHand.getAmount() == 1) {
            player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
        } else {
            itemInHand.setAmount(itemInHand.getAmount() - 1);
        }
        animal.getWorld().playSound(animal.getLocation(), Sound.ENTITY_COW_MILK, 1.0f, 1.0f);
        ++this.totalSoundsPlayed;
        event.setCancelled(true);
    }

    @EventHandler
    public void onPlayerInteractEntityBlockVanillaMilk(PlayerInteractEntityEvent event) {
        Animals animal;
        block8: {
            block7: {
                if (!this.disableVanillaMilking) {
                    return;
                }
                Entity entity = event.getRightClicked();
                if (!(entity instanceof Animals)) break block7;
                animal = (Animals)entity;
                if (event.getHand() == EquipmentSlot.HAND) break block8;
            }
            return;
        }
        if (this.isEntityTypeIgnored(animal.getType())) {
            return;
        }
        if (animal.getType() != EntityType.COW && animal.getType() != EntityType.MUSHROOM_COW) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand.getType() == Material.BUCKET) {
            event.setCancelled(true);
        }
    }

    public AnimalData getAnimalData(UUID id) {
        return this.animalDataCache.get(id);
    }

    public void setAnimalData(UUID id, AnimalData data) {
        this.animalDataCache.put(id, data);
    }

    public void removeAnimalData(UUID id) {
        this.animalDataCache.remove(id);
    }

    public Map<UUID, AnimalData> getAnimalDataCache() {
        return this.animalDataCache;
    }

    public Map<Integer, UUID> getAnimalIdMap() {
        return this.animalIdMap;
    }

    public PluginCompatibility getCompatibility() {
        return this.compatibility;
    }

    public CustomDropManager getCustomDropManager() {
        return this.customDropManager;
    }

    public AnimalDataManager getAnimalDataManager() {
        return this.animalDataManager;
    }

    public AnimalHungerCrutch getCrutch() {
        return this.crutch;
    }

    public boolean isRidingDisabled() {
        return this.disableRiding;
    }

    public boolean isResourceCollectionDisabled() {
        return this.disableResourceCollection;
    }

    public boolean isVanillaMilkingDisabled() {
        return this.disableVanillaMilking;
    }

    private String getAnimalDisplayName(Animals animal) {
        return this.compatibility.getEntityDisplayName((Entity)animal);
    }

    private String addAnimatedElements(String display, AnimalData data) {
        long time = System.currentTimeMillis() / 1000L;
        String[] animations = new String[]{"\u2726", "\u2727", "\u2605", "\u2606"};
        String currentAnim = animations[(int)(time % (long)animations.length)];
        return display.replace("\u2728", currentAnim);
    }

    private String addProgressBars(String line, AnimalData data) {
        if (line.contains("{hunger_bar}")) {
            String hungerBar = this.createProgressBar(data.getHunger(), data.getMaxHunger(), ChatColor.GREEN, ChatColor.RED, 20);
            return line.replace("{hunger_bar}", hungerBar);
        }
        if (line.contains("{bond_bar}")) {
            String bondBar = this.createProgressBar(data.getBondLevel(), 100, ChatColor.LIGHT_PURPLE, ChatColor.GRAY, 20);
            return line.replace("{bond_bar}", bondBar);
        }
        if (line.contains("{level_bar}")) {
            String levelBar = this.createProgressBar(data.getLevel(), this.maxLevel, ChatColor.GOLD, ChatColor.DARK_GRAY, 10);
            return line.replace("{level_bar}", levelBar);
        }
        return line;
    }

    private String createProgressBar(int current, int max, ChatColor fillColor, ChatColor emptyColor, int length) {
        int i;
        if (max == 0) {
            max = 1;
        }
        int filled = (int)((double)current / (double)max * (double)length);
        StringBuilder bar = new StringBuilder();
        bar.append(fillColor);
        for (i = 0; i < filled; ++i) {
            bar.append("\u2588");
        }
        bar.append(emptyColor);
        for (i = filled; i < length; ++i) {
            bar.append("\u2592");
        }
        bar.append(ChatColor.RESET);
        return bar.toString();
    }

    private void addDynamicLore(List<String> lore, String itemType, AnimalData data) {
        switch (itemType) {
            case "hunger_display": {
                lore.add("");
                lore.add(this.getMessage(null, "hunger_status"));
                lore.add(this.createProgressBar(data.getHunger(), data.getMaxHunger(), ChatColor.GREEN, ChatColor.RED, 15));
                break;
            }
            case "bond_display": {
                lore.add("");
                lore.add(this.getMessage(null, "bond_progress"));
                lore.add(this.createProgressBar(data.getBondLevel(), 100, ChatColor.LIGHT_PURPLE, ChatColor.GRAY, 15));
                int nextThreshold = this.getNextBondThreshold(data.getBondLevel());
                if (nextThreshold <= data.getBondLevel() || nextThreshold > 100) break;
                lore.add(this.getMessage(null, "bond_next_threshold").replace("{threshold}", String.valueOf(nextThreshold - data.getBondLevel())));
                break;
            }
            case "level_display": {
                if (data.getLevel() >= this.maxLevel) break;
                lore.add("");
                lore.add(this.getMessage(null, "level_progress"));
                int required = this.feedingsPerLevel * data.getLevel();
                lore.add(this.createProgressBar(data.getFeedCount(), required, ChatColor.GOLD, ChatColor.DARK_GRAY, 15));
            }
        }
    }

    private boolean shouldAddGlow(String itemType, AnimalData data) {
        return switch (itemType) {
            case "bond_display" -> {
                if (data.getBondLevel() >= this.bondThresholdRareDrops) {
                    yield true;
                }
                yield false;
            }
            case "level_display" -> {
                if (data.getLevel() >= this.maxLevel) {
                    yield true;
                }
                yield false;
            }
            case "upgrade_action" -> {
                if (data.getLevel() < this.maxLevel) {
                    yield true;
                }
                yield false;
            }
            case "collect_action" -> {
                if (data.getResourceCount() > 0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private int getNextBondThreshold(int currentBond) {
        if (currentBond < this.bondThresholdResource) {
            return this.bondThresholdResource;
        }
        if (currentBond < this.bondThresholdRareDrops) {
            return this.bondThresholdRareDrops;
        }
        if (currentBond < this.bondThresholdBonusResources) {
            return this.bondThresholdBonusResources;
        }
        return 101;
    }

    private String getBondEffects(int bondLevel) {
        ArrayList<String> effects = new ArrayList<String>();
        if (bondLevel >= this.bondThresholdResource) {
            effects.add("&8\u25b8 &aResource Production Unlocked");
        }
        if (bondLevel >= this.bondThresholdRareDrops) {
            effects.add("&8\u25b8 &aRare Drops Available");
        }
        if (bondLevel >= this.bondThresholdBonusResources) {
            effects.add("&8\u25b8 &aBonus Resources Active");
        }
        return effects.isEmpty() ? "&8\u25b8 &7No Effects" : String.join((CharSequence)"\n", effects);
    }

    private String getHungerStatus(int hunger, int maxHunger) {
        if (maxHunger == 0) {
            return this.getMessage(null, "hunger_status_critical");
        }
        double percent = (double)hunger / (double)maxHunger * 100.0;
        if (percent >= 75.0) {
            return this.getMessage(null, "hunger_status_healthy");
        }
        if (percent >= 50.0) {
            return this.getMessage(null, "hunger_status_hungry");
        }
        if (percent >= 25.0) {
            return this.getMessage(null, "hunger_status_starving");
        }
        return this.getMessage(null, "hunger_status_critical");
    }

    private String getDropQuality(int level) {
        if (level >= 4) {
            return this.getMessage(null, "drop_quality_legendary");
        }
        if (level >= 3) {
            return this.getMessage(null, "drop_quality_rare");
        }
        if (level >= 2) {
            return this.getMessage(null, "drop_quality_uncommon");
        }
        return this.getMessage(null, "drop_quality_common");
    }

    private String getBondStatus(int bondLevel) {
        if (bondLevel >= this.bondThresholdRareDrops) {
            return this.getMessage(null, "bond_status_legendary");
        }
        if (bondLevel >= this.bondThresholdResource) {
            return this.getMessage(null, "bond_status_strong");
        }
        if (bondLevel >= 25) {
            return this.getMessage(null, "bond_status_moderate");
        }
        return this.getMessage(null, "bond_status_weak");
    }

    private ItemStack getResourceItem(Animals animal, AnimalData data) {
        String animalType = animal.getType().name().toLowerCase();
        List resourceItems = this.config.getStringList("animals." + animalType + ".resource_items");
        if (resourceItems.isEmpty()) {
            return null;
        }
        String resourceItem = data.getBondLevel() >= this.resRareItemBond && resourceItems.size() > 1 ? (String)resourceItems.get(1) : (String)resourceItems.get(0);
        Material resourceType = this.getMaterialSafely(resourceItem, Material.STONE);
        int amount = data.getResourceCount();
        if (data.getBondLevel() >= this.resBonusAmountBond) {
            int bonus = this.resBonusMaxAmount > this.resBonusMinAmount ? this.random.nextInt(this.resBonusMaxAmount - this.resBonusMinAmount + 1) + this.resBonusMinAmount : this.resBonusMinAmount;
            amount += bonus;
        }
        return new ItemStack(resourceType, Math.max(1, amount));
    }

    private double getProductionChance(AnimalData data) {
        int bond = data.getBondLevel();
        if (bond >= this.resBonusAmountBond) {
            return this.resChanceLvl3;
        }
        if (bond >= this.resRareItemBond) {
            return this.resChanceLvl2;
        }
        if (bond >= this.resMinBondToProduce) {
            return this.resChanceLvl1;
        }
        return 0.0;
    }

    private void notifyNearbyPlayers(Animals animal, String messageKey) {
        for (Entity entity : animal.getNearbyEntities(10.0, 10.0, 10.0)) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            player.sendMessage(this.getMessage((CommandSender)player, messageKey).replace("{animal}", this.getAnimalDisplayName(animal)));
            player.playSound(animal.getLocation(), Sound.ENTITY_VILLAGER_DEATH, 1.0f, 1.0f);
            if (!this.enableParticles) continue;
            animal.getWorld().spawnParticle(Particle.SMOKE_NORMAL, animal.getLocation().add(0.0, 1.0, 0.0), 10, 0.3, 0.3, 0.3, 0.0);
        }
    }

    private void sendKillMessage(Player player, KillResult result) {
        String messageKey;
        switch (result) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SUCCESS: {
                String string = "animal_killed";
                break;
            }
            case WRONG_TOOL: {
                String string = "animal_killed_wrong_tool";
                break;
            }
            case LEVEL_TOO_LOW: {
                String string = messageKey = "kill_level_required";
            }
        }
        if (result == KillResult.LEVEL_TOO_LOW) {
            player.sendMessage(this.getMessage((CommandSender)player, messageKey).replace("{level}", String.valueOf(this.killRequiredLevel)));
        } else {
            player.sendMessage(this.getMessage((CommandSender)player, messageKey));
        }
    }

    private boolean isValidName(String name) {
        return name.matches("^[a-zA-Z\u0430-\u044f\u0410-\u042f0-9 _\\-!.]+$");
    }

    public boolean isPremiumAnimalHomeEnabled() {
        return false;
    }

    public Animals getAnimalFromMetadataPublic(Player player) {
        return this.getAnimalFromMetadata(player);
    }

    public void saveAnimalHomeDataPublic(UUID id) {
        this.saveAnimalData(id);
    }

    public void saveDataBaseSilentlyPublic() {
        this.saveDataBaseSilently();
    }

    public FileConfiguration getDataBasePublic() {
        return this.dataBase;
    }

    public AnimalHomeManager getAnimalHomeManager() {
        return this.animalHomeManager;
    }

    private void handleResourceCheckCommand(CommandSender sender) {
        long currentTime = System.currentTimeMillis();
        double timeSinceLastCheck = (double)(currentTime - this.lastResourceCheck) / 1000.0;
        if (this.lastResourceCheck == 0L || timeSinceLastCheck <= 0.0) {
            sender.sendMessage(ChatColor.GOLD + "[AnimalHunger] " + ChatColor.YELLOW + "Starting resource monitoring...");
            this.resetResourceStats();
            return;
        }
        double avgTicksPerSecond = (double)this.totalTicksProcessed / timeSinceLastCheck;
        double avgAnimalsPerTick = this.totalTicksProcessed > 0 ? (double)this.totalAnimalsProcessed / (double)this.totalTicksProcessed : 0.0;
        double avgSavesPerSecond = (double)this.totalDataSaves / timeSinceLastCheck;
        double avgGUIPerSecond = (double)this.totalGUIOpens / timeSinceLastCheck;
        sender.sendMessage(ChatColor.GOLD + "=== AnimalHunger Resource Usage (Interval: " + String.format("%.2f", timeSinceLastCheck) + "s) ===");
        sender.sendMessage(ChatColor.AQUA + "Active Animals in Cache: " + ChatColor.WHITE + this.animalDataCache.size());
        sender.sendMessage(ChatColor.AQUA + "Total Tick Tasks: " + ChatColor.WHITE + this.totalTicksProcessed);
        sender.sendMessage(ChatColor.AQUA + "Total Animals Processed (in ticks): " + ChatColor.WHITE + this.totalAnimalsProcessed);
        sender.sendMessage(ChatColor.AQUA + "Total Data Saves (to memory): " + ChatColor.WHITE + this.totalDataSaves);
        sender.sendMessage(ChatColor.AQUA + "Total GUI Opens: " + ChatColor.WHITE + this.totalGUIOpens);
        sender.sendMessage(ChatColor.GOLD + "--- Averages per second ---");
        sender.sendMessage(ChatColor.YELLOW + "Tick Tasks / sec: " + ChatColor.WHITE + String.format("%.2f", avgTicksPerSecond));
        sender.sendMessage(ChatColor.YELLOW + "Data Saves / sec: " + ChatColor.WHITE + String.format("%.2f", avgSavesPerSecond));
        sender.sendMessage(ChatColor.YELLOW + "GUI Opens / sec: " + ChatColor.WHITE + String.format("%.2f", avgGUIPerSecond));
        sender.sendMessage(ChatColor.GOLD + "--- Averages per tick task ---");
        sender.sendMessage(ChatColor.YELLOW + "Animals Processed / tick: " + ChatColor.WHITE + String.format("%.2f", avgAnimalsPerTick));
        this.resetResourceStats();
    }

    private void resetResourceStats() {
        this.totalTicksProcessed = 0;
        this.totalAnimalsProcessed = 0;
        this.totalDataSaves = 0;
        this.totalGUIOpens = 0;
        this.totalFeedingActions = 0;
        this.totalKillActions = 0;
        this.totalUpgradeActions = 0;
        this.totalCollectActions = 0;
        this.totalBondDecays = 0;
        this.totalAnimalDeaths = 0;
        this.totalAnimalBirths = 0;
        this.totalParticlesSpawned = 0;
        this.totalSoundsPlayed = 0;
        this.lastResourceCheck = System.currentTimeMillis();
    }

    private static class GUIItemConfig {
        final Material material;
        final String display;
        final List<String> lore;
        final int customModelData;
        final int positionSmall;
        final int positionMedium;
        final int positionLarge;

        GUIItemConfig(FileConfiguration config, String itemKey) {
            String path = "gui.items." + itemKey;
            this.material = Material.matchMaterial((String)config.getString(path + ".material", "STONE"));
            this.display = config.getString(path + ".display", itemKey);
            this.lore = config.getStringList(path + ".lore");
            this.customModelData = config.getInt(path + ".customModelData", 0);
            this.positionSmall = config.getInt(path + ".positions.small", -1);
            this.positionMedium = config.getInt(path + ".positions.medium", -1);
            this.positionLarge = config.getInt(path + ".positions.large", -1);
        }
    }

    private static class SecondPageItemConfig {
        final Material material;
        final int customModelData;
        final String display;
        final List<String> lore;
        final List<String> lorePremiumEnabled;
        final List<String> lorePremiumLocked;
        final boolean addGlowWhenPremium;
        final String loreResourceProduction;
        final String loreRareDrops;
        final String loreBonusResources;
        final String loreLocked;
        final int minBondToShow;

        SecondPageItemConfig(FileConfiguration config, String itemKey) {
            String path = "gui_second_page.items." + itemKey;
            String materialName = config.getString(path + ".material", "STONE");
            this.material = Material.matchMaterial((String)materialName);
            this.customModelData = config.getInt(path + ".customModelData", 0);
            this.display = config.getString(path + ".display", itemKey);
            this.lore = config.getStringList(path + ".lore");
            this.lorePremiumEnabled = config.getStringList(path + ".lore_premium_enabled");
            this.lorePremiumLocked = config.getStringList(path + ".lore_premium_locked");
            this.addGlowWhenPremium = config.getBoolean(path + ".add_glow_when_premium", false);
            this.loreResourceProduction = config.getString(path + ".lore_resource_production", "");
            this.loreRareDrops = config.getString(path + ".lore_rare_drops", "");
            this.loreBonusResources = config.getString(path + ".lore_bonus_resources", "");
            this.loreLocked = config.getString(path + ".lore_locked", "");
            this.minBondToShow = config.getInt(path + ".min_bond_to_show", 0);
        }
    }

    private static enum GUIAction {
        FEED,
        KILL,
        UPGRADE,
        COLLECT,
        RENAME,
        INFO,
        NAME_COLOR,
        UNKNOWN,
        PAGE2;

    }

    private static enum KillResult {
        SUCCESS,
        WRONG_TOOL,
        LEVEL_TOO_LOW;

    }
}

