/*
 * Decompiled with CFR 0.152.
 */
package animalhunger.animalhunger;

import animalhunger.animalhunger.PluginCompatibility;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class CustomDropManager {
    private static final Logger LOGGER = Logger.getLogger("AnimalHunger.CustomDrops");
    private final JavaPlugin plugin;
    private final PluginCompatibility compatibility;
    private final Random random = new Random();

    public CustomDropManager(JavaPlugin plugin, PluginCompatibility compatibility) {
        this.plugin = plugin;
        this.compatibility = compatibility;
        this.logInitialization();
        this.generateExampleConfig();
    }

    private void logInitialization() {
        LOGGER.info("CustomDropManager \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d");
        LOGGER.info("MMOItems \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0430: " + (this.compatibility.isMMOItemsEnabled() ? "\u0412\u043a\u043b\u044e\u0447\u0435\u043d\u0430" : "\u041e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430"));
        LOGGER.info("MythicMobs \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0430: " + (this.compatibility.isMythicMobsEnabled() ? "\u0412\u043a\u043b\u044e\u0447\u0435\u043d\u0430" : "\u041e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430"));
    }

    private void generateExampleConfig() {
        if (!this.plugin.getConfig().contains("custom_drops")) {
            LOGGER.info("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0440\u0438\u043c\u0435\u0440\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0445 \u0434\u0440\u043e\u043f\u043e\u0432...");
            String exampleConfig = this.generateConfigExample();
            LOGGER.info("\u0414\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0443\u044e \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e \u0432 \u0432\u0430\u0448 config.yml:\n\n" + exampleConfig);
        }
    }

    private String generateConfigExample() {
        StringBuilder example = new StringBuilder();
        example.append("# ========== \u041a\u041e\u041d\u0424\u0418\u0413\u0423\u0420\u0410\u0426\u0418\u042f \u041a\u0410\u0421\u0422\u041e\u041c\u041d\u042b\u0425 \u0414\u0420\u041e\u041f\u041e\u0412 ==========\n");
        example.append("custom_drops:\n");
        example.append("  # \u041f\u0440\u0438\u043c\u0435\u0440 \u0434\u043b\u044f \u043a\u043e\u0440\u043e\u0432\u044b\n");
        example.append("  cow:\n");
        example.append("    kill_drops:\n");
        example.append("      # MMOItems \u0434\u0440\u043e\u043f\n");
        example.append("      rare_meat:\n");
        example.append("        type: mmoitems\n");
        example.append("        mmo_type: CONSUMABLE  # \u0422\u0438\u043f MMOItems (SWORD, CONSUMABLE, etc.)\n");
        example.append("        mmo_id: GOLDEN_BEEF   # ID \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430 \u0432 MMOItems\n");
        example.append("        chance: 25.0          # \u0428\u0430\u043d\u0441 \u0432\u044b\u043f\u0430\u0434\u0435\u043d\u0438\u044f \u0432 \u043f\u0440\u043e\u0446\u0435\u043d\u0442\u0430\u0445\n");
        example.append("        amount: 1             # \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e\n");
        example.append("      # \u041e\u0431\u044b\u0447\u043d\u044b\u0439 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 Minecraft\n");
        example.append("      leather_bonus:\n");
        example.append("        type: vanilla\n");
        example.append("        material: LEATHER\n");
        example.append("        chance: 50.0\n");
        example.append("        amount: 2\n");
        example.append("        display_name: '&6\u041a\u0430\u0447\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0430\u044f \u043a\u043e\u0436\u0430'\n");
        example.append("        lore:\n");
        example.append("          - '&7\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u043e\u0442 \u0441\u0447\u0430\u0441\u0442\u043b\u0438\u0432\u043e\u0439 \u043a\u043e\u0440\u043e\u0432\u044b'\n");
        example.append("          - '&e\u0420\u0435\u0434\u043a\u0438\u0439 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b'\n");
        example.append("    resource_drops:\n");
        example.append("      # \u0414\u0440\u043e\u043f\u044b \u043f\u0440\u0438 \"\u0434\u043e\u0435\u043d\u0438\u0438\" \u0438\u043b\u0438 \u0434\u0440\u0443\u0433\u0438\u0445 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f\u0445\n");
        example.append("      special_milk:\n");
        example.append("        type: mmoitems\n");
        example.append("        mmo_type: CONSUMABLE\n");
        example.append("        mmo_id: SUPER_MILK\n");
        example.append("        chance: 15.0\n");
        example.append("        amount: 1\n");
        example.append("\n");
        example.append("  # \u041f\u0440\u0438\u043c\u0435\u0440 \u0434\u043b\u044f \u0441\u0432\u0438\u043d\u044c\u0438\n");
        example.append("  pig:\n");
        example.append("    kill_drops:\n");
        example.append("      golden_pork:\n");
        example.append("        type: mmoitems\n");
        example.append("        mmo_type: CONSUMABLE\n");
        example.append("        mmo_id: GOLDEN_PORK\n");
        example.append("        chance: 20.0\n");
        example.append("        amount: 1\n");
        example.append("\n");
        example.append("# \u0414\u043b\u044f MythicMobs \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 ID \u043c\u043e\u0431\u0430 \u0432\u043c\u0435\u0441\u0442\u043e \u0442\u0438\u043f\u0430 Bukkit\n");
        example.append("# \u041f\u0440\u0438\u043c\u0435\u0440:\n");
        example.append("  # special_cow:  # ID \u0432\u0430\u0448\u0435\u0433\u043e MythicMob\n");
        example.append("  #   kill_drops:\n");
        example.append("  #     mythic_beef:\n");
        example.append("  #       type: mmoitems\n");
        example.append("  #       mmo_type: CONSUMABLE\n");
        example.append("  #       mmo_id: MYTHIC_BEEF\n");
        example.append("  #       chance: 100.0\n");
        example.append("  #       amount: 3\n");
        return example.toString();
    }

    public ItemStack getCustomDrop(Animals animal, boolean isKillDrop) {
        if (this.compatibility == null) {
            return null;
        }
        try {
            ItemStack drop = this.compatibility.getCustomDrop(animal, isKillDrop);
            if (drop != null) {
                String animalType = this.getAnimalDisplayType(animal);
                String dropType = isKillDrop ? "\u0443\u0431\u0438\u0439\u0441\u0442\u0432\u0430" : "\u0440\u0435\u0441\u0443\u0440\u0441\u0430";
                this.logDebug("\u041a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0439 \u0434\u0440\u043e\u043f \u0434\u043b\u044f " + animalType + " (" + dropType + "): " + drop.getType() + " x" + drop.getAmount());
                if (this.isMMOItemsDrop(drop)) {
                    LOGGER.info("\u0423\u0441\u043f\u0435\u0448\u043d\u044b\u0439 \u0434\u0440\u043e\u043f MMOItems! \u0416\u0438\u0432\u043e\u0442\u043d\u043e\u0435: " + animalType + ", \u041f\u0440\u0435\u0434\u043c\u0435\u0442: " + this.getItemDisplayName(drop));
                }
                return drop;
            }
        }
        catch (Exception e) {
            LOGGER.severe("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u043e\u0433\u043e \u0434\u0440\u043e\u043f\u0430: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public boolean hasCustomDrops(Animals animal, boolean isKillDrop) {
        return this.compatibility != null && this.compatibility.hasCustomDrops(animal, isKillDrop);
    }

    public List<ItemStack> getPossibleDrops(Animals animal, boolean isKillDrop) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        String animalKey = this.getAnimalConfigKey(animal);
        String dropType = isKillDrop ? "kill_drops" : "resource_drops";
        ConfigurationSection dropsSection = this.plugin.getConfig().getConfigurationSection("custom_drops." + animalKey + "." + dropType);
        if (dropsSection == null) {
            return drops;
        }
        for (String dropKey : dropsSection.getKeys(false)) {
            ItemStack item;
            ConfigurationSection dropConfig = dropsSection.getConfigurationSection(dropKey);
            if (dropConfig == null || (item = this.parseDropForDisplay(dropConfig)) == null) continue;
            drops.add(item);
        }
        return drops;
    }

    private ItemStack parseDropForDisplay(ConfigurationSection config) {
        String type = config.getString("type", "vanilla").toLowerCase();
        int amount = config.getInt("amount", 1);
        double chance = config.getDouble("chance", 100.0);
        ItemStack item = null;
        if ("mmoitems".equals(type) || "mmoitem".equals(type)) {
            String mmoType = config.getString("mmo_type", "");
            String mmoId = config.getString("mmo_id", "");
            if (!mmoType.isEmpty() && !mmoId.isEmpty() && this.compatibility.isMMOItemsEnabled()) {
                item = this.compatibility.createMMOItem(mmoType, mmoId, amount);
            }
        } else if ("vanilla".equals(type)) {
            String material = config.getString("material", "STONE");
            try {
                Material mat = Material.valueOf((String)material.toUpperCase());
                item = new ItemStack(mat, amount);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warning("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b: " + material);
                return null;
            }
        }
        if (item != null) {
            this.addChanceToLore(item, chance);
        }
        return item;
    }

    private void addChanceToLore(ItemStack item, double chance) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            ArrayList<String> lore = meta.getLore();
            if (lore == null) {
                lore = new ArrayList<String>();
            }
            lore.add("");
            lore.add("\u00a77\u0428\u0430\u043d\u0441 \u0432\u044b\u043f\u0430\u0434\u0435\u043d\u0438\u044f: \u00a7e" + String.format("%.1f", chance) + "%");
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
    }

    public List<ItemStack> getDropsFromList(List<ItemStack> possibleDrops, int maxDrops) {
        ItemStack randomDrop;
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (possibleDrops.isEmpty() || maxDrops <= 0) {
            return result;
        }
        if (!possibleDrops.isEmpty() && (randomDrop = possibleDrops.get(this.random.nextInt(possibleDrops.size()))) != null) {
            result.add(randomDrop.clone());
        }
        return result;
    }

    private String getAnimalConfigKey(Animals animal) {
        String mythicType;
        if (this.compatibility.isMythicMobsEnabled() && this.compatibility.isMythicMob((Entity)animal) && (mythicType = this.compatibility.getMythicMobType((Entity)animal)) != null) {
            return mythicType.toLowerCase();
        }
        return animal.getType().name().toLowerCase();
    }

    private String getAnimalDisplayType(Animals animal) {
        String mythicName;
        if (this.compatibility.isMythicMobsEnabled() && this.compatibility.isMythicMob((Entity)animal) && (mythicName = this.compatibility.getMythicMobDisplayName((Entity)animal)) != null) {
            return mythicName;
        }
        return animal.getType().name().toLowerCase();
    }

    private boolean isMMOItemsDrop(ItemStack item) {
        if (!this.compatibility.isMMOItemsEnabled() || item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta.hasDisplayName()) {
            String displayName = meta.getDisplayName();
            return displayName.contains("\u00a7") && meta.hasLore();
        }
        return false;
    }

    private String getItemDisplayName(ItemStack item) {
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
            return item.getItemMeta().getDisplayName();
        }
        return item.getType().name();
    }

    public String getDropInfo(Animals animal, boolean isKillDrop) {
        StringBuilder info = new StringBuilder();
        if (!this.hasCustomDrops(animal, isKillDrop)) {
            info.append("\u00a77\u041a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0435 \u0434\u0440\u043e\u043f\u044b \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u044b");
            return info.toString();
        }
        List<ItemStack> possibleDrops = this.getPossibleDrops(animal, isKillDrop);
        if (possibleDrops.isEmpty()) {
            info.append("\u00a77\u0414\u0440\u043e\u043f\u044b \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u044b, \u043d\u043e \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b");
            return info.toString();
        }
        info.append("\u00a7a\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0435 \u0434\u0440\u043e\u043f\u044b:\n");
        int mmoItemsCount = 0;
        int vanillaCount = 0;
        for (ItemStack drop : possibleDrops) {
            if (this.isMMOItemsDrop(drop)) {
                ++mmoItemsCount;
                continue;
            }
            ++vanillaCount;
        }
        if (mmoItemsCount > 0) {
            info.append("\u00a76MMOItems \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432: \u00a7e").append(mmoItemsCount).append("\n");
        }
        if (vanillaCount > 0) {
            info.append("\u00a77\u041e\u0431\u044b\u0447\u043d\u044b\u0445 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432: \u00a7e").append(vanillaCount).append("\n");
        }
        info.append("\u00a77\u0412\u0441\u0435\u0433\u043e: \u00a7e").append(possibleDrops.size()).append(" \u00a77\u0442\u0438\u043f\u043e\u0432 \u0434\u0440\u043e\u043f\u043e\u0432");
        return info.toString();
    }

    public ItemStack giveMMOItem(String type, String id, int amount) {
        if (!this.compatibility.isMMOItemsEnabled()) {
            return null;
        }
        ItemStack item = this.compatibility.createMMOItem(type, id, amount);
        if (item != null) {
            LOGGER.info("\u0421\u043e\u0437\u0434\u0430\u043d MMOItems \u043f\u0440\u0435\u0434\u043c\u0435\u0442: " + type + ":" + id + " x" + amount);
        }
        return item;
    }

    private void logDebug(String message) {
        if (this.plugin.getConfig().getBoolean("debug", false)) {
            LOGGER.info("[DEBUG] " + message);
        }
    }

    public boolean isMMOItemsSupportEnabled() {
        return this.compatibility.isMMOItemsEnabled();
    }

    public boolean isMythicMobsSupportEnabled() {
        return this.compatibility.isMythicMobsEnabled();
    }
}

