/*
 * Decompiled with CFR 0.152.
 */
package animalhunger.animalhunger;

import animalhunger.animalhunger.AnimalData;
import animalhunger.animalhunger.AnimalHunger;
import animalhunger.animalhunger.CustomDropManager;
import java.util.Random;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.entity.Animals;
import org.bukkit.inventory.ItemStack;

public class DropChanceHandler {
    private static final Logger LOGGER = Logger.getLogger("AnimalHunger.DropChanceHandler");
    private final AnimalHunger plugin;
    private final Random random = new Random();

    public DropChanceHandler(AnimalHunger plugin) {
        this.plugin = plugin;
    }

    public ItemStack getDrop(Animals animal, AnimalData data, boolean fromMenu) {
        int rareDropThreshold;
        String animalType = animal.getType().name().toLowerCase();
        this.plugin.logDebug("=== \u041e\u041f\u0420\u0415\u0414\u0415\u041b\u0415\u041d\u0418\u0415 \u0414\u0420\u041e\u041f\u0410 ===");
        this.plugin.logDebug("\u0416\u0438\u0432\u043e\u0442\u043d\u043e\u0435: " + animalType + ", \u0418\u0437 \u043c\u0435\u043d\u044e: " + fromMenu);
        this.plugin.logDebug("\u0414\u0430\u043d\u043d\u044b\u0435: " + (String)(data != null ? "\u0423\u0440\u043e\u0432\u0435\u043d\u044c=" + data.getLevel() + ", \u0421\u0432\u044f\u0437\u044c=" + data.getBondLevel() : "NULL"));
        int requiredLevel = this.plugin.getConfig().getInt("kill.required-level", 2);
        if (data == null || data.getLevel() < requiredLevel) {
            this.plugin.logDebug("\u0423\u0440\u043e\u0432\u0435\u043d\u044c \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043d\u0438\u0437\u043a\u0438\u0439 (" + (data != null ? data.getLevel() : 0) + " < " + requiredLevel + ") - \u043c\u0443\u0441\u043e\u0440\u043d\u044b\u0439 \u0434\u0440\u043e\u043f");
            return this.getGarbageDrop(animal);
        }
        CustomDropManager customDropManager = this.plugin.getCustomDropManager();
        if (customDropManager != null && customDropManager.hasCustomDrops(animal, true)) {
            this.plugin.logDebug("\u041d\u0430\u0439\u0434\u0435\u043d\u044b \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0435 \u0434\u0440\u043e\u043f\u044b \u0434\u043b\u044f " + animalType);
            ItemStack customDrop = customDropManager.getCustomDrop(animal, true);
            if (customDrop != null) {
                this.plugin.logDebug("\u0423\u0441\u043f\u0435\u0448\u043d\u044b\u0439 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0439 \u0434\u0440\u043e\u043f: " + customDrop.getType() + " x" + customDrop.getAmount());
                return customDrop;
            }
            this.plugin.logDebug("\u041a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0435 \u0434\u0440\u043e\u043f\u044b \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u044b, \u043d\u043e \u043d\u0438\u0447\u0435\u0433\u043e \u043d\u0435 \u0432\u044b\u043f\u0430\u043b\u043e (\u0448\u0430\u043d\u0441\u044b \u043d\u0435 \u043f\u0440\u043e\u0448\u043b\u0438)");
        }
        this.plugin.logDebug("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u0443\u044e \u043b\u043e\u0433\u0438\u043a\u0443 AnimalHunger");
        double generalDropChance = this.plugin.getConfig().getDouble("kill.drop-chance", 1.0);
        if (fromMenu && this.random.nextDouble() > generalDropChance) {
            this.plugin.logDebug("\u041e\u0431\u0449\u0438\u0439 \u0448\u0430\u043d\u0441 \u0434\u0440\u043e\u043f\u0430 \u043d\u0435 \u043f\u0440\u043e\u0448\u0435\u043b (" + generalDropChance * 100.0 + "%) - \u043c\u0443\u0441\u043e\u0440\u043d\u044b\u0439 \u0434\u0440\u043e\u043f");
            return this.getGarbageDrop(animal);
        }
        int bondLevel = data.getBondLevel();
        boolean shouldGetRareDrop = bondLevel >= (rareDropThreshold = this.plugin.getConfig().getInt("bond.thresholds.rare-drops", 75));
        this.plugin.logDebug("\u0421\u0432\u044f\u0437\u044c: " + bondLevel + "%, \u043f\u043e\u0440\u043e\u0433 \u0440\u0435\u0434\u043a\u0438\u0445: " + rareDropThreshold + "%, \u0440\u0435\u0434\u043a\u0438\u0439 \u0434\u0440\u043e\u043f: " + shouldGetRareDrop);
        int level = data.getLevel();
        double chance = this.random.nextDouble() * 100.0;
        double cumulative = 0.0;
        for (int i = 1; i <= 5; ++i) {
            double levelChance = this.plugin.getConfig().getDouble("drop.chances." + i, 0.0);
            this.plugin.logDebug("\u0423\u0440\u043e\u0432\u0435\u043d\u044c " + i + ": \u0448\u0430\u043d\u0441=" + levelChance + "%, \u043d\u0430\u043a\u043e\u043f\u0438\u0442\u0435\u043b\u044c\u043d\u043e=" + (cumulative += levelChance) + "%, \u0432\u044b\u043f\u0430\u043b\u043e=" + String.format("%.1f", chance));
            if (level < i || !(chance <= cumulative)) continue;
            ItemStack selectedDrop = shouldGetRareDrop ? this.getRareDrop(animal, data) : this.getStandardDrop(animal);
            this.plugin.logDebug("\u0412\u044b\u0431\u0440\u0430\u043d \u0434\u0440\u043e\u043f \u0443\u0440\u043e\u0432\u043d\u044f " + i + ": " + selectedDrop.getType() + " (\u0440\u0435\u0434\u043a\u0438\u0439: " + shouldGetRareDrop + ")");
            return selectedDrop;
        }
        ItemStack fallbackDrop = this.getStandardDrop(animal);
        this.plugin.logDebug("Fallback \u0434\u0440\u043e\u043f: " + fallbackDrop.getType());
        return fallbackDrop;
    }

    private ItemStack getGarbageDrop(Animals animal) {
        String animalType = animal.getType().name().toLowerCase();
        String garbageItem = this.plugin.getConfig().getString("kill.garbage_drops." + animalType, "DIRT");
        int amount = 1 + this.random.nextInt(2);
        Material material = this.getMaterialSafely(garbageItem);
        ItemStack drop = new ItemStack(material, amount);
        this.plugin.logDebug("\u041c\u0443\u0441\u043e\u0440\u043d\u044b\u0439 \u0434\u0440\u043e\u043f \u0434\u043b\u044f " + animalType + ": " + material + " x" + amount);
        return drop;
    }

    private ItemStack getRareDrop(Animals animal, AnimalData data) {
        String animalType = animal.getType().name().toLowerCase();
        String rareItem = this.plugin.getConfig().getString("kill.rare_drops." + animalType, "DIAMOND");
        int bondLevel = data.getBondLevel();
        int bonus = Math.max(0, (bondLevel - 74) / 5);
        int amount = 1 + bonus + this.random.nextInt(2);
        Material material = this.getMaterialSafely(rareItem);
        ItemStack drop = new ItemStack(material, amount);
        this.plugin.logDebug("\u0420\u0435\u0434\u043a\u0438\u0439 \u0434\u0440\u043e\u043f \u0434\u043b\u044f " + animalType + ": " + material + " x" + amount + " (\u0431\u043e\u043d\u0443\u0441 \u0441\u0432\u044f\u0437\u0438: +" + bonus + ")");
        return drop;
    }

    private ItemStack getStandardDrop(Animals animal) {
        String animalType = animal.getType().name().toLowerCase();
        String standardItem = this.plugin.getConfig().getString("kill.standard_drops." + animalType, "LEATHER");
        int amount = 1 + this.random.nextInt(2);
        Material material = this.getMaterialSafely(standardItem);
        ItemStack drop = new ItemStack(material, amount);
        this.plugin.logDebug("\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0439 \u0434\u0440\u043e\u043f \u0434\u043b\u044f " + animalType + ": " + material + " x" + amount);
        return drop;
    }

    private Material getMaterialSafely(String materialName) {
        try {
            Material material = Material.getMaterial((String)materialName.toUpperCase());
            if (material == null || !material.isItem()) {
                this.plugin.getLogger().warning("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0435: " + materialName + ", \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c DIRT");
                return Material.DIRT;
            }
            return material;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0430 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u0430 " + materialName + ": " + e.getMessage());
            return Material.DIRT;
        }
    }

    public String getDropInfo(Animals animal, AnimalData data) {
        StringBuilder info = new StringBuilder();
        if (data == null) {
            return "\u00a7c\u0414\u0430\u043d\u043d\u044b\u0435 \u0436\u0438\u0432\u043e\u0442\u043d\u043e\u0433\u043e \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b";
        }
        String animalType = animal.getType().name().toLowerCase();
        int requiredLevel = this.plugin.getConfig().getInt("kill.required-level", 2);
        if (data.getLevel() < requiredLevel) {
            info.append("\u00a7e\u0423\u0440\u043e\u0432\u0435\u043d\u044c \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043d\u0438\u0437\u043a\u0438\u0439 \u0434\u043b\u044f \u0445\u043e\u0440\u043e\u0448\u0438\u0445 \u0434\u0440\u043e\u043f\u043e\u0432\n");
            info.append("\u00a77\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f: \u00a7e").append(requiredLevel);
            info.append("\u00a77, \u0422\u0435\u043a\u0443\u0449\u0438\u0439: \u00a7e").append(data.getLevel()).append("\n");
            info.append("\u00a77\u0411\u0443\u0434\u0443\u0442 \u0432\u044b\u043f\u0430\u0434\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043c\u0443\u0441\u043e\u0440\u043d\u044b\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b");
            return info.toString();
        }
        CustomDropManager customDropManager = this.plugin.getCustomDropManager();
        if (customDropManager != null && customDropManager.hasCustomDrops(animal, true)) {
            info.append("\u00a7a\u2713 \u041d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u044b \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0435 \u0434\u0440\u043e\u043f\u044b\n");
            String customInfo = customDropManager.getDropInfo(animal, true);
            if (!customInfo.isEmpty()) {
                info.append(customInfo).append("\n");
            }
            info.append("\u00a77\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442: \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0435 \u2192 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0435\n");
        } else {
            info.append("\u00a77\u041a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0435 \u0434\u0440\u043e\u043f\u044b \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u044b\n");
            info.append("\u00a77\u0411\u0443\u0434\u0443\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u044b \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0435 \u0434\u0440\u043e\u043f\u044b\n");
        }
        int bondLevel = data.getBondLevel();
        int rareThreshold = this.plugin.getConfig().getInt("bond.thresholds.rare-drops", 75);
        if (bondLevel >= rareThreshold) {
            info.append("\u00a7d\u2713 \u0412\u044b\u0441\u043e\u043a\u0430\u044f \u0441\u0432\u044f\u0437\u044c - \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b \u0440\u0435\u0434\u043a\u0438\u0435 \u0434\u0440\u043e\u043f\u044b!\n");
            info.append("\u00a77\u0411\u043e\u043d\u0443\u0441 \u0441\u0432\u044f\u0437\u0438: \u00a7e+").append((bondLevel - 74) / 5).append(" \u00a77\u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432");
        } else {
            info.append("\u00a77\u0421\u0432\u044f\u0437\u044c: \u00a7e").append(bondLevel).append("%");
            info.append("\u00a77, \u0434\u043e \u0440\u0435\u0434\u043a\u0438\u0445 \u0434\u0440\u043e\u043f\u043e\u0432: \u00a7e").append(rareThreshold - bondLevel).append("%");
        }
        return info.toString();
    }

    public String getDropTypeInfo(Animals animal, AnimalData data) {
        int rareThreshold;
        if (data == null) {
            return "\u043c\u0443\u0441\u043e\u0440\u043d\u044b\u0439 (\u043d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445)";
        }
        int requiredLevel = this.plugin.getConfig().getInt("kill.required-level", 2);
        if (data.getLevel() < requiredLevel) {
            return "\u043c\u0443\u0441\u043e\u0440\u043d\u044b\u0439 (\u043d\u0438\u0437\u043a\u0438\u0439 \u0443\u0440\u043e\u0432\u0435\u043d\u044c)";
        }
        CustomDropManager customDropManager = this.plugin.getCustomDropManager();
        if (customDropManager != null && customDropManager.hasCustomDrops(animal, true)) {
            return "\u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0439";
        }
        int bondLevel = data.getBondLevel();
        return bondLevel >= (rareThreshold = this.plugin.getConfig().getInt("bond.thresholds.rare-drops", 75)) ? "\u0440\u0435\u0434\u043a\u0438\u0439" : "\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0439";
    }

    public boolean canDropGoodItems(AnimalData data) {
        if (data == null) {
            return false;
        }
        int requiredLevel = this.plugin.getConfig().getInt("kill.required-level", 2);
        return data.getLevel() >= requiredLevel;
    }

    public double getDropChanceForLevel(int level) {
        double totalChance = 0.0;
        for (int i = 1; i <= Math.min(level, 5); ++i) {
            totalChance += this.plugin.getConfig().getDouble("drop.chances." + i, 0.0);
        }
        return Math.min(totalChance, 100.0);
    }
}

