/*
 * Decompiled with CFR 0.152.
 */
package animalhunger.animalhunger;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Logger;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PluginCompatibility {
    private static final Logger LOGGER = Logger.getLogger("AnimalHunger.Compatibility");
    private final JavaPlugin plugin;
    private final Random random = new Random();
    private boolean isMythicMobsEnabled = false;
    private MythicBukkit mythicBukkit = null;
    private boolean isMMOItemsEnabled = false;
    private MMOItems mmoItems = null;

    public PluginCompatibility(JavaPlugin plugin) {
        this.plugin = plugin;
        this.initializeCompatibility();
    }

    private void initializeCompatibility() {
        this.initializeMythicMobs();
        this.initializeMMOItems();
        this.createExampleConfig();
    }

    private void initializeMythicMobs() {
        Plugin mythicPlugin = Bukkit.getPluginManager().getPlugin("MythicMobs");
        if (mythicPlugin != null && mythicPlugin.isEnabled()) {
            try {
                this.mythicBukkit = MythicBukkit.inst();
                if (this.mythicBukkit != null) {
                    this.isMythicMobsEnabled = true;
                    LOGGER.info("MythicMobs \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0430 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430 (\u0432\u0435\u0440\u0441\u0438\u044f " + mythicPlugin.getDescription().getVersion() + ")");
                }
            }
            catch (Exception e) {
                LOGGER.warning("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a MythicMobs: " + e.getMessage());
                this.isMythicMobsEnabled = false;
            }
        } else {
            LOGGER.info("MythicMobs \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
    }

    private void initializeMMOItems() {
        block7: {
            Plugin mmoPlugin = Bukkit.getPluginManager().getPlugin("MMOItems");
            if (mmoPlugin != null && mmoPlugin.isEnabled()) {
                try {
                    Class.forName("net.Indyuce.mmoitems.MMOItems");
                    Class.forName("net.Indyuce.mmoitems.api.Type");
                    Class.forName("net.Indyuce.mmoitems.api.item.mmoitem.MMOItem");
                    this.mmoItems = MMOItems.plugin;
                    if (this.mmoItems != null && this.mmoItems.getItems() != null) {
                        this.isMMOItemsEnabled = true;
                        LOGGER.info("MMOItems \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0430 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430 (\u0432\u0435\u0440\u0441\u0438\u044f " + mmoPlugin.getDescription().getVersion() + ")");
                        if (this.plugin.getConfig().getBoolean("debug", false)) {
                            this.mmoItems.getTypes().getAll().forEach(type -> LOGGER.info("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0439 \u0442\u0438\u043f MMOItems: " + type.getId()));
                        }
                        break block7;
                    }
                    LOGGER.warning("MMOItems \u043d\u0430\u0439\u0434\u0435\u043d, \u043d\u043e API \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d");
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    LOGGER.warning("MMOItems \u043d\u0430\u0439\u0434\u0435\u043d, \u043d\u043e \u0432\u0435\u0440\u0441\u0438\u044f \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0430: " + e.getMessage());
                    this.isMMOItemsEnabled = false;
                }
                catch (Exception e) {
                    LOGGER.severe("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 MMOItems: " + e.getMessage());
                    this.isMMOItemsEnabled = false;
                }
            } else {
                LOGGER.info("MMOItems \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
        }
    }

    private void createExampleConfig() {
        if (!this.plugin.getConfig().contains("custom_drops")) {
            this.plugin.getLogger().info("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0440\u0438\u043c\u0435\u0440\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0434\u043b\u044f MMOItems \u0434\u0440\u043e\u043f\u043e\u0432...");
            this.plugin.getConfig().set("custom_drops.example_info", (Object)"\u0421\u043a\u043e\u043f\u0438\u0440\u0443\u0439\u0442\u0435 \u0438 \u0430\u0434\u0430\u043f\u0442\u0438\u0440\u0443\u0439\u0442\u0435 \u043f\u0440\u0438\u043c\u0435\u0440\u044b \u043d\u0438\u0436\u0435 \u0432 \u0432\u0430\u0448 config.yml");
            this.plugin.getConfig().set("custom_drops.cow.kill_drops.rare_meat.type", (Object)"mmoitems");
            this.plugin.getConfig().set("custom_drops.cow.kill_drops.rare_meat.mmo_type", (Object)"CONSUMABLE");
            this.plugin.getConfig().set("custom_drops.cow.kill_drops.rare_meat.mmo_id", (Object)"GOLDEN_BEEF");
            this.plugin.getConfig().set("custom_drops.cow.kill_drops.rare_meat.chance", (Object)15.0);
            this.plugin.getConfig().set("custom_drops.cow.kill_drops.rare_meat.amount", (Object)1);
        }
    }

    public boolean isMythicMob(Entity entity) {
        if (!this.isMythicMobsEnabled || this.mythicBukkit == null || !(entity instanceof LivingEntity)) {
            return false;
        }
        try {
            return this.mythicBukkit.getMobManager().isActiveMob(entity.getUniqueId());
        }
        catch (Exception e) {
            this.logDebug("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 MythicMob: " + e.getMessage());
            return false;
        }
    }

    public String getMythicMobType(Entity entity) {
        if (!this.isMythicMobsEnabled || this.mythicBukkit == null || !(entity instanceof LivingEntity)) {
            return null;
        }
        try {
            ActiveMob activeMob = this.mythicBukkit.getMobManager().getMythicMobInstance((Entity)((LivingEntity)entity));
            return activeMob != null ? activeMob.getMobType() : null;
        }
        catch (Exception e) {
            this.logDebug("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0442\u0438\u043f\u0430 MythicMob: " + e.getMessage());
            return null;
        }
    }

    public String getMythicMobDisplayName(Entity entity) {
        String mythicType = this.getMythicMobType(entity);
        if (mythicType != null) {
            String configName = this.plugin.getConfig().getString("animals." + mythicType.toLowerCase() + ".display_name");
            if (configName != null && !configName.isEmpty()) {
                return configName;
            }
            return mythicType;
        }
        return null;
    }

    public ItemStack createMMOItem(String typeStr, String id, int amount) {
        if (!this.isMMOItemsEnabled || this.mmoItems == null) {
            LOGGER.warning("MMOItems \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0434\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430 " + typeStr + ":" + id);
            return null;
        }
        try {
            Type type = this.mmoItems.getTypes().get(typeStr.toUpperCase());
            if (type == null) {
                LOGGER.warning("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f MMOItems: " + typeStr);
                this.logAvailableTypes();
                return null;
            }
            MMOItem mmoItem = this.mmoItems.getItems().getMMOItem(type, id);
            if (mmoItem == null) {
                LOGGER.warning("\u041f\u0440\u0435\u0434\u043c\u0435\u0442 MMOItems \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: " + typeStr + ":" + id);
                this.logAvailableItems(type);
                return null;
            }
            ItemStack itemStack = mmoItem.newBuilder().build();
            if (itemStack != null && itemStack.getType() != Material.AIR) {
                itemStack.setAmount(amount);
                this.logDebug("\u0421\u043e\u0437\u0434\u0430\u043d \u043f\u0440\u0435\u0434\u043c\u0435\u0442 MMOItems: " + typeStr + ":" + id + " x" + amount);
                return itemStack;
            }
            LOGGER.warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c ItemStack \u0434\u043b\u044f " + typeStr + ":" + id);
            return null;
        }
        catch (Exception e) {
            LOGGER.severe("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f MMOItems \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430 " + typeStr + ":" + id + ": " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public boolean mmoItemExists(String typeStr, String id) {
        if (!this.isMMOItemsEnabled || this.mmoItems == null) {
            return false;
        }
        try {
            Type type = this.mmoItems.getTypes().get(typeStr.toUpperCase());
            if (type == null) {
                return false;
            }
            MMOItem mmoItem = this.mmoItems.getItems().getMMOItem(type, id);
            return mmoItem != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public ItemStack getCustomDrop(Animals animal, boolean isKillDrop) {
        String animalKey = this.getAnimalConfigKey(animal);
        String dropType = isKillDrop ? "kill_drops" : "resource_drops";
        ConfigurationSection dropsSection = this.plugin.getConfig().getConfigurationSection("custom_drops." + animalKey + "." + dropType);
        if (dropsSection == null) {
            return null;
        }
        ArrayList<DropInfo> possibleDrops = new ArrayList<DropInfo>();
        for (String dropKey : dropsSection.getKeys(false)) {
            DropInfo dropInfo;
            ConfigurationSection dropConfig = dropsSection.getConfigurationSection(dropKey);
            if (dropConfig == null || (dropInfo = this.parseDropConfig(dropConfig, dropKey)) == null) continue;
            possibleDrops.add(dropInfo);
        }
        return this.selectRandomDrop(possibleDrops);
    }

    private DropInfo parseDropConfig(ConfigurationSection config, String dropKey) {
        String type = config.getString("type", "vanilla").toLowerCase();
        double chance = config.getDouble("chance", 100.0);
        int amount = config.getInt("amount", 1);
        ItemStack item = null;
        switch (type) {
            case "vanilla": {
                String material = config.getString("material", "STONE");
                try {
                    ItemMeta meta;
                    Material mat = Material.valueOf((String)material.toUpperCase());
                    item = new ItemStack(mat, amount);
                    String displayName = config.getString("display_name");
                    List lore = config.getStringList("lore");
                    if (displayName == null && lore.isEmpty() || (meta = item.getItemMeta()) == null) break;
                    if (displayName != null) {
                        meta.setDisplayName(this.colorize(displayName));
                    }
                    if (!lore.isEmpty()) {
                        ArrayList coloredLore = new ArrayList();
                        lore.forEach(line -> coloredLore.add(this.colorize((String)line)));
                        meta.setLore(coloredLore);
                    }
                    item.setItemMeta(meta);
                    break;
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warning("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438: " + material + " (\u0434\u0440\u043e\u043f: " + dropKey + ")");
                    return null;
                }
            }
            case "mmoitems": 
            case "mmoitem": {
                if (!this.isMMOItemsEnabled) {
                    LOGGER.warning("MMOItems \u0434\u0440\u043e\u043f \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d, \u043d\u043e \u043f\u043b\u0430\u0433\u0438\u043d \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d: " + dropKey);
                    return null;
                }
                String mmoType = config.getString("mmo_type", "");
                String mmoId = config.getString("mmo_id", "");
                if (mmoType.isEmpty() || mmoId.isEmpty()) {
                    LOGGER.warning("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f MMOItems \u0434\u0440\u043e\u043f\u0430: " + dropKey + " (\u043d\u0443\u0436\u043d\u044b mmo_type \u0438 mmo_id)");
                    return null;
                }
                item = this.createMMOItem(mmoType, mmoId, amount);
                if (item != null) break;
                LOGGER.warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c MMOItems \u043f\u0440\u0435\u0434\u043c\u0435\u0442: " + mmoType + ":" + mmoId);
                return null;
            }
            default: {
                LOGGER.warning("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0434\u0440\u043e\u043f\u0430: " + type + " (\u0434\u0440\u043e\u043f: " + dropKey + ")");
                return null;
            }
        }
        if (item != null) {
            this.logDebug("\u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d \u0434\u0440\u043e\u043f: " + dropKey + " (" + type + ") \u0441 \u0448\u0430\u043d\u0441\u043e\u043c " + chance + "%");
            return new DropInfo(item, chance);
        }
        return null;
    }

    private ItemStack selectRandomDrop(List<DropInfo> drops) {
        if (drops.isEmpty()) {
            return null;
        }
        for (DropInfo drop : drops) {
            double roll = ThreadLocalRandom.current().nextDouble(0.0, 100.0);
            if (!(roll < drop.chance)) continue;
            this.logDebug("\u0414\u0440\u043e\u043f \u0432\u044b\u0431\u0440\u0430\u043d: " + drop.item.getType() + " (\u0448\u0430\u043d\u0441: " + drop.chance + "%, \u0432\u044b\u043f\u0430\u043b\u043e: " + String.format("%.1f", roll) + "%)");
            return drop.item.clone();
        }
        this.logDebug("\u041d\u0438 \u043e\u0434\u0438\u043d \u0434\u0440\u043e\u043f \u043d\u0435 \u0432\u044b\u043f\u0430\u043b \u0438\u0437 " + drops.size() + " \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0445");
        return null;
    }

    private String getAnimalConfigKey(Animals animal) {
        String mythicType;
        if (this.isMythicMob((Entity)animal) && (mythicType = this.getMythicMobType((Entity)animal)) != null) {
            return mythicType.toLowerCase();
        }
        return animal.getType().name().toLowerCase();
    }

    public boolean hasCustomDrops(Animals animal, boolean isKillDrop) {
        String animalKey = this.getAnimalConfigKey(animal);
        String dropType = isKillDrop ? "kill_drops" : "resource_drops";
        return this.plugin.getConfig().getConfigurationSection("custom_drops." + animalKey + "." + dropType) != null;
    }

    private String colorize(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    private void logAvailableTypes() {
        if (this.isMMOItemsEnabled && this.mmoItems != null) {
            LOGGER.info("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u0442\u0438\u043f\u044b MMOItems:");
            this.mmoItems.getTypes().getAll().forEach(type -> LOGGER.info("- " + type.getId()));
        }
    }

    private void logAvailableItems(Type type) {
        if (this.isMMOItemsEnabled && this.mmoItems != null) {
            LOGGER.info("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b \u0442\u0438\u043f\u0430 " + type.getId() + ":");
            try {
                LOGGER.info("Legacy MMOItems detected; please update to use getAll()");
            }
            catch (Exception e) {
                LOGGER.warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432: " + e.getMessage());
            }
        }
    }

    public boolean isSupportedEntity(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof Animals) {
            String animalType = entity.getType().name().toLowerCase();
            return this.plugin.getConfig().contains("animals." + animalType);
        }
        if (this.isMythicMobsEnabled && this.mythicBukkit != null) {
            try {
                return this.mythicBukkit.getMobManager().isActiveMob(entity.getUniqueId());
            }
            catch (Exception e) {
                this.logDebug("Error checking MythicMob: " + e.getMessage());
                return false;
            }
        }
        return false;
    }

    public String getEntityDisplayName(Entity entity) {
        if (entity == null) {
            return "Unknown";
        }
        if (this.isMythicMobsEnabled && this.mythicBukkit != null && entity instanceof LivingEntity) {
            try {
                ActiveMob activeMob = this.mythicBukkit.getMobManager().getMythicMobInstance((Entity)((LivingEntity)entity));
                if (activeMob != null) {
                    String configName = this.plugin.getConfig().getString("animals." + activeMob.getMobType().toLowerCase() + ".display_name");
                    return configName != null && !configName.isEmpty() ? this.colorize(configName) : activeMob.getMobType();
                }
            }
            catch (Exception e) {
                this.logDebug("Error getting MythicMob display name: " + e.getMessage());
            }
        }
        if (entity instanceof Animals) {
            String animalType = entity.getType().name().toLowerCase();
            String configName = this.plugin.getConfig().getString("animals." + animalType + ".display_name");
            return configName != null && !configName.isEmpty() ? this.colorize(configName) : animalType;
        }
        return entity.getType().name().toLowerCase();
    }

    public boolean isValidFeedItem(ItemStack item, List<String> feedItems) {
        if (item == null || item.getType() == Material.AIR || feedItems == null || feedItems.isEmpty()) {
            return false;
        }
        String itemMaterial = item.getType().name().toUpperCase();
        if (feedItems.contains(itemMaterial)) {
            return true;
        }
        if (this.isMMOItemsEnabled && this.mmoItems != null) {
            try {
                for (String feedItem : feedItems) {
                    ItemStack mmoItemStack;
                    String[] parts;
                    if (!feedItem.startsWith("mmoitems:") || (parts = feedItem.split(":")).length != 3) continue;
                    String mmoType = parts[1].toUpperCase();
                    String mmoId = parts[2];
                    MMOItem mmoItem = this.mmoItems.getItems().getMMOItem(this.mmoItems.getTypes().get(mmoType), mmoId);
                    if (mmoItem == null || (mmoItemStack = mmoItem.newBuilder().build()) == null || !mmoItemStack.isSimilar(item)) continue;
                    return true;
                }
            }
            catch (Exception e) {
                this.logDebug("Error checking MMOItems feed item: " + e.getMessage());
            }
        }
        return false;
    }

    private void logDebug(String message) {
        if (this.plugin.getConfig().getBoolean("debug", false)) {
            LOGGER.info("[DEBUG] " + message);
        }
    }

    public boolean isMythicMobsEnabled() {
        return this.isMythicMobsEnabled;
    }

    public boolean isMMOItemsEnabled() {
        return this.isMMOItemsEnabled;
    }

    private static class DropInfo {
        final ItemStack item;
        final double chance;

        DropInfo(ItemStack item, double chance) {
            this.item = item;
            this.chance = chance;
        }
    }
}

