/*
 * Decompiled with CFR 0.152.
 */
package animalhunger.animalhunger;

import animalhunger.animalhunger.AnimalData;
import animalhunger.animalhunger.AnimalHungerCrutch;
import animalhunger.animalhunger.AnimalHungerExpansion;
import animalhunger.animalhunger.DropChanceHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AnimalHunger
extends JavaPlugin
implements Listener {
    private static final Logger LOGGER = Logger.getLogger("AnimalHunger");
    private final Map<UUID, AnimalData> animalDataCache = new ConcurrentHashMap<UUID, AnimalData>();
    private int nextAnimalId;
    private final Map<Integer, UUID> animalIdMap = new HashMap<Integer, UUID>();
    private FileConfiguration config;
    private FileConfiguration messages;
    private FileConfiguration dataBase;
    private File dataBaseFile;
    private AnimalHungerCrutch crutch;
    private DropChanceHandler dropHandler;
    private int hungerDecreaseInterval;
    private int hungerRestoreAmount;
    private Material feedItem;
    private Material upgradeItem = Material.GOLDEN_CARROT;
    private int upgradeCost = 3;
    private int maxHungerCap;
    private String language;
    private final Random random = new Random();
    private boolean enableParticles;
    private boolean debug;

    public Map<Integer, UUID> getAnimalIdMap() {
        return this.animalIdMap;
    }

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.loadMessages();
        this.setupDataBase();
        this.loadAllAnimalData();
        this.crutch = new AnimalHungerCrutch(this);
        this.dropHandler = new DropChanceHandler(this);
        this.loadConfigValues();
        new BukkitRunnable(){

            public void run() {
                AnimalHunger.this.animalDataCache.entrySet().removeIf(entry -> {
                    Entity entity = Bukkit.getEntity((UUID)((UUID)entry.getKey()));
                    if (!(entity instanceof Animals)) {
                        AnimalHunger.this.saveAnimalData((UUID)entry.getKey());
                        return true;
                    }
                    Animals animal = (Animals)entity;
                    AnimalData data = (AnimalData)entry.getValue();
                    data.setHunger(Math.max(data.getHunger() - 1, 0));
                    if (data.getHunger() <= 2) {
                        data.setBondLevel(Math.max(data.getBondLevel() - 2, 0));
                    }
                    if (data.getBondLevel() >= 50 && AnimalHunger.this.random.nextDouble() < AnimalHunger.this.getProductionChance(data)) {
                        data.incrementResourceCount();
                    }
                    AnimalHunger.this.updateHungerDisplay(animal, data);
                    if (data.getHunger() <= 0) {
                        animal.remove();
                        AnimalHunger.this.notifyNearbyPlayers(animal, "animal_died");
                        AnimalHunger.this.saveAnimalData((UUID)entry.getKey());
                        return true;
                    }
                    return false;
                });
            }
        }.runTaskTimer((Plugin)this, 0L, (long)this.hungerDecreaseInterval);
        new BukkitRunnable(){

            public void run() {
                AnimalHunger.this.saveAllAnimalData();
            }
        }.runTaskTimerAsynchronously((Plugin)this, 6000L, 6000L);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new AnimalHungerExpansion(this).register();
            LOGGER.info("PlaceholderAPI support enabled.");
        }
        this.nextAnimalId = this.dataBase.getInt("nextAnimalId", 0);
        if (this.debug) {
            LOGGER.info("Loaded nextAnimalId: " + this.nextAnimalId);
        }
        LOGGER.info("AnimalHunger plugin enabled successfully.");
    }

    public void onDisable() {
        this.saveAllAnimalData();
        LOGGER.info("AnimalHunger plugin disabled.");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("animalhunger")) {
            if (args.length == 0) {
                sender.sendMessage(this.getMessage(sender, "plugin_active"));
                return true;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                if (!sender.hasPermission("animalhunger.reload")) {
                    sender.sendMessage(this.getMessage(sender, "no_permission"));
                    return true;
                }
                this.reloadPlugin(sender);
                return true;
            }
            if (args[0].equalsIgnoreCase("debug") && sender instanceof Player) {
                Player player = (Player)sender;
                Animals animal = this.getAnimalFromGUI(player);
                if (animal == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "No valid animal in metadata.");
                    return true;
                }
                AnimalData data = this.getAnimalData(animal.getUniqueId());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Animal: " + String.valueOf(animal.getType()) + " (UUID: " + String.valueOf(animal.getUniqueId()) + ")");
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Data: " + (String)(data != null ? "Hunger=" + data.getHunger() + "/" + data.getMaxHunger() + ", Level=" + data.getLevel() + ", Bond=" + data.getBondLevel() + "%, Resources=" + data.getResourceCount() : "null"));
                return true;
            }
        }
        return false;
    }

    private void reloadPlugin(CommandSender sender) {
        this.reloadConfig();
        this.config = this.getConfig();
        this.loadMessages();
        this.loadConfigValues();
        sender.sendMessage(this.getMessage(sender, "config_reloaded"));
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (event.getHand() != EquipmentSlot.HAND || !(event.getRightClicked() instanceof Animals)) {
            return;
        }
        Player player = event.getPlayer();
        Animals animal = (Animals)event.getRightClicked();
        if (!animal.isValid()) {
            if (this.debug) {
                LOGGER.info("Attempted to interact with invalid animal: " + String.valueOf(animal.getType()) + " (" + String.valueOf(animal.getUniqueId()) + ")");
            }
            return;
        }
        UUID id = animal.getUniqueId();
        AnimalData data = this.getOrCreateAnimalData(id);
        player.setMetadata("lastAnimal", (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)animal));
        if (this.debug) {
            LOGGER.info("Set lastAnimal metadata for player " + player.getName() + " to animal " + String.valueOf(animal.getType()) + " (" + String.valueOf(id) + ")");
        }
        if (player.isSneaking()) {
            event.setCancelled(true);
            this.openAnimalGUI(player, animal);
        } else {
            ItemStack item = player.getInventory().getItemInMainHand();
            if (item != null && item.getType() == this.feedItem) {
                event.setCancelled(true);
                this.startFeedingProcess(player, animal, id, data);
            }
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Animals animal;
        Entity entity;
        block7: {
            block6: {
                entity = event.getEntity();
                if (!(entity instanceof Animals)) break block6;
                animal = (Animals)entity;
                entity = event.getDamager();
                if (entity instanceof Player) break block7;
            }
            return;
        }
        Player player = (Player)entity;
        if (event.getFinalDamage() >= animal.getHealth()) {
            event.setCancelled(true);
            UUID id = animal.getUniqueId();
            AnimalData data = this.getAnimalData(id);
            ItemStack drop = this.dropHandler.getDrop(animal, data, false);
            if (drop != null) {
                animal.getWorld().dropItemNaturally(animal.getLocation(), drop);
            }
            animal.remove();
            this.removeAnimalData(id);
            this.saveAnimalData(id);
            player.playSound(animal.getLocation(), Sound.ENTITY_GENERIC_HURT, 1.0f, 1.0f);
            if (this.enableParticles) {
                animal.getWorld().spawnParticle(Particle.SMOKE_NORMAL, animal.getLocation().add(0.0, 1.0, 0.0), 10, 0.3, 0.3, 0.3, 0.0);
            }
            player.sendMessage(this.getMessage((CommandSender)player, "animal_killed_by_hand"));
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player) || !event.getView().getTitle().equals(this.getConfigString("gui.title"))) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        Animals animal = this.getAnimalFromGUI(player);
        if (animal == null) {
            player.closeInventory();
            return;
        }
        UUID id = animal.getUniqueId();
        AnimalData data = this.getAnimalData(id);
        if (data == null) {
            return;
        }
        int slot = event.getRawSlot();
        List items = this.config.getMapList("gui.items");
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            Map itemConfig;
            Map configMap = itemConfig = (Map)iterator.next();
            int itemSlot = (Integer)configMap.get("slot");
            String action = configMap.getOrDefault("action", "");
            if (itemSlot != slot) continue;
            switch (action.toLowerCase()) {
                case "feed": {
                    this.feedAnimalInGUI(player, animal, id, data);
                    break;
                }
                case "kill": {
                    this.killAnimal(player, animal, id, data);
                    break;
                }
                case "upgrade": {
                    if (data.getLevel() >= this.getMaxLevel()) break;
                    this.upgradeAnimal(player, animal, id, data);
                    break;
                }
                case "collect": {
                    if (data.getBondLevel() < 50) break;
                    this.collectResources(player, animal, id, data);
                    break;
                }
            }
            return;
        }
    }

    private void startFeedingProcess(Player player, Animals animal, UUID id, AnimalData data) {
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getAmount() > 0 && item.getType() == this.feedItem) {
            if (data.getHunger() >= data.getMaxHunger()) {
                player.sendMessage(this.getMessage((CommandSender)player, "animal_already_full").replace("{animal}", animal.getType().name().toLowerCase()));
                return;
            }
            item.setAmount(item.getAmount() - 1);
            data.setHunger(Math.min(data.getHunger() + this.hungerRestoreAmount, data.getMaxHunger()));
            data.setBondLevel(Math.min(data.getBondLevel() + 5, 100));
            this.updateHungerDisplay(animal, data);
            if (this.enableParticles) {
                animal.getWorld().spawnParticle(Particle.HEART, animal.getLocation().add(0.0, 1.0, 0.0), 5);
            }
            animal.getWorld().playSound(animal.getLocation(), Sound.ENTITY_PLAYER_BURP, 1.0f, 1.0f);
            player.sendMessage(this.getMessage((CommandSender)player, "fed_animal").replace("{animal}", animal.getType().name().toLowerCase()).replace("{hunger}", String.valueOf(data.getHunger())).replace("{max_hunger}", String.valueOf(data.getMaxHunger())).replace("{bond}", String.valueOf(data.getBondLevel())));
            this.saveAnimalData(id);
        } else {
            player.sendMessage(this.getMessage((CommandSender)player, "no_feed_item"));
        }
    }

    private void killAnimal(Player player, Animals animal, UUID id, AnimalData data) {
        int requiredLevel = this.config.getInt("kill.required-level", 2);
        if (data.getLevel() < requiredLevel) {
            player.sendMessage(this.getMessage((CommandSender)player, "kill_level_required").replace("{level}", String.valueOf(requiredLevel)));
            return;
        }
        ItemStack drop = this.dropHandler.getDrop(animal, data, true);
        if (drop != null) {
            animal.getWorld().dropItemNaturally(animal.getLocation(), drop);
        }
        animal.remove();
        this.removeAnimalData(id);
        this.saveAnimalData(id);
        player.playSound(animal.getLocation(), Sound.ENTITY_GENERIC_HURT, 1.0f, 1.0f);
        if (this.enableParticles) {
            animal.getWorld().spawnParticle(Particle.SMOKE_NORMAL, animal.getLocation().add(0.0, 1.0, 0.0), 10, 0.3, 0.3, 0.3, 0.0);
        }
        player.sendMessage(this.getMessage((CommandSender)player, "animal_killed"));
        player.closeInventory();
    }

    private void upgradeAnimal(Player player, Animals animal, UUID id, AnimalData data) {
        ItemStack costItem = new ItemStack(this.upgradeItem, this.upgradeCost);
        if (!player.getInventory().containsAtLeast(costItem, this.upgradeCost)) {
            player.sendMessage(this.getMessage((CommandSender)player, "not_enough_resources").replace("{cost}", String.valueOf(this.upgradeCost)));
            return;
        }
        player.getInventory().removeItem(new ItemStack[]{costItem});
        data.setLevel(data.getLevel() + 1);
        data.setMaxHunger(Math.min(data.getMaxHunger() + 2, this.maxHungerCap));
        data.setBondLevel(Math.min(data.getBondLevel() + 10, 100));
        data.setFeedCount(0);
        this.updateHungerDisplay(animal, data);
        this.saveAnimalData(id);
        player.sendMessage(this.getMessage((CommandSender)player, "animal_upgraded").replace("{level}", String.valueOf(data.getLevel())));
        player.playSound(animal.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        if (this.enableParticles) {
            animal.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, animal.getLocation().add(0.0, 1.0, 0.0), 15, 0.5, 0.5, 0.5, 0.0);
        }
        player.closeInventory();
    }

    private void collectResources(Player player, Animals animal, UUID id, AnimalData data) {
        if (data.getResourceCount() == 0) {
            player.sendMessage(this.getMessage((CommandSender)player, "no_resources"));
            return;
        }
        ItemStack resource = this.getResourceItem(animal, data);
        if (resource != null) {
            player.getInventory().addItem(new ItemStack[]{resource});
            player.sendMessage(this.getMessage((CommandSender)player, "resources_collected").replace("{amount}", String.valueOf(data.getResourceCount())).replace("{item}", resource.getType().name().toLowerCase().replace('_', ' ')));
            player.playSound(animal.getLocation(), Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f);
            if (this.enableParticles) {
                animal.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, animal.getLocation().add(0.0, 1.0, 0.0), 10, 0.3, 0.3, 0.3, 0.0);
            }
        }
        data.setResourceCount(0);
        this.saveAnimalData(id);
        player.closeInventory();
    }

    private ItemStack getResourceItem(Animals animal, AnimalData data) {
        Material resourceType;
        switch (animal.getType()) {
            case PIG: {
                Material material;
                if (data.getBondLevel() >= 75) {
                    material = Material.LEATHER;
                    break;
                }
                material = Material.PORKCHOP;
                break;
            }
            case COW: {
                Material material;
                if (data.getBondLevel() >= 75) {
                    material = Material.LEATHER;
                    break;
                }
                material = Material.BEEF;
                break;
            }
            case SHEEP: {
                Material material;
                if (data.getBondLevel() >= 75) {
                    material = Material.WHITE_WOOL;
                    break;
                }
                material = Material.MUTTON;
                break;
            }
            case CHICKEN: {
                Material material;
                if (data.getBondLevel() >= 75) {
                    material = Material.FEATHER;
                    break;
                }
                material = Material.CHICKEN;
                break;
            }
            default: {
                Material material = resourceType = null;
            }
        }
        if (resourceType == null) {
            return null;
        }
        int amount = data.getResourceCount();
        if (data.getBondLevel() >= 100) {
            amount += this.random.nextInt(2);
        }
        return new ItemStack(resourceType, Math.max(1, amount));
    }

    private double getProductionChance(AnimalData data) {
        if (data.getBondLevel() >= 100) {
            return 0.1;
        }
        if (data.getBondLevel() >= 75) {
            return 0.05;
        }
        return 0.02;
    }

    private void levelUpAnimal(Player player, Animals animal, AnimalData data) {
        if (data.getLevel() >= this.getMaxLevel()) {
            return;
        }
        data.setLevel(data.getLevel() + 1);
        data.setMaxHunger(Math.min(data.getMaxHunger() + 2, this.maxHungerCap));
        data.setFeedCount(0);
        data.setBondLevel(Math.min(data.getBondLevel() + 10, 100));
        this.updateHungerDisplay(animal, data);
        this.saveAnimalData(animal.getUniqueId());
        player.sendMessage(this.getMessage((CommandSender)player, "animal_level_up").replace("{level}", String.valueOf(data.getLevel())));
        player.playSound(animal.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        if (this.enableParticles) {
            animal.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, animal.getLocation().add(0.0, 1.0, 0.0), 15, 0.5, 0.5, 0.5, 0.0);
        }
    }

    private void openAnimalGUI(Player player, Animals animal) {
        int slot;
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)27, (String)this.getConfigString("gui.title"));
        UUID id = animal.getUniqueId();
        AnimalData data = this.getOrCreateAnimalData(id);
        List items = this.config.getMapList("gui.items");
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            Map itemConfig;
            Map configMap = itemConfig = (Map)iterator.next();
            String materialName = (String)configMap.get("material");
            int customModelData = configMap.containsKey("customModelData") ? (Integer)configMap.get("customModelData") : 0;
            slot = (Integer)configMap.get("slot");
            String display = (String)configMap.get("display");
            List lore = configMap.getOrDefault("lore", new ArrayList());
            boolean showInfo = configMap.containsKey("iteminfo") ? (Boolean)configMap.get("iteminfo") : true;
            Material material = Material.getMaterial((String)materialName.toUpperCase());
            if (material == null) {
                material = Material.STONE;
                LOGGER.warning("Invalid material in gui.items: " + materialName);
            }
            List processedLore = lore.stream().map(line -> ChatColor.translateAlternateColorCodes((char)'&', (String)line.replace("{level}", String.valueOf(data.getLevel())).replace("{hunger}", String.valueOf(data.getHunger())).replace("{maxhunger}", String.valueOf(data.getMaxHunger())).replace("{bond}", String.valueOf(data.getBondLevel())).replace("{nextlevel}", String.valueOf(data.getLevel() + 1)).replace("{resources}", String.valueOf(data.getResourceCount())).replace("{feed_item}", this.config.getString("feed-item", "WHEAT")))).collect(Collectors.toList());
            String processedDisplay = ChatColor.translateAlternateColorCodes((char)'&', (String)display.replace("{level}", String.valueOf(data.getLevel())).replace("{hunger}", String.valueOf(data.getHunger())).replace("{maxhunger}", String.valueOf(data.getMaxHunger())).replace("{bond}", String.valueOf(data.getBondLevel())).replace("{nextlevel}", String.valueOf(data.getLevel() + 1)).replace("{resources()", String.valueOf(data.getResourceCount())).replace("{feed_item}", this.config.getString("feed-item", "WHEAT")));
            ItemStack item = new ItemStack(material);
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(processedDisplay);
                meta.setCustomModelData(Integer.valueOf(customModelData));
                if (showInfo && !processedLore.isEmpty()) {
                    meta.setLore(processedLore);
                }
                item.setItemMeta(meta);
            }
            gui.setItem(slot, item);
        }
        List decor = this.config.getMapList("gui.decoration");
        Iterator iterator2 = decor.iterator();
        while (iterator2.hasNext()) {
            ItemMeta meta;
            Map decorConfig;
            Map decorMap = decorConfig = (Map)iterator2.next();
            String materialName = (String)decorMap.get("material");
            slot = (Integer)decorMap.get("slot");
            Material material = Material.getMaterial((String)materialName.toUpperCase());
            if (material == null) {
                material = Material.STONE;
                LOGGER.warning("Invalid material in gui.decoration: " + materialName);
            }
            ItemStack decorItem = new ItemStack(material);
            if (decorMap.containsKey("customModelData") && (meta = decorItem.getItemMeta()) != null) {
                meta.setCustomModelData(Integer.valueOf((Integer)decorMap.get("customModelData")));
                decorItem.setItemMeta(meta);
            }
            gui.setItem(slot, decorItem);
        }
        player.openInventory(gui);
        player.setMetadata("lastAnimal", (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)animal));
    }

    private Animals getAnimalFromGUI(Player player) {
        Animals animal;
        if (!player.hasMetadata("lastAnimal")) {
            return null;
        }
        Object value = ((MetadataValue)player.getMetadata("lastAnimal").get(0)).value();
        if (!(value instanceof Animals) || !(animal = (Animals)value).isValid()) {
            player.removeMetadata("lastAnimal", (Plugin)this);
            return null;
        }
        return animal;
    }

    private boolean hasFeedItem(Player player) {
        return player.getInventory().getItemInMainHand() != null && player.getInventory().getItemInMainHand().getType() == this.feedItem;
    }

    private boolean removeFeedItem(Player player) {
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item != null && item.getType() == this.feedItem && item.getAmount() > 0) {
            if (item.getAmount() == 1) {
                player.getInventory().setItemInMainHand(null);
            } else {
                item.setAmount(item.getAmount() - 1);
            }
            return true;
        }
        return false;
    }

    private void updateHungerDisplay(Animals animal, AnimalData data) {
        double percent = (double)data.getHunger() / (double)data.getMaxHunger() * 100.0;
        String bar = String.valueOf(ChatColor.GREEN) + "\u2588".repeat((int)(percent / 10.0)) + String.valueOf(ChatColor.RED) + "\u2588".repeat(10 - (int)(percent / 10.0));
        String display = String.valueOf(ChatColor.YELLOW) + animal.getType().name() + "\n" + this.getMessageForAll("hunger_display") + bar + " " + String.valueOf(ChatColor.GRAY) + (int)percent + "%\n" + this.getMessageForAll("level_display") + data.getLevel() + "\n" + this.getMessageForAll("bond_display") + data.getBondLevel() + "%";
        for (Entity entity : animal.getNearbyEntities(20.0, 20.0, 20.0)) {
            if (!(entity instanceof Player)) continue;
            final Player player = (Player)entity;
            player.sendTitle(display, "", 0, 40, 0);
            new BukkitRunnable(){

                public void run() {
                    player.resetTitle();
                }
            }.runTaskLater((Plugin)this, 40L);
        }
    }

    private void feedAnimalInGUI(Player player, Animals animal, UUID id, AnimalData data) {
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getAmount() > 0 && item.getType() == this.feedItem) {
            item.setAmount(item.getAmount() - 1);
            data.setHunger(Math.min(data.getHunger() + this.hungerRestoreAmount, data.getMaxHunger()));
            data.setFeedCount(data.getFeedCount() + 1);
            int feedingsPerLevel = this.config.getInt("feedings-per-level", 5);
            int previousLevel = data.getLevel();
            if (data.getFeedCount() >= feedingsPerLevel * data.getLevel() && data.getLevel() < this.config.getInt("max-level", 5)) {
                data.setLevel(data.getLevel() + 1);
                data.setMaxHunger(Math.min(data.getMaxHunger() + 2, this.maxHungerCap));
                if (data.getLevel() == 2 && !this.animalIdMap.containsValue(id)) {
                    this.animalIdMap.put(this.nextAnimalId, id);
                    if (this.debug) {
                        LOGGER.info("Assigned Id " + this.nextAnimalId + " to UUID " + String.valueOf(id));
                    }
                    ++this.nextAnimalId;
                    this.saveAnimalData(id);
                } else if (data.getLevel() >= 2 && !this.animalIdMap.containsValue(id)) {
                    this.animalIdMap.put(this.nextAnimalId, id);
                    if (this.debug) {
                        LOGGER.info("Assigned Id " + this.nextAnimalId + " to UUID " + String.valueOf(id) + " (retroactive for level " + data.getLevel() + ")");
                    }
                    ++this.nextAnimalId;
                    this.saveAnimalData(id);
                }
                player.sendMessage(this.getMessage((CommandSender)player, "level_up").replace("{level}", String.valueOf(data.getLevel())));
                if (this.enableParticles) {
                    animal.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, animal.getLocation().add(0.0, 1.0, 0.0), 10);
                }
            }
            data.setBondLevel(Math.min(data.getBondLevel() + 5, 100));
            this.updateHungerDisplay(animal, data);
            if (this.enableParticles) {
                animal.getWorld().spawnParticle(Particle.HEART, animal.getLocation().add(0.0, 1.0, 0.0), 5);
            }
            animal.getWorld().playSound(animal.getLocation(), Sound.ENTITY_PLAYER_BURP, 1.0f, 1.0f);
            player.sendMessage(this.getMessage((CommandSender)player, "gui_fed_animal").replace("{animal}", animal.getType().name().toLowerCase()).replace("{hunger}", String.valueOf(data.getHunger())).replace("{max_hunger}", String.valueOf(data.getMaxHunger())).replace("{bond}", String.valueOf(data.getBondLevel())));
            this.saveAnimalData(id);
        } else {
            player.sendMessage(this.getMessage((CommandSender)player, "no_gui_feed_item"));
        }
    }

    private void loadConfigValues() {
        this.hungerDecreaseInterval = this.config.getInt("hunger-decrease-interval", 6000);
        this.hungerRestoreAmount = this.config.getInt("hunger-restore-amount", 1);
        this.feedItem = Material.getMaterial((String)this.config.getString("feed-item", "WHEAT").toUpperCase());
        if (this.feedItem == null) {
            this.feedItem = Material.WHEAT;
        }
        this.maxHungerCap = this.config.getInt("max-hunger-cap", 15);
        this.language = this.config.getString("language", "en");
        this.enableParticles = this.config.getBoolean("enable-particles", true);
        this.debug = this.config.getBoolean("debug", false);
    }

    private void loadMessages() {
        File messageFile = new File(this.getDataFolder(), "messages.yml");
        if (!messageFile.exists()) {
            this.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messageFile);
    }

    private String getMessage(CommandSender sender, String key) {
        String locale = sender instanceof Player && !this.language.equals("default") ? this.language : ((Player)sender).getLocale().replace("_", "");
        String message = this.messages.getString(locale + "." + key, this.messages.getString("en." + key, this.messages.getString("ru." + key, "Message not found: " + key)));
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private String getMessageForAll(String key) {
        String message = this.messages.getString(this.language + "." + key, this.messages.getString("en." + key, this.messages.getString("ru." + key, "Message not found: " + key)));
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private void setupDataBase() {
        this.dataBaseFile = new File(this.getDataFolder(), "data.yml");
        if (!this.dataBaseFile.exists()) {
            try {
                this.dataBaseFile.createNewFile();
                if (this.debug) {
                    LOGGER.info("Created new data.yml file.");
                }
            }
            catch (IOException e) {
                LOGGER.severe("Could not create data.yml: " + e.getMessage());
            }
        }
        this.dataBase = YamlConfiguration.loadConfiguration((File)this.dataBaseFile);
    }

    private void loadAllAnimalData() {
        this.animalDataCache.clear();
        this.animalIdMap.clear();
        if (this.dataBase == null) {
            LOGGER.warning("Database not initialized, skipping data load.");
            return;
        }
        for (String key : this.dataBase.getKeys(false)) {
            if (key.equals("nextAnimalId")) continue;
            try {
                UUID uuid = UUID.fromString(key);
                int hunger = this.dataBase.getInt(key + ".hunger", 10);
                int maxHunger = this.dataBase.getInt(key + ".maxHunger", 10);
                int level = this.dataBase.getInt(key + ".level", 1);
                int feedCount = this.dataBase.getInt(key + ".feedCount", 0);
                int bondLevel = this.dataBase.getInt(key + ".bondLevel", 0);
                int resourceCount = this.dataBase.getInt(key + ".resourceCount", 0);
                int animalId = this.dataBase.getInt(key + ".id", -1);
                AnimalData data = new AnimalData(hunger, maxHunger, level, feedCount, bondLevel, resourceCount);
                this.animalDataCache.put(uuid, data);
                if (animalId >= 0) {
                    this.animalIdMap.put(animalId, uuid);
                }
                if (!this.debug) continue;
                LOGGER.info("Loaded animal data for UUID " + String.valueOf(uuid) + ": Hunger=" + hunger + "/" + maxHunger + ", Level=" + level + ", Bond=" + bondLevel + ", Resources=" + resourceCount + ", FeedCount=" + feedCount + ", Id=" + String.valueOf(animalId >= 0 ? Integer.valueOf(animalId) : "none"));
            }
            catch (IllegalArgumentException e) {
                LOGGER.warning("Invalid UUID in data.yml: " + key);
            }
        }
    }

    private void saveAnimalData(UUID id) {
        AnimalData data = this.animalDataCache.get(id);
        if (data == null) {
            this.dataBase.set(id.toString(), null);
            if (this.debug) {
                LOGGER.info("Removed animal data for UUID " + String.valueOf(id) + " from database (no data in cache).");
            }
        } else {
            this.dataBase.set(id.toString() + ".hunger", (Object)data.getHunger());
            this.dataBase.set(id.toString() + ".maxHunger", (Object)data.getMaxHunger());
            this.dataBase.set(id.toString() + ".level", (Object)data.getLevel());
            this.dataBase.set(id.toString() + ".feedCount", (Object)data.getFeedCount());
            this.dataBase.set(id.toString() + ".bondLevel", (Object)data.getBondLevel());
            this.dataBase.set(id.toString() + ".resourceCount", (Object)data.getResourceCount());
            int animalId = this.animalIdMap.entrySet().stream().filter(entry -> ((UUID)entry.getValue()).equals(id)).map(Map.Entry::getKey).findFirst().orElse(-1);
            if (data.getLevel() >= 2) {
                if (animalId < 0) {
                    animalId = this.nextAnimalId;
                    this.animalIdMap.put(animalId, id);
                    if (this.debug) {
                        LOGGER.info("Assigned Id " + animalId + " to UUID " + String.valueOf(id) + " (fallback for level " + data.getLevel() + ")");
                    }
                    ++this.nextAnimalId;
                }
                this.dataBase.set(id.toString() + ".id", (Object)animalId);
                if (this.debug) {
                    LOGGER.info("Saved Id " + animalId + " for UUID " + String.valueOf(id));
                }
            }
            if (this.debug) {
                LOGGER.info("Saved animal data for UUID " + String.valueOf(id) + ": Hunger=" + data.getHunger() + "/" + data.getMaxHunger() + ", Level=" + data.getLevel() + ", Bond=" + data.getBondLevel() + ", Resources=" + data.getResourceCount() + ", FeedCount=" + data.getFeedCount() + ", Id=" + String.valueOf(animalId >= 0 ? Integer.valueOf(animalId) : "none"));
            }
        }
        this.dataBase.set("nextAnimalId", (Object)this.nextAnimalId);
        try {
            this.dataBase.save(this.dataBaseFile);
        }
        catch (IOException e) {
            LOGGER.severe("Could not save data.yml: " + e.getMessage());
        }
    }

    private void saveAllAnimalData() {
        for (UUID id : this.animalDataCache.keySet()) {
            this.saveAnimalData(id);
        }
        if (this.debug) {
            LOGGER.info("Saved all animal data to data.yml (" + this.animalDataCache.size() + " entries).");
        }
    }

    private void saveDataBaseAsync() {
        new BukkitRunnable(){

            public void run() {
                try {
                    AnimalHunger.this.dataBase.save(AnimalHunger.this.dataBaseFile);
                }
                catch (IOException e) {
                    LOGGER.severe("Failed to save base.yml: " + e.getMessage());
                }
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    private void notifyNearbyPlayers(Animals animal, String messageKey) {
        for (Entity entity : animal.getNearbyEntities(10.0, 10.0, 10.0)) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            player.sendMessage(this.getMessage((CommandSender)player, messageKey));
            player.playSound(animal.getLocation(), Sound.ENTITY_VILLAGER_DEATH, 1.0f, 1.0f);
            if (!this.enableParticles) continue;
            animal.getWorld().spawnParticle(Particle.SMOKE_NORMAL, animal.getLocation().add(0.0, 1.0, 0.0), 10, 0.3, 0.3, 0.3, 0.0);
        }
    }

    private String getConfigString(String path) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString(path, ""));
    }

    private int getMaxLevel() {
        return this.config.getInt("max-level", 5);
    }

    private int getFeedingsForLevelUp(int currentLevel) {
        return this.config.getInt("feedings-per-level", 5) * currentLevel;
    }

    public AnimalData getAnimalData(UUID id) {
        return this.animalDataCache.get(id);
    }

    public void setAnimalData(UUID id, AnimalData data) {
        this.animalDataCache.put(id, data);
    }

    public void removeAnimalData(UUID id) {
        this.animalDataCache.remove(id);
    }

    public AnimalData getOrCreateAnimalData(UUID id) {
        return this.animalDataCache.computeIfAbsent(id, k -> new AnimalData(10, 10, 1, 0, 0, 0));
    }

    public AnimalHungerCrutch getCrutch() {
        return this.crutch;
    }

    public Map<UUID, AnimalData> getAnimalDataCache() {
        return this.animalDataCache;
    }
}

