/*
 * Decompiled with CFR 0.152.
 */
package animalhunger.animalhunger;

import animalhunger.animalhunger.AnimalData;
import animalhunger.animalhunger.AnimalHunger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class AnimalHungerExpansion
extends PlaceholderExpansion {
    private final AnimalHunger plugin;
    private final Map<String, String> placeholders;

    public AnimalHungerExpansion(AnimalHunger plugin) {
        this.plugin = plugin;
        this.placeholders = this.loadPlaceholders();
    }

    @NotNull
    public String getIdentifier() {
        return "animalhunger";
    }

    @NotNull
    public String getAuthor() {
        return "Vlsq";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String onPlaceholderRequest(Player player, @NotNull String identifier) {
        if (identifier.startsWith("level_by_id_")) {
            try {
                int animalId = Integer.parseInt(identifier.substring("level_by_id_".length()));
                UUID animalUuid = this.plugin.getAnimalIdMap().get(animalId);
                if (animalUuid == null) {
                    return this.plugin.getConfig().getString("placeholders.fallback", "N/A");
                }
                AnimalData data = this.plugin.getAnimalData(animalUuid);
                if (data == null) {
                    return this.plugin.getConfig().getString("placeholders.fallback", "N/A");
                }
                return String.valueOf(data.getLevel());
            }
            catch (NumberFormatException e) {
                return this.plugin.getConfig().getString("placeholders.fallback", "N/A");
            }
        }
        if (player == null) {
            return "";
        }
        Animals animal = this.getAnimalFromMetadata(player);
        if (animal == null) {
            return this.plugin.getConfig().getString("placeholders.fallback", "N/A");
        }
        AnimalData data = this.plugin.getAnimalData(animal.getUniqueId());
        if (data == null) {
            return this.plugin.getConfig().getString("placeholders.fallback", "N/A");
        }
        String format = this.placeholders.get(identifier.toLowerCase());
        if (format == null) {
            return null;
        }
        return format.replace("{hunger}", String.valueOf(data.getHunger())).replace("{max_hunger}", String.valueOf(data.getMaxHunger())).replace("{level}", String.valueOf(data.getLevel())).replace("{bond}", String.valueOf(data.getBondLevel())).replace("{resources}", String.valueOf(data.getResourceCount())).replace("{animal_type}", animal.getType().name()).replace("{hunger_percent}", String.format("%.0f", (double)data.getHunger() / (double)data.getMaxHunger() * 100.0));
    }

    private Animals getAnimalFromMetadata(Player player) {
        Animals animal;
        if (!player.hasMetadata("lastAnimal")) {
            return null;
        }
        Object value = ((MetadataValue)player.getMetadata("lastAnimal").get(0)).value();
        if (!(value instanceof Animals) || !(animal = (Animals)value).isValid()) {
            player.removeMetadata("lastAnimal", (Plugin)this.plugin);
            return null;
        }
        return animal;
    }

    private Map<String, String> loadPlaceholders() {
        HashMap<String, String> placeholderMap = new HashMap<String, String>();
        List placeholderList = this.plugin.getConfig().getMapList("placeholders.list");
        Iterator iterator = placeholderList.iterator();
        while (iterator.hasNext()) {
            Map placeholderConfig;
            Map configMap = placeholderConfig = (Map)iterator.next();
            String key = (String)configMap.get("key");
            String format = (String)configMap.get("format");
            if (key == null || format == null) continue;
            placeholderMap.put(key.toLowerCase(), format);
        }
        return placeholderMap;
    }
}

