/*
 * Decompiled with CFR 0.152.
 */
package animalhunger.animalhunger;

import animalhunger.animalhunger.AnimalData;
import animalhunger.animalhunger.AnimalHunger;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.entity.Animals;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class DropChanceHandler {
    private final AnimalHunger plugin;
    private final Random random = new Random();

    public DropChanceHandler(AnimalHunger plugin) {
        this.plugin = plugin;
    }

    public ItemStack getDrop(Animals animal, AnimalData data, boolean fromMenu) {
        if (!fromMenu) {
            return data != null && data.getLevel() <= 1 ? this.getGarbageDrop(animal) : null;
        }
        if (data == null || data.getLevel() <= 1) {
            this.plugin.getLogger().info("Dropping garbage for " + String.valueOf(animal.getType()) + " with level " + String.valueOf(data != null ? Integer.valueOf(data.getLevel()) : "null"));
            return this.getGarbageDrop(animal);
        }
        if (data.getBondLevel() >= 75 && this.random.nextDouble() <= 0.3) {
            return this.getRareDrop(animal, data);
        }
        return this.getStandardDrop(animal);
    }

    private ItemStack getGarbageDrop(Animals animal) {
        int amount = 1 + this.random.nextInt(2);
        return switch (animal.getType()) {
            case EntityType.COW -> new ItemStack(Material.DIRT, amount);
            case EntityType.PIG, EntityType.SHEEP, EntityType.CHICKEN -> new ItemStack(Material.ROTTEN_FLESH, amount);
            default -> new ItemStack(Material.DIRT, amount);
        };
    }

    private ItemStack getRareDrop(Animals animal, AnimalData data) {
        int bonus = (data.getBondLevel() - 74) / 5;
        int amount = 1 + bonus + this.random.nextInt(2);
        return switch (animal.getType()) {
            case EntityType.COW, EntityType.PIG -> new ItemStack(Material.LEATHER, amount);
            case EntityType.SHEEP -> new ItemStack(Material.WHITE_WOOL, amount);
            case EntityType.CHICKEN -> new ItemStack(Material.FEATHER, amount);
            default -> this.getStandardDrop(animal);
        };
    }

    private ItemStack getStandardDrop(Animals animal) {
        int amount = 1 + this.random.nextInt(2);
        return switch (animal.getType()) {
            case EntityType.PIG -> new ItemStack(Material.PORKCHOP, amount);
            case EntityType.COW -> new ItemStack(Material.BEEF, amount);
            case EntityType.SHEEP -> new ItemStack(Material.MUTTON, amount);
            case EntityType.CHICKEN -> new ItemStack(Material.CHICKEN, amount);
            default -> null;
        };
    }
}

