/*
 * Decompiled with CFR 0.152.
 */
package animalhunger.animalhunger;

import animalhunger.animalhunger.AnimalData;
import animalhunger.animalhunger.AnimalHungerCrutch;
import animalhunger.animalhunger.DropChanceHandler;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AnimalHunger
extends JavaPlugin
implements Listener {
    private static final Logger LOGGER = Logger.getLogger("AnimalHunger");
    private final Map<UUID, AnimalData> animalDataCache = new ConcurrentHashMap<UUID, AnimalData>();
    private FileConfiguration config;
    private FileConfiguration messages;
    private FileConfiguration dataBase;
    private File dataBaseFile;
    private AnimalHungerCrutch crutch;
    private DropChanceHandler dropHandler;
    private int hungerDecreaseInterval;
    private int hungerRestoreAmount;
    private Material feedItem;
    private Material upgradeItem = Material.GOLDEN_CARROT;
    private int upgradeCost = 3;
    private int maxHungerCap;
    private String language;
    private final Random random = new Random();

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.loadMessages();
        this.setupDataBase();
        this.loadAllAnimalData();
        this.crutch = new AnimalHungerCrutch(this);
        this.dropHandler = new DropChanceHandler(this);
        this.loadConfigValues();
        new BukkitRunnable(){

            public void run() {
                AnimalHunger.this.animalDataCache.entrySet().removeIf(entry -> {
                    Entity entity = Bukkit.getEntity((UUID)((UUID)entry.getKey()));
                    if (!(entity instanceof Animals)) {
                        AnimalHunger.this.saveAnimalData((UUID)entry.getKey());
                        return true;
                    }
                    Animals animal = (Animals)entity;
                    AnimalData data = (AnimalData)entry.getValue();
                    data.setHunger(Math.max(data.getHunger() - 1, 0));
                    AnimalHunger.this.updateHungerDisplay(animal, data);
                    if (data.getHunger() <= 0) {
                        animal.remove();
                        AnimalHunger.this.notifyNearbyPlayers(animal, "animal_died");
                        AnimalHunger.this.saveAnimalData((UUID)entry.getKey());
                        return true;
                    }
                    return false;
                });
            }
        }.runTaskTimer((Plugin)this, 0L, (long)this.hungerDecreaseInterval);
        new BukkitRunnable(){

            public void run() {
                AnimalHunger.this.saveAllAnimalData();
            }
        }.runTaskTimerAsynchronously((Plugin)this, 6000L, 6000L);
        LOGGER.info("AnimalHunger plugin enabled successfully.");
    }

    public void onDisable() {
        this.saveAllAnimalData();
        LOGGER.info("AnimalHunger plugin disabled.");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("animalhunger")) {
            if (args.length == 0) {
                sender.sendMessage(this.getMessage(sender, "plugin_active"));
                return true;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                if (!sender.hasPermission("animalhunger.reload")) {
                    sender.sendMessage(this.getMessage(sender, "no_permission"));
                    return true;
                }
                this.reloadPlugin(sender);
                return true;
            }
        }
        return false;
    }

    private void reloadPlugin(CommandSender sender) {
        this.reloadConfig();
        this.config = this.getConfig();
        this.loadMessages();
        this.loadConfigValues();
        sender.sendMessage(this.getMessage(sender, "config_reloaded"));
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEntityEvent event) {
        if (event.getHand() != EquipmentSlot.HAND || !(event.getRightClicked() instanceof Animals)) {
            return;
        }
        event.setCancelled(true);
        Player player = event.getPlayer();
        Animals animal = (Animals)event.getRightClicked();
        this.openAnimalGUI(player, animal);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player) || !event.getView().getTitle().equals(this.getConfigString("gui.title"))) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        Animals animal = this.getAnimalFromGUI(player);
        if (animal == null) {
            player.closeInventory();
            return;
        }
        UUID id = animal.getUniqueId();
        AnimalData data = this.getAnimalData(id);
        if (data == null) {
            return;
        }
        int slot = event.getRawSlot();
        if (slot == this.config.getInt("gui.slots.feed")) {
            this.startFeedingProcess(player, animal, id, data);
        } else if (slot == this.config.getInt("gui.slots.kill")) {
            this.killAnimal(player, animal, id, data);
        } else if (slot == this.config.getInt("gui.slots.upgrade") && data.getLevel() < this.getMaxLevel()) {
            this.upgradeAnimal(player, animal, id, data);
        }
    }

    private void startFeedingProcess(final Player player, final Animals animal, final UUID id, final AnimalData data) {
        if (data.getHunger() >= data.getMaxHunger() || !this.hasFeedItem(player)) {
            player.sendMessage(this.getMessage((CommandSender)player, "cannot_feed"));
            return;
        }
        player.sendMessage(this.getMessage((CommandSender)player, "feeding_start"));
        new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                if (!animal.isValid() || !player.isOnline()) {
                    this.cancel();
                    return;
                }
                if (this.ticks >= 40) {
                    if (AnimalHunger.this.removeFeedItem(player)) {
                        data.setHunger(Math.min(data.getHunger() + AnimalHunger.this.hungerRestoreAmount, data.getMaxHunger()));
                        data.setFeedCount(data.getFeedCount() + 1);
                        if (data.getFeedCount() >= AnimalHunger.this.getFeedingsForLevelUp(data.getLevel())) {
                            AnimalHunger.this.levelUpAnimal(player, animal, data);
                        }
                        AnimalHunger.this.updateHungerDisplay(animal, data);
                        AnimalHunger.this.saveAnimalData(id);
                        player.playSound(animal.getLocation(), Sound.ENTITY_GENERIC_EAT, 1.0f, 1.0f);
                        animal.getWorld().spawnParticle(Particle.HEART, animal.getLocation().add(0.0, 1.0, 0.0), 5);
                        player.sendMessage(AnimalHunger.this.getMessage((CommandSender)player, "fed_animal").replace("{animal}", animal.getType().name()).replace("{hunger}", String.valueOf(data.getHunger())).replace("{max_hunger}", String.valueOf(data.getMaxHunger())));
                        if (data.getHunger() <= 2) {
                            int expReward = 5 + (data.getLevel() - 1) * 5;
                            player.giveExp(expReward);
                            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                            player.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, player.getLocation().add(0.0, 1.0, 0.0), 5);
                            player.sendMessage(AnimalHunger.this.getMessage((CommandSender)player, "saved_animal").replace("{exp}", String.valueOf(expReward)));
                        }
                    }
                    player.closeInventory();
                    this.cancel();
                    return;
                }
                if (this.ticks % 10 == 0) {
                    player.sendMessage(AnimalHunger.this.getMessage((CommandSender)player, "feeding_progress").replace("{progress}", String.valueOf(this.ticks / 10)));
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this, 0L, 1L);
    }

    private void killAnimal(Player player, Animals animal, UUID id, AnimalData data) {
        int requiredLevel = this.config.getInt("kill.required-level", 2);
        if (data.getLevel() < requiredLevel) {
            player.sendMessage(this.getMessage((CommandSender)player, "kill_level_required").replace("{level}", String.valueOf(requiredLevel)));
            return;
        }
        ItemStack drop = this.dropHandler.getDrop(animal, data);
        if (drop != null) {
            animal.getWorld().dropItemNaturally(animal.getLocation(), drop);
        }
        animal.remove();
        this.removeAnimalData(id);
        this.saveAnimalData(id);
        player.sendMessage(this.getMessage((CommandSender)player, "animal_killed"));
        player.closeInventory();
    }

    private void upgradeAnimal(Player player, Animals animal, UUID id, AnimalData data) {
        ItemStack costItem = new ItemStack(this.upgradeItem, this.upgradeCost);
        if (!player.getInventory().containsAtLeast(costItem, this.upgradeCost)) {
            player.sendMessage(this.getMessage((CommandSender)player, "not_enough_resources").replace("{cost}", String.valueOf(this.upgradeCost)));
            return;
        }
        player.getInventory().removeItem(new ItemStack[]{costItem});
        data.setLevel(data.getLevel() + 1);
        data.setMaxHunger(Math.min(data.getMaxHunger() + 2, this.maxHungerCap));
        data.setFeedCount(0);
        this.updateHungerDisplay(animal, data);
        this.saveAnimalData(id);
        player.sendMessage(this.getMessage((CommandSender)player, "animal_upgraded").replace("{level}", String.valueOf(data.getLevel())));
        animal.getWorld().spawnParticle(Particle.FIREWORKS_SPARK, animal.getLocation().add(0.0, 1.0, 0.0), 10);
        player.playSound(animal.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        player.closeInventory();
    }

    private void levelUpAnimal(Player player, Animals animal, AnimalData data) {
        if (data.getLevel() >= this.getMaxLevel()) {
            return;
        }
        data.setLevel(data.getLevel() + 1);
        data.setMaxHunger(Math.min(data.getMaxHunger() + 2, this.maxHungerCap));
        data.setFeedCount(0);
        this.updateHungerDisplay(animal, data);
        this.saveAnimalData(animal.getUniqueId());
        player.sendMessage(this.getMessage((CommandSender)player, "animal_level_up").replace("{level}", String.valueOf(data.getLevel())));
        animal.getWorld().spawnParticle(Particle.FIREWORKS_SPARK, animal.getLocation().add(0.0, 1.0, 0.0), 10);
        player.playSound(animal.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
    }

    private void openAnimalGUI(Player player, Animals animal) {
        ItemStack killItem;
        ItemMeta killMeta;
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)9, (String)this.getConfigString("gui.title"));
        UUID id = animal.getUniqueId();
        AnimalData data = this.getOrCreateAnimalData(id);
        ItemStack levelItem = new ItemStack(Material.NAME_TAG);
        ItemMeta levelMeta = levelItem.getItemMeta();
        if (levelMeta != null) {
            levelMeta.setDisplayName(ChatColor.YELLOW + this.getMessageForAll("level_display") + data.getLevel());
            levelItem.setItemMeta(levelMeta);
        }
        gui.setItem(this.config.getInt("gui.slots.level"), levelItem);
        ItemStack hungerItem = new ItemStack(Material.COOKED_BEEF);
        ItemMeta hungerMeta = hungerItem.getItemMeta();
        if (hungerMeta != null) {
            hungerMeta.setDisplayName(ChatColor.GREEN + this.getMessageForAll("hunger_display") + data.getHunger() + "/" + data.getMaxHunger());
            hungerItem.setItemMeta(hungerMeta);
        }
        gui.setItem(this.config.getInt("gui.slots.hunger"), hungerItem);
        if (data.getHunger() < data.getMaxHunger() && this.hasFeedItem(player)) {
            ItemStack feedItem = new ItemStack(Material.valueOf((String)this.getConfigString("gui.feed-item")));
            ItemMeta feedMeta = feedItem.getItemMeta();
            if (feedMeta != null) {
                feedMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfigString("gui.feed-display")));
                feedItem.setItemMeta(feedMeta);
            }
            gui.setItem(this.config.getInt("gui.slots.feed"), feedItem);
        }
        if ((killMeta = (killItem = new ItemStack(Material.valueOf((String)this.getConfigString("gui.kill-item")))).getItemMeta()) != null) {
            killMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfigString("gui.kill-display")));
            killMeta.setLore(List.of(ChatColor.GRAY + "Chance: 100%", ChatColor.GRAY + "Required Level: " + this.config.getInt("kill.required-level", 2)));
            killItem.setItemMeta(killMeta);
        }
        gui.setItem(this.config.getInt("gui.slots.kill"), killItem);
        if (data.getLevel() < this.getMaxLevel()) {
            ItemStack upgradeItemStack = new ItemStack(this.upgradeItem);
            ItemMeta upgradeMeta = upgradeItemStack.getItemMeta();
            if (upgradeMeta != null) {
                upgradeMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfigString("gui.upgrade-display")));
                Object itemName = this.upgradeItem.name().toLowerCase().replace('_', ' ');
                itemName = ((String)itemName).substring(0, 1).toUpperCase() + ((String)itemName).substring(1);
                upgradeMeta.setLore(List.of(ChatColor.GRAY + "Cost: " + this.upgradeCost + " " + (String)itemName, ChatColor.GRAY + "Next Level: " + (data.getLevel() + 1)));
                upgradeItemStack.setItemMeta(upgradeMeta);
            }
            gui.setItem(this.config.getInt("gui.slots.upgrade"), upgradeItemStack);
        }
        player.openInventory(gui);
        player.setMetadata("lastAnimal", (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)animal));
    }

    private Animals getAnimalFromGUI(Player player) {
        Animals animal;
        if (!player.hasMetadata("lastAnimal")) {
            return null;
        }
        Object value = ((MetadataValue)player.getMetadata("lastAnimal").get(0)).value();
        if (!(value instanceof Animals) || !(animal = (Animals)value).isValid()) {
            player.removeMetadata("lastAnimal", (Plugin)this);
            return null;
        }
        return animal;
    }

    private boolean hasFeedItem(Player player) {
        return player.getInventory().containsAtLeast(new ItemStack(this.feedItem), 1);
    }

    private boolean removeFeedItem(Player player) {
        if (this.hasFeedItem(player)) {
            ItemStack item = new ItemStack(this.feedItem, 1);
            player.getInventory().removeItem(new ItemStack[]{item});
            return true;
        }
        return false;
    }

    private void updateHungerDisplay(Animals animal, AnimalData data) {
        double percent = (double)data.getHunger() / (double)data.getMaxHunger() * 100.0;
        String bar = ChatColor.GREEN + "\u2588".repeat((int)(percent / 10.0)) + ChatColor.RED + "\u2588".repeat(10 - (int)(percent / 10.0));
        String display = ChatColor.YELLOW + animal.getType().name() + "\n" + this.getMessageForAll("hunger_display") + bar + " " + ChatColor.GRAY + (int)percent + "%\n" + this.getMessageForAll("level_display") + data.getLevel();
        for (Entity entity : animal.getNearbyEntities(20.0, 20.0, 20.0)) {
            if (!(entity instanceof Player)) continue;
            final Player player = (Player)entity;
            player.sendTitle(display, "", 0, 40, 0);
            new BukkitRunnable(){

                public void run() {
                    player.resetTitle();
                }
            }.runTaskLater((Plugin)this, 40L);
        }
    }

    private void loadConfigValues() {
        this.hungerDecreaseInterval = this.config.getInt("hunger-decrease-interval", 6000);
        this.hungerRestoreAmount = this.config.getInt("hunger-restore-amount", 1);
        this.feedItem = Material.getMaterial((String)this.config.getString("feed-item", "WHEAT").toUpperCase());
        if (this.feedItem == null) {
            this.feedItem = Material.WHEAT;
        }
        this.maxHungerCap = this.config.getInt("max-hunger-cap", 15);
        this.language = this.config.getString("language", "en");
    }

    private void loadMessages() {
        File messageFile = new File(this.getDataFolder(), "messages.yml");
        if (!messageFile.exists()) {
            this.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messageFile);
    }

    private String getMessage(CommandSender sender, String key) {
        String locale = sender instanceof Player && !this.language.equals("default") ? this.language : ((Player)sender).getLocale().replace("_", "");
        String message = this.messages.getString(locale + "." + key, this.messages.getString("en." + key, this.messages.getString("ru." + key, "Message not found: " + key)));
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private String getMessageForAll(String key) {
        String message = this.messages.getString(this.language + "." + key, this.messages.getString("en." + key, this.messages.getString("ru." + key, "Message not found: " + key)));
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private void setupDataBase() {
        this.dataBaseFile = new File(this.getDataFolder(), "base.yml");
        if (!this.dataBaseFile.exists()) {
            try {
                this.dataBaseFile.createNewFile();
            }
            catch (IOException e) {
                LOGGER.severe("Failed to create base.yml: " + e.getMessage());
            }
        }
        this.dataBase = YamlConfiguration.loadConfiguration((File)this.dataBaseFile);
    }

    private void loadAllAnimalData() {
        if (this.dataBase.contains("animals")) {
            for (String key : this.dataBase.getConfigurationSection("animals").getKeys(false)) {
                try {
                    UUID id = UUID.fromString(key);
                    int hunger = this.dataBase.getInt("animals." + key + ".hunger", 10);
                    int maxHunger = this.dataBase.getInt("animals." + key + ".maxHunger", 10);
                    int level = this.dataBase.getInt("animals." + key + ".level", 1);
                    int feedCount = this.dataBase.getInt("animals." + key + ".feedCount", 0);
                    this.setAnimalData(id, new AnimalData(hunger, maxHunger, level, feedCount));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warning("Invalid UUID in base.yml: " + key);
                }
            }
        }
    }

    private void saveAnimalData(UUID id) {
        AnimalData data = this.getAnimalData(id);
        String path = "animals." + id.toString();
        if (data == null) {
            this.dataBase.set(path, null);
        } else {
            this.dataBase.set(path + ".hunger", (Object)data.getHunger());
            this.dataBase.set(path + ".maxHunger", (Object)data.getMaxHunger());
            this.dataBase.set(path + ".level", (Object)data.getLevel());
            this.dataBase.set(path + ".feedCount", (Object)data.getFeedCount());
        }
        try {
            this.dataBase.save(this.dataBaseFile);
        }
        catch (IOException e) {
            LOGGER.severe("Failed to save to base.yml: " + e.getMessage());
            this.crutch.saveToFallback(id, data);
        }
    }

    private void saveAllAnimalData() {
        this.animalDataCache.keySet().forEach(this::saveAnimalData);
    }

    private void saveDataBaseAsync() {
        new BukkitRunnable(){

            public void run() {
                try {
                    AnimalHunger.this.dataBase.save(AnimalHunger.this.dataBaseFile);
                }
                catch (IOException e) {
                    LOGGER.severe("Failed to save base.yml: " + e.getMessage());
                }
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    private void notifyNearbyPlayers(Animals animal, String messageKey) {
        for (Entity entity : animal.getNearbyEntities(10.0, 10.0, 10.0)) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            player.sendMessage(this.getMessage((CommandSender)player, messageKey));
            player.playSound(animal.getLocation(), Sound.ENTITY_VILLAGER_DEATH, 1.0f, 1.0f);
        }
    }

    private String getConfigString(String path) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString(path, ""));
    }

    private int getMaxLevel() {
        return this.config.getInt("max-level", 5);
    }

    private int getFeedingsForLevelUp(int currentLevel) {
        return this.config.getInt("feedings-per-level", 5) * currentLevel;
    }

    public AnimalData getAnimalData(UUID id) {
        return this.animalDataCache.get(id);
    }

    public void setAnimalData(UUID id, AnimalData data) {
        this.animalDataCache.put(id, data);
    }

    public void removeAnimalData(UUID id) {
        this.animalDataCache.remove(id);
    }

    public AnimalData getOrCreateAnimalData(UUID id) {
        return this.animalDataCache.computeIfAbsent(id, k -> new AnimalData(10, 10, 1, 0));
    }

    public Map<UUID, AnimalData> getAnimalDataCache() {
        return this.animalDataCache;
    }

    public AnimalHungerCrutch getCrutch() {
        return this.crutch;
    }
}

