/*
 * Decompiled with CFR 0.152.
 */
package animalhunger.animalhunger;

import animalhunger.animalhunger.AnimalData;
import animalhunger.animalhunger.AnimalHunger;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AnimalHungerCrutch {
    private static final Logger LOGGER = Logger.getLogger("AnimalHungerCrutch");
    private final AnimalHunger plugin;
    private FileConfiguration fallbackDataBase;
    private File fallbackDataBaseFile;

    public AnimalHungerCrutch(AnimalHunger plugin) {
        this.plugin = plugin;
        this.setupFallbackDataBase();
        this.startMaintenanceTasks();
    }

    private void setupFallbackDataBase() {
        this.fallbackDataBaseFile = new File(this.plugin.getDataFolder(), "fallback_base.yml");
        if (!this.fallbackDataBaseFile.exists()) {
            try {
                this.fallbackDataBaseFile.createNewFile();
            }
            catch (IOException e) {
                LOGGER.severe("Failed to create fallback_base.yml: " + e.getMessage());
            }
        }
        this.fallbackDataBase = YamlConfiguration.loadConfiguration((File)this.fallbackDataBaseFile);
    }

    public void saveToFallback(UUID id, AnimalData data) {
        String path = "animals." + id.toString();
        if (data == null) {
            this.fallbackDataBase.set(path, null);
        } else {
            this.fallbackDataBase.set(path + ".hunger", (Object)data.getHunger());
            this.fallbackDataBase.set(path + ".maxHunger", (Object)data.getMaxHunger());
            this.fallbackDataBase.set(path + ".level", (Object)data.getLevel());
            this.fallbackDataBase.set(path + ".feedCount", (Object)data.getFeedCount());
        }
        this.saveFallbackDataBaseAsync();
    }

    private void saveFallbackDataBaseAsync() {
        new BukkitRunnable(){

            public void run() {
                try {
                    AnimalHungerCrutch.this.fallbackDataBase.save(AnimalHungerCrutch.this.fallbackDataBaseFile);
                    LOGGER.info("Fallback data saved to fallback_base.yml.");
                }
                catch (IOException e) {
                    LOGGER.severe("Failed to save fallback_base.yml: " + e.getMessage());
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private void startMaintenanceTasks() {
        new BukkitRunnable(){

            public void run() {
                AnimalHungerCrutch.this.plugin.getAnimalDataCache().entrySet().removeIf(entry -> {
                    Entity entity = Bukkit.getEntity((UUID)((UUID)entry.getKey()));
                    if (!(entity instanceof Animals) || !entity.isValid()) {
                        AnimalData data = AnimalHungerCrutch.this.plugin.getAnimalData((UUID)entry.getKey());
                        AnimalHungerCrutch.this.saveToFallback((UUID)entry.getKey(), data);
                        AnimalHungerCrutch.this.plugin.removeAnimalData((UUID)entry.getKey());
                        return true;
                    }
                    return false;
                });
                LOGGER.info("Maintenance task completed: Checked for orphaned entities.");
            }
        }.runTaskTimer((Plugin)this.plugin, 12000L, 12000L);
    }

    public Map<UUID, AnimalData> getAnimalDataCache() {
        return this.plugin.getAnimalDataCache();
    }
}

