/*
 * Decompiled with CFR 0.152.
 */
package animalhunger.animalhunger;

import animalhunger.animalhunger.AnimalData;
import animalhunger.animalhunger.AnimalHunger;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.entity.Animals;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class DropChanceHandler {
    private final Random random;
    private final AnimalHunger plugin;
    private final int[] dropChances;

    public DropChanceHandler(AnimalHunger plugin) {
        this.plugin = plugin;
        this.random = new Random();
        this.dropChances = this.loadDropChances();
    }

    private int[] loadDropChances() {
        int[] chances = new int[]{this.plugin.getConfig().getInt("drop.chances.1", 50), this.plugin.getConfig().getInt("drop.chances.2", 25), this.plugin.getConfig().getInt("drop.chances.3", 15), this.plugin.getConfig().getInt("drop.chances.4", 7), this.plugin.getConfig().getInt("drop.chances.5", 3)};
        int total = 0;
        for (int chance : chances) {
            total += chance;
        }
        if (total != 100) {
            this.plugin.getLogger().warning("Drop chances in config.yml do not sum to 100 (total: " + total + "). Adjusting to default values.");
            return new int[]{50, 25, 15, 7, 3};
        }
        return chances;
    }

    public ItemStack getDrop(Animals animal, AnimalData data) {
        if (data == null || !this.isDropEligible(data.getLevel())) {
            return null;
        }
        Material meat = this.getMeatType(animal.getType());
        if (meat == null) {
            return null;
        }
        int baseAmount = this.getRandomAmount();
        int levelBonus = Math.min(data.getLevel(), 3);
        int totalAmount = baseAmount + (levelBonus > 0 ? this.random.nextInt(levelBonus + 1) : 0);
        return new ItemStack(meat, Math.max(1, totalAmount));
    }

    private boolean isDropEligible(int level) {
        int minLevelForDrop = this.plugin.getConfig().getInt("drop.min-level", 1);
        return level >= minLevelForDrop;
    }

    private Material getMeatType(EntityType type) {
        return switch (type) {
            case EntityType.PIG -> Material.PORKCHOP;
            case EntityType.COW -> Material.BEEF;
            case EntityType.SHEEP -> Material.MUTTON;
            case EntityType.CHICKEN -> Material.CHICKEN;
            default -> null;
        };
    }

    private int getRandomAmount() {
        int roll = this.random.nextInt(100);
        int cumulative = 0;
        for (int i = 0; i < this.dropChances.length; ++i) {
            if (roll >= (cumulative += this.dropChances[i])) continue;
            return i + 1;
        }
        return 1;
    }
}

