/*
 * Decompiled with CFR 0.152.
 */
package animalhunger.animalhunger;

import animalhunger.animalhunger.AnimalData;
import animalhunger.animalhunger.AnimalDataManager;
import animalhunger.animalhunger.AnimalHungerCrutch;
import animalhunger.animalhunger.AnimalHungerExpansion;
import animalhunger.animalhunger.AnimalRidingSystem;
import animalhunger.animalhunger.ColorSelectionGUI;
import animalhunger.animalhunger.CustomDropManager;
import animalhunger.animalhunger.DropChanceHandler;
import animalhunger.animalhunger.PluginCompatibility;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AnimalHunger
extends JavaPlugin
implements Listener {
    private ColorSelectionGUI colorSelectionGUI;
    private static final Logger LOGGER = Logger.getLogger("AnimalHunger");
    private static final String LAST_ANIMAL_META_KEY = "lastAnimal";
    private static final String RENAMING_ANIMAL_META_KEY = "renamingAnimal";
    private static final int AUTO_SAVE_INTERVAL = 6000;
    private static final int RENAME_TIMEOUT_TICKS = 600;
    private static final double NEARBY_ENTITY_RADIUS = 20.0;
    private static final double NOTIFICATION_RADIUS = 10.0;
    private final Map<UUID, Long> breedingCooldowns = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, UUID> breedingPairs = new ConcurrentHashMap<UUID, UUID>();
    private static final long BREEDING_COOLDOWN = 300000L;
    private static final int MIN_BREEDING_LEVEL = 6;
    private static final int MAX_NAME_LENGTH = 20;
    private static final int HUNGER_BAR_LENGTH = 10;
    private AnimalRidingSystem animalRidingSystem;
    private PluginCompatibility compatibility;
    private AnimalDataManager animalDataManager;
    private CustomDropManager customDropManager;
    private final Map<UUID, AnimalData> animalDataCache = new ConcurrentHashMap<UUID, AnimalData>();
    private final Map<Integer, UUID> animalIdMap = new ConcurrentHashMap<Integer, UUID>();
    private final Random random = new Random();
    private FileConfiguration config;
    private FileConfiguration messages;
    private FileConfiguration dataBase;
    private File dataBaseFile;
    private long lastResourceCheck = 0L;
    private int resourceCheckInterval = 6000;
    private int totalTicksProcessed = 0;
    private int totalAnimalsProcessed = 0;
    private int totalDataSaves = 0;
    private int totalGUIOpens = 0;
    private int totalFeedingActions = 0;
    private int totalKillActions = 0;
    private int totalUpgradeActions = 0;
    private int totalCollectActions = 0;
    private int totalBondDecays = 0;
    private int totalAnimalDeaths = 0;
    private int totalAnimalBirths = 0;
    private int totalParticlesSpawned = 0;
    private int totalSoundsPlayed = 0;
    private AnimalHungerCrutch crutch;
    private DropChanceHandler dropHandler;
    private boolean disableVanillaMilking;
    private boolean isMilkingEnabled;
    private List<String> milkableAnimals;
    private List<String> vanillaMilkableAnimals;
    private String milkingResultItem;
    private double milkingChance;
    private String milkingSuccessMessage;
    private String milkingNotMilkableMessage;
    private int nextAnimalId;
    private int hungerDecreaseInterval;
    private int hungerRestoreAmount;
    private int maxHungerCap;
    private int maxLevel;
    private int feedingsPerLevel;
    private int upgradeCost;
    private boolean disableRiding;
    private boolean disableResourceCollection;
    private String language;
    private boolean enableParticles;
    private boolean debug;
    private boolean bondDecayEnabled;
    private int bondDecayRate;
    private long bondDecayInterval;
    private Material feedItem;
    private Material upgradeItem;

    public void onEnable() {
        if (!this.getServer().getPluginManager().isPluginEnabled("ProtocolLib")) {
            LOGGER.severe("ProtocolLib is not installed or enabled! AnimalHunger requires ProtocolLib to function.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (!this.initializePlugin()) {
            LOGGER.severe("Failed to initialize AnimalHunger plugin!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (this.animalRidingSystem == null) {
            this.animalRidingSystem = new AnimalRidingSystem(this, this.animalDataCache);
        }
        if (this.animalDataManager == null) {
            this.animalDataManager = new AnimalDataManager(this);
        }
        this.getServer().getPluginManager().registerEvents((Listener)this.animalRidingSystem, (Plugin)this);
        this.startScheduledTasks();
        this.registerPlaceholderAPI();
        String messageKey = "&e[AnimalHunger] &7You are using the PAID version of the plugin, thank you for your support!";
        String message = this.messages.getString(this.language + "." + messageKey, "&e[AnimalHunger] &7You are using the PAID version of the plugin, thank you for your support!");
        String coloredMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        TextComponent clickableMessage = new TextComponent(coloredMessage);
        clickableMessage.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://patreon.com/msL244"));
        clickableMessage.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Click to visit Patreon!").create()));
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission("animalhunger.admin")) continue;
            player.spigot().sendMessage((BaseComponent)clickableMessage);
        }
        LOGGER.info("AnimalHunger plugin enabled successfully.");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("animalhunger.admin")) {
            String messageKey = "free_version_notice";
            String message = this.messages.getString(this.language + "." + messageKey, "&e[AnimalHunger] &7This is the free version of the plugin! Unlock the full version at &b&npatreon.com/msL244&7!");
            String coloredMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
            TextComponent clickableMessage = new TextComponent(coloredMessage);
            clickableMessage.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://patreon.com/msL244"));
            clickableMessage.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Click to visit Patreon!").create()));
            player.spigot().sendMessage((BaseComponent)clickableMessage);
        }
    }

    public PluginCompatibility getCompatibility() {
        return this.compatibility;
    }

    public CustomDropManager getCustomDropManager() {
        return this.customDropManager;
    }

    private boolean initializePlugin() {
        try {
            this.saveDefaultConfig();
            this.config = this.getConfig();
            this.loadMessages();
            this.setupDataBase();
            this.loadConfigValues();
            this.animalDataManager = new AnimalDataManager(this);
            this.compatibility = new PluginCompatibility(this);
            this.customDropManager = new CustomDropManager(this, this.compatibility);
            if (this.compatibility == null || this.animalDataManager == null || this.customDropManager == null) {
                LOGGER.severe("Failed to initialize critical components!");
                return false;
            }
            this.loadAllAnimalData();
            this.nextAnimalId = this.dataBase.getInt("nextAnimalId", 0);
            try {
                this.crutch = new AnimalHungerCrutch(this);
                this.dropHandler = new DropChanceHandler(this);
                this.colorSelectionGUI = new ColorSelectionGUI(this);
            }
            catch (Exception e) {
                LOGGER.warning("Some helper components failed to initialize: " + e.getMessage());
            }
            this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
            this.initializeExistingAnimals();
            this.logDebug("Plugin initialized successfully");
            return true;
        }
        catch (Exception e) {
            LOGGER.severe("Critical error during plugin initialization: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private void initializeExistingAnimals() {
        int initializedCount = 0;
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                Animals animal;
                if (!(entity instanceof Animals) || !this.compatibility.isSupportedEntity((Entity)(animal = (Animals)entity))) continue;
                UUID animalId = animal.getUniqueId();
                if (!this.animalDataCache.containsKey(animalId)) {
                    int defaultHunger = this.config.getInt("default_values.hunger", 10);
                    int defaultMaxHunger = this.config.getInt("default_values.max_hunger", 10);
                    int defaultLevel = this.config.getInt("default_values.level", 1);
                    int defaultBond = this.config.getInt("default_values.bond", 0);
                    int defaultResources = this.config.getInt("default_values.resources", 0);
                    int defaultFeedCount = this.config.getInt("default_values.feed_count", 0);
                    AnimalData data = new AnimalData(defaultHunger, defaultMaxHunger, defaultLevel, defaultBond, defaultResources, defaultFeedCount);
                    this.animalDataCache.put(animalId, data);
                    this.updateHungerDisplay(animal, data);
                    ++initializedCount;
                    this.logDebug("Initialized existing animal: " + animal.getType() + " (UUID: " + animalId + ")");
                    continue;
                }
                AnimalData existingData = this.animalDataCache.get(animalId);
                this.updateHungerDisplay(animal, existingData);
            }
        }
        if (initializedCount > 0) {
            LOGGER.info("Initialized " + initializedCount + " existing animals on server startup.");
        }
        this.logDebug("Existing animals initialization completed. Total animals in cache: " + this.animalDataCache.size());
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Animals)) {
            return;
        }
        Animals animal = (Animals)livingEntity;
        if (!this.compatibility.isSupportedEntity((Entity)animal)) {
            return;
        }
        UUID animalId = animal.getUniqueId();
        if (!this.animalDataCache.containsKey(animalId)) {
            int defaultHunger = this.config.getInt("default_values.hunger", 10);
            int defaultMaxHunger = this.config.getInt("default_values.max_hunger", 10);
            int defaultLevel = this.config.getInt("default_values.level", 1);
            int defaultBond = this.config.getInt("default_values.bond", 0);
            int defaultResources = this.config.getInt("default_values.resources", 0);
            int defaultFeedCount = this.config.getInt("default_values.feed_count", 0);
            AnimalData data = new AnimalData(defaultHunger, defaultMaxHunger, defaultLevel, defaultBond, defaultResources, defaultFeedCount);
            this.animalDataCache.put(animalId, data);
            this.updateHungerDisplay(animal, data);
            this.logDebug("Created data for newly spawned animal: " + animal.getType() + " (UUID: " + animalId + ")");
        }
    }

    @EventHandler
    public void onPlayerInteractEntityVanillaMilk(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Animals)) {
            return;
        }
        Animals animal = (Animals)entity;
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand.getType() != Material.BUCKET) {
            return;
        }
        String animalTypeKey = animal.getType().name().toUpperCase();
        if (!this.vanillaMilkableAnimals.contains(animalTypeKey)) {
            return;
        }
        double chance = this.getConfig().getDouble("vanilla_milking.chance", 100.0);
        if (ThreadLocalRandom.current().nextDouble(100.0) >= chance) {
            String failureMsg = this.getConfig().getString("vanilla_milking.failure_message", "&cThe {animal_name} didn't give any milk this time.").replace("{animal_name}", this.getAnimalDisplayName(animal));
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)failureMsg));
            return;
        }
        ItemStack milkBucket = new ItemStack(Material.MILK_BUCKET);
        HashMap overflow = player.getInventory().addItem(new ItemStack[]{milkBucket});
        if (!overflow.isEmpty()) {
            for (ItemStack item : overflow.values()) {
                animal.getWorld().dropItemNaturally(animal.getLocation(), item);
            }
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&eYour inventory was full. Some items were dropped."));
        }
        if (itemInHand.getAmount() == 1) {
            player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
        } else {
            itemInHand.setAmount(itemInHand.getAmount() - 1);
        }
        Sound cowMilkSound = Sound.ENTITY_COW_MILK;
        if (cowMilkSound != null) {
            animal.getWorld().playSound(animal.getLocation(), cowMilkSound, 1.0f, 1.0f);
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onPlayerInteractEntityBlockVanillaMilk(PlayerInteractEntityEvent event) {
        if (!this.isVanillaMilkingDisabled()) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Animals)) {
            return;
        }
        Animals animal = (Animals)entity;
        if (animal.getType() != EntityType.COW && animal.getType() != EntityType.MUSHROOM_COW) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand.getType() != Material.BUCKET) {
            return;
        }
        event.setCancelled(true);
    }

    private void startScheduledTasks() {
        new BukkitRunnable(){

            public void run() {
                AnimalHunger.this.processAnimalTick();
            }
        }.runTaskTimer((Plugin)this, (long)this.hungerDecreaseInterval, (long)this.hungerDecreaseInterval);
        if (this.bondDecayEnabled) {
            new BukkitRunnable(){

                public void run() {
                    AnimalHunger.this.processBondDecay();
                }
            }.runTaskTimer((Plugin)this, this.bondDecayInterval, this.bondDecayInterval);
        }
        new BukkitRunnable(){

            public void run() {
                AnimalHunger.this.saveAllAnimalData();
            }
        }.runTaskTimer((Plugin)this, 6000L, 6000L);
        this.logDebug("Scheduled tasks started: Hunger processing (every " + this.hungerDecreaseInterval + " ticks), " + (String)(this.bondDecayEnabled ? "Bond decay (every " + this.bondDecayInterval + " ticks), " : "") + "Auto-save (every 6000 ticks)");
    }

    private boolean validateGUIConfig() {
        String[] layouts = new String[]{"small", "medium", "large"};
        String[] itemTypes = new String[]{"level_display", "hunger_display", "bond_display", "name_display", "feed_action", "kill_action", "upgrade_action", "collect_action"};
        for (String layout : layouts) {
            if (this.config.contains("gui.layouts." + layout + ".info_slots") && this.config.contains("gui.layouts." + layout + ".action_slots") && this.config.contains("gui.layouts." + layout + ".decoration_border")) continue;
            LOGGER.warning("Missing layout configuration for: " + layout);
            return false;
        }
        for (String itemType : itemTypes) {
            if (!(this.config.contains("gui.items." + itemType + ".material") && this.config.contains("gui.items." + itemType + ".display") && this.config.contains("gui.items." + itemType + ".lore"))) {
                LOGGER.warning("Missing item configuration for: " + itemType);
                return false;
            }
            for (String layout : layouts) {
                if (this.config.contains("gui.items." + itemType + ".positions." + layout)) continue;
                LOGGER.warning("Missing position for item " + itemType + " in layout " + layout);
                return false;
            }
        }
        return true;
    }

    private void registerPlaceholderAPI() {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new AnimalHungerExpansion(this).register();
            LOGGER.info("PlaceholderAPI support enabled.");
        }
    }

    private void handleAnimalDeath(Animals animal, UUID animalId) {
        animal.remove();
        this.notifyNearbyPlayers(animal, "animal_died");
        this.saveAnimalData(animalId);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String cmdName = command.getName().toLowerCase();
        if (cmdName.equals("animalhunger")) {
            if (args.length == 0) {
                sender.sendMessage(this.getMessage(sender, "plugin_active"));
                return true;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                if (!sender.hasPermission("animalhunger.reload")) {
                    sender.sendMessage(this.getMessage(sender, "no_permission"));
                    return true;
                }
                this.reloadPlugin(sender);
                return true;
            }
            if (args[0].equalsIgnoreCase("debug") && sender instanceof Player) {
                Player player = (Player)sender;
                Animals animal = this.getAnimalFromMetadata(player);
                if (animal == null) {
                    player.sendMessage(ChatColor.RED + "No valid animal in metadata.");
                    return true;
                }
                AnimalData data = this.getAnimalData(animal.getUniqueId());
                player.sendMessage(ChatColor.GREEN + "Animal: " + animal.getType() + " (UUID: " + animal.getUniqueId() + ")");
                player.sendMessage(ChatColor.GREEN + "Data: " + (String)(data != null ? "Hunger=" + data.getHunger() + "/" + data.getMaxHunger() + ", Level=" + data.getLevel() + ", Bond=" + data.getBondLevel() + "%, Resources=" + data.getResourceCount() + ", Name=" + (data.getCustomName() != null ? data.getCustomName() : "none") : "null"));
                if (data != null) {
                    boolean canBreed = data.getLevel() >= 6;
                    Long lastBreeding = this.breedingCooldowns.get(animal.getUniqueId());
                    boolean onCooldown = lastBreeding != null && System.currentTimeMillis() - lastBreeding < 300000L;
                    player.sendMessage(ChatColor.GREEN + "Breeding: Level " + data.getLevel() + "/6 (min), " + (canBreed ? "\u2713" : "\u2717") + " Level OK, " + (onCooldown ? "\u2717 On cooldown" : "\u2713 Ready"));
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("resources") && sender.hasPermission("animalhunger.admin")) {
                this.handleResourceCheckCommand(sender);
                return true;
            }
        }
        if (cmdName.equals("sp")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(ChatColor.RED + "This command can only be used by players!");
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("animalhunger.ride")) {
                player.sendMessage(this.getMessage((CommandSender)player, "no_permission"));
                return true;
            }
            this.handleSpCommand(player);
            return true;
        }
        return false;
    }

    private void handleResourceCheckCommand(CommandSender sender) {
        long currentTime = System.currentTimeMillis();
        double timeSinceLastCheck = (double)(currentTime - this.lastResourceCheck) / 1000.0;
        if (this.lastResourceCheck == 0L) {
            sender.sendMessage(ChatColor.GOLD + "[AnimalHunger] " + ChatColor.YELLOW + "First resource check. Starting monitoring...");
            this.lastResourceCheck = currentTime;
            return;
        }
        double avgTicksPerSecond = (double)this.totalTicksProcessed / timeSinceLastCheck;
        double avgAnimalsPerTick = (double)this.totalAnimalsProcessed / (double)this.totalTicksProcessed;
        double avgSavesPerSecond = (double)this.totalDataSaves / timeSinceLastCheck;
        double avgGUIPerSecond = (double)this.totalGUIOpens / timeSinceLastCheck;
        double avgFeedingPerSecond = (double)this.totalFeedingActions / timeSinceLastCheck;
        double avgKillPerSecond = (double)this.totalKillActions / timeSinceLastCheck;
        double avgUpgradePerSecond = (double)this.totalUpgradeActions / timeSinceLastCheck;
        double avgCollectPerSecond = (double)this.totalCollectActions / timeSinceLastCheck;
        double avgBondDecayPerSecond = (double)this.totalBondDecays / timeSinceLastCheck;
        double avgDeathPerSecond = (double)this.totalAnimalDeaths / timeSinceLastCheck;
        double avgBirthPerSecond = (double)this.totalAnimalBirths / timeSinceLastCheck;
        double avgParticlesPerSecond = (double)this.totalParticlesSpawned / timeSinceLastCheck;
        double avgSoundsPerSecond = (double)this.totalSoundsPlayed / timeSinceLastCheck;
        sender.sendMessage(ChatColor.GOLD + "=== AnimalHunger Resource Usage Report ===");
        sender.sendMessage(ChatColor.AQUA + "Time since last check: " + ChatColor.WHITE + String.format("%.2f", timeSinceLastCheck) + " seconds");
        sender.sendMessage(ChatColor.AQUA + "Total ticks processed: " + ChatColor.WHITE + this.totalTicksProcessed);
        sender.sendMessage(ChatColor.AQUA + "Total animals processed: " + ChatColor.WHITE + this.totalAnimalsProcessed);
        sender.sendMessage(ChatColor.AQUA + "Total data saves: " + ChatColor.WHITE + this.totalDataSaves);
        sender.sendMessage(ChatColor.AQUA + "Total GUI opens: " + ChatColor.WHITE + this.totalGUIOpens);
        sender.sendMessage(ChatColor.AQUA + "Total feeding actions: " + ChatColor.WHITE + this.totalFeedingActions);
        sender.sendMessage(ChatColor.AQUA + "Total kill actions: " + ChatColor.WHITE + this.totalKillActions);
        sender.sendMessage(ChatColor.AQUA + "Total upgrade actions: " + ChatColor.WHITE + this.totalUpgradeActions);
        sender.sendMessage(ChatColor.AQUA + "Total collect actions: " + ChatColor.WHITE + this.totalCollectActions);
        sender.sendMessage(ChatColor.AQUA + "Total bond decays: " + ChatColor.WHITE + this.totalBondDecays);
        sender.sendMessage(ChatColor.AQUA + "Total animal deaths: " + ChatColor.WHITE + this.totalAnimalDeaths);
        sender.sendMessage(ChatColor.AQUA + "Total animal births: " + ChatColor.WHITE + this.totalAnimalBirths);
        sender.sendMessage(ChatColor.AQUA + "Total particles spawned: " + ChatColor.WHITE + this.totalParticlesSpawned);
        sender.sendMessage(ChatColor.AQUA + "Total sounds played: " + ChatColor.WHITE + this.totalSoundsPlayed);
        sender.sendMessage(ChatColor.GOLD + "--- Averages per second ---");
        sender.sendMessage(ChatColor.YELLOW + "Ticks processed: " + ChatColor.WHITE + String.format("%.2f", avgTicksPerSecond));
        sender.sendMessage(ChatColor.YELLOW + "Animals processed: " + ChatColor.WHITE + String.format("%.2f", avgAnimalsPerTick));
        sender.sendMessage(ChatColor.YELLOW + "Data saves: " + ChatColor.WHITE + String.format("%.2f", avgSavesPerSecond));
        sender.sendMessage(ChatColor.YELLOW + "GUI opens: " + ChatColor.WHITE + String.format("%.2f", avgGUIPerSecond));
        sender.sendMessage(ChatColor.YELLOW + "Feeding actions: " + ChatColor.WHITE + String.format("%.2f", avgFeedingPerSecond));
        sender.sendMessage(ChatColor.YELLOW + "Kill actions: " + ChatColor.WHITE + String.format("%.2f", avgKillPerSecond));
        sender.sendMessage(ChatColor.YELLOW + "Upgrade actions: " + ChatColor.WHITE + String.format("%.2f", avgUpgradePerSecond));
        sender.sendMessage(ChatColor.YELLOW + "Collect actions: " + ChatColor.WHITE + String.format("%.2f", avgCollectPerSecond));
        sender.sendMessage(ChatColor.YELLOW + "Bond decays: " + ChatColor.WHITE + String.format("%.2f", avgBondDecayPerSecond));
        sender.sendMessage(ChatColor.YELLOW + "Animal deaths: " + ChatColor.WHITE + String.format("%.2f", avgDeathPerSecond));
        sender.sendMessage(ChatColor.YELLOW + "Animal births: " + ChatColor.WHITE + String.format("%.2f", avgBirthPerSecond));
        sender.sendMessage(ChatColor.YELLOW + "Particles spawned: " + ChatColor.WHITE + String.format("%.2f", avgParticlesPerSecond));
        sender.sendMessage(ChatColor.YELLOW + "Sounds played: " + ChatColor.WHITE + String.format("%.2f", avgSoundsPerSecond));
        this.lastResourceCheck = currentTime;
    }

    private void resetResourceStats() {
        this.totalTicksProcessed = 0;
        this.totalAnimalsProcessed = 0;
        this.totalDataSaves = 0;
        this.totalGUIOpens = 0;
        this.totalFeedingActions = 0;
        this.totalKillActions = 0;
        this.totalUpgradeActions = 0;
        this.totalCollectActions = 0;
        this.totalBondDecays = 0;
        this.totalAnimalDeaths = 0;
        this.totalAnimalBirths = 0;
        this.totalParticlesSpawned = 0;
        this.totalSoundsPlayed = 0;
        this.lastResourceCheck = System.currentTimeMillis();
    }

    private void processAnimalTick() {
        ++this.totalTicksProcessed;
        this.animalDataCache.entrySet().removeIf(entry -> {
            Animals animal;
            AnimalData data;
            UUID animalId;
            block7: {
                block6: {
                    animalId = (UUID)entry.getKey();
                    data = (AnimalData)entry.getValue();
                    ++this.totalAnimalsProcessed;
                    Entity entity = Bukkit.getEntity((UUID)animalId);
                    if (!(entity instanceof Animals)) break block6;
                    animal = (Animals)entity;
                    if (entity.isValid()) break block7;
                }
                this.saveAnimalData(animalId);
                ++this.totalDataSaves;
                return true;
            }
            data.setHunger(Math.max(data.getHunger() - 1, 0));
            int starvingBondLoss = this.config.getInt("bond.starving-bond-loss", 2);
            if (data.getHunger() <= 2) {
                data.setBondLevel(Math.max(data.getBondLevel() - starvingBondLoss, 0));
            }
            int resourceThreshold = this.config.getInt("bond.thresholds.resource-production", 50);
            if (data.getBondLevel() >= resourceThreshold && this.random.nextDouble() < this.getProductionChance(data)) {
                data.incrementResourceCount();
            }
            this.updateHungerDisplay(animal, data);
            if (data.getHunger() <= 0) {
                this.handleAnimalDeath(animal, animalId);
                ++this.totalAnimalDeaths;
                return true;
            }
            return false;
        });
    }

    private void processBondDecay() {
        this.animalDataCache.forEach((animalId, data) -> {
            Entity entity = Bukkit.getEntity((UUID)animalId);
            if (entity instanceof Animals && entity.isValid()) {
                data.setBondLevel(Math.max(0, data.getBondLevel() - this.bondDecayRate));
                ++this.totalBondDecays;
            }
        });
    }

    private void handleSpCommand(Player player) {
        Animals closestAnimal = null;
        double closestDistance = 5.0;
        for (Entity entity : player.getNearbyEntities(5.0, 5.0, 5.0)) {
            AnimalData data;
            double distance;
            Animals animal;
            if (!(entity instanceof Animals) || !this.isSupportedAnimal((Entity)(animal = (Animals)entity)) || !((distance = player.getLocation().distance(animal.getLocation())) < closestDistance) || (data = this.getAnimalData(animal.getUniqueId())) == null || data.getLevel() < 6) continue;
            closestAnimal = animal;
            closestDistance = distance;
        }
        if (closestAnimal == null) {
            player.sendMessage(ChatColor.RED + "no_rideable_animal_nearby");
            return;
        }
        if (closestAnimal.getPassengers().size() > 0) {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_already_ridden"));
            return;
        }
        AnimalData data = this.getAnimalData(closestAnimal.getUniqueId());
        if (data.getHunger() < data.getMaxHunger() / 2) {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_too_hungry"));
            return;
        }
        this.animalRidingSystem.startRidingCommand(player, closestAnimal, data);
    }

    private void reloadPlugin(CommandSender sender) {
        this.reloadConfig();
        this.config = this.getConfig();
        this.loadMessages();
        this.loadConfigValues();
        sender.sendMessage(this.getMessage(sender, "config_reloaded"));
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        boolean hasEmptyHands;
        Entity entity;
        if (event.getHand() != EquipmentSlot.HAND || !((entity = event.getRightClicked()) instanceof Animals)) {
            return;
        }
        Animals animal = (Animals)entity;
        Player player = event.getPlayer();
        if (!this.compatibility.isSupportedEntity((Entity)animal)) {
            return;
        }
        if (!animal.isValid()) {
            this.logDebug("Attempted to interact with invalid animal: " + animal.getType() + " (UUID: " + animal.getUniqueId() + ")");
            return;
        }
        UUID animalId = animal.getUniqueId();
        AnimalData data = this.getOrCreateAnimalData(animalId);
        this.setLastAnimalMetadata(player, animal);
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        boolean bl = hasEmptyHands = itemInHand == null || itemInHand.getType() == Material.AIR;
        if (this.isVanillaMilkingDisabled() && itemInHand != null && itemInHand.getType() == Material.BUCKET && (animal.getType() == EntityType.COW || animal.getType() == EntityType.MUSHROOM_COW)) {
            event.setCancelled(true);
            this.logDebug("Cancelled vanilla milking for " + player.getName() + " with " + animal.getType());
            return;
        }
        if (player.isSneaking()) {
            event.setCancelled(true);
            this.openEnhancedAnimalGUI(player, animal);
        } else if (!hasEmptyHands && this.hasValidFeedItemForAnimal(player, animal)) {
            event.setCancelled(true);
            this.startFeedingProcess(player, animal, animalId, data);
        } else {
            boolean canRide;
            event.setCancelled(true);
            boolean bl2 = canRide = !this.isRidingDisabled() && data.getLevel() >= 6 && data.getHunger() >= data.getMaxHunger() / 2;
            if (canRide) {
                this.logDebug("Attempting to start riding for " + player.getName() + " on " + animal.getType());
                if (!animal.getPassengers().isEmpty()) {
                    player.sendMessage(this.getMessage((CommandSender)player, "animal_already_ridden"));
                    return;
                }
                this.animalRidingSystem.startRidingCommand(player, animal, data);
            } else if (this.hasValidFeedItemForAnimal(player, animal)) {
                String messageKey = this.isRidingDisabled() ? "ride_disabled" : (data.getLevel() < 6 ? "ride_level_too_low" : "ride_hunger_too_low");
                player.sendMessage(this.getMessage((CommandSender)player, messageKey).replace("{animal}", this.getAnimalDisplayName(animal)).replace("{required_level}", "6").replace("{level}", String.valueOf(data.getLevel())).replace("{hunger}", String.valueOf(data.getHunger())).replace("{max_hunger}", String.valueOf(data.getMaxHunger())));
            } else {
                String messageKey = this.isRidingDisabled() ? "ride_disabled" : (data.getLevel() < 6 ? "ride_level_too_low" : "ride_hunger_too_low");
                player.sendMessage(this.getMessage((CommandSender)player, messageKey).replace("{animal}", this.getAnimalDisplayName(animal)).replace("{required_level}", "6").replace("{level}", String.valueOf(data.getLevel())).replace("{hunger}", String.valueOf(data.getHunger())).replace("{max_hunger}", String.valueOf(data.getMaxHunger())));
            }
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (!this.isValidKillAttempt(event)) {
            return;
        }
        Animals animal = (Animals)event.getEntity();
        Player player = (Player)event.getDamager();
        if (event.getFinalDamage() >= animal.getHealth()) {
            event.setCancelled(true);
            this.handleAnimalKill(player, animal, false);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            this.logDebug("Inventory click by non-player entity: " + event.getWhoClicked());
            return;
        }
        Player player = (Player)humanEntity;
        String title = event.getView().getTitle();
        if (title.contains(ChatColor.DARK_PURPLE + "\u0412\u044b\u0431\u043e\u0440 \u0446\u0432\u0435\u0442\u0430 \u0438\u043c\u0435\u043d\u0438")) {
            this.colorSelectionGUI.handleColorSelection(event);
            return;
        }
        if (!this.isAnimalGUIClick(event)) {
            this.logDebug("Click outside Animal GUI, allowing default behavior: title=" + title);
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            this.logDebug("Clicked empty slot or null item in GUI: slot=" + event.getRawSlot());
            event.setCancelled(true);
            return;
        }
        Animals animal = this.getAnimalFromMetadata(player);
        if (animal == null || !animal.isValid()) {
            player.closeInventory();
            player.sendMessage(this.getMessage((CommandSender)player, "animal_not_found"));
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
            this.logDebug("No valid animal found in metadata for player: " + player.getName());
            return;
        }
        String layoutType = this.getGUILayoutType(event.getInventory().getSize());
        event.setCancelled(true);
        try {
            String action = this.getActionForSlot(event.getRawSlot(), layoutType);
            this.logDebug("Slot " + event.getRawSlot() + " clicked in layout " + layoutType + ", action: " + action);
            if (action != null && !action.isEmpty()) {
                this.logDebug("Processing GUI action: " + action + " for slot " + event.getRawSlot());
                this.handleGUIAction(player, animal, action, event.getRawSlot());
            } else {
                this.logDebug("No action defined for slot " + event.getRawSlot() + " in layout " + layoutType);
            }
        }
        catch (Exception e) {
            player.sendMessage(ChatColor.RED + "\u274c An error occurred while processing the action!");
            this.logDebug("GUI Click Error for player " + player.getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        final Player player = event.getPlayer();
        if (!player.hasMetadata(RENAMING_ANIMAL_META_KEY)) {
            return;
        }
        event.setCancelled(true);
        final String message = event.getMessage().trim();
        if (message.equalsIgnoreCase("cancel") || message.equalsIgnoreCase("\u043e\u0442\u043c\u0435\u043d\u0430")) {
            player.removeMetadata(RENAMING_ANIMAL_META_KEY, (Plugin)this);
            player.sendMessage(this.getMessage((CommandSender)player, "rename_cancelled"));
            return;
        }
        new BukkitRunnable(){

            public void run() {
                AnimalHunger.this.handleAnimalRename(player, message);
            }
        }.runTask((Plugin)this);
    }

    private void handleAnimalRename(Player player, String newName) {
        if (!player.hasMetadata(RENAMING_ANIMAL_META_KEY)) {
            return;
        }
        Object metaValue = ((MetadataValue)player.getMetadata(RENAMING_ANIMAL_META_KEY).get(0)).value();
        player.removeMetadata(RENAMING_ANIMAL_META_KEY, (Plugin)this);
        if (!(metaValue instanceof Animals)) {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_not_found"));
            return;
        }
        Animals animal = (Animals)metaValue;
        UUID animalId = animal.getUniqueId();
        if (newName.length() > 20) {
            player.sendMessage(this.getMessage((CommandSender)player, "name_too_long"));
            return;
        }
        if (newName.isEmpty()) {
            player.sendMessage(this.getMessage((CommandSender)player, "name_empty"));
            return;
        }
        if (!this.isValidName(newName)) {
            player.sendMessage(ChatColor.RED + "error_name");
            return;
        }
        AnimalData data = this.getAnimalData(animalId);
        if (data == null) {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_not_found"));
            return;
        }
        if (!animal.isValid()) {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_not_found"));
            return;
        }
        data.setCustomName(newName);
        this.updateHungerDisplay(animal, data);
        this.saveAnimalData(animalId);
        player.sendMessage(this.getMessage((CommandSender)player, "animal_renamed").replace("{name}", newName));
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.2f);
        if (this.enableParticles) {
            animal.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, animal.getLocation().add(0.0, 1.0, 0.0), 10, 0.3, 0.3, 0.3, 0.0);
        }
    }

    private boolean isValidName(String name) {
        return name.matches("^[a-zA-Z\u0430-\u044f\u0410-\u042f0-9 _\\-!.]+$");
    }

    private boolean isAnimalGUIClick(InventoryClickEvent event) {
        String title = event.getView().getTitle();
        String smallTitle = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("gui.titles.small", "&6&l{animal_name} Care")).split(" ")[0];
        String mediumTitle = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("gui.titles.medium", "&6&l{animal_name} Management")).split(" ")[0];
        String largeTitle = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("gui.titles.large", "&6&l{animal_name} Sanctuary")).split(" ")[0];
        return title.contains(smallTitle) || title.contains(mediumTitle) || title.contains(largeTitle);
    }

    private String getActionForSlot(int slot, String layoutType) {
        String[] itemTypes;
        for (String itemType : itemTypes = new String[]{"level_display", "hunger_display", "bond_display", "name_display", "feed_action", "kill_action", "upgrade_action", "collect_action", "info_display", "name_color"}) {
            int configSlot = this.config.getInt("gui.items." + itemType + ".positions." + layoutType, -1);
            if (configSlot != slot) continue;
            return switch (itemType) {
                case "feed_action" -> "feed";
                case "kill_action" -> "kill";
                case "upgrade_action" -> "upgrade";
                case "collect_action" -> "collect";
                case "name_display" -> "rename";
                case "info_display" -> "info";
                case "name_color" -> "name_color";
                default -> null;
            };
        }
        Map<String, Map<String, Integer>> fallbackPositions = Map.of("small", Map.of("level_display", 11, "hunger_display", 12, "bond_display", 13, "name_display", 14, "feed_action", 19, "kill_action", 21, "upgrade_action", 23, "collect_action", 20, "info_display", 22, "name_color", 15), "medium", Map.of("level_display", 11, "hunger_display", 12, "bond_display", 13, "name_display", 14, "feed_action", 29, "kill_action", 31, "upgrade_action", 33, "collect_action", 30, "info_display", 32, "name_color", 15), "large", Map.of("level_display", 12, "hunger_display", 13, "bond_display", 14, "name_display", 15, "feed_action", 29, "kill_action", 31, "upgrade_action", 33, "collect_action", 30, "info_display", 32, "name_color", 16));
        Map<String, Integer> positions = fallbackPositions.getOrDefault(layoutType, fallbackPositions.get("large"));
        for (Map.Entry<String, Integer> entry : positions.entrySet()) {
            String itemType;
            if (entry.getValue() != slot) continue;
            return switch (itemType = entry.getKey()) {
                case "feed_action" -> "feed";
                case "kill_action" -> "kill";
                case "upgrade_action" -> "upgrade";
                case "collect_action" -> "collect";
                case "name_display" -> "rename";
                case "info_display" -> "info";
                case "name_color" -> "name_color";
                default -> null;
            };
        }
        return null;
    }

    private void upgradeAnimal(final Player player, final Animals animal, UUID animalId, AnimalData data) {
        if (data.getLevel() >= this.maxLevel) {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_already_max_level").replace("{animal}", this.getAnimalDisplayName(animal)));
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
            return;
        }
        ItemStack costItem = new ItemStack(this.upgradeItem, this.upgradeCost);
        if (!player.getInventory().containsAtLeast(costItem, this.upgradeCost)) {
            player.sendMessage(this.getMessage((CommandSender)player, "not_enough_resources").replace("{cost}", String.valueOf(this.upgradeCost)).replace("{upgrade_item}", this.upgradeItem.name().toLowerCase().replace("_", " ")));
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
            return;
        }
        int oldLevel = data.getLevel();
        int oldBond = data.getBondLevel();
        int oldMaxHunger = data.getMaxHunger();
        player.getInventory().removeItem(new ItemStack[]{costItem});
        data.setLevel(data.getLevel() + 1);
        data.setMaxHunger(Math.min(data.getMaxHunger() + 2, this.maxHungerCap));
        int upgradeBondGain = this.config.getInt("bond.upgrade-bond-gain", 10);
        data.setBondLevel(Math.min(data.getBondLevel() + upgradeBondGain, 100));
        data.setFeedCount(0);
        if (data.getLevel() >= 2 && !this.animalIdMap.containsValue(animalId)) {
            this.animalIdMap.put(this.nextAnimalId, animalId);
            this.logDebug("Assigned Id " + this.nextAnimalId + " to UUID " + animalId + " via upgrade");
            ++this.nextAnimalId;
        }
        this.updateHungerDisplay(animal, data);
        this.saveAnimalData(animalId);
        player.sendMessage(this.getMessage((CommandSender)player, "animal_upgraded").replace("{level}", String.valueOf(data.getLevel())).replace("{animal}", this.getAnimalDisplayName(animal)));
        player.sendMessage(this.getMessage((CommandSender)player, "upgrade_level_change").replace("{old_level}", String.valueOf(oldLevel)).replace("{new_level}", String.valueOf(data.getLevel())));
        player.sendMessage(this.getMessage((CommandSender)player, "upgrade_max_hunger_change").replace("{old_max_hunger}", String.valueOf(oldMaxHunger)).replace("{new_max_hunger}", String.valueOf(data.getMaxHunger())));
        player.sendMessage(this.getMessage((CommandSender)player, "upgrade_bond_change").replace("{old_bond}", String.valueOf(oldBond)).replace("{new_bond}", String.valueOf(data.getBondLevel())));
        player.playSound(animal.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
        if (this.enableParticles && this.config.getBoolean("gui.animations.level_up_effect", true)) {
            animal.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, animal.getLocation().add(0.0, 1.0, 0.0), 20, 0.7, 0.7, 0.7, 0.1);
            animal.getWorld().spawnParticle(Particle.FIREWORKS_SPARK, animal.getLocation().add(0.0, 1.0, 0.0), 15, 0.5, 0.5, 0.5, 0.05);
        }
        player.closeInventory();
        new BukkitRunnable(){

            public void run() {
                if (player.isOnline() && animal.isValid()) {
                    AnimalHunger.this.openEnhancedAnimalGUI(player, animal);
                }
            }
        }.runTaskLater((Plugin)this, 1L);
    }

    private void openEnhancedAnimalGUI(Player player, Animals animal) {
        ++this.totalGUIOpens;
        if (!animal.isValid()) {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_not_found"));
            this.logDebug("Attempted to open GUI for invalid animal: " + animal.getType() + " (" + animal.getUniqueId() + ")");
            return;
        }
        try {
            UUID animalId = animal.getUniqueId();
            AnimalData data = this.getOrCreateAnimalData(animalId);
            int guiSize = this.getGUISize(animal);
            String layoutType = this.getGUILayoutType(guiSize);
            String title = this.getGUITitle(animal, layoutType);
            Inventory gui = Bukkit.createInventory(null, (int)guiSize, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)title));
            double bondMultiplier = this.calculateBondMultiplier(data.getBondLevel());
            int resourceThreshold = this.config.getInt("bond.thresholds.resource-production", 40);
            String animalType = animal.getType().name().toLowerCase();
            List feedItemsList = this.config.getStringList("animals." + animalType + ".feed_items");
            String feedItems = feedItemsList.isEmpty() ? "none" : String.join((CharSequence)", ", feedItemsList);
            List resourceItemsList = this.config.getStringList("animals." + animalType + ".resource_items");
            String resourceType = resourceItemsList.isEmpty() ? "NONE" : (String)resourceItemsList.get(0);
            int hungerPercent = (int)((double)data.getHunger() / (double)data.getMaxHunger() * 100.0);
            int nextThreshold = this.getNextBondThreshold(data.getBondLevel());
            String bondEffects = this.getBondEffects(data.getBondLevel());
            this.populateEnhancedGUIItems(gui, animal, data, layoutType, bondMultiplier, resourceThreshold, feedItems, resourceType, hungerPercent, nextThreshold, bondEffects);
            this.logDebug("Resource threshold set to: " + resourceThreshold + "% for animal: " + animal.getType());
            this.populateEnhancedGUIDecoration(gui, layoutType);
            this.addSpecialDecorations(gui, layoutType, data);
            player.openInventory(gui);
            this.setLastAnimalMetadata(player, animal);
            if (this.enableParticles && this.config.getBoolean("gui.animations.enabled", true) && this.config.getBoolean("gui.animations.gui_open_sound", true)) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.2f);
                if (this.config.getBoolean("gui.animations.level_up_effect", true)) {
                    animal.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, animal.getLocation().add(0.0, 1.0, 0.0), 15, 0.5, 0.5, 0.5, 0.1);
                }
            }
            this.logDebug("Opened GUI for player " + player.getName() + ", animal: " + animal.getType() + ", layout: " + layoutType + ", size: " + guiSize);
        }
        catch (Exception e) {
            player.sendMessage(ChatColor.RED + "\u274c \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u0438 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430: " + e.getMessage());
            this.logDebug("GUI Opening Error for player " + player.getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void addSpecialDecorations(Inventory gui, String layoutType, AnimalData data) {
        int[] cornerSlots;
        String decorKey;
        Material decorMaterial;
        if (data.getBondLevel() >= 75) {
            decorMaterial = Material.GOLD_BLOCK;
            decorKey = "decoration_gold";
        } else if (data.getBondLevel() >= 50) {
            decorMaterial = Material.IRON_BLOCK;
            decorKey = "decoration_silver";
        } else if (data.getBondLevel() >= 25) {
            decorMaterial = Material.COPPER_BLOCK;
            decorKey = "decoration_bronze";
        } else {
            decorMaterial = Material.COBBLESTONE;
            decorKey = "decoration_base";
        }
        for (int slot : cornerSlots = this.getCornerSlots(layoutType)) {
            if (slot >= gui.getSize()) continue;
            ItemStack decorItem = new ItemStack(decorMaterial);
            ItemMeta meta = decorItem.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(this.getMessage(null, decorKey));
                meta.setLore(Arrays.asList(this.getMessage(null, "decoration_bond_level").replace("{bond}", String.valueOf(data.getBondLevel())), this.getMessage(null, "decoration_bond_status").replace("{status}", this.getBondStatus(data.getBondLevel()))));
                decorItem.setItemMeta(meta);
                meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this, "non_pickup"), PersistentDataType.BYTE, (Object)1);
                decorItem.setItemMeta(meta);
            }
            gui.setItem(slot, decorItem);
        }
    }

    private int[] getCornerSlots(String layoutType) {
        int[] nArray;
        switch (layoutType) {
            case "small": {
                int[] nArray2 = new int[4];
                nArray2[0] = 0;
                nArray2[1] = 8;
                nArray2[2] = 18;
                nArray = nArray2;
                nArray2[3] = 26;
                break;
            }
            case "medium": {
                int[] nArray3 = new int[4];
                nArray3[0] = 0;
                nArray3[1] = 8;
                nArray3[2] = 36;
                nArray = nArray3;
                nArray3[3] = 44;
                break;
            }
            default: {
                int[] nArray4 = new int[4];
                nArray4[0] = 0;
                nArray4[1] = 8;
                nArray4[2] = 45;
                nArray = nArray4;
                nArray4[3] = 53;
            }
        }
        return nArray;
    }

    private ChatColor getBondStatusColor(int bondLevel) {
        if (bondLevel >= 75) {
            return ChatColor.GOLD;
        }
        if (bondLevel >= 50) {
            return ChatColor.GREEN;
        }
        if (bondLevel >= 25) {
            return ChatColor.YELLOW;
        }
        return ChatColor.RED;
    }

    private String getBondStatus(int bondLevel) {
        if (bondLevel >= 75) {
            return this.getMessage(null, "bond_status_legendary");
        }
        if (bondLevel >= 50) {
            return this.getMessage(null, "bond_status_strong");
        }
        if (bondLevel >= 25) {
            return this.getMessage(null, "bond_status_moderate");
        }
        return this.getMessage(null, "bond_status_weak");
    }

    private void populateEnhancedGUIDecoration(Inventory gui, String layoutType) {
        List borderSlots = this.config.getIntegerList("gui.layouts." + layoutType + ".decoration_border");
        Material[] gradientMaterials = new Material[]{Material.PURPLE_STAINED_GLASS_PANE, Material.MAGENTA_STAINED_GLASS_PANE, Material.PINK_STAINED_GLASS_PANE, Material.LIGHT_BLUE_STAINED_GLASS_PANE};
        for (int i = 0; i < borderSlots.size(); ++i) {
            int slot = (Integer)borderSlots.get(i);
            if (slot >= gui.getSize()) continue;
            Material material = gradientMaterials[i % gradientMaterials.length];
            ItemStack decorItem = new ItemStack(material);
            ItemMeta meta = decorItem.getItemMeta();
            if (meta != null) {
                meta.setDisplayName("" + ChatColor.RESET);
                decorItem.setItemMeta(meta);
            }
            gui.setItem(slot, decorItem);
        }
    }

    private ItemStack createEnhancedGUIItem(Animals animal, AnimalData data, String itemType) {
        List lore;
        String animalType = animal.getType().name().toLowerCase();
        String materialName = this.config.getString("gui.items." + itemType + ".material", "STONE");
        Material material = this.getMaterialSafely(materialName, Material.STONE);
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            this.logDebug("Failed to get ItemMeta for item type: " + itemType);
            return item;
        }
        String display = this.config.getString("gui.items." + itemType + ".display", itemType);
        display = this.addAnimatedElements(display, data);
        meta.setDisplayName(this.processEnhancedPlaceholders(display, animal, data));
        if (this.config.contains("gui.items." + itemType + ".customModelData")) {
            meta.setCustomModelData(Integer.valueOf(this.config.getInt("gui.items." + itemType + ".customModelData")));
        }
        if ((lore = this.config.getStringList("gui.items." + itemType + ".lore")).isEmpty()) {
            lore.add(ChatColor.GRAY + "No lore defined for " + itemType);
            this.logDebug("No lore defined for GUI item: " + itemType);
        }
        List<String> processedLore = lore.stream().map(line -> this.processEnhancedPlaceholders((String)line, animal, data)).map(line -> this.addProgressBars((String)line, data)).collect(Collectors.toList());
        this.addDynamicLore(processedLore, itemType, data);
        meta.setLore(processedLore);
        if (this.shouldAddGlow(itemType, data)) {
            meta.addEnchant(Enchantment.DURABILITY, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        item.setItemMeta(meta);
        return item;
    }

    private String addAnimatedElements(String display, AnimalData data) {
        long time = System.currentTimeMillis() / 1000L;
        String[] animations = new String[]{"\u2726", "\u2727", "\u2605", "\u2606"};
        String currentAnim = animations[(int)(time % (long)animations.length)];
        return display.replace("\u2728", currentAnim);
    }

    private String addProgressBars(String line, AnimalData data) {
        if (line.contains("{hunger_bar}")) {
            String hungerBar = this.createProgressBar(data.getHunger(), data.getMaxHunger(), ChatColor.GREEN, ChatColor.RED, 20);
            return line.replace("{hunger_bar}", hungerBar);
        }
        if (line.contains("{bond_bar}")) {
            String bondBar = this.createProgressBar(data.getBondLevel(), 100, ChatColor.LIGHT_PURPLE, ChatColor.GRAY, 20);
            return line.replace("{bond_bar}", bondBar);
        }
        if (line.contains("{level_bar}")) {
            int maxLevel = this.config.getInt("max-level", 5);
            String levelBar = this.createProgressBar(data.getLevel(), maxLevel, ChatColor.GOLD, ChatColor.DARK_GRAY, 10);
            return line.replace("{level_bar}", levelBar);
        }
        return line;
    }

    private String createProgressBar(int current, int max, ChatColor fillColor, ChatColor emptyColor, int length) {
        int i;
        int filled = (int)((double)current / (double)max * (double)length);
        StringBuilder bar = new StringBuilder();
        bar.append(fillColor);
        for (i = 0; i < filled; ++i) {
            bar.append("\u2588");
        }
        bar.append(emptyColor);
        for (i = filled; i < length; ++i) {
            bar.append("\u2592");
        }
        bar.append(ChatColor.RESET);
        return bar.toString();
    }

    private void addDynamicLore(List<String> lore, String itemType, AnimalData data) {
        switch (itemType) {
            case "hunger_display": {
                lore.add("");
                lore.add(this.getMessage(null, "hunger_status"));
                lore.add(this.createProgressBar(data.getHunger(), data.getMaxHunger(), ChatColor.GREEN, ChatColor.RED, 15));
                break;
            }
            case "bond_display": {
                lore.add("");
                lore.add(this.getMessage(null, "bond_progress"));
                lore.add(this.createProgressBar(data.getBondLevel(), 100, ChatColor.LIGHT_PURPLE, ChatColor.GRAY, 15));
                int nextThreshold = this.getNextBondThreshold(data.getBondLevel());
                if (nextThreshold <= data.getBondLevel()) break;
                lore.add(this.getMessage(null, "bond_next_threshold").replace("{threshold}", String.valueOf(nextThreshold - data.getBondLevel())));
                break;
            }
            case "level_display": {
                int maxLevel = this.config.getInt("max-level", 5);
                if (data.getLevel() >= maxLevel) break;
                lore.add("");
                lore.add(this.getMessage(null, "level_progress"));
                int required = this.config.getInt("feedings-per-level", 5) * data.getLevel();
                lore.add(this.createProgressBar(data.getFeedCount(), required, ChatColor.GOLD, ChatColor.DARK_GRAY, 15));
            }
        }
    }

    private boolean shouldAddGlow(String itemType, AnimalData data) {
        return switch (itemType) {
            case "bond_display" -> {
                if (data.getBondLevel() >= 75) {
                    yield true;
                }
                yield false;
            }
            case "level_display" -> {
                if (data.getLevel() >= this.config.getInt("max-level", 5)) {
                    yield true;
                }
                yield false;
            }
            case "upgrade_action" -> {
                if (data.getLevel() < this.config.getInt("max-level", 5)) {
                    yield true;
                }
                yield false;
            }
            case "collect_action" -> {
                if (data.getResourceCount() > 0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private void handleGUIAction(final Player player, final Animals animal, String action, int slot) {
        if (!animal.isValid()) {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_not_found"));
            player.closeInventory();
            return;
        }
        UUID animalId = animal.getUniqueId();
        AnimalData data = this.getAnimalData(animalId);
        if (data == null) {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_not_found"));
            player.closeInventory();
            this.logDebug("Animal data not found for UUID: " + animalId);
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        this.logDebug("Processing GUI action: " + action + " for player " + player.getName() + ", animal: " + animal.getType());
        switch (action.toLowerCase()) {
            case "feed": {
                if (!player.hasPermission("animalhunger.feed")) {
                    player.sendMessage(this.getMessage((CommandSender)player, "no_permission"));
                    return;
                }
                this.feedAnimalInGUI(player, animal, animalId, data);
                new BukkitRunnable(){

                    public void run() {
                        if (player.isOnline() && animal.isValid()) {
                            AnimalHunger.this.openEnhancedAnimalGUI(player, animal);
                        }
                    }
                }.runTaskLater((Plugin)this, 1L);
                break;
            }
            case "name_color": {
                if (!player.hasPermission("animalhunger.rename")) {
                    player.sendMessage(this.getMessage((CommandSender)player, "no_permission"));
                    return;
                }
                this.colorSelectionGUI.openColorSelectionGUI(player, animal);
                break;
            }
            case "kill": {
                if (!player.hasPermission("animalhunger.kill")) {
                    player.sendMessage(this.getMessage((CommandSender)player, "no_permission"));
                    return;
                }
                int minKillLevel = this.config.getInt("kill.required-level", 2);
                if (data.getLevel() < minKillLevel) {
                    player.sendMessage(this.getMessage((CommandSender)player, "kill_level_required").replace("{level}", String.valueOf(minKillLevel)));
                    player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
                    return;
                }
                this.killAnimalDirectly(player, animal, animalId, data);
                break;
            }
            case "upgrade": {
                if (!player.hasPermission("animalhunger.upgrade")) {
                    player.sendMessage(this.getMessage((CommandSender)player, "no_permission"));
                    return;
                }
                if (data.getLevel() >= this.maxLevel) {
                    player.sendMessage(this.getMessage((CommandSender)player, "animal_already_max_level").replace("{animal}", this.getAnimalDisplayName(animal)));
                    player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
                    return;
                }
                this.upgradeAnimal(player, animal, animalId, data);
                break;
            }
            case "collect": {
                if (!player.hasPermission("animalhunger.collect")) {
                    player.sendMessage(this.getMessage((CommandSender)player, "no_permission"));
                    return;
                }
                if (this.isResourceCollectionDisabled()) {
                    player.sendMessage(ChatColor.RED + "Resource collection is disabled.");
                    player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
                    return;
                }
                int resourceThreshold = this.config.getInt("bond.thresholds.resource-production", 50);
                if (data.getBondLevel() >= resourceThreshold) {
                    this.collectResources(player, animal, animalId, data);
                    new BukkitRunnable(){

                        public void run() {
                            if (player.isOnline() && animal.isValid()) {
                                AnimalHunger.this.openEnhancedAnimalGUI(player, animal);
                            }
                        }
                    }.runTaskLater((Plugin)this, 1L);
                    break;
                }
                player.sendMessage(this.getMessage((CommandSender)player, "no_resources"));
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
                break;
            }
            case "rename": {
                if (!player.hasPermission("animalhunger.rename")) {
                    player.sendMessage(this.getMessage((CommandSender)player, "no_permission"));
                    return;
                }
                player.sendMessage(this.getMessage((CommandSender)player, "rename_instruction"));
                player.setMetadata(RENAMING_ANIMAL_META_KEY, (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)animal));
                player.closeInventory();
                new BukkitRunnable(){

                    public void run() {
                        if (player.hasMetadata(AnimalHunger.RENAMING_ANIMAL_META_KEY)) {
                            player.sendMessage(AnimalHunger.this.getMessage((CommandSender)player, "rename_cancelled"));
                            player.removeMetadata(AnimalHunger.RENAMING_ANIMAL_META_KEY, (Plugin)AnimalHunger.this);
                        }
                    }
                }.runTaskLater((Plugin)this, 600L);
                break;
            }
            case "info": {
                if (!player.hasPermission("animalhunger.info")) {
                    player.sendMessage(this.getMessage((CommandSender)player, "no_permission"));
                    return;
                }
                player.sendMessage(this.getMessage((CommandSender)player, "info_header").replace("{animal}", this.getAnimalDisplayName(animal)));
                player.sendMessage(this.getMessage((CommandSender)player, "info_level").replace("{level}", String.valueOf(data.getLevel())).replace("{max_level}", String.valueOf(this.maxLevel)));
                player.sendMessage(this.getMessage((CommandSender)player, "info_hunger").replace("{hunger}", String.valueOf(data.getHunger())).replace("{max_hunger}", String.valueOf(data.getMaxHunger())));
                player.sendMessage(this.getMessage((CommandSender)player, "info_bond").replace("{bond}", String.valueOf(data.getBondLevel())));
                player.sendMessage(this.getMessage((CommandSender)player, "info_resources").replace("{resources}", String.valueOf(data.getResourceCount())));
                player.sendMessage(this.getMessage((CommandSender)player, "info_feedings").replace("{feed_count}", String.valueOf(data.getFeedCount())));
                if (data.getCustomName() != null) {
                    player.sendMessage(this.getMessage((CommandSender)player, "info_name").replace("{name}", data.getCustomName()));
                }
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 1.0f);
                break;
            }
            default: {
                this.logDebug("Unknown GUI action: " + action);
            }
        }
    }

    private void killAnimalDirectly(Player player, Animals animal, UUID animalId, AnimalData data) {
        DropChanceHandler dropHandler = new DropChanceHandler(this);
        ItemStack drop = dropHandler.getDrop(animal, data, true);
        if (drop != null) {
            animal.getWorld().dropItemNaturally(animal.getLocation(), drop);
            player.sendMessage(this.getMessage((CommandSender)player, "animal_killed"));
        } else {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_killed_by_hand"));
        }
        this.removeAnimalData(animalId);
        animal.remove();
        player.closeInventory();
    }

    private void feedAnimalInGUI(Player player, Animals animal, UUID animalId, AnimalData data) {
        ItemStack item = player.getInventory().getItemInMainHand();
        String animalType = animal.getType().name().toLowerCase();
        List feedItems = this.config.getStringList("animals." + animalType + ".feed_items");
        if (item == null || item.getAmount() <= 0 || !feedItems.contains(item.getType().name())) {
            player.sendMessage(this.getMessage((CommandSender)player, "no_gui_feed_item"));
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
            return;
        }
        if (data.getHunger() >= data.getMaxHunger()) {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_already_full").replace("{animal}", this.getAnimalDisplayName(animal)));
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            return;
        }
        int hungerRestore = this.getFoodValue(item.getType(), animalType);
        item.setAmount(item.getAmount() - 1);
        int oldHunger = data.getHunger();
        int oldBond = data.getBondLevel();
        int feedingBondGain = this.config.getInt("bond.feeding-bond-gain", 5);
        data.setHunger(Math.min(data.getHunger() + hungerRestore, data.getMaxHunger()));
        data.setFeedCount(data.getFeedCount() + 1);
        data.setBondLevel(Math.min(data.getBondLevel() + feedingBondGain, 100));
        this.checkForBreeding(player, animal, animalId, data);
        boolean leveledUp = false;
        if (data.getFeedCount() >= this.feedingsPerLevel * data.getLevel() && data.getLevel() < this.maxLevel) {
            this.levelUpAnimal(player, animal, data, animalId);
            leveledUp = true;
        }
        this.updateHungerDisplay(animal, data);
        this.playFeedingEffects(animal);
        this.saveAnimalData(animalId);
        player.sendMessage(this.getMessage((CommandSender)player, "gui_fed_animal").replace("{animal}", this.getAnimalDisplayName(animal)).replace("{hunger}", String.valueOf(data.getHunger())).replace("{max_hunger}", String.valueOf(data.getMaxHunger())).replace("{bond}", String.valueOf(data.getBondLevel())).replace("{food_value}", String.valueOf(hungerRestore)));
        if (leveledUp) {
            player.sendMessage(this.getMessage((CommandSender)player, "level_up").replace("{level}", String.valueOf(data.getLevel())));
        }
    }

    private int getFoodValue(Material foodType, String animalType) {
        String configPath = "animals." + animalType + ".food_values." + foodType.name();
        if (this.config.contains(configPath)) {
            return this.config.getInt(configPath);
        }
        switch (foodType) {
            case HAY_BLOCK: {
                return this.config.getInt("food-values.hay_block", 5);
            }
            case WHEAT: {
                return this.config.getInt("food-values.wheat", 1);
            }
            case GOLDEN_CARROT: {
                return this.config.getInt("food-values.golden_carrot", 3);
            }
            case CARROT: {
                return this.config.getInt("food-values.carrot", 2);
            }
            case POTATO: {
                return this.config.getInt("food-values.potato", 2);
            }
            case BEETROOT: {
                return this.config.getInt("food-values.beetroot", 1);
            }
            case APPLE: {
                return this.config.getInt("food-values.apple", 2);
            }
        }
        return this.config.getInt("hunger-restore-amount", 1);
    }

    private void checkForBreeding(Player player, Animals animal, UUID animalId, AnimalData data) {
        UUID partnerId;
        AnimalData partnerData;
        Animals partner;
        if (data.getLevel() < 6) {
            return;
        }
        if (this.breedingCooldowns.containsKey(animalId)) {
            long lastBreeding = this.breedingCooldowns.get(animalId);
            if (System.currentTimeMillis() - lastBreeding < 300000L) {
                return;
            }
        }
        if ((partner = this.findBreedingPartner(animal, animalId)) != null && (partnerData = this.getAnimalData(partnerId = partner.getUniqueId())) != null && this.canBreed(partnerData, partnerId)) {
            this.performBreeding(player, animal, partner, animalId, partnerId, data, partnerData);
        }
    }

    private void performBreeding(Player player, Animals parent1, Animals parent2, UUID parent1Id, UUID parent2Id, AnimalData data1, AnimalData data2) {
        long currentTime = System.currentTimeMillis();
        this.breedingCooldowns.put(parent1Id, currentTime);
        this.breedingCooldowns.put(parent2Id, currentTime);
        Animals baby = (Animals)parent1.getWorld().spawnEntity(parent1.getLocation().add(0.5, 0.0, 0.5), parent1.getType());
        ++this.totalAnimalBirths;
        if (baby instanceof Ageable) {
            baby.setBaby();
        }
        UUID babyId = baby.getUniqueId();
        int inheritedLevel = Math.max(1, (data1.getLevel() + data2.getLevel()) / 3);
        int inheritedMaxHunger = Math.min((data1.getMaxHunger() + data2.getMaxHunger()) / 2, this.maxHungerCap);
        int inheritedBond = (data1.getBondLevel() + data2.getBondLevel()) / 4;
        AnimalData babyData = new AnimalData(inheritedMaxHunger, inheritedMaxHunger, inheritedLevel, 0, inheritedBond, 0);
        this.setAnimalData(babyId, babyData);
        this.playBreedingEffects(parent1, parent2, baby);
        player.sendMessage(this.getMessage((CommandSender)player, "breeding_success").replace("{animal}", this.getAnimalDisplayName(parent1)).replace("{baby_level}", String.valueOf(inheritedLevel)).replace("{baby_bond}", String.valueOf(inheritedBond)));
        player.giveExp(this.random.nextInt(7) + 1);
        this.saveAnimalData(babyId);
        this.logDebug("Breeding successful: " + parent1.getType() + " parents (levels " + data1.getLevel() + " & " + data2.getLevel() + ") -> baby (level " + inheritedLevel + ")");
    }

    private void playBreedingEffects(Animals parent1, Animals parent2, final Animals baby) {
        if (this.enableParticles) {
            parent1.getWorld().spawnParticle(Particle.HEART, parent1.getLocation().add(0.0, 2.0, 0.0), 5, 0.5, 0.5, 0.5, 0.0);
            parent2.getWorld().spawnParticle(Particle.HEART, parent2.getLocation().add(0.0, 2.0, 0.0), 5, 0.5, 0.5, 0.5, 0.0);
            baby.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, baby.getLocation().add(0.0, 1.0, 0.0), 10, 0.3, 0.3, 0.3, 0.0);
        }
        parent1.getWorld().playSound(parent1.getLocation(), Sound.ENTITY_GENERIC_EAT, 1.0f, 1.0f);
        new BukkitRunnable(){

            public void run() {
                if (baby.isValid()) {
                    switch (baby.getType()) {
                        case COW: {
                            baby.getWorld().playSound(baby.getLocation(), Sound.ENTITY_COW_AMBIENT, 0.8f, 1.5f);
                            break;
                        }
                        case SHEEP: {
                            baby.getWorld().playSound(baby.getLocation(), Sound.ENTITY_SHEEP_AMBIENT, 0.8f, 1.5f);
                            break;
                        }
                        case PIG: {
                            baby.getWorld().playSound(baby.getLocation(), Sound.ENTITY_PIG_AMBIENT, 0.8f, 1.5f);
                            break;
                        }
                        case CHICKEN: {
                            baby.getWorld().playSound(baby.getLocation(), Sound.ENTITY_CHICKEN_AMBIENT, 0.8f, 1.5f);
                            break;
                        }
                        default: {
                            baby.getWorld().playSound(baby.getLocation(), Sound.ENTITY_GENERIC_EAT, 0.8f, 1.2f);
                        }
                    }
                }
            }
        }.runTaskLater((Plugin)this, 20L);
    }

    private boolean canBreed(AnimalData data, UUID animalId) {
        if (data.getLevel() < 6) {
            return false;
        }
        if (this.breedingCooldowns.containsKey(animalId)) {
            long lastBreeding = this.breedingCooldowns.get(animalId);
            if (System.currentTimeMillis() - lastBreeding < 300000L) {
                return false;
            }
        }
        return true;
    }

    private Animals findBreedingPartner(Animals animal, UUID animalId) {
        for (Entity nearbyEntity : animal.getNearbyEntities(8.0, 8.0, 8.0)) {
            AnimalData nearbyData;
            Animals nearbyAnimal;
            if (!(nearbyEntity instanceof Animals) || (nearbyAnimal = (Animals)nearbyEntity).getType() != animal.getType() || nearbyAnimal.getUniqueId().equals(animalId) || (nearbyData = this.getAnimalData(nearbyAnimal.getUniqueId())) == null || nearbyData.getLevel() < 6) continue;
            return nearbyAnimal;
        }
        return null;
    }

    private void startFeedingProcess(Player player, Animals animal, UUID animalId, AnimalData data) {
        ++this.totalFeedingActions;
        ItemStack item = player.getInventory().getItemInMainHand();
        String animalType = animal.getType().name().toLowerCase();
        if (data.getHunger() >= data.getMaxHunger()) {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_already_full").replace("{animal}", this.getAnimalDisplayName(animal)));
            return;
        }
        int hungerRestore = this.getFoodValue(item.getType(), animalType);
        item.setAmount(item.getAmount() - 1);
        int feedingBondGain = this.config.getInt("bond.feeding-bond-gain", 5);
        data.setHunger(Math.min(data.getHunger() + hungerRestore, data.getMaxHunger()));
        data.setFeedCount(data.getFeedCount() + 1);
        data.setBondLevel(Math.min(data.getBondLevel() + feedingBondGain, 100));
        this.checkForBreeding(player, animal, animalId, data);
        if (data.getFeedCount() >= this.feedingsPerLevel * data.getLevel() && data.getLevel() < this.maxLevel) {
            this.levelUpAnimal(player, animal, data, animalId);
        }
        this.updateHungerDisplay(animal, data);
        this.playFeedingEffects(animal);
        player.sendMessage(this.getMessage((CommandSender)player, "fed_animal").replace("{animal}", this.getAnimalDisplayName(animal)).replace("{hunger}", String.valueOf(data.getHunger())).replace("{max_hunger}", String.valueOf(data.getMaxHunger())).replace("{bond}", String.valueOf(data.getBondLevel())).replace("{food_value}", String.valueOf(hungerRestore)));
        this.saveAnimalData(animalId);
    }

    private double calculateBondMultiplier(int bondLevel) {
        double baseMultiplier = 1.0;
        double increment = 0.1;
        double maxMultiplier = 2.5;
        double multiplier = baseMultiplier + (double)bondLevel / 10.0 * increment;
        return Math.min(multiplier, maxMultiplier);
    }

    private void levelUpAnimal(Player player, Animals animal, AnimalData data, UUID animalId) {
        data.setLevel(data.getLevel() + 1);
        data.setMaxHunger(Math.min(data.getMaxHunger() + 2, this.maxHungerCap));
        data.setFeedCount(0);
        if (data.getLevel() >= 2 && !this.animalIdMap.containsValue(animalId)) {
            this.animalIdMap.put(this.nextAnimalId, animalId);
            this.logDebug("Assigned Id " + this.nextAnimalId + " to UUID " + animalId);
            ++this.nextAnimalId;
        }
        player.sendMessage(this.getMessage((CommandSender)player, "level_up").replace("{level}", String.valueOf(data.getLevel())));
        if (this.enableParticles && this.config.getBoolean("gui.animations.level_up_effect", true)) {
            animal.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, animal.getLocation().add(0.0, 1.0, 0.0), 20, 0.5, 0.5, 0.5, 0.0);
            animal.getWorld().playSound(animal.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        }
        this.saveAnimalData(animalId);
    }

    private void collectResources(Player player, Animals animal, UUID animalId, AnimalData data) {
        int resourceThreshold = this.config.getInt("bond.thresholds.resource-production", 50);
        if (data.getResourceCount() == 0 || data.getBondLevel() < resourceThreshold) {
            player.sendMessage(this.getMessage((CommandSender)player, "no_resources"));
            return;
        }
        ItemStack resource = this.getResourceItem(animal, data);
        if (resource != null) {
            player.getInventory().addItem(new ItemStack[]{resource});
            player.sendMessage(this.getMessage((CommandSender)player, "resources_collected").replace("{amount}", String.valueOf(data.getResourceCount())).replace("{item}", resource.getType().name().toLowerCase().replace('_', ' ')));
            player.playSound(animal.getLocation(), Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f);
            if (this.enableParticles && this.config.getBoolean("gui.animations.bond_particles", true)) {
                animal.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, animal.getLocation().add(0.0, 1.0, 0.0), 10, 0.3, 0.3, 0.3, 0.0);
            }
        }
        data.setResourceCount(0);
        this.saveAnimalData(animalId);
        player.closeInventory();
    }

    private void playFeedingEffects(Animals animal) {
        if (this.enableParticles && this.config.getBoolean("gui.animations.bond_particles", true)) {
            animal.getWorld().spawnParticle(Particle.HEART, animal.getLocation().add(0.0, 1.0, 0.0), 5);
            ++this.totalParticlesSpawned;
        }
        animal.getWorld().playSound(animal.getLocation(), Sound.ENTITY_PLAYER_BURP, 1.0f, 1.0f);
        ++this.totalSoundsPlayed;
    }

    private ItemStack getResourceItem(Animals animal, AnimalData data) {
        String animalType = animal.getType().name().toLowerCase();
        List resourceItems = this.config.getStringList("animals." + animalType + ".resource_items");
        if (resourceItems.isEmpty()) {
            return null;
        }
        String resourceItem = (String)resourceItems.get(data.getBondLevel() >= 75 ? 1 : 0);
        Material resourceType = this.getMaterialSafely(resourceItem, Material.STONE);
        int amount = data.getResourceCount();
        if (data.getBondLevel() >= this.config.getInt("bond.thresholds.bonus-resources", 100)) {
            amount += this.random.nextInt(2) + 1;
        }
        return new ItemStack(resourceType, Math.max(1, amount));
    }

    private double getProductionChance(AnimalData data) {
        if (data.getBondLevel() >= this.config.getInt("bond.thresholds.bonus-resources", 100)) {
            return 0.15;
        }
        if (data.getBondLevel() >= this.config.getInt("bond.thresholds.rare-drops", 75)) {
            return 0.1;
        }
        if (data.getBondLevel() >= this.config.getInt("bond.thresholds.resource-production", 50)) {
            return 0.05;
        }
        return 0.0;
    }

    public void updateHungerDisplay(Animals animal, AnimalData data) {
        if (animal == null || data == null) {
            return;
        }
        if (!this.config.getBoolean("entity_display.enabled", false)) {
            String customName = data.getColoredName(animal.getType().name());
            if (customName != null && !customName.trim().isEmpty()) {
                animal.setCustomName(customName);
                animal.setCustomNameVisible(true);
            } else {
                animal.setCustomNameVisible(false);
            }
            return;
        }
        String animalTypeKey = this.getAnimalTypeKey(animal);
        String displayName = this.config.getString("animals." + animalTypeKey + ".display_name", animalTypeKey);
        String name = data.getCustomName() != null ? data.getCustomName() : displayName;
        ChatColor nameColor = data.getNameColor();
        String coloredName = nameColor + name;
        Object levelPart = "";
        Object bondPart = "";
        Object barPart = "";
        if (this.config.getBoolean("entity_display.show_level", true)) {
            levelPart = " \u00a7e[\u00a76Lvl " + data.getLevel() + "\u00a7e]";
        }
        if (this.config.getBoolean("entity_display.show_bond", false)) {
            bondPart = " \u00a7d[" + data.getBondLevel() + "%\u00a7d]";
        }
        if (this.config.getBoolean("entity_display.bar.enabled", true)) {
            barPart = " " + this.buildHungerBar(data);
        }
        String format = this.config.getString("entity_display.format", "{name} {level} {bond}");
        String displayText = format.replace("{name}", coloredName).replace("{level}", (CharSequence)levelPart).replace("{bond}", (CharSequence)bondPart).replace("{bar}", (CharSequence)barPart).trim();
        animal.setCustomName(displayText);
        animal.setCustomNameVisible(true);
    }

    private String buildHungerBar(AnimalData data) {
        int barLength = this.config.getInt("entity_display.bar.length", 10);
        double hungerPercent = (double)data.getHunger() / (double)data.getMaxHunger();
        int filledBars = (int)((double)barLength * hungerPercent);
        String hungerColor = this.config.getString("entity_display.bar.hunger_color", "&c");
        String fullColor = this.config.getString("entity_display.bar.full_color", "&a");
        String barColor = hungerPercent < 0.4 ? hungerColor : fullColor;
        StringBuilder bar = new StringBuilder();
        bar.append(barColor);
        for (int i = 0; i < barLength; ++i) {
            bar.append(i < filledBars ? "\u2588" : "\u2592");
        }
        return "[" + bar + "\u00a7r]";
    }

    private void notifyNearbyPlayers(Animals animal, String messageKey) {
        for (Entity entity : animal.getNearbyEntities(10.0, 10.0, 10.0)) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            player.sendMessage(this.getMessage((CommandSender)player, messageKey).replace("{animal}", this.getAnimalDisplayName(animal)));
            player.playSound(animal.getLocation(), Sound.ENTITY_VILLAGER_DEATH, 1.0f, 1.0f);
            if (!this.enableParticles) continue;
            animal.getWorld().spawnParticle(Particle.SMOKE_NORMAL, animal.getLocation().add(0.0, 1.0, 0.0), 10, 0.3, 0.3, 0.3, 0.0);
        }
    }

    public AnimalDataManager getAnimalDataManager() {
        return this.animalDataManager;
    }

    private String getAnimalDisplayName(Animals animal) {
        return this.compatibility.getEntityDisplayName((Entity)animal);
    }

    private void loadConfigValues() {
        this.disableVanillaMilking = this.config.getBoolean("disable-vanilla-milking", false);
        this.resourceCheckInterval = this.config.getInt("performance.resource-check-interval", 6000);
        this.vanillaMilkableAnimals = this.config.getStringList("vanilla_milking.milkable_animals");
        this.vanillaMilkableAnimals.replaceAll(String::toUpperCase);
        this.isMilkingEnabled = this.config.getBoolean("milking.enabled", false);
        this.milkableAnimals = this.config.getStringList("milking.milkable_animals");
        this.milkableAnimals.replaceAll(String::toUpperCase);
        this.milkingResultItem = this.config.getString("milking.result_item", "MILK_BUCKET");
        this.milkingChance = this.config.getDouble("milking.chance", 100.0);
        this.milkingSuccessMessage = this.config.getString("milking.success_message", "&aYou successfully milked the {animal_name}!");
        this.milkingNotMilkableMessage = this.config.getString("milking.not_milkable_message", "&cThis {animal_name} cannot be milked.");
        this.hungerDecreaseInterval = this.config.getInt("hunger-decrease-interval", 6000);
        this.hungerRestoreAmount = this.config.getInt("hunger-restore-amount", 1);
        this.maxHungerCap = this.config.getInt("max-hunger-cap", 15);
        this.maxLevel = this.config.getInt("max-level", 5);
        this.feedingsPerLevel = this.config.getInt("feedings-per-level", 5);
        this.upgradeCost = this.config.getInt("gui.items.upgrade_action.cost", 3);
        this.language = this.config.getString("language", "en");
        this.enableParticles = this.config.getBoolean("enable-particles", true);
        this.debug = this.config.getBoolean("debug", false);
        this.bondDecayEnabled = this.config.getBoolean("bond.enable-decay", false);
        this.bondDecayRate = this.config.getInt("bond.decay-rate", 1);
        this.bondDecayInterval = this.config.getLong("bond.decay-interval", 12000L);
        this.feedItem = this.getMaterialSafely(this.config.getString("feed-item", "WHEAT"), Material.WHEAT);
        this.upgradeItem = this.getMaterialSafely("GOLDEN_CARROT", Material.GOLDEN_CARROT);
        this.disableRiding = this.config.getBoolean("disable-riding", false);
        this.disableResourceCollection = this.config.getBoolean("disable-resource-collection", false);
    }

    private void loadMessages() {
        File messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
        this.language = "en";
    }

    private String getMessage(CommandSender sender, String key) {
        String locale = sender instanceof Player && !this.language.equals("default") ? this.language : (sender instanceof Player ? ((Player)sender).getLocale().replace("_", "") : "en");
        String message = this.messages.getString(locale + "." + key, this.messages.getString("en." + key, this.messages.getString("ru." + key, "Message not found: " + key)));
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public String getMessageForAll(String key) {
        String message = this.messages.getString(this.language + "." + key, this.messages.getString("en." + key, this.messages.getString("ru." + key, "Message not found: " + key)));
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private void setupDataBase() {
        this.dataBaseFile = new File(this.getDataFolder(), "data.yml");
        if (!this.dataBaseFile.exists()) {
            try {
                this.dataBaseFile.createNewFile();
                this.logDebug("Created new data.yml file.");
            }
            catch (IOException e) {
                LOGGER.severe("Could not create data.yml: " + e.getMessage());
            }
        }
        this.dataBase = YamlConfiguration.loadConfiguration((File)this.dataBaseFile);
    }

    private void loadAllAnimalData() {
        this.animalDataCache.clear();
        this.animalIdMap.clear();
        if (this.dataBase == null) {
            LOGGER.warning("Database not initialized, skipping data load.");
            return;
        }
        for (String key : this.dataBase.getKeys(false)) {
            if (key.equals("nextAnimalId")) continue;
            try {
                UUID uuid = UUID.fromString(key);
                this.loadAnimalDataFromConfig(uuid, key);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warning("Invalid UUID in data.yml: " + key);
            }
        }
    }

    private void loadAnimalDataFromConfig(UUID uuid, String key) {
        ChatColor nameColor;
        int hunger = this.dataBase.getInt(key + ".hunger", 10);
        int maxHunger = this.dataBase.getInt(key + ".maxHunger", 10);
        int level = this.dataBase.getInt(key + ".level", 1);
        int feedCount = this.dataBase.getInt(key + ".feedCount", 0);
        int bondLevel = this.dataBase.getInt(key + ".bondLevel", 0);
        int resourceCount = this.dataBase.getInt(key + ".resourceCount", 0);
        String customName = this.dataBase.getString(key + ".customName", null);
        int animalId = this.dataBase.getInt(key + ".id", -1);
        String colorName = this.dataBase.getString(key + ".nameColor", "YELLOW");
        try {
            nameColor = ChatColor.valueOf((String)colorName);
        }
        catch (IllegalArgumentException e) {
            nameColor = ChatColor.YELLOW;
        }
        AnimalData data = new AnimalData(hunger, maxHunger, level, feedCount, bondLevel, resourceCount);
        data.setCustomName(customName);
        data.setNameColor(nameColor);
        this.animalDataCache.put(uuid, data);
        if (animalId >= 0) {
            this.animalIdMap.put(animalId, uuid);
        }
        this.logDebug("Loaded animal data for UUID " + uuid + ": Hunger=" + hunger + "/" + maxHunger + ", Level=" + level + ", Bond=" + bondLevel + ", Resources=" + resourceCount + ", FeedCount=" + feedCount + ", Name=" + (customName != null ? customName : "none") + ", Color=" + nameColor.name() + ", Id=" + (Serializable)(animalId >= 0 ? Integer.valueOf(animalId) : "none"));
    }

    public void saveAnimalData(UUID id) {
        AnimalData data = this.animalDataCache.get(id);
        if (data == null) {
            this.dataBase.set(id.toString(), null);
            ++this.totalDataSaves;
            this.logDebug("Removed animal data for UUID " + id + " from database (no data in cache).");
        } else {
            this.saveAnimalDataToConfig(id, data);
        }
        this.dataBase.set("nextAnimalId", (Object)this.nextAnimalId);
        try {
            this.dataBase.save(this.dataBaseFile);
        }
        catch (IOException e) {
            LOGGER.severe("Could not save data.yml: " + e.getMessage());
            ++this.totalDataSaves;
            this.crutch.saveToFallback(id, data);
        }
    }

    private void saveAnimalDataToConfig(UUID id, AnimalData data) {
        String path = id.toString();
        this.dataBase.set(path + ".hunger", (Object)data.getHunger());
        this.dataBase.set(path + ".maxHunger", (Object)data.getMaxHunger());
        this.dataBase.set(path + ".level", (Object)data.getLevel());
        this.dataBase.set(path + ".feedCount", (Object)data.getFeedCount());
        this.dataBase.set(path + ".bondLevel", (Object)data.getBondLevel());
        this.dataBase.set(path + ".resourceCount", (Object)data.getResourceCount());
        this.dataBase.set(path + ".customName", (Object)data.getCustomName());
        this.dataBase.set(path + ".nameColor", (Object)data.getNameColor().name());
        int animalId = this.getAnimalId(id);
        if (data.getLevel() >= 2) {
            if (animalId < 0) {
                animalId = this.nextAnimalId++;
                this.animalIdMap.put(animalId, id);
                this.logDebug("Assigned Id " + animalId + " to UUID " + id + " (fallback for level " + data.getLevel() + ")");
            }
            this.dataBase.set(path + ".id", (Object)animalId);
            this.logDebug("Saved Id " + animalId + " for UUID " + id);
        }
    }

    private int getAnimalId(UUID id) {
        return this.animalIdMap.entrySet().stream().filter(entry -> ((UUID)entry.getValue()).equals(id)).map(Map.Entry::getKey).findFirst().orElse(-1);
    }

    private void saveAllAnimalData() {
        for (UUID id : this.animalDataCache.keySet()) {
            this.saveAnimalData(id);
        }
        this.logDebug("Saved all animal data to data.yml (" + this.animalDataCache.size() + " entries).");
    }

    private void handleAnimalKill(Player player, Animals animal, boolean fromGUI) {
        KillResult result;
        UUID animalId = animal.getUniqueId();
        AnimalData data = this.getOrCreateAnimalData(animalId);
        ItemStack drop = this.getKillDrop(animal, data, result = this.validateKillAttempt(player, data, fromGUI));
        if (drop != null) {
            animal.getWorld().dropItemNaturally(animal.getLocation(), drop);
        }
        animal.remove();
        this.removeAnimalData(animalId);
        this.saveAnimalData(animalId);
        this.playKillEffects(player, animal);
        this.sendKillMessage(player, result);
        if (fromGUI) {
            player.closeInventory();
        }
    }

    private KillResult validateKillAttempt(Player player, AnimalData data, boolean fromGUI) {
        boolean hasRequiredTool;
        int requiredLevel = this.config.getInt("kill.required-level", 2);
        if (fromGUI) {
            return data.getLevel() >= requiredLevel ? KillResult.SUCCESS : KillResult.LEVEL_TOO_LOW;
        }
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        String requiredItem = this.config.getString("kill.required-item", "");
        boolean bl = hasRequiredTool = requiredItem.isEmpty() || heldItem != null && heldItem.getType().name().equalsIgnoreCase(requiredItem);
        if (data.getLevel() < requiredLevel) {
            return KillResult.LEVEL_TOO_LOW;
        }
        return hasRequiredTool ? KillResult.SUCCESS : KillResult.WRONG_TOOL;
    }

    private ItemStack getKillDrop(Animals animal, AnimalData data, KillResult result) {
        return switch (result) {
            default -> throw new IncompatibleClassChangeError();
            case KillResult.SUCCESS -> this.dropHandler.getDrop(animal, data, true);
            case KillResult.WRONG_TOOL, KillResult.LEVEL_TOO_LOW -> this.dropHandler.getDrop(animal, data, false);
        };
    }

    private void playKillEffects(Player player, Animals animal) {
        player.playSound(animal.getLocation(), Sound.ENTITY_GENERIC_HURT, 1.0f, 1.0f);
        if (this.enableParticles) {
            animal.getWorld().spawnParticle(Particle.SMOKE_NORMAL, animal.getLocation().add(0.0, 1.0, 0.0), 10, 0.3, 0.3, 0.3, 0.0);
        }
    }

    private void sendKillMessage(Player player, KillResult result) {
        String messageKey;
        switch (result) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SUCCESS: {
                String string = "animal_killed";
                break;
            }
            case WRONG_TOOL: {
                String string = "animal_killed_wrong_tool";
                break;
            }
            case LEVEL_TOO_LOW: {
                String string = messageKey = "kill_level_required";
            }
        }
        if (result == KillResult.LEVEL_TOO_LOW) {
            int requiredLevel = this.config.getInt("kill.required-level", 2);
            player.sendMessage(this.getMessage((CommandSender)player, messageKey).replace("{level}", String.valueOf(requiredLevel)));
        } else {
            player.sendMessage(this.getMessage((CommandSender)player, messageKey));
        }
    }

    private void initiateAnimalRename(final Player player, UUID animalId) {
        Animals animal;
        Entity entity = Bukkit.getEntity((UUID)animalId);
        if (!(entity instanceof Animals) || !(animal = (Animals)entity).isValid()) {
            player.sendMessage(this.getMessage((CommandSender)player, "animal_not_found"));
            return;
        }
        player.closeInventory();
        player.sendMessage(this.getMessage((CommandSender)player, "rename_instruction"));
        player.setMetadata(RENAMING_ANIMAL_META_KEY, (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)animal));
        new BukkitRunnable(){

            public void run() {
                if (player.hasMetadata(AnimalHunger.RENAMING_ANIMAL_META_KEY)) {
                    player.removeMetadata(AnimalHunger.RENAMING_ANIMAL_META_KEY, (Plugin)AnimalHunger.this);
                    player.sendMessage(AnimalHunger.this.getMessage((CommandSender)player, "rename_cancelled"));
                }
            }
        }.runTaskLater((Plugin)this, 600L);
    }

    private int getGUISize(Animals animal) {
        return 54;
    }

    private String getGUILayoutType(int size) {
        return switch (size) {
            case 27 -> "small";
            case 45 -> "medium";
            default -> "large";
        };
    }

    private int getSlotForItemType(String itemType, String layoutType) {
        int configSlot = this.config.getInt("gui.items." + itemType + ".positions." + layoutType, -1);
        if (configSlot >= 0) {
            return configSlot;
        }
        Map<String, Map<String, Integer>> defaultPositions = Map.of("small", Map.of("level_display", 11, "hunger_display", 12, "bond_display", 13, "name_display", 14, "feed_action", 19, "kill_action", 21, "upgrade_action", 23, "collect_action", 20, "info_display", 22), "medium", Map.of("level_display", 11, "hunger_display", 12, "bond_display", 13, "name_display", 14, "feed_action", 29, "kill_action", 31, "upgrade_action", 33, "collect_action", 30, "info_display", 32), "large", Map.of("level_display", 12, "hunger_display", 13, "bond_display", 14, "name_display", 15, "feed_action", 29, "kill_action", 31, "upgrade_action", 33, "collect_action", 30, "info_display", 32));
        return defaultPositions.getOrDefault(layoutType, defaultPositions.get("large")).getOrDefault(itemType, -1);
    }

    private String getGUITitle(Animals animal, String layoutType) {
        String animalType = animal.getType().name().toLowerCase();
        UUID animalId = animal.getUniqueId();
        AnimalData data = this.getOrCreateAnimalData(animalId);
        String displayName = data != null && data.getCustomName() != null ? data.getCustomName() : this.config.getString("animals." + animalType + ".display_name", animal.getType().name());
        String configTitle = this.config.getString("gui.titles." + layoutType, "");
        if (!configTitle.isEmpty()) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)configTitle.replace("{animal_name}", displayName));
        }
        return switch (layoutType) {
            case "small" -> ChatColor.GOLD + "Animal: " + ChatColor.WHITE + displayName;
            case "medium" -> ChatColor.GOLD + "Management: " + ChatColor.WHITE + displayName;
            default -> ChatColor.GOLD + "Animal Management: " + ChatColor.WHITE + displayName;
        };
    }

    private void populateEnhancedGUIItems(Inventory gui, Animals animal, AnimalData data, String layoutType, double bondMultiplier, int resourceThreshold, String feedItems, String resourceType, int hungerPercent, int nextThreshold, String bondEffects) {
        String[] itemTypes;
        for (String itemKey : itemTypes = new String[]{"level_display", "hunger_display", "bond_display", "name_display", "feed_action", "kill_action", "upgrade_action", "collect_action", "info_display", "name_color"}) {
            String positionPath;
            int position;
            if (!this.config.contains("gui.items." + itemKey) || (position = this.config.getInt(positionPath = "gui.items." + itemKey + ".positions." + layoutType, -1)) < 0 || position >= gui.getSize()) continue;
            try {
                ItemStack item = this.createEnhancedGUIItem(animal, data, itemKey);
                if (item == null || item.getType() == Material.AIR) continue;
                gui.setItem(position, item);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<String> getFeedItems() {
        return new ArrayList<String>();
    }

    public List<String> getResourceItems() {
        return new ArrayList<String>();
    }

    private String getHungerStatus(int hunger, int maxHunger) {
        double percent = (double)hunger / (double)maxHunger * 100.0;
        if (percent >= 75.0) {
            return this.getMessage(null, "hunger_status_healthy");
        }
        if (percent >= 50.0) {
            return this.getMessage(null, "hunger_status_hungry");
        }
        if (percent >= 25.0) {
            return this.getMessage(null, "hunger_status_starving");
        }
        return this.getMessage(null, "hunger_status_critical");
    }

    private String getDropQuality(int level) {
        if (level >= 4) {
            return this.getMessage(null, "drop_quality_legendary");
        }
        if (level >= 3) {
            return this.getMessage(null, "drop_quality_rare");
        }
        if (level >= 2) {
            return this.getMessage(null, "drop_quality_uncommon");
        }
        return this.getMessage(null, "drop_quality_common");
    }

    private void createAndSetGUIItem(Inventory gui, Animals animal, AnimalData data, String itemType, String layoutType) {
        int slot = this.getSlotForItemType(itemType, layoutType);
        if (slot < 0 || slot >= gui.getSize()) {
            this.logDebug("Invalid slot for " + itemType + " in layout " + layoutType + ": " + slot);
            return;
        }
        ItemStack item = this.createEnhancedGUIItem(animal, data, itemType);
        if (item == null || item.getType() == Material.AIR) {
            this.logDebug("Failed to create GUI item for type: " + itemType);
            return;
        }
        gui.setItem(slot, item);
        this.logDebug("Set GUI item " + itemType + " at slot " + slot + " for layout " + layoutType);
    }

    private String processEnhancedPlaceholders(String text, Animals animal, AnimalData data) {
        if (text == null) {
            return "";
        }
        String animalType = animal.getType().name().toLowerCase();
        String displayName = this.config.getString("animals." + animalType + ".display_name", animalType);
        List feedItemsList = this.config.getStringList("animals." + animalType + ".feed_items");
        String feedItemsStr = feedItemsList.isEmpty() ? "none" : feedItemsList.stream().map(item -> item.toLowerCase().replace("_", " ")).collect(Collectors.joining(", "));
        List resourceItemsList = this.config.getStringList("animals." + animalType + ".resource_items");
        String resourceType = "none";
        if (!resourceItemsList.isEmpty()) {
            int index = data.getBondLevel() >= 75 && resourceItemsList.size() > 1 ? 1 : 0;
            resourceType = ((String)resourceItemsList.get(index)).toLowerCase().replace("_", " ");
        }
        int nextThreshold = this.getNextBondThreshold(data.getBondLevel());
        String bondEffects = this.getBondEffects(data.getBondLevel());
        double hungerPercent = data.getMaxHunger() > 0 ? (double)data.getHunger() / (double)data.getMaxHunger() * 100.0 : 0.0;
        String hungerStatus = this.getHungerStatus(data.getHunger(), data.getMaxHunger());
        String customName = data.getCustomName() != null ? data.getCustomName() : displayName;
        int requiredFeeds = Math.max(1, this.feedingsPerLevel * data.getLevel());
        double bondMultiplier = 1.0 + (double)data.getBondLevel() / 100.0;
        double productionRate = this.getProductionChance(data) * 100.0;
        String dropQuality = this.getDropQuality(data.getLevel());
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text.replace("{animal_name}", displayName).replace("{hunger}", String.valueOf(data.getHunger())).replace("{maxhunger}", String.valueOf(data.getMaxHunger())).replace("{hunger_percent}", String.format("%.0f", hungerPercent)).replace("{hunger_status}", hungerStatus).replace("{level}", String.valueOf(data.getLevel())).replace("{max_level}", String.valueOf(this.maxLevel)).replace("{bond}", String.valueOf(data.getBondLevel())).replace("{feed_count}", String.valueOf(data.getFeedCount())).replace("{required_feeds}", String.valueOf(requiredFeeds)).replace("{resources}", String.valueOf(data.getResourceCount())).replace("{resource_type}", resourceType).replace("{feed_items}", feedItemsStr).replace("{hunger_restore}", String.valueOf(this.hungerRestoreAmount)).replace("{bond_gain}", String.valueOf(this.config.getInt("bond.feeding-bond-gain", 5))).replace("{bond_multiplier}", String.format("%.2f", bondMultiplier)).replace("{production_rate}", String.format("%.2f%%", productionRate)).replace("{name}", customName).replace("{nextlevel}", String.valueOf(data.getLevel() + 1)).replace("{upgrade_cost}", String.valueOf(this.upgradeCost)).replace("{upgrade_item}", this.upgradeItem.name().toLowerCase().replace("_", " ")).replace("{min_kill_level}", String.valueOf(this.config.getInt("kill.required-level", 2))).replace("{drop_quality}", dropQuality).replace("{next_threshold}", String.valueOf(nextThreshold)).replace("{bond_effects}", bondEffects).replace("{upgrade_bond_gain}", String.valueOf(this.config.getInt("bond.upgrade-bond-gain", 15))).replace("{resource_threshold}", String.valueOf(this.config.getInt("bond.thresholds.resource-production", 50)) + "%"));
    }

    private int getNextBondThreshold(int currentBond) {
        int[] thresholds;
        for (int threshold : thresholds = new int[]{this.config.getInt("bond.thresholds.resource-production", 50), this.config.getInt("bond.thresholds.rare-drops", 75), this.config.getInt("bond.thresholds.bonus-resources", 100)}) {
            if (currentBond >= threshold) continue;
            return threshold;
        }
        return 100;
    }

    private String getBondEffects(int bondLevel) {
        ArrayList<String> effects = new ArrayList<String>();
        if (bondLevel >= this.config.getInt("bond.thresholds.resource-production", 50)) {
            effects.add("&8\u25b8 &aResource Production Unlocked");
        }
        if (bondLevel >= this.config.getInt("bond.thresholds.rare-drops", 75)) {
            effects.add("&8\u25b8 &aRare Drops Available");
        }
        if (bondLevel >= this.config.getInt("bond.thresholds.bonus-resources", 100)) {
            effects.add("&8\u25b8 &aBonus Resources Active");
        }
        return effects.isEmpty() ? "&8\u25b8 &7No Effects" : String.join((CharSequence)"\n", effects);
    }

    private boolean isValidAnimalInteraction(PlayerInteractEntityEvent event) {
        return event.getHand() == EquipmentSlot.HAND && event.getRightClicked() instanceof Animals;
    }

    private boolean isValidKillAttempt(EntityDamageByEntityEvent event) {
        return event.getEntity() instanceof Animals && event.getDamager() instanceof Player && this.isSupportedAnimal(event.getEntity());
    }

    private boolean isSupportedAnimal(Entity entity) {
        if (this.compatibility == null) {
            this.logDebug("PluginCompatibility is null when checking if entity " + (Serializable)(entity != null ? entity.getType() : "null") + " is supported.");
            return false;
        }
        return this.compatibility.isSupportedEntity(entity);
    }

    private boolean hasValidFeedItemForAnimal(Player player, Animals animal) {
        if (this.compatibility == null) {
            this.logDebug("PluginCompatibility is null when checking feed item for animal " + (Serializable)(animal != null ? animal.getType() : "null"));
            return false;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getAmount() <= 0) {
            return false;
        }
        String animalTypeKey = this.getAnimalTypeKey(animal);
        List feedItems = this.config.getStringList("animals." + animalTypeKey + ".feed_items");
        return this.compatibility.isValidFeedItem(item, feedItems);
    }

    private String getAnimalTypeKey(Animals animal) {
        String mythicType;
        if (this.compatibility.isMythicMobsEnabled() && this.compatibility.isMythicMob((Entity)animal) && (mythicType = this.compatibility.getMythicMobType((Entity)animal)) != null) {
            return mythicType.toLowerCase();
        }
        return animal.getType().name().toLowerCase();
    }

    private Material getMaterialSafely(String materialName, Material fallback) {
        try {
            Material material = Material.getMaterial((String)materialName.toUpperCase());
            if (material == null) {
                LOGGER.warning("Invalid material: " + materialName + ", using fallback: " + fallback.name());
                return fallback;
            }
            return material;
        }
        catch (Exception e) {
            LOGGER.warning("Error parsing material: " + materialName + ", using fallback: " + fallback.name());
            return fallback;
        }
    }

    private void setLastAnimalMetadata(Player player, Animals animal) {
        player.setMetadata(LAST_ANIMAL_META_KEY, (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)animal));
        this.logDebug("Set lastAnimal metadata for player " + player.getName() + " to animal " + animal.getType() + " (" + animal.getUniqueId() + ")");
    }

    private Animals getAnimalFromMetadata(Player player) {
        Animals animal;
        if (!player.hasMetadata(LAST_ANIMAL_META_KEY)) {
            return null;
        }
        Object value = ((MetadataValue)player.getMetadata(LAST_ANIMAL_META_KEY).get(0)).value();
        if (!(value instanceof Animals) || !(animal = (Animals)value).isValid()) {
            player.removeMetadata(LAST_ANIMAL_META_KEY, (Plugin)this);
            return null;
        }
        return animal;
    }

    public boolean isVanillaMilkingDisabled() {
        return this.disableVanillaMilking;
    }

    public void logDebug(String message) {
        if (this.debug) {
            LOGGER.info("[DEBUG] " + message);
        }
    }

    public boolean isRidingDisabled() {
        return this.disableRiding;
    }

    public boolean isResourceCollectionDisabled() {
        return this.disableResourceCollection;
    }

    public Map<UUID, AnimalData> getAnimalDataCache() {
        return this.animalDataCache;
    }

    public Map<Integer, UUID> getAnimalIdMap() {
        return this.animalIdMap;
    }

    public AnimalData getAnimalData(UUID id) {
        return this.animalDataCache.get(id);
    }

    public void setAnimalData(UUID id, AnimalData data) {
        this.animalDataCache.put(id, data);
    }

    public void removeAnimalData(UUID id) {
        this.animalDataCache.remove(id);
    }

    public AnimalData getOrCreateAnimalData(UUID id) {
        return this.animalDataCache.computeIfAbsent(id, k -> new AnimalData(10, 10, 1, 0, 0, 0));
    }

    public AnimalHungerCrutch getCrutch() {
        return this.crutch;
    }

    private static enum KillResult {
        SUCCESS,
        WRONG_TOOL,
        LEVEL_TOO_LOW;

    }
}

