/*
 * Decompiled with CFR 0.152.
 */
package animalhunger.animalhunger;

import animalhunger.animalhunger.AnimalData;
import animalhunger.animalhunger.AnimalHunger;
import animalhunger.animalhunger.PluginCompatibility;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.java.JavaPlugin;

public class AnimalDataManager {
    private final Map<UUID, AnimalData> animalDataMap = new ConcurrentHashMap<UUID, AnimalData>();
    private final JavaPlugin plugin;

    public AnimalDataManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public AnimalData getAnimalData(UUID animalUUID) {
        return this.animalDataMap.get(animalUUID);
    }

    public void setAnimalData(UUID animalUUID, AnimalData data) {
        this.animalDataMap.put(animalUUID, data);
    }

    public AnimalData createAnimalData(UUID animalUUID) {
        int maxHunger = this.plugin.getConfig().getInt("max-hunger-cap", 20);
        AnimalData data = new AnimalData(maxHunger, maxHunger, 1, 0, 0, 0);
        this.animalDataMap.put(animalUUID, data);
        return data;
    }

    public void removeAnimalData(UUID animalUUID) {
        this.animalDataMap.remove(animalUUID);
    }

    public String getAnimalDisplayName(Animals animal) {
        if (animal.getCustomName() != null) {
            return animal.getCustomName();
        }
        try {
            String mythicName;
            PluginCompatibility compatibility = ((AnimalHunger)this.plugin).getCompatibility();
            if (compatibility != null && compatibility.isMythicMobsEnabled() && compatibility.isMythicMob((Entity)animal) && (mythicName = compatibility.getMythicMobDisplayName((Entity)animal)) != null && !mythicName.isEmpty()) {
                return mythicName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getDefaultAnimalName(animal.getType());
    }

    public String getDefaultAnimalName(EntityType type) {
        return this.plugin.getConfig().getString("animals." + type.name().toLowerCase() + ".display_name", type.name().toLowerCase().replace('_', ' '));
    }

    public AnimalData getOrCreateAnimalData(UUID animalUUID) {
        AnimalData data = this.getAnimalData(animalUUID);
        if (data == null) {
            data = this.createAnimalData(animalUUID);
        }
        return data;
    }

    public boolean hasAnimalData(UUID animalUUID) {
        return this.animalDataMap.containsKey(animalUUID);
    }

    public int getTrackedAnimalsCount() {
        return this.animalDataMap.size();
    }

    public Map<UUID, AnimalData> getDataMap() {
        return this.animalDataMap;
    }

    public void clearAll() {
        this.animalDataMap.clear();
    }

    public void updateMaxHungerForAll() {
        int newMaxHunger = this.plugin.getConfig().getInt("max-hunger-cap", 20);
        this.animalDataMap.values().forEach(data -> {
            if (data.getMaxHunger() < newMaxHunger) {
                data.setMaxHunger(newMaxHunger);
                if (data.getHunger() > newMaxHunger) {
                    data.setHunger(newMaxHunger);
                }
            }
        });
    }
}

