/*
 * Decompiled with CFR 0.152.
 */
package animalhunger.animalhunger;

import animalhunger.animalhunger.AnimalData;
import animalhunger.animalhunger.AnimalHunger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class AnimalHomeManager {
    private final AnimalHunger plugin;
    private final Map<UUID, HomeData> homeDataMap = new ConcurrentHashMap<UUID, HomeData>();
    private final Map<UUID, Location> pendingHomeSelection = new HashMap<UUID, Location>();
    private final Map<UUID, BukkitRunnable> activeVisualizations = new HashMap<UUID, BukkitRunnable>();
    private int defaultRadius;
    private int maxRadius;
    private int minRadius;
    private boolean preventTeleportOut;
    private boolean showMessageOnLeaveAttempt;
    private boolean enableVisualPreview;
    private String visualParticleType;
    private boolean useSquareVisualization;
    private String guiTitle;
    private int guiSize;
    private Material guiDecorationMaterial;
    private List<Integer> guiDecorationSlots;
    private final Map<String, HomeGUIItemConfig> guiItemConfigs = new HashMap<String, HomeGUIItemConfig>();

    public AnimalHomeManager(AnimalHunger plugin) {
        this.plugin = plugin;
        this.loadConfig();
        this.loadAllHomeData();
        this.startBoundaryEnforcement();
    }

    public void loadConfig() {
        this.defaultRadius = this.plugin.getConfig().getInt("animal-home.default-radius", 8);
        this.maxRadius = this.plugin.getConfig().getInt("animal-home.max-radius", 32);
        this.minRadius = this.plugin.getConfig().getInt("animal-home.min-radius", 3);
        this.preventTeleportOut = this.plugin.getConfig().getBoolean("animal-home.prevent-teleport-out", true);
        this.showMessageOnLeaveAttempt = this.plugin.getConfig().getBoolean("animal-home.show-message-on-leave-attempt", false);
        this.enableVisualPreview = this.plugin.getConfig().getBoolean("animal-home.enable-visual-preview", true);
        this.visualParticleType = this.plugin.getConfig().getString("animal-home.visual-particle-type", "VILLAGER_HAPPY");
        this.useSquareVisualization = this.plugin.getConfig().getBoolean("animal-home.use-square-visualization", false);
        this.minRadius = Math.max(1, this.minRadius);
        this.maxRadius = Math.max(this.minRadius, this.maxRadius);
        ConfigurationSection guiConfig = this.plugin.getConfig().getConfigurationSection("animal_home_gui");
        if (guiConfig != null) {
            ConfigurationSection itemsConfig;
            this.guiTitle = ChatColor.translateAlternateColorCodes((char)'&', (String)guiConfig.getString("title", "&c&lAnimal Home"));
            this.guiSize = guiConfig.getInt("size", 27);
            this.guiDecorationMaterial = Material.matchMaterial((String)guiConfig.getString("decoration.material", "GRAY_STAINED_GLASS_PANE"));
            if (this.guiDecorationMaterial == null) {
                this.guiDecorationMaterial = Material.GRAY_STAINED_GLASS_PANE;
            }
            this.guiDecorationSlots = guiConfig.getIntegerList("decoration.slots");
            if (this.guiDecorationSlots.isEmpty()) {
                this.guiDecorationSlots = new ArrayList<Integer>();
                for (int i = 0; i < this.guiSize; ++i) {
                    if (i >= 9 && i < this.guiSize - 9 && i % 9 != 0 && i % 9 != 8) continue;
                    this.guiDecorationSlots.add(i);
                }
            }
            if ((itemsConfig = guiConfig.getConfigurationSection("items")) != null) {
                for (String key : itemsConfig.getKeys(false)) {
                    this.guiItemConfigs.put(key, new HomeGUIItemConfig(itemsConfig.getConfigurationSection(key)));
                }
            }
        } else {
            this.guiTitle = "Animal Home (Error)";
            this.guiSize = 27;
        }
    }

    public boolean handleCommand(final Player player, String[] args) {
        if (!this.plugin.isPremiumAnimalHomeEnabled()) {
            player.sendMessage(ChatColor.RED + "This feature is only available in the premium version!");
            return true;
        }
        if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
            this.showHelp(player);
            return true;
        }
        Animals target = this.plugin.getAnimalFromMetadataPublic(player);
        if (target == null || !target.isValid()) {
            player.sendMessage(ChatColor.RED + "First, right-click an animal to select it!");
            return true;
        }
        if (args[0].equalsIgnoreCase("set")) {
            if (args.length < 2) {
                player.sendMessage(ChatColor.RED + "Usage: /animalhome set <radius>");
                return true;
            }
            int providedRadius = this.parseInt(args[1], -1);
            if (providedRadius == -1) {
                player.sendMessage(ChatColor.RED + "Invalid radius: " + args[1]);
                return true;
            }
            final int finalRadius = Math.max(this.minRadius, Math.min(this.maxRadius, providedRadius));
            final Location center = target.getLocation();
            Location pendingLoc = center.clone();
            pendingLoc.setY((double)finalRadius);
            this.pendingHomeSelection.put(player.getUniqueId(), pendingLoc);
            BukkitRunnable previousTask = this.activeVisualizations.remove(player.getUniqueId());
            if (previousTask != null) {
                previousTask.cancel();
            }
            if (this.enableVisualPreview) {
                BukkitRunnable visualizationTask = new BukkitRunnable(){

                    public void run() {
                        if (!player.isOnline() || !AnimalHomeManager.this.pendingHomeSelection.containsKey(player.getUniqueId())) {
                            this.cancel();
                            AnimalHomeManager.this.activeVisualizations.remove(player.getUniqueId());
                            return;
                        }
                        AnimalHomeManager.this.visualizeHomeZone(player, center, finalRadius);
                    }
                };
                visualizationTask.runTaskTimer((Plugin)this.plugin, 0L, 20L);
                this.activeVisualizations.put(player.getUniqueId(), visualizationTask);
            }
            player.sendMessage(ChatColor.GREEN + "Home zone visualized with radius: " + finalRadius + " blocks. Use /animalhome confirm to apply or /animalhome cancel to stop visualization.");
            return true;
        }
        if (args[0].equalsIgnoreCase("confirm")) {
            Location pendingData = this.pendingHomeSelection.remove(player.getUniqueId());
            if (pendingData == null) {
                player.sendMessage(ChatColor.RED + "No pending home zone to confirm!");
                return true;
            }
            int finalRadius = (int)pendingData.getY();
            Location center = pendingData.clone();
            center.setY(target.getLocation().getY());
            BukkitRunnable task = this.activeVisualizations.remove(player.getUniqueId());
            if (task != null) {
                task.cancel();
            }
            this.assignHome(target, center, finalRadius);
            player.sendMessage(ChatColor.GREEN + "Home assigned! Radius: " + finalRadius + " blocks.");
            return true;
        }
        if (args[0].equalsIgnoreCase("cancel")) {
            Location center = this.pendingHomeSelection.remove(player.getUniqueId());
            if (center == null) {
                player.sendMessage(ChatColor.RED + "No pending home zone to cancel!");
                return true;
            }
            BukkitRunnable task = this.activeVisualizations.remove(player.getUniqueId());
            if (task != null) {
                task.cancel();
            }
            player.sendMessage(ChatColor.YELLOW + "Home zone visualization cancelled.");
            return true;
        }
        if (args[0].equalsIgnoreCase("remove")) {
            this.removeHome(target.getUniqueId());
            player.sendMessage(ChatColor.GREEN + "Animal home removed.");
            return true;
        }
        this.showHelp(player);
        return true;
    }

    private void showHelp(Player player) {
        player.sendMessage(ChatColor.GOLD + "=== Animal Home (Premium) ===");
        player.sendMessage(ChatColor.AQUA + "/animalhome set [radius]" + ChatColor.GRAY + " \u2013 visualize home zone");
        player.sendMessage(ChatColor.AQUA + "/animalhome confirm" + ChatColor.GRAY + " \u2013 confirm and assign");
        player.sendMessage(ChatColor.AQUA + "/animalhome cancel" + ChatColor.GRAY + " \u2013 stop visualization");
        player.sendMessage(ChatColor.AQUA + "/animalhome remove" + ChatColor.GRAY + " \u2013 remove home");
    }

    private void visualizeHomeZone(Player player, Location center, int radius) {
        World world = center.getWorld();
        if (this.useSquareVisualization) {
            Location loc2;
            Location loc1;
            for (int x = -radius; x <= radius; ++x) {
                loc1 = new Location(world, center.getX() + (double)x, center.getY() + 0.1, center.getZ() - (double)radius);
                loc2 = new Location(world, center.getX() + (double)x, center.getY() + 0.1, center.getZ() + (double)radius);
                this.spawnParticleLine(player, loc1, loc2, 1);
            }
            for (int z = -radius; z <= radius; ++z) {
                loc1 = new Location(world, center.getX() - (double)radius, center.getY() + 0.1, center.getZ() + (double)z);
                loc2 = new Location(world, center.getX() + (double)radius, center.getY() + 0.1, center.getZ() + (double)z);
                this.spawnParticleLine(player, loc1, loc2, 1);
            }
        } else {
            double angleStep = 0.19634954084936207;
            ArrayList<Location> particles = new ArrayList<Location>();
            for (int i = 0; i < 32; ++i) {
                double angle = (double)i * angleStep;
                double x = center.getX() + Math.cos(angle) * (double)radius;
                double z = center.getZ() + Math.sin(angle) * (double)radius;
                particles.add(new Location(world, x, center.getY() + 0.1, z));
            }
            Particle particle = this.getValidParticle(this.visualParticleType);
            for (Location loc : particles) {
                player.spawnParticle(particle, loc, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void spawnParticleLine(Player player, Location start, Location end, int particlesPerBlock) {
        Particle particle = this.getValidParticle(this.visualParticleType);
        World world = start.getWorld();
        double distance = start.distance(end);
        Vector vector = end.toVector().subtract(start.toVector()).normalize().multiply(1.0 / (double)particlesPerBlock);
        Location current = start.clone();
        for (double d = 0.0; d <= distance; d += 1.0 / (double)particlesPerBlock) {
            player.spawnParticle(particle, current, 1, 0.0, 0.0, 0.0, 0.0);
            current.add(vector);
        }
    }

    private Particle getValidParticle(String configParticleName) {
        try {
            return Particle.valueOf((String)configParticleName);
        }
        catch (IllegalArgumentException e) {
            return Particle.VILLAGER_HAPPY;
        }
    }

    public void assignHome(Animals animal, Location center, int radius) {
        this.homeDataMap.put(animal.getUniqueId(), new HomeData(center, radius));
        this.saveHomeData(animal.getUniqueId());
    }

    public void removeHome(UUID animalId) {
        this.homeDataMap.remove(animalId);
        this.deleteHomeData(animalId);
    }

    private void startBoundaryEnforcement() {
        new BukkitRunnable(){

            public void run() {
                if (!AnimalHomeManager.this.plugin.isPremiumAnimalHomeEnabled()) {
                    return;
                }
                for (World world : Bukkit.getWorlds()) {
                    for (Animals animal : world.getEntitiesByClass(Animals.class)) {
                        Player owner;
                        UUID id = animal.getUniqueId();
                        HomeData home = AnimalHomeManager.this.homeDataMap.get(id);
                        if (home == null || !animal.isValid() || home.isInside(animal.getLocation())) continue;
                        Location safe = AnimalHomeManager.this.findSafeReturn(home);
                        animal.teleport(safe);
                        AnimalHomeManager.this.plugin.logDebug("Animal " + id + " returned to home zone.");
                        if (!AnimalHomeManager.this.showMessageOnLeaveAttempt || !animal.hasMetadata("lastOwner") || (owner = (Player)((MetadataValue)animal.getMetadata("lastOwner").get(0)).value()) == null || !owner.isOnline()) continue;
                        TextComponent message = new TextComponent(ChatColor.RED + "Your animal tried to leave its home zone!");
                        owner.spigot().sendMessage((BaseComponent)message);
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 20L);
    }

    private Location findSafeReturn(HomeData home) {
        Location center = home.getCenter();
        World world = center.getWorld();
        int radius = home.getRadius();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                Location loc = center.clone().add((double)dx, 0.0, (double)dz);
                Location highest = world.getHighestBlockAt(loc).getLocation().add(0.0, 1.0, 0.0);
                if (!highest.getBlock().isEmpty() || !highest.clone().subtract(0.0, 1.0, 0.0).getBlock().getType().isSolid()) continue;
                return highest;
            }
        }
        return new Location(world, center.getX(), Math.max(64.0, center.getY()), center.getZ());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadAllHomeData() {
        this.homeDataMap.clear();
        String sql = "SELECT uuid, home_center_world, home_center_x, home_center_y, home_center_z, home_radius FROM animal_data WHERE home_center_world IS NOT NULL";
        try (Connection conn = this.plugin.getDatabaseManager().getConnection();
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                try {
                    UUID uuid = UUID.fromString(rs.getString("uuid"));
                    String worldName = rs.getString("home_center_world");
                    double x = rs.getDouble("home_center_x");
                    double y = rs.getDouble("home_center_y");
                    double z = rs.getDouble("home_center_z");
                    int radius = rs.getInt("home_radius");
                    World world = Bukkit.getWorld((String)worldName);
                    if (world == null) continue;
                    Location center = new Location(world, x, y, z);
                    this.homeDataMap.put(uuid, new HomeData(center, radius));
                }
                catch (Exception exception) {}
            }
            return;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void saveHomeData(UUID animalId) {
        HomeData home = this.homeDataMap.get(animalId);
        String sql = home == null ? "UPDATE animal_data SET home_center_world = NULL, home_center_x = NULL, home_center_y = NULL, home_center_z = NULL, home_radius = NULL WHERE uuid = ?" : "UPDATE animal_data SET home_center_world = ?, home_center_x = ?, home_center_y = ?, home_center_z = ?, home_radius = ? WHERE uuid = ?";
        try (Connection conn = this.plugin.getDatabaseManager().getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            if (home == null) {
                ps.setString(1, animalId.toString());
            } else {
                Location center = home.getCenter();
                ps.setString(1, center.getWorld().getName());
                ps.setDouble(2, center.getX());
                ps.setDouble(3, center.getY());
                ps.setDouble(4, center.getZ());
                ps.setInt(5, home.getRadius());
                ps.setString(6, animalId.toString());
            }
            ps.executeUpdate();
            this.plugin.logDebug("Saved home data for animal: " + animalId);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void deleteHomeData(UUID animalId) {
        String sql = "UPDATE animal_data SET home_center_world = NULL, home_center_x = NULL, home_center_y = NULL, home_center_z = NULL, home_radius = NULL WHERE uuid = ?";
        try (Connection conn = this.plugin.getDatabaseManager().getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, animalId.toString());
            ps.executeUpdate();
            this.plugin.logDebug("Deleted home data for animal: " + animalId);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void saveAllHomeData() {
        int savedCount = 0;
        int failedCount = 0;
        for (UUID animalId : this.homeDataMap.keySet()) {
            try {
                this.saveHomeData(animalId);
                ++savedCount;
            }
            catch (Exception e) {
                ++failedCount;
            }
        }
    }

    public boolean isPremiumEnabled() {
        return this.plugin.isPremiumAnimalHomeEnabled();
    }

    public String getPremiumMessage(Player player) {
        if (this.isPremiumEnabled()) {
            return this.plugin.getMessage((CommandSender)player, "animal_home_gui_premium_info");
        }
        return this.plugin.getMessage((CommandSender)player, "animal_home_gui_premium_locked");
    }

    private int parseInt(String s, int def) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public void openHomeGUI(Player player, Animals animal) {
        AnimalData data = this.plugin.getAnimalData(animal.getUniqueId());
        if (data == null) {
            this.plugin.logDebug("Cannot open home GUI, animal data is null.");
            return;
        }
        Inventory gui = Bukkit.createInventory(null, (int)this.guiSize, (String)this.guiTitle);
        for (Map.Entry<String, HomeGUIItemConfig> entry : this.guiItemConfigs.entrySet()) {
            HomeGUIItemConfig itemConfig = entry.getValue();
            ItemStack item = this.createHomeGUIItem(itemConfig, animal, data);
            gui.setItem(itemConfig.slot, item);
        }
        ItemStack decorItem = new ItemStack(this.guiDecorationMaterial);
        ItemMeta meta = decorItem.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(" ");
            decorItem.setItemMeta(meta);
        }
        for (int slot : this.guiDecorationSlots) {
            if (gui.getItem(slot) != null) continue;
            gui.setItem(slot, decorItem);
        }
        player.openInventory(gui);
    }

    public void handleHomeGUIClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        int slot = event.getRawSlot();
        Animals animal = this.plugin.getAnimalFromMetadataPublic(player);
        if (animal == null || !animal.isValid()) {
            player.closeInventory();
            player.sendMessage(ChatColor.RED + "Animal not found or is invalid.");
            return;
        }
        HomeGUIItemConfig setConfig = this.guiItemConfigs.get("set_home");
        if (setConfig != null && slot == setConfig.slot) {
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            this.assignHome(animal, animal.getLocation(), this.defaultRadius);
            player.sendMessage(ChatColor.GREEN + "Home set at animal's current location with radius " + this.defaultRadius + ".");
            this.plugin.refreshGUI(player, animal);
            return;
        }
        HomeGUIItemConfig removeConfig = this.guiItemConfigs.get("remove_home");
        if (removeConfig != null && slot == removeConfig.slot) {
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            this.removeHome(animal.getUniqueId());
            player.sendMessage(ChatColor.YELLOW + "Animal home has been removed.");
            this.plugin.refreshGUI(player, animal);
            return;
        }
        HomeGUIItemConfig backConfig = this.guiItemConfigs.get("back_button");
        if (backConfig != null && slot == backConfig.slot) {
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.8f, 1.0f);
            this.plugin.openSecondPageGUI(player, animal);
            return;
        }
    }

    private ItemStack createHomeGUIItem(HomeGUIItemConfig config, Animals animal, AnimalData data) {
        ItemStack item;
        ItemMeta meta;
        Material mat = config.material;
        if (mat == null) {
            mat = Material.STONE;
        }
        if ((meta = (item = new ItemStack(mat)).getItemMeta()) != null) {
            String displayName = this.plugin.processEnhancedPlaceholders(config.display, animal, data);
            meta.setDisplayName(displayName);
            List lore = config.lore.stream().map(line -> this.plugin.processEnhancedPlaceholders((String)line, animal, data)).collect(Collectors.toList());
            meta.setLore(lore);
            if (config.customModelData != 0) {
                meta.setCustomModelData(Integer.valueOf(config.customModelData));
            }
            if (config.slot == this.guiItemConfigs.get((Object)"status_display").slot && this.homeDataMap.containsKey(animal.getUniqueId())) {
                meta.addEnchant(Enchantment.DURABILITY, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            if (config.slot == this.guiItemConfigs.get((Object)"remove_home").slot && this.homeDataMap.containsKey(animal.getUniqueId())) {
                meta.addEnchant(Enchantment.DURABILITY, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public HomeData getHomeData(UUID animalId) {
        return this.homeDataMap.get(animalId);
    }

    public int getDefaultRadius() {
        return this.defaultRadius;
    }

    private static class HomeGUIItemConfig {
        final Material material;
        final int customModelData;
        final int slot;
        final String display;
        final List<String> lore;

        HomeGUIItemConfig(ConfigurationSection config) {
            this.material = Material.matchMaterial((String)config.getString("material", "STONE"));
            this.customModelData = config.getInt("customModelData", 0);
            this.slot = config.getInt("slot", 0);
            this.display = config.getString("display", " ");
            this.lore = config.getStringList("lore");
        }
    }

    public static class HomeData {
        private final Location center;
        private final int radius;

        public HomeData(Location center, int radius) {
            this.center = center.clone();
            this.radius = radius;
        }

        public boolean isInside(Location loc) {
            return loc.getWorld().equals(this.center.getWorld()) && Math.abs(loc.getX() - this.center.getX()) <= (double)this.radius && Math.abs(loc.getZ() - this.center.getZ()) <= (double)this.radius;
        }

        public Location getCenter() {
            return this.center.clone();
        }

        public int getRadius() {
            return this.radius;
        }
    }
}

