/*
 * Decompiled with CFR 0.152.
 */
package animalhunger.animalhunger;

import animalhunger.animalhunger.AnimalData;
import animalhunger.animalhunger.AnimalHunger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Mule;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class AnimalRidingSystem
implements Listener {
    private final AnimalHunger plugin;
    private final Map<UUID, AnimalData> animalDataMap;
    private final Map<UUID, RidingData> ridingPlayers = new ConcurrentHashMap<UUID, RidingData>();
    private final Map<UUID, Long> ridingCooldowns = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Long> lastJumpTime = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, BukkitTask> ridingTasks = new ConcurrentHashMap<UUID, BukkitTask>();
    private final Map<UUID, Map<String, Long>> lastMessageTimes = new ConcurrentHashMap<UUID, Map<String, Long>>();
    private final Map<UUID, Location> lastPlayerLocations = new ConcurrentHashMap<UUID, Location>();
    private final Map<UUID, Integer> stuckCounter = new ConcurrentHashMap<UUID, Integer>();
    private final int minRidingLevel;
    private final long ridingCooldown;
    private final double ridingSpeedMultiplier;
    private final double jumpForce;
    private final int minHungerToRide;
    private final long jumpCooldown;
    private final double autoJumpThreshold;
    private final boolean autoJumpEnabled;
    private static final long MESSAGE_COOLDOWN = 5000L;

    public AnimalRidingSystem(AnimalHunger plugin, Map<UUID, AnimalData> animalDataMap) {
        this.plugin = plugin;
        this.animalDataMap = animalDataMap;
        if (plugin.isRidingDisabled()) {
            this.minRidingLevel = 6;
            this.ridingCooldown = 5000L;
            this.ridingSpeedMultiplier = 1.5;
            this.jumpForce = 0.42;
            this.minHungerToRide = 5;
            this.jumpCooldown = 500L;
            this.autoJumpThreshold = 0.1;
            this.autoJumpEnabled = true;
            this.logDebug("Riding system is disabled in config. Skipping full initialization.");
            return;
        }
        this.minRidingLevel = plugin.getConfig().getInt("riding.min_level", 6);
        this.ridingCooldown = plugin.getConfig().getLong("riding.cooldown", 5000L);
        this.ridingSpeedMultiplier = plugin.getConfig().getDouble("riding.speed_multiplier", 1.5);
        this.jumpForce = plugin.getConfig().getDouble("riding.jump_force", 0.42);
        this.minHungerToRide = plugin.getConfig().getInt("riding.min_hunger_to_ride", 5);
        this.jumpCooldown = plugin.getConfig().getLong("riding.jump_cooldown", 500L);
        this.autoJumpThreshold = plugin.getConfig().getDouble("riding.auto_jump_threshold", 0.1);
        this.autoJumpEnabled = plugin.getConfig().getBoolean("riding.auto_jump_enabled", true);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.startMaintenanceTask();
        this.logDebug("AnimalRidingSystem initialized with jump force: " + this.jumpForce + ", auto-jump: " + this.autoJumpEnabled);
    }

    private AnimalData getAnimalData(UUID animalUUID) {
        return this.animalDataMap.get(animalUUID);
    }

    public void startRidingCommand(Player player, Animals animal, AnimalData data) {
        if (this.ridingCooldowns.containsKey(player.getUniqueId())) {
            long lastRide = this.ridingCooldowns.get(player.getUniqueId());
            if (System.currentTimeMillis() - lastRide < this.ridingCooldown) {
                return;
            }
        }
        if (data.getLevel() < this.minRidingLevel) {
            return;
        }
        if (data.getHunger() < this.minHungerToRide) {
            return;
        }
        if (!animal.getPassengers().isEmpty()) {
            return;
        }
        if (!this.isRidableAnimal(animal)) {
            return;
        }
        if (this.requiresSaddle(animal)) {
            ItemStack mainHand = player.getInventory().getItemInMainHand();
            if (mainHand.getType() != Material.SADDLE) {
                return;
            }
            mainHand.setAmount(mainHand.getAmount() - 1);
        }
        this.startRiding(player, animal, data);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (this.plugin.isRidingDisabled()) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Animals)) {
            return;
        }
        Animals animal = (Animals)entity;
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (this.isAnimalFood(animal, item.getType())) {
            return;
        }
        if (!player.isSneaking() && this.isRidableAnimal(animal)) {
            event.setCancelled(true);
            AnimalData data = this.getAnimalData(animal.getUniqueId());
            if (data != null) {
                this.startRidingCommand(player, animal, data);
            }
        }
    }

    private void startRiding(Player player, Animals animal, AnimalData data) {
        if (!animal.addPassenger((Entity)player)) {
            this.sendMessage(player, "animal_already_ridden", new String[0]);
            return;
        }
        this.makeAnimalRideable(animal, data);
        RidingData ridingData = new RidingData(animal.getUniqueId());
        this.ridingPlayers.put(player.getUniqueId(), ridingData);
        this.ridingCooldowns.put(player.getUniqueId(), System.currentTimeMillis());
        this.lastPlayerLocations.put(player.getUniqueId(), player.getLocation());
        this.stuckCounter.put(player.getUniqueId(), 0);
        this.startRidingControlTask(player, animal, ridingData, data);
        this.sendMessage(player, "riding_started", "{animal}", this.getAnimalDisplayName(animal));
        this.playRidingStartEffects(animal, player);
        this.logDebug("Player " + player.getName() + " started riding " + animal.getType() + " (Level " + data.getLevel() + ")");
    }

    private void startRidingControlTask(final Player player, final Animals animal, final RidingData ridingData, final AnimalData data) {
        final UUID playerId = player.getUniqueId();
        BukkitTask task = new BukkitRunnable(){
            private double lastYaw;
            private boolean isMoving;
            private int tickCounter;
            {
                this.lastYaw = player.getLocation().getYaw();
                this.isMoving = false;
                this.tickCounter = 0;
            }

            public void run() {
                Vector movement;
                ++this.tickCounter;
                if (!AnimalRidingSystem.this.ridingPlayers.containsKey(playerId) || !player.isOnline()) {
                    this.cleanup();
                    return;
                }
                if (!(player.getVehicle() instanceof Animals) || !animal.isValid()) {
                    AnimalRidingSystem.this.stopRiding(player, "invalid_vehicle");
                    this.cleanup();
                    return;
                }
                if (AnimalRidingSystem.this.autoJumpEnabled) {
                    AnimalRidingSystem.this.checkMovementAndObstacles(player, animal, ridingData, data);
                }
                if ((movement = AnimalRidingSystem.this.handleRidingMovement(player, animal, ridingData, data)) != null) {
                    animal.setVelocity(movement);
                }
                if (!player.isSneaking() && this.tickCounter % 5 == 0 && AnimalRidingSystem.this.autoJumpEnabled) {
                    AnimalRidingSystem.this.checkAutoJump(player, animal, ridingData, data);
                }
            }

            private void cleanup() {
                this.cancel();
                AnimalRidingSystem.this.ridingTasks.remove(playerId);
                AnimalRidingSystem.this.lastPlayerLocations.remove(playerId);
                AnimalRidingSystem.this.stuckCounter.remove(playerId);
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
        this.ridingTasks.put(playerId, task);
    }

    private void checkMovementAndObstacles(Player player, Animals animal, RidingData ridingData, AnimalData data) {
        UUID playerId = player.getUniqueId();
        Location currentLoc = animal.getLocation();
        Location lastLoc = this.lastPlayerLocations.get(playerId);
        if (lastLoc == null) {
            this.lastPlayerLocations.put(playerId, currentLoc.clone());
            return;
        }
        double distance = currentLoc.distance(lastLoc);
        if (distance < this.autoJumpThreshold && animal.getVelocity().length() > 0.1) {
            int stuck = this.stuckCounter.getOrDefault(playerId, 0) + 1;
            this.stuckCounter.put(playerId, stuck);
            if (stuck >= 3) {
                this.checkForObstaclesAndJump(player, animal, data);
                this.stuckCounter.put(playerId, 0);
            }
        } else {
            this.stuckCounter.put(playerId, 0);
        }
        this.lastPlayerLocations.put(playerId, currentLoc.clone());
    }

    private void checkForObstaclesAndJump(Player player, Animals animal, AnimalData data) {
        Block legBlock;
        if (!animal.isOnGround()) {
            return;
        }
        Location animalLoc = animal.getLocation();
        Vector direction = player.getLocation().getDirection();
        direction.setY(0);
        direction.normalize();
        Location checkLoc = animalLoc.clone().add(direction.multiply(1.2));
        Block groundBlock = checkLoc.getBlock();
        if (groundBlock.getType().isSolid()) {
            Block blockAbove = checkLoc.clone().add(0.0, 1.0, 0.0).getBlock();
            Block blockAbove2 = checkLoc.clone().add(0.0, 2.0, 0.0).getBlock();
            if (!blockAbove.getType().isSolid() && !blockAbove2.getType().isSolid()) {
                this.performAutoJump(player, animal, data, 1.0);
                return;
            }
        }
        if ((legBlock = checkLoc.clone().add(0.0, 1.0, 0.0).getBlock()).getType().isSolid()) {
            Block blockAbove = checkLoc.clone().add(0.0, 2.0, 0.0).getBlock();
            Block blockAbove2 = checkLoc.clone().add(0.0, 3.0, 0.0).getBlock();
            if (!blockAbove.getType().isSolid() && !blockAbove2.getType().isSolid()) {
                this.performAutoJump(player, animal, data, 1.0);
                return;
            }
        }
        this.checkForStepsAndJump(player, animal, data, checkLoc);
    }

    private void checkForStepsAndJump(Player player, Animals animal, AnimalData data, Location checkLoc) {
        Block blockAbove2;
        Block groundBlock = checkLoc.getBlock();
        Block blockAbove = checkLoc.clone().add(0.0, 1.0, 0.0).getBlock();
        if (groundBlock.getType().isSolid() && (groundBlock.getType().name().contains("SLAB") || groundBlock.getType().name().contains("STAIRS") || groundBlock.getType().name().contains("STEP"))) {
            this.performAutoJump(player, animal, data, 0.7);
            return;
        }
        if (blockAbove.getType().isSolid() && !(blockAbove2 = checkLoc.clone().add(0.0, 2.0, 0.0).getBlock()).getType().isSolid()) {
            this.performAutoJump(player, animal, data, 1.0);
        }
        if (groundBlock.getType().name().contains("FENCE") || groundBlock.getType().name().contains("WALL") || groundBlock.getType().name().contains("GATE")) {
            this.performAutoJump(player, animal, data, 0.8);
        }
    }

    private void checkAutoJump(Player player, Animals animal, RidingData ridingData, AnimalData data) {
        Block frontBlockUp;
        if (!animal.isOnGround()) {
            return;
        }
        Vector velocity = animal.getVelocity();
        if (velocity.length() < 0.1) {
            return;
        }
        Location animalLoc = animal.getLocation();
        Vector direction = velocity.clone().normalize();
        direction.setY(0);
        Location checkLoc = animalLoc.clone().add(direction.multiply(0.8));
        Block frontBlock = checkLoc.getBlock();
        if (frontBlock.getType().isSolid()) {
            Block above1 = checkLoc.clone().add(0.0, 1.0, 0.0).getBlock();
            Block above2 = checkLoc.clone().add(0.0, 2.0, 0.0).getBlock();
            if (!above1.getType().isSolid() && !above2.getType().isSolid()) {
                this.performAutoJump(player, animal, data, 1.0);
                return;
            }
        }
        if ((frontBlockUp = checkLoc.clone().add(0.0, 1.0, 0.0).getBlock()).getType().isSolid()) {
            Block above1 = checkLoc.clone().add(0.0, 2.0, 0.0).getBlock();
            Block above2 = checkLoc.clone().add(0.0, 3.0, 0.0).getBlock();
            if (!above1.getType().isSolid() && !above2.getType().isSolid()) {
                this.performAutoJump(player, animal, data, 1.0);
            }
        }
    }

    private void performAutoJump(Player player, Animals animal, AnimalData data, double heightMultiplier) {
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (this.lastJumpTime.containsKey(playerId) && currentTime - this.lastJumpTime.get(playerId) < this.jumpCooldown) {
            return;
        }
        double jumpForce = this.getAnimalJumpForce(data);
        Vector velocity = animal.getVelocity();
        velocity.setY(jumpForce);
        animal.setVelocity(velocity);
        this.lastJumpTime.put(playerId, currentTime);
        player.playSound(animal.getLocation(), Sound.ENTITY_HORSE_JUMP, 0.8f, 1.2f);
        if (this.plugin.getConfig().getBoolean("enable-particles", true)) {
            animal.getWorld().spawnParticle(Particle.CLOUD, animal.getLocation().add(0.0, 0.5, 0.0), 5, 0.3, 0.1, 0.3, 0.05);
        }
    }

    private Vector handleRidingMovement(Player player, Animals animal, RidingData ridingData, AnimalData data) {
        Location playerLoc = player.getLocation();
        Vector direction = playerLoc.getDirection();
        direction.setY(0);
        direction.normalize();
        Vector movement = animal.getVelocity().clone();
        double baseSpeed = this.getAnimalSpeed(data, animal.getType()) * this.ridingSpeedMultiplier;
        Vector targetVelocity = direction.multiply(baseSpeed * 0.3);
        movement.setX(movement.getX() * 0.8 + targetVelocity.getX());
        movement.setZ(movement.getZ() * 0.8 + targetVelocity.getZ());
        return movement;
    }

    private double getAnimalJumpForce(AnimalData data) {
        return this.jumpForce;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (!this.ridingPlayers.containsKey(player.getUniqueId())) {
            return;
        }
        Entity vehicle = player.getVehicle();
        if (!(vehicle instanceof Animals)) {
            return;
        }
        Animals animal = (Animals)vehicle;
        RidingData ridingData = this.ridingPlayers.get(player.getUniqueId());
        if (ridingData == null) {
            return;
        }
        AnimalData animalData = this.getAnimalData(animal.getUniqueId());
        if (animalData == null) {
            return;
        }
        Location from = event.getFrom();
        Location to = event.getTo();
        if (from.getYaw() != to.getYaw() || from.getPitch() != to.getPitch()) {
            Vector direction = to.getDirection();
            direction.setY(0);
            direction.normalize();
            double baseSpeed = this.getAnimalSpeed(animalData, animal.getType()) * this.ridingSpeedMultiplier;
            Vector velocity = animal.getVelocity();
            Vector targetVelocity = direction.multiply(baseSpeed * 0.15);
            velocity.setX(velocity.getX() * 0.9 + targetVelocity.getX());
            velocity.setZ(velocity.getZ() * 0.9 + targetVelocity.getZ());
            animal.setVelocity(velocity);
        }
    }

    @EventHandler
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        Entity vehicle;
        final Player player = event.getPlayer();
        if (!event.isSneaking()) {
            return;
        }
        if (this.ridingPlayers.containsKey(player.getUniqueId()) && (vehicle = player.getVehicle()) instanceof Animals) {
            new BukkitRunnable(){

                public void run() {
                    vehicle.removePassenger((Entity)player);
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
        }
    }

    private void stopRiding(Player player, String reason) {
        Animals animal;
        UUID playerId = player.getUniqueId();
        RidingData ridingData = this.ridingPlayers.get(playerId);
        if (ridingData == null) {
            return;
        }
        BukkitTask task = this.ridingTasks.get(playerId);
        if (task != null) {
            task.cancel();
            this.ridingTasks.remove(playerId);
        }
        if ((animal = (Animals)Bukkit.getEntity((UUID)ridingData.animalId)) != null) {
            animal.removePassenger((Entity)player);
            this.restoreAnimalAttributes(animal);
        }
        this.ridingPlayers.remove(playerId);
        this.lastJumpTime.remove(playerId);
        this.lastPlayerLocations.remove(playerId);
        this.stuckCounter.remove(playerId);
        this.lastMessageTimes.remove(playerId);
        String messageKey = switch (reason) {
            case "exhausted" -> "riding_stopped_exhausted";
            case "knocked_off" -> "riding_stopped_knocked_off";
            case "forced" -> "riding_stopped";
            case "dismount" -> "riding_stopped";
            default -> "riding_stopped";
        };
        this.sendMessage(player, messageKey, new String[0]);
        this.playRidingStopEffects(player);
        this.logDebug("Player " + player.getName() + " stopped riding: " + reason);
    }

    private void makeAnimalRideable(Animals animal, AnimalData data) {
        try {
            animal.setMetadata("riding", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            animal.setMetadata("rider_level", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)data.getLevel()));
            animal.setMetadata("original_ai", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)animal.hasAI()));
            animal.setAI(true);
            if (animal.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED) != null) {
                double speed = this.getAnimalSpeed(data, animal.getType()) * this.ridingSpeedMultiplier;
                animal.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(speed);
            }
            switch (animal.getType()) {
                case PIG: {
                    if (!(animal instanceof Pig)) break;
                    Pig pig = (Pig)animal;
                    pig.setSaddle(true);
                    break;
                }
                case LLAMA: {
                    if (!(animal instanceof Llama)) break;
                    Llama llama = (Llama)animal;
                    llama.setTamed(true);
                    llama.setOwner(null);
                    break;
                }
                case DONKEY: {
                    if (!(animal instanceof Donkey)) break;
                    Donkey donkey = (Donkey)animal;
                    donkey.setTamed(true);
                    donkey.setOwner(null);
                    break;
                }
                case MULE: {
                    if (!(animal instanceof Mule)) break;
                    Mule mule = (Mule)animal;
                    mule.setTamed(true);
                    mule.setOwner(null);
                    break;
                }
                case WOLF: {
                    if (!(animal instanceof Wolf)) break;
                    Wolf wolf = (Wolf)animal;
                    wolf.setTamed(true);
                    wolf.setOwner(null);
                    wolf.setSitting(false);
                    animal.setMetadata("temp_tamed", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
                    break;
                }
                case CAT: {
                    if (!(animal instanceof Cat)) break;
                    Cat cat = (Cat)animal;
                    cat.setTamed(true);
                    cat.setOwner(null);
                    cat.setSitting(false);
                    animal.setMetadata("temp_tamed", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
                    break;
                }
                default: {
                    animal.setMetadata("custom_rideable", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
                }
            }
            this.logDebug("Made " + animal.getType() + " rideable with speed " + this.getAnimalSpeed(data, animal.getType()) * this.ridingSpeedMultiplier);
        }
        catch (Exception e) {
            this.logDebug("Error making animal rideable: " + e.getMessage());
        }
    }

    private void restoreAnimalAttributes(Animals animal) {
        try {
            if (animal.hasMetadata("original_ai")) {
                boolean originalAI = ((MetadataValue)animal.getMetadata("original_ai").get(0)).asBoolean();
                animal.setAI(originalAI);
            } else {
                animal.setAI(true);
            }
            animal.removeMetadata("riding", (Plugin)this.plugin);
            animal.removeMetadata("rider_level", (Plugin)this.plugin);
            animal.removeMetadata("original_ai", (Plugin)this.plugin);
            animal.removeMetadata("custom_rideable", (Plugin)this.plugin);
            animal.removeMetadata("temp_tamed", (Plugin)this.plugin);
            if (animal.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED) != null) {
                double defaultSpeed = this.getDefaultSpeed(animal.getType());
                animal.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(defaultSpeed);
            }
            switch (animal.getType()) {
                case PIG: {
                    if (!(animal instanceof Pig)) break;
                    Pig pig = (Pig)animal;
                    pig.setSaddle(false);
                    break;
                }
                case WOLF: {
                    if (!(animal instanceof Wolf)) break;
                    Wolf wolf = (Wolf)animal;
                    if (!animal.hasMetadata("temp_tamed")) break;
                    wolf.setTamed(false);
                    wolf.setOwner(null);
                    break;
                }
                case CAT: {
                    if (!(animal instanceof Cat)) break;
                    Cat cat = (Cat)animal;
                    if (!animal.hasMetadata("temp_tamed")) break;
                    cat.setTamed(false);
                    cat.setOwner(null);
                }
            }
            this.logDebug("Restored attributes for " + animal.getType());
        }
        catch (Exception e) {
            this.logDebug("Error restoring animal attributes: " + e.getMessage());
        }
    }

    private double getDefaultSpeed(EntityType type) {
        return switch (type) {
            case EntityType.HORSE -> 0.225;
            case EntityType.DONKEY, EntityType.MULE -> 0.175;
            case EntityType.LLAMA -> 0.175;
            case EntityType.PIG -> 0.25;
            case EntityType.COW -> 0.2;
            case EntityType.SHEEP -> 0.23;
            case EntityType.GOAT -> 0.2;
            case EntityType.WOLF -> 0.3;
            case EntityType.CAT -> 0.3;
            case EntityType.PANDA -> 0.15;
            default -> 0.2;
        };
    }

    @EventHandler
    public void onVehicleExit(VehicleExitEvent event) {
        Player player;
        LivingEntity livingEntity = event.getExited();
        if (livingEntity instanceof Player && this.ridingPlayers.containsKey((player = (Player)livingEntity).getUniqueId())) {
            new BukkitRunnable(){

                public void run() {
                    AnimalRidingSystem.this.stopRiding(player, "dismount");
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Animals)) {
            return;
        }
        Animals animal = (Animals)entity;
        if (!animal.getPassengers().isEmpty()) {
            Player rider = null;
            for (Entity passenger : animal.getPassengers()) {
                if (!(passenger instanceof Player)) continue;
                rider = (Player)passenger;
                break;
            }
            if (rider != null && this.ridingPlayers.containsKey(rider.getUniqueId())) {
                this.sendMessage(rider, "riding_animal_hurt", new String[0]);
                if (event.getDamage() > 4.0 && Math.random() < 0.3) {
                    this.stopRiding(rider, "knocked_off");
                }
            }
        }
    }

    private void startMaintenanceTask() {
        new BukkitRunnable(){

            public void run() {
                Iterator<Map.Entry<UUID, RidingData>> iterator = AnimalRidingSystem.this.ridingPlayers.entrySet().iterator();
                while (iterator.hasNext()) {
                    Animals animal;
                    Map.Entry<UUID, RidingData> entry = iterator.next();
                    Player player = Bukkit.getPlayer((UUID)entry.getKey());
                    RidingData ridingData = entry.getValue();
                    if (player == null || !player.isOnline()) {
                        iterator.remove();
                        AnimalRidingSystem.this.lastPlayerLocations.remove(entry.getKey());
                        AnimalRidingSystem.this.stuckCounter.remove(entry.getKey());
                        continue;
                    }
                    Entity vehicle = player.getVehicle();
                    if (!(vehicle instanceof Animals) || !(animal = (Animals)vehicle).isValid()) {
                        AnimalRidingSystem.this.stopRiding(player, "invalid_vehicle");
                        continue;
                    }
                    AnimalData animalData = AnimalRidingSystem.this.getAnimalData(animal.getUniqueId());
                    if (animalData == null || animalData.getHunger() >= AnimalRidingSystem.this.minHungerToRide) continue;
                    AnimalRidingSystem.this.stopRiding(player, "exhausted");
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    private void sendMessage(Player player, String key, String ... replacements) {
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if ((key.equals("riding_auto_jump") || key.equals("riding_auto_jump_step") || key.equals("riding_auto_jump_fence")) && !this.plugin.getConfig().getBoolean("riding.show_auto_jump_messages", false)) {
            return;
        }
        if (key.equals("riding_controls") && !this.plugin.getConfig().getBoolean("riding.show_control_messages", false)) {
            return;
        }
        this.lastMessageTimes.computeIfAbsent(playerId, k -> new HashMap());
        Map<String, Long> playerMessageTimes = this.lastMessageTimes.get(playerId);
        if (playerMessageTimes.containsKey(key) && currentTime - playerMessageTimes.get(key) < 5000L) {
            return;
        }
        String message = this.plugin.getMessage((CommandSender)player, key);
        for (int i = 0; i < replacements.length; i += 2) {
            message = message.replace(replacements[i], replacements[i + 1]);
        }
        player.sendMessage(message);
        playerMessageTimes.put(key, currentTime);
    }

    private String getAnimalDisplayName(Animals animal) {
        AnimalData data = this.getAnimalData(animal.getUniqueId());
        if (data != null && data.getCustomName() != null) {
            return data.getColoredName(animal.getType().name());
        }
        return animal.getType().name();
    }

    private void logDebug(String message) {
        if (this.plugin.getConfig().getBoolean("debug", false)) {
            // empty if block
        }
    }

    private boolean isRidableAnimal(Animals animal) {
        return switch (animal.getType()) {
            case EntityType.PIG, EntityType.LLAMA, EntityType.DONKEY, EntityType.MULE, EntityType.WOLF, EntityType.CAT, EntityType.COW, EntityType.SHEEP, EntityType.GOAT, EntityType.PANDA -> true;
            case EntityType.CHICKEN, EntityType.RABBIT, EntityType.BAT, EntityType.PARROT -> false;
            case EntityType.HORSE -> false;
            default -> this.plugin.getConfig().getBoolean("animals." + animal.getType().name().toLowerCase() + ".rideable", true);
        };
    }

    private boolean requiresSaddle(Animals animal) {
        if (animal.getType() == EntityType.PIG) {
            return this.plugin.getConfig().getBoolean("riding.pig_requires_saddle", true);
        }
        return this.plugin.getConfig().getBoolean("riding.require_saddle", false);
    }

    private boolean isAnimalFood(Animals animal, Material material) {
        String animalType = animal.getType().name().toLowerCase();
        return this.plugin.getConfig().getStringList("animals." + animalType + ".feed_items").contains(material.name());
    }

    private double getAnimalSpeed(AnimalData data, EntityType animalType) {
        String type = animalType.name().toLowerCase();
        double baseSpeed = this.plugin.getConfig().getDouble("animals." + type + ".riding_speed", 0.2);
        double levelBonus = (double)data.getLevel() * 0.01;
        double bondBonus = (double)data.getBondLevel() / 100.0 * 0.05;
        return Math.min(baseSpeed + levelBonus + bondBonus, 0.5);
    }

    private void playRidingStartEffects(Animals animal, Player player) {
        player.playSound(player.getLocation(), Sound.ENTITY_HORSE_SADDLE, 1.0f, 1.0f);
        if (this.plugin.getConfig().getBoolean("enable-particles", true)) {
            animal.getWorld().spawnParticle(Particle.HEART, animal.getLocation().add(0.0, 2.0, 0.0), 5, 0.5, 0.5, 0.5, 0.0);
        }
    }

    private void playRidingStopEffects(Player player) {
        player.playSound(player.getLocation(), Sound.ENTITY_HORSE_LAND, 1.0f, 0.8f);
    }

    public boolean isPlayerRiding(UUID playerId) {
        return this.ridingPlayers.containsKey(playerId);
    }

    public void forceStopRiding(UUID playerId) {
        Player player = Bukkit.getPlayer((UUID)playerId);
        if (player != null && this.ridingPlayers.containsKey(playerId)) {
            this.stopRiding(player, "forced");
        }
    }

    public Map<UUID, RidingData> getRidingPlayers() {
        return new HashMap<UUID, RidingData>(this.ridingPlayers);
    }

    private static class RidingData {
        public final UUID animalId;

        public RidingData(UUID animalId) {
            this.animalId = animalId;
        }
    }
}

