/*
 * Decompiled with CFR 0.152.
 */
package animalhunger.animalhunger;

import animalhunger.animalhunger.PluginCompatibility;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class CustomDropManager {
    private static final Logger LOGGER = Logger.getLogger("AnimalHunger.CustomDrops");
    private final JavaPlugin plugin;
    private final PluginCompatibility compatibility;
    private final Random random = new Random();

    public CustomDropManager(JavaPlugin plugin, PluginCompatibility compatibility) {
        this.plugin = plugin;
        this.compatibility = compatibility;
        this.logInitialization();
        this.generateExampleConfig();
    }

    private void logInitialization() {
        LOGGER.info("CustomDropManager initialized");
        LOGGER.info("MMOItems support: " + (this.compatibility.isMMOItemsEnabled() ? "Enabled" : "Disabled"));
        LOGGER.info("MythicMobs support: " + (this.compatibility.isMythicMobsEnabled() ? "Enabled" : "Disabled"));
    }

    private void generateExampleConfig() {
        if (!this.plugin.getConfig().contains("custom_drops")) {
            LOGGER.info("Creating example custom drops configuration...");
            String exampleConfig = this.generateConfigExample();
            LOGGER.info("Add the following configuration to your config.yml:\n\n" + exampleConfig);
        }
    }

    private String generateConfigExample() {
        StringBuilder example = new StringBuilder();
        example.append("# ========== CUSTOM DROPS CONFIGURATION ==========\n");
        example.append("custom_drops:\n");
        example.append("  # Example for cow\n");
        example.append("  cow:\n");
        example.append("    kill_drops:\n");
        example.append("      # MMOItems drop\n");
        example.append("      rare_meat:\n");
        example.append("        type: mmoitems\n");
        example.append("        mmo_type: CONSUMABLE  # MMOItems type (SWORD, CONSUMABLE, etc.)\n");
        example.append("        mmo_id: GOLDEN_BEEF   # Item ID in MMOItems\n");
        example.append("        chance: 25.0          # Drop chance in percent\n");
        example.append("        amount: 1             # Quantity\n");
        example.append("      # Vanilla Minecraft item\n");
        example.append("      leather_bonus:\n");
        example.append("        type: vanilla\n");
        example.append("        material: LEATHER\n");
        example.append("        chance: 50.0\n");
        example.append("        amount: 2\n");
        example.append("        display_name: '&6Quality leather'\n");
        example.append("        lore:\n");
        example.append("          - '&7Obtained from a happy cow'\n");
        example.append("          - '&eRare material'\n");
        example.append("    resource_drops:\n");
        example.append("      # Drops for milking or other actions\n");
        example.append("      special_milk:\n");
        example.append("        type: mmoitems\n");
        example.append("        mmo_type: CONSUMABLE\n");
        example.append("        mmo_id: SUPER_MILK\n");
        example.append("        chance: 15.0\n");
        example.append("        amount: 1\n");
        example.append("\n");
        example.append("  # Example for pig\n");
        example.append("  pig:\n");
        example.append("    kill_drops:\n");
        example.append("      golden_pork:\n");
        example.append("        type: mmoitems\n");
        example.append("        mmo_type: CONSUMABLE\n");
        example.append("        mmo_id: GOLDEN_PORK\n");
        example.append("        chance: 20.0\n");
        example.append("        amount: 1\n");
        example.append("\n");
        example.append("# For MythicMobs use mob ID instead of Bukkit type\n");
        example.append("# Example:\n");
        example.append("  # special_cow:  # Your MythicMob ID\n");
        example.append("  #   kill_drops:\n");
        example.append("  #     mythic_beef:\n");
        example.append("  #       type: mmoitems\n");
        example.append("  #       mmo_type: CONSUMABLE\n");
        example.append("  #       mmo_id: MYTHIC_BEEF\n");
        example.append("  #       chance: 100.0\n");
        example.append("  #       amount: 3\n");
        return example.toString();
    }

    public ItemStack getCustomDrop(Animals animal, boolean isKillDrop) {
        if (this.compatibility == null) {
            return null;
        }
        try {
            ItemStack drop = this.compatibility.getCustomDrop(animal, isKillDrop);
            if (drop != null) {
                String dropType;
                String animalType = this.getAnimalDisplayType(animal);
                String string = dropType = isKillDrop ? "kill" : "resource";
                if (this.plugin.getConfig().getBoolean("debug", false)) {
                    LOGGER.info("[DEBUG] Custom drop for " + animalType + " (" + dropType + "): " + drop.getType() + " x" + drop.getAmount());
                }
                if (this.isMMOItemsDrop(drop)) {
                    LOGGER.info("Successful MMOItems drop! Animal: " + animalType + ", Item: " + this.getItemDisplayName(drop));
                }
                return drop;
            }
        }
        catch (Exception e) {
            LOGGER.severe("Error getting custom drop: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public boolean hasCustomDrops(Animals animal, boolean isKillDrop) {
        return this.compatibility != null && this.compatibility.hasCustomDrops(animal, isKillDrop);
    }

    public List<ItemStack> getPossibleDrops(Animals animal, boolean isKillDrop) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        String animalKey = this.getAnimalConfigKey(animal);
        String dropType = isKillDrop ? "kill_drops" : "resource_drops";
        ConfigurationSection dropsSection = this.plugin.getConfig().getConfigurationSection("custom_drops." + animalKey + "." + dropType);
        if (dropsSection == null) {
            return drops;
        }
        for (String dropKey : dropsSection.getKeys(false)) {
            ItemStack item;
            ConfigurationSection dropConfig = dropsSection.getConfigurationSection(dropKey);
            if (dropConfig == null || (item = this.parseDropForDisplay(dropConfig)) == null) continue;
            drops.add(item);
        }
        return drops;
    }

    private ItemStack parseDropForDisplay(ConfigurationSection config) {
        String type = config.getString("type", "vanilla").toLowerCase();
        int amount = config.getInt("amount", 1);
        double chance = config.getDouble("chance", 100.0);
        ItemStack item = null;
        if ("mmoitems".equals(type) || "mmoitem".equals(type)) {
            String mmoType = config.getString("mmo_type", "");
            String mmoId = config.getString("mmo_id", "");
            if (!mmoType.isEmpty() && !mmoId.isEmpty() && this.compatibility.isMMOItemsEnabled()) {
                item = this.compatibility.createMMOItem(mmoType, mmoId, amount);
            }
        } else if ("vanilla".equals(type)) {
            String material = config.getString("material", "STONE");
            try {
                Material mat = Material.valueOf((String)material.toUpperCase());
                item = new ItemStack(mat, amount);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warning("Invalid material: " + material);
                return null;
            }
        }
        if (item != null) {
            this.addChanceToLore(item, chance);
        }
        return item;
    }

    private void addChanceToLore(ItemStack item, double chance) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            ArrayList<String> lore = meta.getLore();
            if (lore == null) {
                lore = new ArrayList<String>();
            }
            lore.add("");
            lore.add("\u00a77Drop chance: \u00a7e" + String.format("%.1f", chance) + "%");
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
    }

    public List<ItemStack> getDropsFromList(List<ItemStack> possibleDrops, int maxDrops) {
        ItemStack randomDrop;
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (possibleDrops.isEmpty() || maxDrops <= 0) {
            return result;
        }
        if (!possibleDrops.isEmpty() && (randomDrop = possibleDrops.get(this.random.nextInt(possibleDrops.size()))) != null) {
            result.add(randomDrop.clone());
        }
        return result;
    }

    private String getAnimalConfigKey(Animals animal) {
        String mythicType;
        if (this.compatibility.isMythicMobsEnabled() && this.compatibility.isMythicMob((Entity)animal) && (mythicType = this.compatibility.getMythicMobType((Entity)animal)) != null) {
            return mythicType.toLowerCase();
        }
        return animal.getType().name().toLowerCase();
    }

    private String getAnimalDisplayType(Animals animal) {
        String mythicName;
        if (this.compatibility.isMythicMobsEnabled() && this.compatibility.isMythicMob((Entity)animal) && (mythicName = this.compatibility.getMythicMobDisplayName((Entity)animal)) != null) {
            return mythicName;
        }
        return animal.getType().name().toLowerCase();
    }

    private boolean isMMOItemsDrop(ItemStack item) {
        if (!this.compatibility.isMMOItemsEnabled() || item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta.hasDisplayName()) {
            String displayName = meta.getDisplayName();
            return displayName.contains("\u00a7") && meta.hasLore();
        }
        return false;
    }

    private String getItemDisplayName(ItemStack item) {
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
            return item.getItemMeta().getDisplayName();
        }
        return item.getType().name();
    }

    public String getDropInfo(Animals animal, boolean isKillDrop) {
        StringBuilder info = new StringBuilder();
        if (!this.hasCustomDrops(animal, isKillDrop)) {
            info.append("\u00a77Custom drops not configured");
            return info.toString();
        }
        List<ItemStack> possibleDrops = this.getPossibleDrops(animal, isKillDrop);
        if (possibleDrops.isEmpty()) {
            info.append("\u00a77Drops configured but unavailable");
            return info.toString();
        }
        info.append("\u00a7aAvailable custom drops:\n");
        int mmoItemsCount = 0;
        int vanillaCount = 0;
        for (ItemStack drop : possibleDrops) {
            if (this.isMMOItemsDrop(drop)) {
                ++mmoItemsCount;
                continue;
            }
            ++vanillaCount;
        }
        if (mmoItemsCount > 0) {
            info.append("\u00a76MMOItems items: \u00a7e").append(mmoItemsCount).append("\n");
        }
        if (vanillaCount > 0) {
            info.append("\u00a77Vanilla items: \u00a7e").append(vanillaCount).append("\n");
        }
        info.append("\u00a77Total: \u00a7e").append(possibleDrops.size()).append(" \u00a77drop types");
        return info.toString();
    }

    public ItemStack giveMMOItem(String type, String id, int amount) {
        if (!this.compatibility.isMMOItemsEnabled()) {
            return null;
        }
        return this.compatibility.createMMOItem(type, id, amount);
    }

    public boolean isMMOItemsSupportEnabled() {
        return this.compatibility.isMMOItemsEnabled();
    }

    public boolean isMythicMobsSupportEnabled() {
        return this.compatibility.isMythicMobsEnabled();
    }
}

