/*
 * Decompiled with CFR 0.152.
 */
package animalhunger.animalhunger;

import animalhunger.animalhunger.AnimalData;
import animalhunger.animalhunger.AnimalHunger;
import animalhunger.animalhunger.CustomDropManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.entity.Animals;
import org.bukkit.inventory.ItemStack;

public class DropChanceHandler {
    private static final Logger LOGGER = Logger.getLogger("AnimalHunger.DropChanceHandler");
    private final AnimalHunger plugin;
    private final Random random = new Random();

    public DropChanceHandler(AnimalHunger plugin) {
        this.plugin = plugin;
    }

    public List<ItemStack> getDrops(Animals animal, AnimalData data, boolean fromMenu) {
        int rareDropThreshold;
        ItemStack customDrop;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        String animalType = animal.getType().name().toLowerCase();
        int requiredLevel = this.plugin.getConfig().getInt("kill.required-level", 2);
        if (data == null || data.getLevel() < requiredLevel) {
            drops.addAll(this.getGarbageDrops(animal));
            return drops;
        }
        CustomDropManager customDropManager = this.plugin.getCustomDropManager();
        if (customDropManager != null && customDropManager.hasCustomDrops(animal, true) && (customDrop = customDropManager.getCustomDrop(animal, true)) != null) {
            drops.add(customDrop);
            return drops;
        }
        double generalDropChance = this.plugin.getConfig().getDouble("kill.drop-chance", 1.0);
        if (fromMenu && this.random.nextDouble() > generalDropChance) {
            drops.addAll(this.getGarbageDrops(animal));
            return drops;
        }
        int bondLevel = data.getBondLevel();
        boolean shouldGetRareDrop = bondLevel >= (rareDropThreshold = this.plugin.getConfig().getInt("bond.thresholds.rare-drops", 75));
        int level = data.getLevel();
        double chance = this.random.nextDouble() * 100.0;
        double cumulative = 0.0;
        for (int i = 1; i <= 5; ++i) {
            double levelChance = this.plugin.getConfig().getDouble("drop.chances." + i, 0.0);
            cumulative += levelChance;
            if (level < i || !(chance <= cumulative)) continue;
            if (shouldGetRareDrop) {
                drops.addAll(this.getRareDrops(animal, data));
            } else {
                drops.addAll(this.getStandardDrops(animal));
            }
            return drops;
        }
        drops.addAll(this.getStandardDrops(animal));
        return drops;
    }

    public ItemStack getDrop(Animals animal, AnimalData data, boolean fromMenu) {
        List<ItemStack> drops = this.getDrops(animal, data, fromMenu);
        return drops.isEmpty() ? null : drops.get(0);
    }

    private List<ItemStack> getGarbageDrops(Animals animal) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        String animalType = animal.getType().name().toLowerCase();
        if (this.plugin.getConfig().isList("kill.garbage_drops." + animalType)) {
            List items = this.plugin.getConfig().getStringList("kill.garbage_drops." + animalType);
            for (String itemName : items) {
                int amount = 1 + this.random.nextInt(2);
                Material material = this.getMaterialSafely(itemName);
                drops.add(new ItemStack(material, amount));
            }
        } else {
            String garbageItem = this.plugin.getConfig().getString("kill.garbage_drops." + animalType, null);
            if (garbageItem != null) {
                int amount = 1 + this.random.nextInt(2);
                Material material = this.getMaterialSafely(garbageItem);
                drops.add(new ItemStack(material, amount));
            }
        }
        return drops;
    }

    private List<ItemStack> getRareDrops(Animals animal, AnimalData data) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        String animalType = animal.getType().name().toLowerCase();
        if (this.plugin.getConfig().isList("kill.rare_drops." + animalType)) {
            List items = this.plugin.getConfig().getStringList("kill.rare_drops." + animalType);
            if (items.isEmpty()) {
                return this.getStandardDrops(animal);
            }
            int bondLevel = data.getBondLevel();
            int bonus = Math.max(0, (bondLevel - 74) / 5);
            for (String itemName : items) {
                int amount = 1 + bonus + this.random.nextInt(2);
                Material material = this.getMaterialSafely(itemName);
                drops.add(new ItemStack(material, amount));
            }
        } else {
            String rareItem = this.plugin.getConfig().getString("kill.rare_drops." + animalType, "DIAMOND");
            int bondLevel = data.getBondLevel();
            int bonus = Math.max(0, (bondLevel - 74) / 5);
            int amount = 1 + bonus + this.random.nextInt(2);
            Material material = this.getMaterialSafely(rareItem);
            drops.add(new ItemStack(material, amount));
        }
        return drops;
    }

    private List<ItemStack> getStandardDrops(Animals animal) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        String animalType = animal.getType().name().toLowerCase();
        if (this.plugin.getConfig().isList("kill.standard_drops." + animalType)) {
            List items = this.plugin.getConfig().getStringList("kill.standard_drops." + animalType);
            for (String itemName : items) {
                int amount = 1 + this.random.nextInt(2);
                Material material = this.getMaterialSafely(itemName);
                drops.add(new ItemStack(material, amount));
            }
        } else {
            String standardItem = this.plugin.getConfig().getString("kill.standard_drops." + animalType, "LEATHER");
            int amount = 1 + this.random.nextInt(2);
            Material material = this.getMaterialSafely(standardItem);
            drops.add(new ItemStack(material, amount));
        }
        return drops;
    }

    private Material getMaterialSafely(String materialName) {
        try {
            Material material = Material.getMaterial((String)materialName.toUpperCase());
            if (material == null || !material.isItem()) {
                return Material.DIRT;
            }
            return material;
        }
        catch (Exception e) {
            return Material.DIRT;
        }
    }

    public String getDropInfo(Animals animal, AnimalData data) {
        StringBuilder info = new StringBuilder();
        if (data == null) {
            return "\u00a7cAnimal data not found";
        }
        int requiredLevel = this.plugin.getConfig().getInt("kill.required-level", 2);
        if (data.getLevel() < requiredLevel) {
            info.append("\u00a7eLevel too low for good drops\n").append("\u00a77Required: \u00a7e").append(requiredLevel).append("\u00a77, Current: \u00a7e").append(data.getLevel()).append("\n").append("\u00a77Will only drop garbage items");
            return info.toString();
        }
        CustomDropManager customDropManager = this.plugin.getCustomDropManager();
        if (customDropManager != null && customDropManager.hasCustomDrops(animal, true)) {
            info.append("\u00a7a\u2713 Custom drops configured\n");
            String customInfo = customDropManager.getDropInfo(animal, true);
            if (!customInfo.isEmpty()) {
                info.append(customInfo).append("\n");
            }
            info.append("\u00a77Priority: custom \u2192 standard\n");
        } else {
            info.append("\u00a77Custom drops not configured\n").append("\u00a77Standard drops will be used\n");
        }
        int bondLevel = data.getBondLevel();
        int rareThreshold = this.plugin.getConfig().getInt("bond.thresholds.rare-drops", 75);
        if (bondLevel >= rareThreshold) {
            info.append("\u00a7d\u2713 High bond - rare drops available!\n").append("\u00a77Bond bonus: \u00a7e+").append((bondLevel - 74) / 5).append(" \u00a77items");
        } else {
            info.append("\u00a77Bond: \u00a7e").append(bondLevel).append("%").append("\u00a77, until rare drops: \u00a7e").append(rareThreshold - bondLevel).append("%");
        }
        return info.toString();
    }

    public String getDropTypeInfo(Animals animal, AnimalData data) {
        int rareThreshold;
        if (data == null) {
            return "garbage (no data)";
        }
        int requiredLevel = this.plugin.getConfig().getInt("kill.required-level", 2);
        if (data.getLevel() < requiredLevel) {
            return "garbage (low level)";
        }
        CustomDropManager customDropManager = this.plugin.getCustomDropManager();
        if (customDropManager != null && customDropManager.hasCustomDrops(animal, true)) {
            return "custom";
        }
        int bondLevel = data.getBondLevel();
        return bondLevel >= (rareThreshold = this.plugin.getConfig().getInt("bond.thresholds.rare-drops", 75)) ? "rare" : "standard";
    }

    public boolean canDropGoodItems(AnimalData data) {
        if (data == null) {
            return false;
        }
        int requiredLevel = this.plugin.getConfig().getInt("kill.required-level", 2);
        return data.getLevel() >= requiredLevel;
    }

    public double getDropChanceForLevel(int level) {
        double totalChance = 0.0;
        for (int i = 1; i <= Math.min(level, 5); ++i) {
            totalChance += this.plugin.getConfig().getDouble("drop.chances." + i, 0.0);
        }
        return Math.min(totalChance, 100.0);
    }
}

